/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.ByteBufferAsFloatBufferL;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ReadOnlyBufferException;

class ByteBufferAsFloatBufferRL
extends ByteBufferAsFloatBufferL {
    ByteBufferAsFloatBufferRL(ByteBuffer bb) {
        super(bb);
    }

    ByteBufferAsFloatBufferRL(ByteBuffer bb, int mark, int pos, int lim, int cap, int off) {
        super(bb, mark, pos, lim, cap, off);
    }

    public FloatBuffer slice() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        int off = (pos << 2) + this.offset;
        assert (off >= 0);
        return new ByteBufferAsFloatBufferRL(this.bb, -1, 0, rem, rem, off);
    }

    public FloatBuffer duplicate() {
        return new ByteBufferAsFloatBufferRL(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    public FloatBuffer asReadOnlyBuffer() {
        return this.duplicate();
    }

    public FloatBuffer put(float x) {
        throw new ReadOnlyBufferException();
    }

    public FloatBuffer put(int i, float x) {
        throw new ReadOnlyBufferException();
    }

    public FloatBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    public boolean isDirect() {
        return this.bb.isDirect();
    }

    public boolean isReadOnly() {
        return true;
    }

    public ByteOrder order() {
        return ByteOrder.LITTLE_ENDIAN;
    }
}

