/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.ByteBuffer;
import java.nio.ByteBufferAsShortBufferRL;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;

class ByteBufferAsShortBufferL
extends ShortBuffer {
    protected final ByteBuffer bb;
    protected final int offset;

    ByteBufferAsShortBufferL(ByteBuffer bb) {
        super(-1, 0, bb.remaining() >> 1, bb.remaining() >> 1);
        this.bb = bb;
        int cap = this.capacity();
        this.limit(cap);
        int pos = this.position();
        assert (pos <= cap);
        this.offset = pos;
    }

    ByteBufferAsShortBufferL(ByteBuffer bb, int mark, int pos, int lim, int cap, int off) {
        super(mark, pos, lim, cap);
        this.bb = bb;
        this.offset = off;
    }

    public ShortBuffer slice() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        int off = (pos << 1) + this.offset;
        assert (off >= 0);
        return new ByteBufferAsShortBufferL(this.bb, -1, 0, rem, rem, off);
    }

    public ShortBuffer duplicate() {
        return new ByteBufferAsShortBufferL(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    public ShortBuffer asReadOnlyBuffer() {
        return new ByteBufferAsShortBufferRL(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    protected int ix(int i) {
        return (i << 1) + this.offset;
    }

    public short get() {
        return Bits.getShortL(this.bb, this.ix(this.nextGetIndex()));
    }

    public short get(int i) {
        return Bits.getShortL(this.bb, this.ix(this.checkIndex(i)));
    }

    public ShortBuffer put(short x) {
        Bits.putShortL(this.bb, this.ix(this.nextPutIndex()), x);
        return this;
    }

    public ShortBuffer put(int i, short x) {
        Bits.putShortL(this.bb, this.ix(this.checkIndex(i)), x);
        return this;
    }

    public ShortBuffer compact() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        ByteBuffer db = this.bb.duplicate();
        db.limit(this.ix(lim));
        db.position(this.ix(0));
        ByteBuffer sb = db.slice();
        sb.position(pos << 1);
        sb.compact();
        this.position(rem);
        this.limit(this.capacity());
        return this;
    }

    public boolean isDirect() {
        return this.bb.isDirect();
    }

    public boolean isReadOnly() {
        return false;
    }

    public ByteOrder order() {
        return ByteOrder.LITTLE_ENDIAN;
    }
}

