/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import net.sourceforge.jnlp.runtime.JNLPClassLoader;
import net.sourceforge.jnlp.runtime.JNLPRuntime;

public class JNLPPolicy
extends Policy {
    private static CodeSource shellSource;
    private static CodeSource systemSource;
    private static Policy systemPolicy;

    protected JNLPPolicy() {
        shellSource = JNLPPolicy.class.getProtectionDomain().getCodeSource();
        systemSource = Policy.class.getProtectionDomain().getCodeSource();
        systemPolicy = Policy.getPolicy();
    }

    @Override
    public PermissionCollection getPermissions(CodeSource source) {
        if (source.equals(systemSource) || source.equals(shellSource)) {
            return this.getAllPermissions();
        }
        if (JNLPRuntime.getApplication() != null && JNLPRuntime.getApplication().getClassLoader() instanceof JNLPClassLoader) {
            JNLPClassLoader cl = (JNLPClassLoader)JNLPRuntime.getApplication().getClassLoader();
            PermissionCollection clPermissions = cl.getPermissions(source);
            Enumeration<Permission> e = systemPolicy.getPermissions(source).elements();
            while (e.hasMoreElements()) {
                clPermissions.add(e.nextElement());
            }
            return clPermissions;
        }
        return systemPolicy.getPermissions(source);
    }

    @Override
    public void refresh() {
    }

    private Permissions getAllPermissions() {
        Permissions result = new Permissions();
        result.add(new AllPermission());
        return result;
    }

    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        PermissionCollection pc = this.getPermissions(domain.getCodeSource());
        return super.implies(domain, permission) || pc.implies(permission);
    }
}

