/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.cert.X509Certificate;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.security.AccessWarningPane;
import net.sourceforge.jnlp.security.AppletWarningPane;
import net.sourceforge.jnlp.security.CertVerifier;
import net.sourceforge.jnlp.security.CertWarningPane;
import net.sourceforge.jnlp.security.CertsInfoPane;
import net.sourceforge.jnlp.security.MoreInfoPane;
import net.sourceforge.jnlp.security.SingleCertInfoPane;

public class SecurityWarningDialog
extends JOptionPane {
    private DialogType dialogType;
    private AccessType accessType;
    private JNLPFile file;
    private CertVerifier certVerifier;
    private X509Certificate cert;
    private Object[] extras;
    private boolean initialized = false;

    public SecurityWarningDialog(DialogType dialogType, AccessType accessType, JNLPFile file) {
        this.dialogType = dialogType;
        this.accessType = accessType;
        this.file = file;
        this.certVerifier = null;
        this.initialized = true;
        this.updateUI();
    }

    public SecurityWarningDialog(DialogType dialogType, AccessType accessType, JNLPFile file, CertVerifier jarSigner) {
        this.dialogType = dialogType;
        this.accessType = accessType;
        this.file = file;
        this.certVerifier = jarSigner;
        this.initialized = true;
        this.updateUI();
    }

    public SecurityWarningDialog(DialogType dialogType, AccessType accessType, CertVerifier certVerifier) {
        this.dialogType = dialogType;
        this.accessType = accessType;
        this.file = null;
        this.certVerifier = certVerifier;
        this.initialized = true;
        this.updateUI();
    }

    public SecurityWarningDialog(DialogType dialogType, AccessType accessType, JNLPFile file, Object[] extras) {
        this.dialogType = dialogType;
        this.accessType = accessType;
        this.file = file;
        this.certVerifier = null;
        this.initialized = true;
        this.extras = extras;
        this.updateUI();
    }

    public SecurityWarningDialog(DialogType dialogType, X509Certificate c) {
        this.dialogType = dialogType;
        this.accessType = null;
        this.file = null;
        this.certVerifier = null;
        this.cert = c;
        this.initialized = true;
        this.updateUI();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public static boolean showAccessWarningDialog(AccessType accessType, JNLPFile file) {
        return SecurityWarningDialog.showAccessWarningDialog(accessType, file, null);
    }

    public static boolean showAccessWarningDialog(AccessType accessType, JNLPFile file, Object[] extras) {
        SecurityWarningDialog swd = new SecurityWarningDialog(DialogType.ACCESS_WARNING, accessType, file, extras);
        JDialog dialog = swd.createDialog();
        swd.selectInitialValue();
        dialog.setResizable(true);
        SecurityWarningDialog.centerDialog(dialog);
        dialog.setVisible(true);
        dialog.dispose();
        Object selectedValue = swd.getValue();
        if (selectedValue == null) {
            return false;
        }
        if (selectedValue instanceof Integer) {
            return (Integer)selectedValue == 0;
        }
        return false;
    }

    public static boolean showCertWarningDialog(AccessType accessType, JNLPFile file, CertVerifier jarSigner) {
        SecurityWarningDialog swd = new SecurityWarningDialog(DialogType.CERT_WARNING, accessType, file, jarSigner);
        JDialog dialog = swd.createDialog();
        swd.selectInitialValue();
        dialog.setResizable(true);
        SecurityWarningDialog.centerDialog(dialog);
        dialog.setVisible(true);
        dialog.dispose();
        Object selectedValue = swd.getValue();
        if (selectedValue == null) {
            return false;
        }
        if (selectedValue instanceof Integer) {
            return (Integer)selectedValue == 0;
        }
        return false;
    }

    public static void showMoreInfoDialog(CertVerifier jarSigner, JOptionPane parent) {
        SecurityWarningDialog swd = new SecurityWarningDialog(DialogType.MORE_INFO, null, null, jarSigner);
        JDialog dialog = swd.createDialog();
        dialog.setLocationRelativeTo(parent);
        swd.selectInitialValue();
        dialog.setResizable(true);
        dialog.setVisible(true);
        dialog.dispose();
    }

    public static void showCertInfoDialog(CertVerifier jarSigner, JOptionPane parent) {
        SecurityWarningDialog swd = new SecurityWarningDialog(DialogType.CERT_INFO, null, null, jarSigner);
        JDialog dialog = swd.createDialog();
        dialog.setLocationRelativeTo(parent);
        swd.selectInitialValue();
        dialog.setResizable(true);
        dialog.setVisible(true);
        dialog.dispose();
    }

    public static void showSingleCertInfoDialog(X509Certificate c, JOptionPane parent) {
        SecurityWarningDialog swd = new SecurityWarningDialog(DialogType.SINGLE_CERT_INFO, c);
        JDialog dialog = swd.createDialog();
        dialog.setLocationRelativeTo(parent);
        swd.selectInitialValue();
        dialog.setResizable(true);
        dialog.setVisible(true);
        dialog.dispose();
    }

    public static int showAppletWarning() {
        SecurityWarningDialog swd = new SecurityWarningDialog(DialogType.APPLET_WARNING, null, null, (CertVerifier)null);
        JDialog dialog = swd.createDialog();
        SecurityWarningDialog.centerDialog(dialog);
        swd.selectInitialValue();
        dialog.setResizable(true);
        dialog.setVisible(true);
        dialog.dispose();
        Object selectedValue = swd.getValue();
        if (selectedValue == null) {
            return 2;
        }
        if (selectedValue instanceof Integer) {
            return (Integer)selectedValue;
        }
        return 2;
    }

    private JDialog createDialog() {
        String dialogTitle = "";
        if (this.dialogType == DialogType.CERT_WARNING) {
            dialogTitle = "Warning - Security";
        } else if (this.dialogType == DialogType.MORE_INFO) {
            dialogTitle = "More Information";
        } else if (this.dialogType == DialogType.CERT_INFO) {
            dialogTitle = "Details - Certificate";
        } else if (this.dialogType == DialogType.ACCESS_WARNING) {
            dialogTitle = "Security Warning";
        } else if (this.dialogType == DialogType.APPLET_WARNING) {
            dialogTitle = "Applet Warning";
        }
        final JDialog dialog = new JDialog((Frame)null, dialogTitle, true);
        Container contentPane = dialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this, "Center");
        dialog.pack();
        WindowAdapter adapter = new WindowAdapter(){
            private boolean gotFocus = false;

            @Override
            public void windowClosing(WindowEvent we) {
                SecurityWarningDialog.this.setValue(null);
            }

            @Override
            public void windowGainedFocus(WindowEvent we) {
                if (!this.gotFocus) {
                    SecurityWarningDialog.this.selectInitialValue();
                    this.gotFocus = true;
                }
            }
        };
        dialog.addWindowListener(adapter);
        dialog.addWindowFocusListener(adapter);
        dialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent ce) {
                SecurityWarningDialog.this.setValue(JOptionPane.UNINITIALIZED_VALUE);
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (dialog.isVisible() && event.getSource() == SecurityWarningDialog.this && (event.getPropertyName().equals("value") || event.getPropertyName().equals("inputValue")) && event.getNewValue() != null && event.getNewValue() != JOptionPane.UNINITIALIZED_VALUE) {
                    dialog.setVisible(false);
                }
            }
        });
        return dialog;
    }

    public AccessType getType() {
        return this.accessType;
    }

    public JNLPFile getFile() {
        return this.file;
    }

    public CertVerifier getJarSigner() {
        return this.certVerifier;
    }

    public X509Certificate getCert() {
        return this.cert;
    }

    @Override
    public void updateUI() {
        if (this.dialogType == DialogType.CERT_WARNING) {
            this.setUI(new CertWarningPane(this, this.certVerifier));
        } else if (this.dialogType == DialogType.MORE_INFO) {
            this.setUI(new MoreInfoPane(this, this.certVerifier));
        } else if (this.dialogType == DialogType.CERT_INFO) {
            this.setUI(new CertsInfoPane(this, this.certVerifier));
        } else if (this.dialogType == DialogType.SINGLE_CERT_INFO) {
            this.setUI(new SingleCertInfoPane(this, this.certVerifier));
        } else if (this.dialogType == DialogType.ACCESS_WARNING) {
            this.setUI(new AccessWarningPane(this, this.extras, this.certVerifier));
        } else if (this.dialogType == DialogType.APPLET_WARNING) {
            this.setUI(new AppletWarningPane(this, this.certVerifier));
        }
    }

    private static void centerDialog(JDialog dialog) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = dialog.getSize();
        dialog.setLocation((screen.width - dialogSize.width) / 2, (screen.height - dialogSize.height) / 2);
    }

    public static enum AccessType {
        READ_FILE,
        WRITE_FILE,
        CLIPBOARD_READ,
        CLIPBOARD_WRITE,
        PRINTER,
        NETWORK,
        VERIFIED,
        UNVERIFIED,
        SIGNING_ERROR;

    }

    public static enum DialogType {
        CERT_WARNING,
        MORE_INFO,
        CERT_INFO,
        SINGLE_CERT_INFO,
        ACCESS_WARNING,
        APPLET_WARNING;

    }
}

