/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.font.FontStrike;
import sun.font.FontStrikeDisposer;
import sun.java2d.Disposer;
import sun.misc.Unsafe;

public final class StrikeCache {
    static final Unsafe unsafe = Unsafe.getUnsafe();
    static ReferenceQueue refQueue = Disposer.getQueue();
    static int MINSTRIKES = 8;
    static int recentStrikeIndex = 0;
    static FontStrike[] recentStrikes;
    static boolean cacheRefTypeWeak;
    static int nativeAddressSize;
    static int glyphInfoSize;
    static int xAdvanceOffset;
    static int yAdvanceOffset;
    static int boundsOffset;
    static int widthOffset;
    static int heightOffset;
    static int rowBytesOffset;
    static int topLeftXOffset;
    static int topLeftYOffset;
    static int pixelDataOffset;
    static long invisibleGlyphPtr;

    static native void getGlyphCacheDescription(long[] var0);

    static void refStrike(FontStrike strike) {
        int index = recentStrikeIndex;
        StrikeCache.recentStrikes[index] = strike;
        if (++index == MINSTRIKES) {
            index = 0;
        }
        recentStrikeIndex = index;
    }

    static void disposeStrike(FontStrikeDisposer disposer) {
        if (disposer.intGlyphImages != null) {
            StrikeCache.freeIntMemory(disposer.intGlyphImages, disposer.pScalerContext);
        } else if (disposer.longGlyphImages != null) {
            StrikeCache.freeLongMemory(disposer.longGlyphImages, disposer.pScalerContext);
        } else if (disposer.segIntGlyphImages != null) {
            for (int i = 0; i < disposer.segIntGlyphImages.length; ++i) {
                if (disposer.segIntGlyphImages[i] == null) continue;
                StrikeCache.freeIntMemory(disposer.segIntGlyphImages[i], disposer.pScalerContext);
                disposer.pScalerContext = 0L;
                disposer.segIntGlyphImages[i] = null;
            }
            if (disposer.pScalerContext != 0L) {
                StrikeCache.freeIntMemory(new int[0], disposer.pScalerContext);
            }
        } else if (disposer.segLongGlyphImages != null) {
            for (int i = 0; i < disposer.segLongGlyphImages.length; ++i) {
                if (disposer.segLongGlyphImages[i] == null) continue;
                StrikeCache.freeLongMemory(disposer.segLongGlyphImages[i], disposer.pScalerContext);
                disposer.pScalerContext = 0L;
                disposer.segLongGlyphImages[i] = null;
            }
            if (disposer.pScalerContext != 0L) {
                StrikeCache.freeLongMemory(new long[0], disposer.pScalerContext);
            }
        }
    }

    static native void freeIntPointer(int var0);

    static native void freeLongPointer(long var0);

    private static native void freeIntMemory(int[] var0, long var1);

    private static native void freeLongMemory(long[] var0, long var1);

    public static Reference getStrikeRef(FontStrike strike) {
        return StrikeCache.getStrikeRef(strike, cacheRefTypeWeak);
    }

    public static Reference getStrikeRef(FontStrike strike, boolean weak) {
        if (strike.disposer == null) {
            if (weak) {
                return new WeakReference<FontStrike>(strike);
            }
            return new SoftReference<FontStrike>(strike);
        }
        if (weak) {
            return new WeakDisposerRef(strike);
        }
        return new SoftDisposerRef(strike);
    }

    static {
        long[] nativeInfo = new long[11];
        StrikeCache.getGlyphCacheDescription(nativeInfo);
        nativeAddressSize = (int)nativeInfo[0];
        glyphInfoSize = (int)nativeInfo[1];
        xAdvanceOffset = (int)nativeInfo[2];
        yAdvanceOffset = (int)nativeInfo[3];
        widthOffset = (int)nativeInfo[4];
        heightOffset = (int)nativeInfo[5];
        rowBytesOffset = (int)nativeInfo[6];
        topLeftXOffset = (int)nativeInfo[7];
        topLeftYOffset = (int)nativeInfo[8];
        pixelDataOffset = (int)nativeInfo[9];
        invisibleGlyphPtr = nativeInfo[10];
        if (nativeAddressSize < 4) {
            throw new InternalError("Unexpected address size for font data: " + nativeAddressSize);
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String refType = System.getProperty("sun.java2d.font.reftype", "soft");
                cacheRefTypeWeak = refType.equals("weak");
                String minStrikesStr = System.getProperty("sun.java2d.font.minstrikes");
                if (minStrikesStr != null) {
                    try {
                        MINSTRIKES = Integer.parseInt(minStrikesStr);
                        if (MINSTRIKES <= 0) {
                            MINSTRIKES = 1;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                recentStrikes = new FontStrike[MINSTRIKES];
                return null;
            }
        });
    }

    static class WeakDisposerRef
    extends WeakReference
    implements DisposableStrike {
        private FontStrikeDisposer disposer;

        public FontStrikeDisposer getDisposer() {
            return this.disposer;
        }

        WeakDisposerRef(FontStrike strike) {
            super(strike, refQueue);
            this.disposer = strike.disposer;
            Disposer.addReference(this, this.disposer);
        }
    }

    static class SoftDisposerRef
    extends SoftReference
    implements DisposableStrike {
        private FontStrikeDisposer disposer;

        public FontStrikeDisposer getDisposer() {
            return this.disposer;
        }

        SoftDisposerRef(FontStrike strike) {
            super(strike, refQueue);
            this.disposer = strike.disposer;
            Disposer.addReference(this, this.disposer);
        }
    }

    static interface DisposableStrike {
        public FontStrikeDisposer getDisposer();
    }
}

