/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import sun.java2d.InvalidPipeException;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.XORComposite;
import sun.java2d.pipe.BufferedPaints;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.RenderBuffer;
import sun.java2d.pipe.RenderQueue;
import sun.java2d.pipe.SpanIterator;

public class BufferedContext {
    public static final int NO_CONTEXT_FLAGS = 0;
    public static final int SRC_IS_OPAQUE = 1;
    public static final int USE_MASK = 2;
    protected RenderQueue rq;
    protected RenderBuffer buf;
    protected static BufferedContext currentContext;
    private SurfaceData validatedSrcData;
    private SurfaceData validatedDstData;
    private Region validatedClip;
    private Composite validatedComp;
    private Paint validatedPaint;
    private int validatedFlags;
    private boolean xformInUse;

    protected BufferedContext(RenderQueue rq) {
        this.rq = rq;
        this.buf = rq.getBuffer();
    }

    public void validate(SurfaceData srcData, SurfaceData dstData, Region clip, Composite comp, AffineTransform xform, Paint paint, SunGraphics2D sg2d, int flags) {
        boolean updatePaint;
        boolean updateClip = clip != this.validatedClip;
        boolean bl = updatePaint = paint != this.validatedPaint;
        if (!dstData.isValid()) {
            throw new InvalidPipeException("bounds changed");
        }
        if (currentContext != this || srcData != this.validatedSrcData || dstData != this.validatedDstData) {
            if (dstData != this.validatedDstData) {
                updateClip = true;
            }
            if (paint == null) {
                updatePaint = true;
            }
            this.setSurfaces(srcData, dstData);
            currentContext = this;
            this.validatedSrcData = srcData;
            this.validatedDstData = dstData;
        }
        if (updateClip) {
            if (clip != null) {
                this.setClip(clip);
            } else {
                this.resetClip();
            }
            this.validatedClip = clip;
        }
        if (comp != this.validatedComp || flags != this.validatedFlags) {
            if (comp != null) {
                this.setComposite(comp, flags);
            } else {
                this.resetComposite();
            }
            updatePaint = true;
            this.validatedComp = comp;
            this.validatedFlags = flags;
        }
        if (xform == null) {
            if (this.xformInUse) {
                this.resetTransform();
                this.xformInUse = false;
            }
        } else {
            this.setTransform(xform);
            this.xformInUse = true;
        }
        if (updatePaint) {
            if (paint != null) {
                BufferedPaints.setPaint(this.rq, sg2d, paint, flags);
            } else {
                BufferedPaints.resetPaint(this.rq);
            }
            this.validatedPaint = paint;
        }
        dstData.markDirty();
    }

    public void invalidateSurfaces() {
        this.validatedSrcData = null;
        this.validatedDstData = null;
    }

    private void setSurfaces(SurfaceData srcData, SurfaceData dstData) {
        this.rq.ensureCapacityAndAlignment(20, 4);
        this.buf.putInt(70);
        this.buf.putLong(srcData.getNativeOps());
        this.buf.putLong(dstData.getNativeOps());
    }

    private void resetClip() {
        this.rq.ensureCapacity(4);
        this.buf.putInt(55);
    }

    private void setClip(Region clip) {
        if (clip.isRectangular()) {
            this.rq.ensureCapacity(20);
            this.buf.putInt(51);
            this.buf.putInt(clip.getLoX()).putInt(clip.getLoY());
            this.buf.putInt(clip.getHiX()).putInt(clip.getHiY());
        } else {
            this.rq.ensureCapacity(28);
            this.buf.putInt(52);
            this.buf.putInt(53);
            int countIndex = this.buf.position();
            this.buf.putInt(0);
            int spanCount = 0;
            int remainingSpans = this.buf.remaining() / 16;
            int[] span = new int[4];
            SpanIterator si = clip.getSpanIterator();
            while (si.nextSpan(span)) {
                if (remainingSpans == 0) {
                    this.buf.putInt(countIndex, spanCount);
                    this.rq.flushNow();
                    this.buf.putInt(53);
                    countIndex = this.buf.position();
                    this.buf.putInt(0);
                    spanCount = 0;
                    remainingSpans = this.buf.remaining() / 16;
                }
                this.buf.putInt(span[0]);
                this.buf.putInt(span[1]);
                this.buf.putInt(span[2]);
                this.buf.putInt(span[3]);
                ++spanCount;
                --remainingSpans;
            }
            this.buf.putInt(countIndex, spanCount);
            this.rq.ensureCapacity(4);
            this.buf.putInt(54);
        }
    }

    private void resetComposite() {
        this.rq.ensureCapacity(4);
        this.buf.putInt(58);
    }

    private void setComposite(Composite comp, int flags) {
        if (comp instanceof AlphaComposite) {
            AlphaComposite ac = (AlphaComposite)comp;
            this.rq.ensureCapacity(16);
            this.buf.putInt(56);
            this.buf.putInt(ac.getRule());
            this.buf.putFloat(ac.getAlpha());
            this.buf.putInt(flags);
        } else if (comp instanceof XORComposite) {
            int xorPixel = ((XORComposite)comp).getXorPixel();
            this.rq.ensureCapacity(8);
            this.buf.putInt(57);
            this.buf.putInt(xorPixel);
        } else {
            throw new InternalError("not yet implemented");
        }
    }

    private void resetTransform() {
        this.rq.ensureCapacity(4);
        this.buf.putInt(60);
    }

    private void setTransform(AffineTransform xform) {
        this.rq.ensureCapacityAndAlignment(52, 4);
        this.buf.putInt(59);
        this.buf.putDouble(xform.getScaleX());
        this.buf.putDouble(xform.getShearY());
        this.buf.putDouble(xform.getShearX());
        this.buf.putDouble(xform.getScaleY());
        this.buf.putDouble(xform.getTranslateX());
        this.buf.putDouble(xform.getTranslateY());
    }
}

