/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.net.ProgressSource;
import sun.net.www.MeteredStream;
import sun.net.www.http.HttpClient;
import sun.net.www.http.Hurryable;
import sun.net.www.http.KeepAliveCleanerEntry;
import sun.net.www.http.KeepAliveStreamCleaner;

public class KeepAliveStream
extends MeteredStream
implements Hurryable {
    HttpClient hc;
    boolean hurried;
    protected boolean queuedForCleanup = false;
    private static KeepAliveStreamCleaner queue = new KeepAliveStreamCleaner();
    private static Thread cleanerThread = null;
    private static boolean startCleanupThread;

    public KeepAliveStream(InputStream is, ProgressSource pi, int expected, HttpClient hc) {
        super(is, pi, expected);
        this.hc = hc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.queuedForCleanup) {
            return;
        }
        try {
            if (this.expected > this.count) {
                long nskip = this.expected - this.count;
                if (nskip <= (long)this.available()) {
                    long n = 0L;
                    while (n < nskip) {
                        n = this.skip(nskip -= n);
                    }
                } else if (this.expected <= KeepAliveStreamCleaner.MAX_DATA_REMAINING && !this.hurried) {
                    KeepAliveStream.queueForCleanup(new KeepAliveCleanerEntry(this, this.hc));
                } else {
                    this.hc.closeServer();
                }
            }
            if (!(this.closed || this.hurried || this.queuedForCleanup)) {
                this.hc.finished();
            }
            Object var6_3 = null;
            if (this.pi != null) {
                this.pi.finishTracking();
            }
            if (!this.queuedForCleanup) {
                this.in = null;
                this.hc = null;
                this.closed = true;
            }
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            if (this.pi != null) {
                this.pi.finishTracking();
            }
            if (!this.queuedForCleanup) {
                this.in = null;
                this.hc = null;
                this.closed = true;
            }
            throw throwable;
        }
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int limit) {
    }

    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public synchronized boolean hurry() {
        try {
            if (this.closed || this.count >= this.expected) {
                return false;
            }
            if (this.in.available() < this.expected - this.count) {
                return false;
            }
            byte[] buf = new byte[this.expected - this.count];
            DataInputStream dis = new DataInputStream(this.in);
            dis.readFully(buf);
            this.in = new ByteArrayInputStream(buf);
            this.hurried = true;
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static synchronized void queueForCleanup(KeepAliveCleanerEntry kace) {
        if (queue != null && !kace.getQueuedForCleanup()) {
            if (!queue.offer(kace)) {
                kace.getHttpClient().closeServer();
                return;
            }
            kace.setQueuedForCleanup();
        }
        boolean bl = startCleanupThread = cleanerThread == null;
        if (!startCleanupThread && !cleanerThread.isAlive()) {
            startCleanupThread = true;
        }
        if (startCleanupThread) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ThreadGroup grp = Thread.currentThread().getThreadGroup();
                    ThreadGroup parent = null;
                    while ((parent = grp.getParent()) != null) {
                        grp = parent;
                    }
                    cleanerThread = new Thread(grp, queue, "Keep-Alive-SocketCleaner");
                    cleanerThread.setDaemon(true);
                    cleanerThread.setPriority(8);
                    cleanerThread.start();
                    return null;
                }
            });
        }
    }

    protected int remainingToRead() {
        return this.expected - this.count;
    }

    protected void setClosed() {
        this.in = null;
        this.hc = null;
        this.closed = true;
    }
}

