/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.Channel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.SelectorProvider;
import sun.nio.ch.DatagramChannelImpl;
import sun.nio.ch.Reflect;
import sun.nio.ch.SelectorProviderImpl;
import sun.nio.ch.ServerSocketChannelImpl;
import sun.nio.ch.SocketChannelImpl;
import sun.nio.ch.Util;

class InheritedChannel {
    private static final int UNKNOWN = -1;
    private static final int SOCK_STREAM = 1;
    private static final int SOCK_DGRAM = 2;
    private static final int O_RDONLY = 0;
    private static final int O_WRONLY = 1;
    private static final int O_RDWR = 2;
    private static int devnull = -1;
    private static boolean haveChannel = false;
    private static Channel channel = null;

    InheritedChannel() {
    }

    private static void detachIOStreams() {
        try {
            InheritedChannel.dup2(devnull, 0);
            InheritedChannel.dup2(devnull, 1);
            InheritedChannel.dup2(devnull, 2);
        }
        catch (IOException ioe) {
            throw new InternalError();
        }
    }

    private static void checkAccess(Channel c) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("inheritedChannel"));
        }
    }

    private static Channel createChannel() throws IOException {
        AbstractSelectableChannel c;
        int fdVal = InheritedChannel.dup(0);
        int st = InheritedChannel.soType0(fdVal);
        if (st != 1 && st != 2) {
            InheritedChannel.close0(fdVal);
            return null;
        }
        Class[] paramTypes = new Class[]{Integer.TYPE};
        Constructor ctr = Reflect.lookupConstructor("java.io.FileDescriptor", paramTypes);
        Object[] args = new Object[]{new Integer(fdVal)};
        FileDescriptor fd = (FileDescriptor)Reflect.invoke(ctr, args);
        SelectorProvider provider = SelectorProvider.provider();
        assert (provider instanceof SelectorProviderImpl);
        if (st == 1) {
            InetAddress ia = InheritedChannel.peerAddress0(fdVal);
            if (ia == null) {
                c = new InheritedServerSocketChannelImpl(provider, fd);
            } else {
                int port = InheritedChannel.peerPort0(fdVal);
                assert (port > 0);
                InetSocketAddress isa = new InetSocketAddress(ia, port);
                c = new InheritedSocketChannelImpl(provider, fd, isa);
            }
        } else {
            c = new InheritedDatagramChannelImpl(provider, fd);
        }
        return c;
    }

    public static synchronized Channel getChannel() throws IOException {
        if (devnull < 0) {
            devnull = InheritedChannel.open0("/dev/null", 2);
        }
        if (!haveChannel) {
            channel = InheritedChannel.createChannel();
            haveChannel = true;
        }
        if (channel != null) {
            InheritedChannel.checkAccess(channel);
        }
        return channel;
    }

    private static native int dup(int var0) throws IOException;

    private static native void dup2(int var0, int var1) throws IOException;

    private static native int open0(String var0, int var1) throws IOException;

    private static native void close0(int var0) throws IOException;

    private static native int soType0(int var0);

    private static native InetAddress peerAddress0(int var0);

    private static native int peerPort0(int var0);

    static {
        Util.load();
    }

    public static class InheritedDatagramChannelImpl
    extends DatagramChannelImpl {
        InheritedDatagramChannelImpl(SelectorProvider sp, FileDescriptor fd) throws IOException {
            super(sp, fd);
        }

        protected void implCloseSelectableChannel() throws IOException {
            super.implCloseSelectableChannel();
            InheritedChannel.detachIOStreams();
        }
    }

    public static class InheritedServerSocketChannelImpl
    extends ServerSocketChannelImpl {
        InheritedServerSocketChannelImpl(SelectorProvider sp, FileDescriptor fd) throws IOException {
            super(sp, fd);
        }

        protected void implCloseSelectableChannel() throws IOException {
            super.implCloseSelectableChannel();
            InheritedChannel.detachIOStreams();
        }
    }

    public static class InheritedSocketChannelImpl
    extends SocketChannelImpl {
        InheritedSocketChannelImpl(SelectorProvider sp, FileDescriptor fd, InetSocketAddress remote) throws IOException {
            super(sp, fd, remote);
        }

        protected void implCloseSelectableChannel() throws IOException {
            super.implCloseSelectableChannel();
            InheritedChannel.detachIOStreams();
        }
    }
}

