/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetBoundException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import sun.nio.ch.AlreadyBoundException;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.NativeThread;
import sun.nio.ch.Net;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.ServerSocketAdaptor;
import sun.nio.ch.SocketChannelImpl;
import sun.nio.ch.SocketDispatcher;
import sun.nio.ch.SocketOpts;
import sun.nio.ch.SocketOptsImpl;
import sun.nio.ch.Util;

class ServerSocketChannelImpl
extends ServerSocketChannel
implements SelChImpl {
    private static NativeDispatcher nd;
    private final FileDescriptor fd;
    private int fdVal;
    private volatile long thread = 0L;
    private final Object lock = new Object();
    private final Object stateLock = new Object();
    private static final int ST_UNINITIALIZED = -1;
    private static final int ST_INUSE = 0;
    private static final int ST_KILLED = 1;
    private int state = -1;
    private SocketAddress localAddress = null;
    private SocketOpts.IP.TCP options = null;
    ServerSocket socket;

    public ServerSocketChannelImpl(SelectorProvider sp) throws IOException {
        super(sp);
        this.fd = Net.serverSocket(true);
        this.fdVal = IOUtil.fdVal(this.fd);
        this.state = 0;
    }

    public ServerSocketChannelImpl(SelectorProvider sp, FileDescriptor fd) throws IOException {
        super(sp);
        this.fd = fd;
        this.fdVal = IOUtil.fdVal(fd);
        this.state = 0;
        this.localAddress = Net.localAddress(fd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerSocket socket() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.socket == null) {
                this.socket = ServerSocketAdaptor.create(this);
            }
            return this.socket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBound() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.localAddress != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress localAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.localAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(SocketAddress local, int backlog) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (this.isBound()) {
                throw new AlreadyBoundException();
            }
            InetSocketAddress isa = Net.checkAddress(local);
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkListen(isa.getPort());
            }
            Net.bind(this.fd, isa.getAddress(), isa.getPort());
            ServerSocketChannelImpl.listen(this.fd, backlog < 1 ? 50 : backlog);
            Object object2 = this.stateLock;
            synchronized (object2) {
                this.localAddress = Net.localAddress(this.fd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SocketChannel accept() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            InetSocketAddress[] isaa;
            FileDescriptor newfd;
            int n;
            SocketChannelImpl sc;
            block16: {
                boolean bl;
                SocketChannel socketChannel;
                block15: {
                    if (!this.isOpen()) {
                        throw new ClosedChannelException();
                    }
                    if (!this.isBound()) {
                        throw new NotYetBoundException();
                    }
                    sc = null;
                    n = 0;
                    newfd = new FileDescriptor();
                    isaa = new InetSocketAddress[1];
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            socketChannel = null;
                            Object var8_8 = null;
                            this.thread = 0L;
                            bl = n > 0;
                            break block15;
                        }
                        this.thread = NativeThread.current();
                        while ((n = this.accept0(this.fd, newfd, isaa)) == -3 && this.isOpen()) {
                        }
                        break block16;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        this.thread = 0L;
                        this.end(n > 0);
                        assert (IOStatus.check(n));
                        throw throwable;
                    }
                }
                this.end(bl);
                assert (IOStatus.check(n));
                return socketChannel;
            }
            Object var8_9 = null;
            this.thread = 0L;
            this.end(n > 0);
            assert (IOStatus.check(n));
            if (n < 1) {
                return null;
            }
            IOUtil.configureBlocking(newfd, true);
            InetSocketAddress isa = isaa[0];
            sc = new SocketChannelImpl(this.provider(), newfd, isa);
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                try {
                    sm.checkAccept(isa.getAddress().getHostAddress(), isa.getPort());
                }
                catch (SecurityException x) {
                    sc.close();
                    throw x;
                }
            }
            return sc;
        }
    }

    protected void implConfigureBlocking(boolean block) throws IOException {
        IOUtil.configureBlocking(this.fd, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketOpts options() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.options == null) {
                SocketOptsImpl.Dispatcher d = new SocketOptsImpl.Dispatcher(){

                    int getInt(int opt) throws IOException {
                        return Net.getIntOption(ServerSocketChannelImpl.this.fd, opt);
                    }

                    void setInt(int opt, int arg) throws IOException {
                        Net.setIntOption(ServerSocketChannelImpl.this.fd, opt, arg);
                    }
                };
                this.options = new SocketOptsImpl.IP.TCP(d);
            }
            return this.options;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void implCloseSelectableChannel() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            nd.preClose(this.fd);
            long th = this.thread;
            if (th != 0L) {
                NativeThread.signal(th);
            }
            if (!this.isRegistered()) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 1) {
                return;
            }
            if (this.state == -1) {
                this.state = 1;
                return;
            }
            assert (!this.isOpen() && !this.isRegistered());
            nd.close(this.fd);
            this.state = 1;
        }
    }

    public boolean translateReadyOps(int ops, int initialOps, SelectionKeyImpl sk) {
        int intOps = sk.nioInterestOps();
        int oldOps = sk.nioReadyOps();
        int newOps = initialOps;
        if ((ops & 0x20) != 0) {
            return false;
        }
        if ((ops & 0x18) != 0) {
            newOps = intOps;
            sk.nioReadyOps(newOps);
            return (newOps & ~oldOps) != 0;
        }
        if ((ops & 1) != 0 && (intOps & 0x10) != 0) {
            newOps |= 0x10;
        }
        sk.nioReadyOps(newOps);
        return (newOps & ~oldOps) != 0;
    }

    public boolean translateAndUpdateReadyOps(int ops, SelectionKeyImpl sk) {
        return this.translateReadyOps(ops, sk.nioReadyOps(), sk);
    }

    public boolean translateAndSetReadyOps(int ops, SelectionKeyImpl sk) {
        return this.translateReadyOps(ops, 0, sk);
    }

    public void translateAndSetInterestOps(int ops, SelectionKeyImpl sk) {
        int newOps = 0;
        if ((ops & 0x10) != 0) {
            newOps |= 1;
        }
        sk.selector.putEventOps(sk, newOps);
    }

    public FileDescriptor getFD() {
        return this.fd;
    }

    public int getFDVal() {
        return this.fdVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append('[');
        if (!this.isOpen()) {
            sb.append("closed");
        } else {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.localAddress() == null) {
                    sb.append("unbound");
                } else {
                    sb.append(this.localAddress().toString());
                }
            }
        }
        sb.append(']');
        return sb.toString();
    }

    private static native void listen(FileDescriptor var0, int var1) throws IOException;

    private native int accept0(FileDescriptor var1, FileDescriptor var2, InetSocketAddress[] var3) throws IOException;

    private static native void initIDs();

    static {
        Util.load();
        ServerSocketChannelImpl.initIDs();
        nd = new SocketDispatcher();
    }
}

