/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.ietf.jgss.Oid;
import sun.security.jgss.GSSUtil;
import sun.security.util.Debug;

public class LoginConfigImpl
extends Configuration {
    private final Configuration config;
    private final int caller;
    private final String mechName;
    private static final Debug debug = Debug.getInstance("gssloginconfig", "\t[GSS LoginConfigImpl]");

    public LoginConfigImpl(int caller, Oid mech) {
        this.caller = caller;
        if (!mech.equals(GSSUtil.GSS_KRB5_MECH_OID)) {
            throw new IllegalArgumentException(mech.toString() + " not supported");
        }
        this.mechName = "krb5";
        this.config = AccessController.doPrivileged(new PrivilegedAction<Configuration>(){

            @Override
            public Configuration run() {
                return Configuration.getConfiguration();
            }
        });
    }

    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        String[] alts;
        AppConfigurationEntry[] entries;
        block14: {
            block13: {
                entries = null;
                if ("OTHER".equalsIgnoreCase(name)) {
                    return null;
                }
                alts = null;
                if (!"krb5".equals(this.mechName)) break block13;
                switch (this.caller) {
                    case 1: {
                        alts = new String[]{"com.sun.security.jgss.krb5.initiate", "com.sun.security.jgss.initiate"};
                        break block14;
                    }
                    case 2: {
                        alts = new String[]{"com.sun.security.jgss.krb5.accept", "com.sun.security.jgss.accept"};
                        break block14;
                    }
                    case 3: {
                        alts = new String[]{"com.sun.security.jgss.krb5.initiate", "com.sun.net.ssl.client"};
                        break block14;
                    }
                    case 4: {
                        alts = new String[]{"com.sun.security.jgss.krb5.accept", "com.sun.net.ssl.server"};
                        break block14;
                    }
                    case 5: {
                        alts = new String[]{"com.sun.security.jgss.krb5.initiate"};
                        break block14;
                    }
                    case -1: {
                        throw new AssertionError((Object)"caller cannot be unknown");
                    }
                    default: {
                        throw new AssertionError((Object)"caller not defined");
                    }
                }
            }
            throw new IllegalArgumentException(this.mechName + " not supported");
        }
        for (String alt : alts) {
            entries = this.config.getAppConfigurationEntry(alt);
            if (debug != null) {
                debug.println("Trying " + alt + (entries == null ? ": does not exist." : ": Found!"));
            }
            if (entries != null) break;
        }
        if (entries == null) {
            if (debug != null) {
                debug.println("Cannot read JGSS entry, use default values instead.");
            }
            entries = this.getDefaultConfigurationEntry();
        }
        return entries;
    }

    private AppConfigurationEntry[] getDefaultConfigurationEntry() {
        HashMap<String, String> options = new HashMap<String, String>(2);
        if (this.mechName == null || this.mechName.equals("krb5")) {
            if (LoginConfigImpl.isServerSide(this.caller)) {
                options.put("useKeyTab", "true");
                options.put("storeKey", "true");
                options.put("doNotPrompt", "true");
                options.put("isInitiator", "false");
            } else {
                options.put("useTicketCache", "true");
                options.put("doNotPrompt", "false");
            }
            return new AppConfigurationEntry[]{new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        }
        return null;
    }

    private static boolean isServerSide(int caller) {
        return 2 == caller || 4 == caller;
    }
}

