/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.OIDMap;

public class OtherName
implements GeneralNameInterface {
    private String name;
    private ObjectIdentifier oid;
    private byte[] nameValue = null;
    private GeneralNameInterface gni = null;
    private static final byte TAG_VALUE = 0;
    private int myhash = -1;

    public OtherName(ObjectIdentifier oid, byte[] value) throws IOException {
        if (oid == null || value == null) {
            throw new NullPointerException("parameters may not be null");
        }
        this.oid = oid;
        this.nameValue = value;
        this.gni = this.getGNI(oid, value);
        this.name = this.gni != null ? this.gni.toString() : "Unrecognized ObjectIdentifier: " + oid.toString();
    }

    public OtherName(DerValue derValue) throws IOException {
        DerInputStream in = derValue.toDerInputStream();
        this.oid = in.getOID();
        DerValue val = in.getDerValue();
        this.nameValue = val.toByteArray();
        this.gni = this.getGNI(this.oid, this.nameValue);
        this.name = this.gni != null ? this.gni.toString() : "Unrecognized ObjectIdentifier: " + this.oid.toString();
    }

    public ObjectIdentifier getOID() {
        return this.oid;
    }

    public byte[] getNameValue() {
        return (byte[])this.nameValue.clone();
    }

    private GeneralNameInterface getGNI(ObjectIdentifier oid, byte[] nameValue) throws IOException {
        try {
            Class extClass = OIDMap.getClass(oid);
            if (extClass == null) {
                return null;
            }
            Class[] params = new Class[]{Object.class};
            Constructor cons = extClass.getConstructor(params);
            Object[] passed = new Object[]{nameValue};
            GeneralNameInterface gni = (GeneralNameInterface)cons.newInstance(passed);
            return gni;
        }
        catch (Exception e) {
            throw (IOException)new IOException("Instantiation error: " + e).initCause(e);
        }
    }

    public int getType() {
        return 0;
    }

    public void encode(DerOutputStream out) throws IOException {
        if (this.gni != null) {
            this.gni.encode(out);
            return;
        }
        DerOutputStream tmp = new DerOutputStream();
        tmp.putOID(this.oid);
        tmp.write(DerValue.createTag((byte)-128, true, (byte)0), this.nameValue);
        out.write((byte)48, tmp);
    }

    public boolean equals(Object other) {
        boolean result;
        if (this == other) {
            return true;
        }
        if (!(other instanceof OtherName)) {
            return false;
        }
        OtherName otherOther = (OtherName)other;
        if (!otherOther.oid.equals(this.oid)) {
            return false;
        }
        GeneralNameInterface otherGNI = null;
        try {
            otherGNI = this.getGNI(otherOther.oid, otherOther.nameValue);
        }
        catch (IOException ioe) {
            return false;
        }
        if (otherGNI != null) {
            try {
                result = otherGNI.constrains(this) == 0;
            }
            catch (UnsupportedOperationException ioe) {
                result = false;
            }
        } else {
            result = Arrays.equals(this.nameValue, otherOther.nameValue);
        }
        return result;
    }

    public int hashCode() {
        if (this.myhash == -1) {
            this.myhash = 37 + this.oid.hashCode();
            for (int i = 0; i < this.nameValue.length; ++i) {
                this.myhash = 37 * this.myhash + this.nameValue[i];
            }
        }
        return this.myhash;
    }

    public String toString() {
        return "Other-Name: " + this.name;
    }

    public int constrains(GeneralNameInterface inputName) {
        int constraintType;
        if (inputName == null) {
            constraintType = -1;
        } else if (inputName.getType() != 0) {
            constraintType = -1;
        } else {
            throw new UnsupportedOperationException("Narrowing, widening, and matching are not supported for OtherName.");
        }
        return constraintType;
    }

    public int subtreeDepth() {
        throw new UnsupportedOperationException("subtreeDepth() not supported for generic OtherName");
    }
}

