/*
 * Decompiled with CFR 0.152.
 */
package sun.util;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.spi.BreakIteratorProvider;
import java.text.spi.CollatorProvider;
import java.text.spi.DateFormatProvider;
import java.text.spi.DateFormatSymbolsProvider;
import java.text.spi.DecimalFormatSymbolsProvider;
import java.text.spi.NumberFormatProvider;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import java.util.spi.CurrencyNameProvider;
import java.util.spi.LocaleNameProvider;
import java.util.spi.LocaleServiceProvider;
import java.util.spi.TimeZoneNameProvider;
import sun.util.resources.LocaleData;
import sun.util.resources.OpenListResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocaleServiceProviderPool {
    private static Map<Class, LocaleServiceProviderPool> poolOfPools = new ConcurrentHashMap<Class, LocaleServiceProviderPool>();
    private Set<LocaleServiceProvider> providers = new LinkedHashSet<LocaleServiceProvider>();
    private Map<Locale, LocaleServiceProvider> providersCache = new ConcurrentHashMap<Locale, LocaleServiceProvider>();
    private Set<Locale> availableLocales = null;
    private static List<Locale> availableJRELocales = null;
    private Set<Locale> providerLocales = null;

    public static LocaleServiceProviderPool getPool(Class<? extends LocaleServiceProvider> providerClass) {
        LocaleServiceProviderPool newPool;
        LocaleServiceProviderPool pool = poolOfPools.get(providerClass);
        if (pool == null && (pool = poolOfPools.put(providerClass, newPool = new LocaleServiceProviderPool(providerClass))) == null) {
            pool = newPool;
        }
        return pool;
    }

    private LocaleServiceProviderPool(final Class<? extends LocaleServiceProvider> c) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() {
                    for (LocaleServiceProvider provider : ServiceLoader.loadInstalled(c)) {
                        LocaleServiceProviderPool.this.providers.add(provider);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Logger.getLogger("sun.util.LocaleServiceProviderPool").config(e.toString());
        }
    }

    public static Locale[] getAllAvailableLocales() {
        return (Locale[])AllAvailableLocales.allAvailableLocales.clone();
    }

    public synchronized Locale[] getAvailableLocales() {
        if (this.availableLocales == null) {
            this.availableLocales = new HashSet<Locale>(this.getJRELocales());
            if (this.hasProviders()) {
                this.availableLocales.addAll(this.getProviderLocales());
            }
        }
        Locale[] tmp = new Locale[this.availableLocales.size()];
        this.availableLocales.toArray(tmp);
        return tmp;
    }

    private synchronized Set<Locale> getProviderLocales() {
        if (this.providerLocales == null) {
            this.providerLocales = new HashSet<Locale>();
            if (this.hasProviders()) {
                for (LocaleServiceProvider lsp : this.providers) {
                    Locale[] locales;
                    for (Locale locale : locales = lsp.getAvailableLocales()) {
                        this.providerLocales.add(locale);
                    }
                }
            }
        }
        return this.providerLocales;
    }

    public boolean hasProviders() {
        return !this.providers.isEmpty();
    }

    private synchronized List<Locale> getJRELocales() {
        if (availableJRELocales == null) {
            availableJRELocales = Arrays.asList(LocaleData.getAvailableLocales());
        }
        return availableJRELocales;
    }

    private boolean isJRESupported(Locale locale) {
        List<Locale> locales = this.getJRELocales();
        return locales.contains(locale);
    }

    public <P, S> S getLocalizedObject(LocalizedObjectGetter<P, S> getter, Locale locale, Object ... params) {
        return this.getLocalizedObjectImpl(getter, locale, true, null, null, null, params);
    }

    public <P, S> S getLocalizedObject(LocalizedObjectGetter<P, S> getter, Locale locale, OpenListResourceBundle bundle, String key, Object ... params) {
        return this.getLocalizedObjectImpl(getter, locale, false, null, bundle, key, params);
    }

    public <P, S> S getLocalizedObject(LocalizedObjectGetter<P, S> getter, Locale locale, String bundleKey, OpenListResourceBundle bundle, String key, Object ... params) {
        return this.getLocalizedObjectImpl(getter, locale, false, bundleKey, bundle, key, params);
    }

    private <P, S> S getLocalizedObjectImpl(LocalizedObjectGetter<P, S> getter, Locale locale, boolean isObjectProvider, String bundleKey, OpenListResourceBundle bundle, String key, Object ... params) {
        if (this.hasProviders()) {
            LocaleServiceProvider lsp;
            if (bundleKey == null) {
                bundleKey = key;
            }
            Locale bundleLocale = bundle != null ? bundle.getLocale() : null;
            Locale requested = locale;
            S providersObj = null;
            while ((locale = this.findProviderLocale(locale, bundleLocale)) != null) {
                lsp = this.findProvider(locale);
                if (lsp != null) {
                    providersObj = getter.getObject(lsp, requested, key, params);
                    if (providersObj != null) {
                        return providersObj;
                    }
                    if (isObjectProvider) {
                        Logger.getLogger("sun.util.LocaleServiceProviderPool").config("A locale sensitive service provider returned null for a localized objects,  which should not happen.  provider: " + lsp + " locale: " + requested);
                    }
                }
                locale = LocaleServiceProviderPool.getParentLocale(locale);
            }
            while (bundle != null) {
                bundleLocale = bundle.getLocale();
                if (bundle.handleGetKeys().contains(bundleKey)) {
                    return null;
                }
                lsp = this.findProvider(bundleLocale);
                if (lsp != null && (providersObj = (S)getter.getObject(lsp, requested, key, params)) != null) {
                    return providersObj;
                }
                bundle = bundle.getParent();
            }
        }
        return null;
    }

    private LocaleServiceProvider findProvider(Locale locale) {
        if (!this.hasProviders()) {
            return null;
        }
        if (this.providersCache.containsKey(locale)) {
            LocaleServiceProvider provider = this.providersCache.get(locale);
            if (provider != NullProvider.INSTANCE) {
                return provider;
            }
        } else {
            for (LocaleServiceProvider lsp : this.providers) {
                Locale[] locales;
                for (Locale available : locales = lsp.getAvailableLocales()) {
                    if (!locale.equals(available)) continue;
                    LocaleServiceProvider providerInCache = this.providersCache.put(locale, lsp);
                    return providerInCache != null ? providerInCache : lsp;
                }
            }
            this.providersCache.put(locale, NullProvider.INSTANCE);
        }
        return null;
    }

    private Locale findProviderLocale(Locale start, Locale end) {
        Set<Locale> provLoc = this.getProviderLocales();
        Locale current = start;
        while (current != null) {
            if (end != null) {
                if (current.equals(end)) {
                    current = null;
                    break;
                }
            } else if (this.isJRESupported(current)) {
                current = null;
                break;
            }
            if (provLoc.contains(current)) break;
            current = LocaleServiceProviderPool.getParentLocale(current);
        }
        return current;
    }

    private static Locale getParentLocale(Locale locale) {
        String variant = locale.getVariant();
        if (variant != "") {
            int underscoreIndex = variant.lastIndexOf(95);
            if (underscoreIndex != -1) {
                return new Locale(locale.getLanguage(), locale.getCountry(), variant.substring(0, underscoreIndex));
            }
            return new Locale(locale.getLanguage(), locale.getCountry());
        }
        if (locale.getCountry() != "") {
            return new Locale(locale.getLanguage());
        }
        if (locale.getLanguage() != "") {
            return Locale.ROOT;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface LocalizedObjectGetter<P, S> {
        public S getObject(P var1, Locale var2, String var3, Object ... var4);
    }

    private static class NullProvider
    extends LocaleServiceProvider {
        private static final NullProvider INSTANCE = new NullProvider();

        private NullProvider() {
        }

        public Locale[] getAvailableLocales() {
            throw new RuntimeException("Should not get called.");
        }
    }

    private static class AllAvailableLocales {
        static final Locale[] allAvailableLocales;

        private AllAvailableLocales() {
        }

        static {
            Class[] providerClasses = new Class[]{BreakIteratorProvider.class, CollatorProvider.class, DateFormatProvider.class, DateFormatSymbolsProvider.class, DecimalFormatSymbolsProvider.class, NumberFormatProvider.class, CurrencyNameProvider.class, LocaleNameProvider.class, TimeZoneNameProvider.class};
            HashSet<Locale> all = new HashSet<Locale>(Arrays.asList(LocaleData.getAvailableLocales()));
            for (Class providerClass : providerClasses) {
                LocaleServiceProviderPool pool = LocaleServiceProviderPool.getPool(providerClass);
                all.addAll(pool.getProviderLocales());
            }
            allAvailableLocales = all.toArray(new Locale[0]);
        }
    }
}

