/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.help;

import com.sun.star.help.HelpFileDocument;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.cjk.CJKAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexWriter;

public class HelpIndexer {
    public static void main(String[] stringArray) {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if ("-lang".equals(stringArray[i])) {
                if (i + 1 < n) {
                    string2 = stringArray[i + 1];
                    bl = true;
                }
                ++i;
                continue;
            }
            if ("-mod".equals(stringArray[i])) {
                if (i + 1 < n) {
                    string3 = stringArray[i + 1];
                    bl2 = true;
                }
                ++i;
                continue;
            }
            if ("-zipdir".equals(stringArray[i])) {
                if (i + 1 < n) {
                    string = stringArray[i + 1];
                    bl3 = true;
                }
                ++i;
                continue;
            }
            if (!"-o".equals(stringArray[i])) continue;
            if (i + 1 < n) {
                string4 = stringArray[i + 1];
                bl4 = true;
            }
            ++i;
        }
        if (!(bl && bl2 && bl3 && bl4)) {
            System.out.println("Usage: HelpIndexer -lang ISOLangCode -mod HelpModule -zipdir TempZipDir -o OutputZipFile");
            System.exit(-1);
        }
        File file = new File(string);
        String string5 = string3 + ".idxl";
        File file2 = new File(string + File.separator + string5);
        File file3 = new File(string + File.separator + "caption");
        File file4 = new File(string + File.separator + "content");
        try {
            Date date = new Date();
            CJKAnalyzer cJKAnalyzer = string2.equals("ja") ? new CJKAnalyzer() : new StandardAnalyzer();
            IndexWriter indexWriter = new IndexWriter(file2, (Analyzer)cJKAnalyzer, true);
            System.out.println("Lucene: Indexing to directory '" + file2 + "'...");
            int n2 = HelpIndexer.indexDocs(indexWriter, string3, file3, file4);
            if (n2 != -1) {
                System.out.println();
                System.out.println("Optimizing ...");
                indexWriter.optimize();
            }
            indexWriter.close();
            if (n2 == -1) {
                HelpIndexer.deleteRecursively(file2);
            }
            System.out.println("Zipping ...");
            File file5 = new File(string);
            HelpIndexer.createZipFile(file5, string4);
            HelpIndexer.deleteRecursively(file5);
            Date date2 = new Date();
            System.out.println(date2.getTime() - date.getTime() + " total milliseconds");
        }
        catch (IOException iOException) {
            System.out.println(" caught a " + iOException.getClass() + "\n with message: " + iOException.getMessage());
            System.exit(-1);
        }
    }

    private static int indexDocs(IndexWriter indexWriter, String string, File file, File file2) throws IOException {
        File file3;
        if (!file.canRead() || !file.isDirectory()) {
            System.out.println("Not found: " + file);
            return -1;
        }
        if (!file2.canRead() || !file2.isDirectory()) {
            System.out.println("Not found: " + file2);
            return -1;
        }
        String[] stringArray = file.list();
        List<String> list = Arrays.asList(stringArray);
        HashSet<String> hashSet = new HashSet<String>(list);
        String[] stringArray2 = file2.list();
        List<String> list2 = Arrays.asList(stringArray2);
        HashSet<String> hashSet2 = new HashSet<String>(list2);
        System.out.println("Indexing, adding files");
        for (String string2 : stringArray) {
            File object = new File(file, string2);
            file3 = null;
            if (hashSet2.contains(string2)) {
                file3 = new File(file2, string2);
            }
            System.out.print(".");
            indexWriter.addDocument(HelpFileDocument.Document(string, object, file3));
        }
        for (String string2 : stringArray2) {
            if (hashSet.contains(string2)) continue;
            file3 = null;
            File file4 = new File(file2, string2);
            System.out.print(".");
            indexWriter.addDocument(HelpFileDocument.Document(string, file3, file4));
        }
        return 0;
    }

    public static void createZipFile(File file, String string) throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
        File[] fileArray = file.listFiles();
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            HelpIndexer.addToZipRecursively(zipOutputStream, fileArray[i], null);
        }
        zipOutputStream.close();
    }

    public static void addToZipRecursively(ZipOutputStream zipOutputStream, File file, String string) throws FileNotFoundException, IOException {
        if (file.isDirectory()) {
            String string2 = file.getName();
            if (string2.equalsIgnoreCase("caption") || string2.equalsIgnoreCase("content")) {
                return;
            }
            File[] fileArray = file.listFiles();
            String string3 = "";
            if (string != null) {
                string3 = string3 + string + File.separator;
            }
            string3 = string3 + string2;
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                HelpIndexer.addToZipRecursively(zipOutputStream, fileArray[i], string3);
            }
            return;
        }
        int n = (int)file.length();
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[n];
        int n2 = fileInputStream.read(byArray, 0, n);
        fileInputStream.close();
        String string4 = file.getName();
        String string5 = "";
        if (string != null) {
            string5 = string5 + string + "/";
        }
        string5 = string5 + string4;
        ZipEntry zipEntry = new ZipEntry(string5);
        zipEntry.setTime(file.lastModified());
        zipEntry.setSize(n);
        int n3 = string4.toLowerCase().endsWith(".jar") ? 0 : 8;
        zipEntry.setMethod(n3);
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray, 0, byArray.length);
        zipEntry.setCrc(cRC32.getValue());
        zipOutputStream.putNextEntry(zipEntry);
        zipOutputStream.write(byArray, 0, n);
        zipOutputStream.closeEntry();
    }

    public static boolean deleteRecursively(File file) {
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                boolean bl = HelpIndexer.deleteRecursively(file2);
                if (bl) continue;
                return false;
            }
        }
        return file.delete();
    }
}

