/*
 * Decompiled with CFR 0.152.
 */
package org.GNOME.Accessibility;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleExtendedText;
import javax.accessibility.AccessibleText;
import javax.swing.text.AttributeSet;
import org.GNOME.Accessibility.JavaBridge;
import org.GNOME.Accessibility.TEXT_BOUNDARY_TYPE;
import org.GNOME.Accessibility.TEXT_CLIP_TYPE;
import org.GNOME.Accessibility.TextOperations;
import org.GNOME.Accessibility.TextPOATie;
import org.GNOME.Accessibility.TextPackage.Range;
import org.GNOME.Bonobo.UnknownImpl;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.IntHolder;

public class TextImpl
extends UnknownImpl
implements TextOperations {
    AccessibleText accText;
    AccessibleEditableText accEditableText;
    AccessibleContext ac;
    static final int LINE_PART = 4;

    public TextImpl(AccessibleContext accessibleContext) {
        this.accText = accessibleContext.getAccessibleText();
        this.accEditableText = accessibleContext.getAccessibleEditableText();
        this.ac = accessibleContext;
        this.poa = JavaBridge.getRootPOA();
        this.tie = new TextPOATie(this, JavaBridge.getRootPOA());
        try {
            JavaBridge.getRootPOA().activate_object(this.tie);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        JavaBridge.setInitialTextSize(accessibleContext, this.characterCount());
    }

    @Override
    public int characterCount() {
        int n = 0;
        try {
            if (this.accText != null) {
                n = this.accText.getCharCount();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    @Override
    public int caretOffset() {
        int n = 0;
        try {
            if (this.accText != null) {
                n = this.accText.getCaretPosition();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (n < 0) {
            return 0;
        }
        return n;
    }

    @Override
    public String getText(int n, int n2) {
        String string;
        block14: {
            string = "";
            try {
                int n3 = this.accText.getCharCount();
                if (n < 0) {
                    n = 0;
                }
                if (n2 >= n3 || n2 == -1) {
                    n2 = n3;
                } else if (n2 < -1) {
                    n2 = 0;
                }
                if (this.accEditableText != null) {
                    try {
                        String string2 = this.accEditableText.getTextRange(n, n2);
                        if (string2 != null) {
                            string = string2;
                        }
                        break block14;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    break block14;
                }
                if (this.accText != null) {
                    int n4;
                    String string3 = this.accText.getAtIndex(2, n);
                    for (n4 = n; n4 < n2 && string3.equals(this.accText.getAtIndex(2, n4)); ++n4) {
                        String string4 = this.accText.getAtIndex(1, n4);
                        if (string4 == null) continue;
                        string = string + string4;
                    }
                    while (n4 < n2) {
                        int n5;
                        if ((n4 += (n5 = (string3 = this.accText.getAtIndex(2, n4)).length())) > n2) {
                            string = string + string3.substring(0, string3.length() - (n4 - n2));
                            continue;
                        }
                        string = string + string3;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return string;
    }

    @Override
    public boolean setCaretOffset(int n) {
        if (this.accEditableText != null) {
            this.accEditableText.selectText(n, n);
            return true;
        }
        return false;
    }

    private boolean overlapsVertically(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle == null | rectangle2 == null) {
            return false;
        }
        if (rectangle.y == rectangle2.y) {
            return true;
        }
        int n = rectangle.y;
        int n2 = rectangle.y + rectangle.height;
        int n3 = rectangle2.y;
        int n4 = rectangle2.y + rectangle2.height;
        return n2 == n4 || n > n3 && n < n4 || n3 > n && n3 < n2 || n2 > n3 && n2 < n4 || n4 > n && n4 < n2;
    }

    private StringStruct getLine(AccessibleText accessibleText, int n, TEXT_BOUNDARY_TYPE tEXT_BOUNDARY_TYPE) {
        String string = "";
        StringStruct stringStruct = new StringStruct();
        int n2 = n;
        int n3 = n;
        try {
            int n4 = accessibleText.getCharCount();
            Rectangle rectangle = accessibleText.getCharacterBounds(n);
            Rectangle rectangle2 = null;
            if (rectangle == null && n > 0) {
                rectangle = accessibleText.getCharacterBounds(n - 1);
            }
            while (n2 > 0) {
                if (this.overlapsVertically(rectangle, rectangle2 = accessibleText.getCharacterBounds(--n2))) continue;
                ++n2;
                break;
            }
            rectangle2 = rectangle;
            while (n3 < n4 && this.overlapsVertically(rectangle, rectangle2)) {
                rectangle2 = accessibleText.getCharacterBounds(++n3);
            }
            string = this.getText(n2, n3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (tEXT_BOUNDARY_TYPE == TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_LINE_END && n2 > 0) {
            --n2;
        }
        stringStruct.startOffset = n2;
        stringStruct.endOffset = n3;
        stringStruct.string = string == "" ? "" : string;
        return stringStruct;
    }

    private String concatenateText(AccessibleText accessibleText, String string, TEXT_BOUNDARY_TYPE tEXT_BOUNDARY_TYPE, int n) {
        try {
            int n2 = this.boundaryTypeConvert(tEXT_BOUNDARY_TYPE);
            if (n < 0 || n > accessibleText.getCharCount()) {
                return "";
            }
            if (tEXT_BOUNDARY_TYPE == TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_WORD_START || tEXT_BOUNDARY_TYPE == TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_SENTENCE_START) {
                String string2 = accessibleText.getBeforeIndex(n2, n);
                if (string2 != null) {
                    string = string2 + string;
                }
            } else {
                String string3 = accessibleText.getAfterIndex(n2, n);
                if (string3 != null) {
                    string = string + string3;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    private String concatenateWhitespace(AccessibleText accessibleText, String string, TEXT_BOUNDARY_TYPE tEXT_BOUNDARY_TYPE, int n) {
        try {
            String string2;
            int n2 = this.boundaryTypeConvert(tEXT_BOUNDARY_TYPE);
            if (n < 0 || n > accessibleText.getCharCount()) {
                return "";
            }
            if (tEXT_BOUNDARY_TYPE == TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_WORD_START) {
                String string3 = accessibleText.getAfterIndex(n2, n);
                if (string3 != null) {
                    string = string + string3;
                }
            } else if (tEXT_BOUNDARY_TYPE == TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_WORD_END && (string2 = accessibleText.getBeforeIndex(n2, n)) != null) {
                string = string2 + string;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    private int boundaryTypeConvert(TEXT_BOUNDARY_TYPE tEXT_BOUNDARY_TYPE) {
        int n = tEXT_BOUNDARY_TYPE == TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_LINE_START || tEXT_BOUNDARY_TYPE == TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_LINE_END ? 4 : (tEXT_BOUNDARY_TYPE == TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_WORD_START || tEXT_BOUNDARY_TYPE == TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_WORD_END ? 2 : (tEXT_BOUNDARY_TYPE == TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_SENTENCE_START || tEXT_BOUNDARY_TYPE == TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_SENTENCE_END ? 3 : 1));
        return n;
    }

    private StringStruct findOffsets(AccessibleText accessibleText, String string, int n, boolean bl) {
        StringStruct stringStruct = new StringStruct();
        int n2 = string.length();
        String string2 = this.getText(n - n2, n + n2);
        int n3 = string2.indexOf(string);
        if (n3 == -1 && string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
            n3 = string2.indexOf(string);
        }
        if (bl) {
            while (n3 > 0 && Character.isWhitespace(string2.charAt(n3 - 1))) {
                --n3;
            }
        }
        if ((n -= n2) < 0) {
            n = 0;
        }
        stringStruct.startOffset = n += n3;
        stringStruct.endOffset = n + n2;
        return stringStruct;
    }

    private StringStruct getBoundedString(AccessibleText accessibleText, TEXT_BOUNDARY_TYPE tEXT_BOUNDARY_TYPE, int n) {
        String string = null;
        StringStruct stringStruct = new StringStruct();
        try {
            if (tEXT_BOUNDARY_TYPE == TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_LINE_START || tEXT_BOUNDARY_TYPE == TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_LINE_END) {
                int n2 = this.boundaryTypeConvert(tEXT_BOUNDARY_TYPE);
                string = accessibleText.getAtIndex(n2, n);
                if (string == null) {
                    return this.getLine(accessibleText, n, tEXT_BOUNDARY_TYPE);
                }
            } else {
                int n3 = this.boundaryTypeConvert(tEXT_BOUNDARY_TYPE);
                string = accessibleText.getAtIndex(n3, n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string == null) {
            stringStruct.string = "";
        } else {
            stringStruct = this.findOffsets(accessibleText, string, n, false);
            stringStruct.string = string;
        }
        return stringStruct;
    }

    @Override
    public String getTextBeforeOffset(int n, TEXT_BOUNDARY_TYPE tEXT_BOUNDARY_TYPE, IntHolder intHolder, IntHolder intHolder2) {
        String string = "";
        try {
            boolean bl = false;
            if (this.accText != null) {
                StringStruct stringStruct = this.getBoundedString(this.accText, tEXT_BOUNDARY_TYPE, n);
                if (stringStruct.string != null) {
                    string = stringStruct.string;
                }
                if (tEXT_BOUNDARY_TYPE != TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_LINE_START && tEXT_BOUNDARY_TYPE != TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_LINE_END && tEXT_BOUNDARY_TYPE != TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_CHAR) {
                    if (string.trim().length() == 0) {
                        string = this.concatenateText(this.accText, string, tEXT_BOUNDARY_TYPE, n - stringStruct.string.length());
                    } else {
                        string = this.concatenateWhitespace(this.accText, string, tEXT_BOUNDARY_TYPE, n - stringStruct.string.length());
                        if (tEXT_BOUNDARY_TYPE == TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_SENTENCE_END) {
                            string = string.trim();
                            bl = true;
                        }
                    }
                    stringStruct = this.findOffsets(this.accText, string, n, bl);
                }
                intHolder.value = stringStruct.startOffset;
                intHolder2.value = stringStruct.endOffset;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    @Override
    public String getTextAtOffset(int n, TEXT_BOUNDARY_TYPE tEXT_BOUNDARY_TYPE, IntHolder intHolder, IntHolder intHolder2) {
        String string = "";
        try {
            boolean bl = false;
            if (this.accText != null) {
                StringStruct stringStruct = this.getBoundedString(this.accText, tEXT_BOUNDARY_TYPE, n);
                if (stringStruct.string != null) {
                    string = stringStruct.string;
                }
                if (tEXT_BOUNDARY_TYPE != TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_LINE_START && tEXT_BOUNDARY_TYPE != TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_LINE_END && tEXT_BOUNDARY_TYPE != TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_CHAR) {
                    if (string.trim().length() == 0) {
                        string = this.concatenateText(this.accText, string, tEXT_BOUNDARY_TYPE, n);
                    } else {
                        string = this.concatenateWhitespace(this.accText, string, tEXT_BOUNDARY_TYPE, n);
                        if (tEXT_BOUNDARY_TYPE == TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_SENTENCE_END) {
                            string = string.trim();
                            bl = true;
                        }
                    }
                    stringStruct = this.findOffsets(this.accText, string, n, bl);
                }
                intHolder.value = stringStruct.startOffset;
                intHolder2.value = stringStruct.endOffset;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    @Override
    public String getTextAfterOffset(int n, TEXT_BOUNDARY_TYPE tEXT_BOUNDARY_TYPE, IntHolder intHolder, IntHolder intHolder2) {
        String string = "";
        try {
            boolean bl = false;
            if (this.accText != null) {
                StringStruct stringStruct = this.getBoundedString(this.accText, tEXT_BOUNDARY_TYPE, n);
                if (stringStruct.string != null) {
                    string = stringStruct.string;
                }
                if (tEXT_BOUNDARY_TYPE != TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_LINE_START && tEXT_BOUNDARY_TYPE != TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_LINE_END && tEXT_BOUNDARY_TYPE != TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_CHAR) {
                    if (string.trim().length() == 0) {
                        string = this.concatenateText(this.accText, string, tEXT_BOUNDARY_TYPE, n + stringStruct.string.length());
                    } else {
                        string = this.concatenateWhitespace(this.accText, string, tEXT_BOUNDARY_TYPE, n + stringStruct.string.length());
                        if (tEXT_BOUNDARY_TYPE == TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_SENTENCE_END) {
                            string = string.trim();
                            bl = true;
                        }
                    }
                    stringStruct = this.findOffsets(this.accText, string, n, bl);
                }
                intHolder.value = stringStruct.startOffset;
                intHolder2.value = stringStruct.endOffset;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    @Override
    public int getCharacterAtOffset(int n) {
        try {
            if (this.accText != null) {
                return this.accText.getAtIndex(1, n).charAt(0);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return 0;
    }

    private Object toJavaTextAttribute(String string) {
        if (string.equals("family-name")) {
            return "family";
        }
        if (string.equals("style")) {
            return "italic";
        }
        if (string.equals("weight")) {
            return "bold";
        }
        if (string.equals("fg-color")) {
            return "foreground";
        }
        if (string.equals("bg-color")) {
            return "background";
        }
        return string;
    }

    private String fromJavaTextAttribute(Object object, Object object2) {
        String string = "";
        String string2 = object.toString();
        String string3 = object2.toString();
        if (string2.equals("family")) {
            string = "family-name:" + string3;
        } else if (string2.equals("size")) {
            string = string2 + ":" + string3;
        } else if (string2.equals("italic")) {
            string = Boolean.valueOf(string3).booleanValue() ? "style:italic" : "style:normal";
        } else if (string2.equals("bold")) {
            string = Boolean.valueOf(string3).booleanValue() ? "weight:700" : "weight:400";
        } else if (string2.equals("foreground") || string2.equals("color")) {
            if (object2 instanceof Color) {
                Color color = (Color)object2;
                string = "fg-color:";
                string = string + (color.getRed() * 256 + color.getRed());
                string = string + ",";
                string = string + (color.getGreen() * 256 + color.getGreen());
                string = string + ",";
                string = string + (color.getBlue() * 256 + color.getBlue());
            }
        } else if (string2.equals("background")) {
            if (object2 instanceof Color) {
                Color color = (Color)object2;
                string = "bg-color:";
                string = string + (color.getRed() * 256 + color.getRed());
                string = string + ",";
                string = string + (color.getGreen() * 256 + color.getGreen());
                string = string + ",";
                string = string + (color.getBlue() * 256 + color.getBlue());
            }
        } else if (string2.equals("underline")) {
            string = "underline:";
            string = Boolean.valueOf(string3).booleanValue() ? string + "single" : string + "none";
        } else {
            string = string2.equals("strikethrough") ? "strikethrough:" + Boolean.valueOf(string3) : string2 + ":" + string3;
        }
        return string;
    }

    private String attributeSetConvert(AttributeSet attributeSet) {
        String string = "";
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            Object object = attributeSet.getAttribute(obj);
            string = string + this.fromJavaTextAttribute(obj, object);
            if (!enumeration.hasMoreElements()) continue;
            string = string + "; ";
        }
        return string;
    }

    @Override
    public String getAttributes(int n, IntHolder intHolder, IntHolder intHolder2) {
        int n2 = n;
        int n3 = n;
        int n4 = -1;
        try {
            if (this.accText != null) {
                AttributeSet attributeSet;
                AttributeSet attributeSet2 = this.accText.getCharacterAttribute(n);
                n4 = this.accText.getCharCount();
                if (--n2 > 0) {
                    attributeSet = this.accText.getCharacterAttribute(n2);
                    while (n2 > 0 && (attributeSet2 == null && attributeSet2 == attributeSet || attributeSet2 != null && attributeSet != null && attributeSet2.isEqual(attributeSet))) {
                        attributeSet = this.accText.getCharacterAttribute(--n2);
                    }
                }
                if (++n3 < n4) {
                    attributeSet = this.accText.getCharacterAttribute(n3);
                    while (n3 < n4 && (attributeSet2 == null && attributeSet2 == attributeSet || attributeSet2 != null && attributeSet != null && attributeSet2.isEqual(attributeSet))) {
                        attributeSet = this.accText.getCharacterAttribute(++n3);
                    }
                }
                intHolder.value = ++n2;
                intHolder2.value = n3;
                if (attributeSet2 != null) {
                    return this.attributeSetConvert(attributeSet2);
                }
                return "";
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        intHolder.value = n;
        intHolder2.value = n4 < 0 ? n + 1 : n4;
        return "";
    }

    private Point getToplevelLocationOnScreen() {
        Point point = new Point(0, 0);
        Accessible accessible = this.ac.getAccessibleParent();
        AccessibleContext accessibleContext = this.ac;
        AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
        while (accessible != null && accessibleComponent != null) {
            Point point2 = accessibleComponent.getLocation();
            point.x += point2.x;
            point.y += point2.y;
            accessible = accessibleContext.getAccessibleParent();
            accessibleContext = accessible.getAccessibleContext();
            accessibleComponent = accessibleContext.getAccessibleComponent();
        }
        return point;
    }

    @Override
    public void getCharacterExtents(int n, IntHolder intHolder, IntHolder intHolder2, IntHolder intHolder3, IntHolder intHolder4, short s) {
        block8: {
            try {
                Object object;
                Rectangle rectangle = null;
                if (this.accText == null) break block8;
                rectangle = this.accText.getCharacterBounds(n);
                if (rectangle == null) {
                    if (n > 0) {
                        rectangle = this.accText.getCharacterBounds(n - 1);
                    }
                    if (rectangle == null) {
                        return;
                    }
                    rectangle.height = 0;
                    rectangle.width = 0;
                }
                try {
                    object = this.ac.getAccessibleComponent();
                    Point point = object.getLocationOnScreen();
                    rectangle.x += point.x;
                    rectangle.y += point.y;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (s != 0) {
                    object = this.getToplevelLocationOnScreen();
                    rectangle.x -= ((Point)object).x;
                    rectangle.y -= ((Point)object).y;
                }
                intHolder.value = rectangle.x;
                intHolder2.value = rectangle.y;
                intHolder4.value = rectangle.height;
                intHolder3.value = rectangle.width;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public int getOffsetAtPoint(int n, int n2, short s) {
        int n3 = 0;
        try {
            if (this.accText != null) {
                n3 = this.accText.getIndexAtPoint(new Point(n, n2));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n3;
    }

    @Override
    public int getNSelections() {
        try {
            if (this.accText != null) {
                String string = this.accText.getSelectedText();
                return string == null || string.length() == 0 ? 0 : 1;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return 0;
    }

    @Override
    public void getSelection(int n, IntHolder intHolder, IntHolder intHolder2) {
        try {
            if (n == 0) {
                intHolder.value = this.accText.getSelectionStart();
                intHolder2.value = this.accText.getSelectionEnd();
            } else {
                intHolder.value = 0;
                intHolder2.value = 0;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean addSelection(int n, int n2) {
        try {
            if (this.accEditableText != null && this.getNSelections() == 0) {
                return this.setSelection(0, n, n2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean removeSelection(int n) {
        try {
            if (this.accEditableText != null && n == 0) {
                this.accEditableText.selectText(0, 0);
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean setSelection(int n, int n2, int n3) {
        try {
            if (this.accEditableText != null && n == 0) {
                this.accEditableText.selectText(n2, n3);
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    @Override
    public void getRangeExtents(int n, int n2, IntHolder intHolder, IntHolder intHolder2, IntHolder intHolder3, IntHolder intHolder4, short s) {
        if (s != 0 && s != 1) {
            return;
        }
        if (this.accText instanceof AccessibleExtendedText) {
            AccessibleExtendedText accessibleExtendedText = (AccessibleExtendedText)((Object)this.accText);
            Rectangle rectangle = accessibleExtendedText.getTextBounds(n, n2);
            if (rectangle == null) {
                return;
            }
            AccessibleContext accessibleContext = this.ac.getAccessibleParent().getAccessibleContext();
            AccessibleComponent accessibleComponent = (AccessibleComponent)((Object)accessibleContext);
            Point point = accessibleComponent.getLocationOnScreen();
            if (s == 0) {
                intHolder.value = rectangle.x + point.x;
                intHolder2.value = rectangle.y + point.y;
                intHolder3.value = rectangle.width;
                intHolder4.value = rectangle.height;
            } else {
                Point point2 = this.getToplevelLocationOnScreen();
                intHolder.value = rectangle.x + point.x - point2.x;
                intHolder2.value = rectangle.y + point.y - point2.y;
                intHolder3.value = rectangle.width;
                intHolder4.value = rectangle.height;
            }
        }
    }

    @Override
    public Range[] getBoundedRanges(int n, int n2, int n3, int n4, short s, TEXT_CLIP_TYPE tEXT_CLIP_TYPE, TEXT_CLIP_TYPE tEXT_CLIP_TYPE2) {
        return new Range[0];
    }

    @Override
    public String getDefaultAttributes() {
        return "";
    }

    @Override
    public String[] getDefaultAttributeSet() {
        return null;
    }

    @Override
    public String[] getAttributeRun(int n, IntHolder intHolder, IntHolder intHolder2, boolean bl) {
        return null;
    }

    @Override
    public String getAttributeValue(int n, String string, IntHolder intHolder, IntHolder intHolder2, BooleanHolder booleanHolder) {
        int n2 = n;
        int n3 = n;
        int n4 = -1;
        Object object = this.toJavaTextAttribute(string);
        try {
            if (this.accText != null) {
                AttributeSet attributeSet;
                AttributeSet attributeSet2 = this.accText.getCharacterAttribute(n);
                if (!attributeSet2.isDefined(object)) {
                    booleanHolder.value = false;
                    return "";
                }
                booleanHolder.value = true;
                n4 = this.accText.getCharCount();
                if (--n2 > 0) {
                    attributeSet = this.accText.getCharacterAttribute(n2);
                    while (n2 > 0 && (attributeSet2 == null && attributeSet == null || attributeSet2 != null && attributeSet != null && attributeSet2.getAttribute(string) == attributeSet.getAttribute(object))) {
                        attributeSet = this.accText.getCharacterAttribute(--n2);
                    }
                }
                if (++n3 < n4) {
                    attributeSet = this.accText.getCharacterAttribute(n3);
                    while (n3 < n4 && (attributeSet2 == null && attributeSet2 == attributeSet || attributeSet2 != null && attributeSet != null && attributeSet2.getAttribute(string) == attributeSet.getAttribute(object))) {
                        attributeSet = this.accText.getCharacterAttribute(++n3);
                    }
                }
                intHolder.value = ++n2;
                intHolder2.value = n3;
                if (attributeSet2 != null) {
                    return this.fromJavaTextAttribute(object, attributeSet2.getAttribute(object));
                }
                return "";
            }
        }
        catch (Exception exception) {
            booleanHolder.value = false;
            exception.printStackTrace();
        }
        intHolder.value = n;
        intHolder2.value = n4 < 0 ? n + 1 : n4;
        return "";
    }

    @Override
    public void unImplemented() {
    }

    @Override
    public void unImplemented2() {
    }

    public void unImplemented3() {
    }

    public void unImplemented4() {
    }

    private String typeToString(TEXT_BOUNDARY_TYPE tEXT_BOUNDARY_TYPE) {
        String string;
        switch (tEXT_BOUNDARY_TYPE.value()) {
            case 0: {
                string = "_TEXT_BOUNDARY_CHAR";
                break;
            }
            case 1: {
                string = "_TEXT_BOUNDARY_WORD_START";
                break;
            }
            case 2: {
                string = "_TEXT_BOUNDARY_WORD_END";
                break;
            }
            case 3: {
                string = "_TEXT_BOUNDARY_SENTENCE_START";
                break;
            }
            case 4: {
                string = "_TEXT_BOUNDARY_SENTENCE_END";
                break;
            }
            case 5: {
                string = "_TEXT_BOUNDARY_LINE_START";
                break;
            }
            case 6: {
                string = "_TEXT_BOUNDARY_LINE_END";
                break;
            }
            default: {
                string = "UNKNOWN!!!";
            }
        }
        return string;
    }

    public class StringStruct {
        public int startOffset;
        public int endOffset;
        public String string;
    }
}

