/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import sun.misc.Cache;
import sun.security.ssl.Debug;
import sun.security.ssl.SSLSessionImpl;
import sun.security.ssl.SessionId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SSLSessionContextImpl
implements SSLSessionContext {
    private Cache sessionCache = new Cache();
    private Cache sessionHostPortCache = new Cache();
    private int cacheLimit = this.getCacheLimit();
    private long timeoutMillis = 86400000L;
    private static final Debug debug = Debug.getInstance("ssl");

    SSLSessionContextImpl() {
    }

    @Override
    public SSLSession getSession(byte[] id) {
        SSLSession sess = (SSLSession)this.sessionCache.get((Object)new SessionId(id));
        return this.checkTimeValidity(sess);
    }

    @Override
    public Enumeration<byte[]> getIds() {
        Vector<byte[]> v = new Vector<byte[]>(this.sessionCache.size());
        Enumeration e = this.sessionCache.keys();
        while (e.hasMoreElements()) {
            SessionId sessId = (SessionId)e.nextElement();
            if (this.isTimedout((SSLSession)this.sessionCache.get((Object)sessId))) continue;
            v.addElement(sessId.getId());
        }
        return v.elements();
    }

    @Override
    public void setSessionTimeout(int seconds) throws IllegalArgumentException {
        if (seconds < 0) {
            throw new IllegalArgumentException();
        }
        this.timeoutMillis = (long)seconds * 1000L;
    }

    @Override
    public int getSessionTimeout() {
        return (int)(this.timeoutMillis / 1000L);
    }

    @Override
    public void setSessionCacheSize(int size) throws IllegalArgumentException {
        if (size < 0) {
            throw new IllegalArgumentException();
        }
        this.cacheLimit = size;
        if (this.cacheLimit != 0 && this.sessionCache.size() > this.cacheLimit) {
            this.adjustCacheSizeTo(this.cacheLimit);
        }
    }

    @Override
    public int getSessionCacheSize() {
        return this.cacheLimit;
    }

    SSLSessionImpl get(byte[] id) {
        return (SSLSessionImpl)this.getSession(id);
    }

    SSLSessionImpl get(String hostname, int port) {
        if (hostname == null && port == -1) {
            return null;
        }
        SSLSessionImpl sess = (SSLSessionImpl)this.sessionHostPortCache.get((Object)this.getKey(hostname, port));
        return (SSLSessionImpl)this.checkTimeValidity(sess);
    }

    private String getKey(String hostname, int port) {
        return (hostname + ":" + String.valueOf(port)).toLowerCase();
    }

    void put(SSLSessionImpl s) {
        if (this.cacheLimit != 0 && this.sessionCache.size() >= this.cacheLimit) {
            this.adjustCacheSizeTo(this.cacheLimit - 1);
        }
        this.sessionCache.put((Object)s.getSessionId(), (Object)s);
        if (s.getPeerHost() != null && s.getPeerPort() != -1) {
            this.sessionHostPortCache.put((Object)this.getKey(s.getPeerHost(), s.getPeerPort()), (Object)s);
        }
        s.setContext(this);
    }

    private void adjustCacheSizeTo(int targetSize) {
        int cacheSize = this.sessionCache.size();
        if (targetSize < 0) {
            return;
        }
        while (cacheSize > targetSize) {
            SSLSessionImpl lru = null;
            SSLSessionImpl s = null;
            if (debug != null && Debug.isOn("sessioncache")) {
                System.out.println("exceeded cache limit of " + this.cacheLimit);
            }
            int count = 0;
            Enumeration e = this.sessionCache.elements();
            while (e.hasMoreElements()) {
                try {
                    s = (SSLSessionImpl)e.nextElement();
                }
                catch (NoSuchElementException nsee) {
                    break;
                }
                if (this.isTimedout(s)) {
                    lru = s;
                    break;
                }
                if (lru == null || s.getLastAccessedTime() < lru.getLastAccessedTime()) {
                    lru = s;
                }
                ++count;
            }
            if (lru != null && count > targetSize) {
                if (debug != null && Debug.isOn("sessioncache")) {
                    System.out.println("uncaching " + lru);
                }
                lru.invalidate();
            }
            cacheSize = --count;
        }
    }

    void remove(SessionId key) {
        SSLSessionImpl s = (SSLSessionImpl)this.sessionCache.get((Object)key);
        this.sessionCache.remove((Object)key);
        this.sessionHostPortCache.remove((Object)this.getKey(s.getPeerHost(), s.getPeerPort()));
    }

    private int getCacheLimit() {
        int cacheLimit = 0;
        try {
            String s = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("javax.net.ssl.sessionCacheSize");
                }
            });
            cacheLimit = s != null ? Integer.valueOf(s) : 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cacheLimit > 0 ? cacheLimit : 0;
    }

    SSLSession checkTimeValidity(SSLSession sess) {
        if (this.isTimedout(sess)) {
            sess.invalidate();
            return null;
        }
        return sess;
    }

    boolean isTimedout(SSLSession sess) {
        if (this.timeoutMillis == 0L) {
            return false;
        }
        return sess != null && sess.getCreationTime() + this.timeoutMillis <= System.currentTimeMillis();
    }
}

