/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import javax.crypto.spec.DHParameterSpec;
import sun.security.pkcs11.P11ECKeyFactory;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import sun.security.provider.ParameterCache;
import sun.security.rsa.RSAKeyFactory;

final class P11KeyPairGenerator
extends KeyPairGeneratorSpi {
    private final Token token;
    private final String algorithm;
    private final long mechanism;
    private int keySize;
    private AlgorithmParameterSpec params;
    private BigInteger rsaPublicExponent = RSAKeyGenParameterSpec.F4;
    private SecureRandom random;

    P11KeyPairGenerator(Token token, String algorithm, long mechanism) throws PKCS11Exception {
        this.token = token;
        this.algorithm = algorithm;
        this.mechanism = mechanism;
        if (algorithm.equals("EC")) {
            this.initialize(256, null);
        } else {
            this.initialize(1024, null);
        }
    }

    public void initialize(int keySize, SecureRandom random) {
        this.token.ensureValid();
        try {
            this.checkKeySize(keySize, null);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidParameterException(e.getMessage());
        }
        this.keySize = keySize;
        this.params = null;
        this.random = random;
        if (this.algorithm.equals("EC")) {
            this.params = P11ECKeyFactory.getECParameterSpec(keySize);
            if (this.params == null) {
                throw new InvalidParameterException("No EC parameters available for key size " + keySize + " bits");
            }
        }
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        this.token.ensureValid();
        if (this.algorithm.equals("DH")) {
            if (!(params instanceof DHParameterSpec)) {
                throw new InvalidAlgorithmParameterException("DHParameterSpec required for Diffie-Hellman");
            }
            DHParameterSpec dhParams = (DHParameterSpec)params;
            int tmpKeySize = dhParams.getP().bitLength();
            this.checkKeySize(tmpKeySize, dhParams);
            this.keySize = tmpKeySize;
            this.params = dhParams;
        } else if (this.algorithm.equals("RSA")) {
            if (!(params instanceof RSAKeyGenParameterSpec)) {
                throw new InvalidAlgorithmParameterException("RSAKeyGenParameterSpec required for RSA");
            }
            RSAKeyGenParameterSpec rsaParams = (RSAKeyGenParameterSpec)params;
            int tmpKeySize = rsaParams.getKeysize();
            this.checkKeySize(tmpKeySize, rsaParams);
            this.keySize = tmpKeySize;
            this.params = null;
            this.rsaPublicExponent = rsaParams.getPublicExponent();
        } else if (this.algorithm.equals("DSA")) {
            if (!(params instanceof DSAParameterSpec)) {
                throw new InvalidAlgorithmParameterException("DSAParameterSpec required for DSA");
            }
            DSAParameterSpec dsaParams = (DSAParameterSpec)params;
            int tmpKeySize = dsaParams.getP().bitLength();
            this.checkKeySize(tmpKeySize, dsaParams);
            this.keySize = tmpKeySize;
            this.params = dsaParams;
        } else if (this.algorithm.equals("EC")) {
            ECParameterSpec ecParams;
            if (params instanceof ECParameterSpec) {
                ecParams = P11ECKeyFactory.getECParameterSpec((ECParameterSpec)params);
                if (ecParams == null) {
                    throw new InvalidAlgorithmParameterException("Unsupported curve: " + params);
                }
            } else if (params instanceof ECGenParameterSpec) {
                String name = ((ECGenParameterSpec)params).getName();
                ecParams = P11ECKeyFactory.getECParameterSpec(name);
                if (ecParams == null) {
                    throw new InvalidAlgorithmParameterException("Unknown curve name: " + name);
                }
            } else {
                throw new InvalidAlgorithmParameterException("ECParameterSpec or ECGenParameterSpec required for EC");
            }
            int tmpKeySize = ecParams.getCurve().getField().getFieldSize();
            this.checkKeySize(tmpKeySize, ecParams);
            this.keySize = tmpKeySize;
            this.params = ecParams;
        } else {
            throw new ProviderException("Unknown algorithm: " + this.algorithm);
        }
        this.random = random;
    }

    private void checkKeySize(int keySize, AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (this.algorithm.equals("EC")) {
            if (keySize < 112) {
                throw new InvalidAlgorithmParameterException("Key size must be at least 112 bit");
            }
            if (keySize > 2048) {
                throw new InvalidAlgorithmParameterException("Key size must be at most 2048 bit");
            }
            return;
        }
        if (this.algorithm.equals("RSA")) {
            BigInteger tmpExponent = this.rsaPublicExponent;
            if (params != null) {
                tmpExponent = ((RSAKeyGenParameterSpec)params).getPublicExponent();
            }
            try {
                RSAKeyFactory.checkKeyLengths(keySize, tmpExponent, 512, 65536);
            }
            catch (InvalidKeyException e) {
                throw new InvalidAlgorithmParameterException(e.getMessage());
            }
            return;
        }
        if (keySize < 512) {
            throw new InvalidAlgorithmParameterException("Key size must be at least 512 bit");
        }
        if (this.algorithm.equals("DH") && params != null) {
            if (keySize > 65536) {
                throw new InvalidAlgorithmParameterException("Key size must be at most 65536 bit");
            }
        } else if (keySize > 1024 || (keySize & 0x3F) != 0) {
            throw new InvalidAlgorithmParameterException("Key size must be a multiple of 64 and at most 1024 bit");
        }
    }

    public KeyPair generateKeyPair() {
        CK_ATTRIBUTE[] privateKeyTemplate;
        CK_ATTRIBUTE[] publicKeyTemplate;
        long keyType;
        this.token.ensureValid();
        if (this.algorithm.equals("RSA")) {
            keyType = 0L;
            publicKeyTemplate = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(289L, this.keySize), new CK_ATTRIBUTE(290L, this.rsaPublicExponent)};
            privateKeyTemplate = new CK_ATTRIBUTE[]{};
        } else if (this.algorithm.equals("DSA")) {
            DSAParameterSpec dsaParams;
            keyType = 1L;
            if (this.params == null) {
                try {
                    dsaParams = ParameterCache.getDSAParameterSpec(this.keySize, this.random);
                }
                catch (GeneralSecurityException e) {
                    throw new ProviderException("Could not generate DSA parameters", e);
                }
            } else {
                dsaParams = (DSAParameterSpec)this.params;
            }
            publicKeyTemplate = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(304L, dsaParams.getP()), new CK_ATTRIBUTE(305L, dsaParams.getQ()), new CK_ATTRIBUTE(306L, dsaParams.getG())};
            privateKeyTemplate = new CK_ATTRIBUTE[]{};
        } else if (this.algorithm.equals("DH")) {
            int privateBits;
            DHParameterSpec dhParams;
            keyType = 2L;
            if (this.params == null) {
                try {
                    dhParams = ParameterCache.getDHParameterSpec(this.keySize, this.random);
                }
                catch (GeneralSecurityException e) {
                    throw new ProviderException("Could not generate DH parameters", e);
                }
                privateBits = 0;
            } else {
                dhParams = (DHParameterSpec)this.params;
                privateBits = dhParams.getL();
            }
            if (privateBits <= 0) {
                privateBits = this.keySize >= 1024 ? 768 : 512;
            }
            publicKeyTemplate = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(304L, dhParams.getP()), new CK_ATTRIBUTE(306L, dhParams.getG())};
            privateKeyTemplate = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(352L, privateBits)};
        } else if (this.algorithm.equals("EC")) {
            keyType = 3L;
            byte[] encodedParams = P11ECKeyFactory.encodeParameters((ECParameterSpec)this.params);
            publicKeyTemplate = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(384L, encodedParams)};
            privateKeyTemplate = new CK_ATTRIBUTE[]{};
        } else {
            throw new ProviderException("Unknown algorithm: " + this.algorithm);
        }
        Session session = null;
        try {
            session = this.token.getObjSession();
            publicKeyTemplate = this.token.getAttributes("generate", 2L, keyType, publicKeyTemplate);
            privateKeyTemplate = this.token.getAttributes("generate", 3L, keyType, privateKeyTemplate);
            long[] keyIDs = this.token.p11.C_GenerateKeyPair(session.id(), new CK_MECHANISM(this.mechanism), publicKeyTemplate, privateKeyTemplate);
            PublicKey publicKey = P11Key.publicKey(session, keyIDs[0], this.algorithm, this.keySize, publicKeyTemplate);
            PrivateKey privateKey = P11Key.privateKey(session, keyIDs[1], this.algorithm, this.keySize, privateKeyTemplate);
            KeyPair keyPair = new KeyPair(publicKey, privateKey);
            return keyPair;
        }
        catch (PKCS11Exception e) {
            throw new ProviderException(e);
        }
        finally {
            this.token.releaseSession(session);
        }
    }
}

