/*
 * Decompiled with CFR 0.152.
 */
package org.classpath.icedtea.pulseaudio;

class Debug {
    private static DebugLevel currentDebugLevel;

    Debug() {
    }

    static void println(String string) {
        Debug.println(DebugLevel.Info, string);
    }

    static void print(DebugLevel level, String string) {
        int result = level.compareTo(currentDebugLevel);
        if (result >= 0) {
            if (level.compareTo(DebugLevel.Error) >= 0) {
                System.err.print(string);
            } else {
                System.out.print(string);
            }
        }
    }

    static void println(DebugLevel level, String string) {
        int result = level.compareTo(currentDebugLevel);
        if (result >= 0) {
            if (level.compareTo(DebugLevel.Error) >= 0) {
                System.err.println("DEBUG: pulse-java: " + string);
            } else {
                System.out.println("DEBUG: pulse-java: " + string);
            }
        }
    }

    static {
        DebugLevel wantedLevel;
        String systemSetting;
        currentDebugLevel = DebugLevel.None;
        try {
            systemSetting = System.getProperty("pulseaudio.debugLevel");
        }
        catch (SecurityException e) {
            systemSetting = null;
        }
        try {
            wantedLevel = DebugLevel.valueOf(systemSetting);
        }
        catch (IllegalArgumentException e) {
            wantedLevel = DebugLevel.Info;
        }
        catch (NullPointerException e) {
            wantedLevel = DebugLevel.None;
        }
        currentDebugLevel = wantedLevel;
        Debug.println(DebugLevel.Info, "Using debug level: " + (Object)((Object)currentDebugLevel));
    }

    static enum DebugLevel {
        Verbose,
        Debug,
        Info,
        Warning,
        Error,
        None;

    }
}

