/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;

public abstract class CharToByteDoubleByte
extends CharToByteConverter {
    protected short[] index1;
    protected String[] index2;
    protected char highHalfZoneCode;

    public short[] getIndex1() {
        return this.index1;
    }

    public String[] getIndex2() {
        return this.index2;
    }

    public int flush(byte[] output, int outStart, int outEnd) throws MalformedInputException, ConversionBufferFullException {
        if (this.highHalfZoneCode != '\u0000') {
            this.highHalfZoneCode = '\u0000';
            this.badInputLength = 0;
            throw new MalformedInputException();
        }
        this.charOff = 0;
        this.byteOff = 0;
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int convert(char[] input, int inOff, int inEnd, byte[] output, int outOff, int outEnd) throws MalformedInputException, UnknownCharacterException, ConversionBufferFullException {
        int inputSize = 0;
        int outputSize = 0;
        byte[] tmpbuf = new byte[2];
        this.charOff = inOff;
        this.byteOff = outOff;
        if (this.highHalfZoneCode != '\u0000') {
            char inputChar = this.highHalfZoneCode;
            this.highHalfZoneCode = '\u0000';
            if (input[inOff] >= '\udc00' && input[inOff] <= '\udfff') {
                this.badInputLength = 1;
                throw new UnknownCharacterException();
            }
            this.badInputLength = 0;
            throw new MalformedInputException();
        }
        while (this.charOff < inEnd) {
            byte[] outputByte;
            block15: {
                inputSize = 1;
                outputByte = tmpbuf;
                char inputChar = input[this.charOff];
                if (inputChar >= '\ud800' && inputChar <= '\udbff') {
                    if (this.charOff + 1 >= inEnd) {
                        this.highHalfZoneCode = inputChar;
                        return this.byteOff - outOff;
                    }
                    inputChar = input[this.charOff + 1];
                    if (inputChar >= '\udc00' && inputChar <= '\udfff') {
                        if (!this.subMode) {
                            this.badInputLength = 2;
                            throw new UnknownCharacterException();
                        }
                        outputByte = this.subBytes;
                        outputSize = this.subBytes.length;
                        inputSize = 2;
                        break block15;
                    } else {
                        this.badInputLength = 1;
                        throw new MalformedInputException();
                    }
                }
                if (inputChar >= '\udc00' && inputChar <= '\udfff') {
                    this.badInputLength = 1;
                    throw new MalformedInputException();
                }
                outputSize = this.convSingleByte(inputChar, outputByte);
                if (outputSize == 0) {
                    int ncode = this.getNative(inputChar);
                    if (ncode != 0) {
                        outputByte[0] = (byte)((ncode & 0xFF00) >> 8);
                        outputByte[1] = (byte)(ncode & 0xFF);
                        outputSize = 2;
                    } else {
                        if (!this.subMode) {
                            this.badInputLength = 1;
                            throw new UnknownCharacterException();
                        }
                        outputByte = this.subBytes;
                        outputSize = this.subBytes.length;
                    }
                }
            }
            if (this.byteOff + outputSize > outEnd) {
                throw new ConversionBufferFullException();
            }
            for (int i = 0; i < outputSize; ++i) {
                output[this.byteOff++] = outputByte[i];
            }
            this.charOff += inputSize;
        }
        return this.byteOff - outOff;
    }

    public int getMaxBytesPerChar() {
        return 2;
    }

    public void reset() {
        this.charOff = 0;
        this.byteOff = 0;
        this.highHalfZoneCode = '\u0000';
    }

    public boolean canConvert(char ch) {
        byte[] outByte = new byte[2];
        if (ch == '\u0000' || this.convSingleByte(ch, outByte) != 0) {
            return true;
        }
        return this.getNative(ch) != 0;
    }

    protected int convSingleByte(char inputChar, byte[] outputByte) {
        if (inputChar < '\u0080') {
            outputByte[0] = (byte)(inputChar & 0x7F);
            return 1;
        }
        return 0;
    }

    protected int getNative(char ch) {
        int offset = this.index1[(ch & 0xFF00) >> 8] << 8;
        return this.index2[offset >> 12].charAt((offset & 0xFFF) + (ch & 0xFF));
    }
}

