/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.orbutil.graph;

import com.sun.corba.se.impl.orbutil.graph.Graph;
import com.sun.corba.se.impl.orbutil.graph.Node;
import com.sun.corba.se.impl.orbutil.graph.NodeData;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class GraphImpl
extends AbstractSet
implements Graph {
    private Map nodeToData = new HashMap();

    public GraphImpl() {
    }

    public GraphImpl(Collection coll) {
        this();
        this.addAll(coll);
    }

    public boolean add(Object obj) {
        if (!(obj instanceof Node)) {
            throw new IllegalArgumentException("Graphs must contain only Node instances");
        }
        Node node = (Node)obj;
        boolean found = this.nodeToData.keySet().contains(obj);
        if (!found) {
            NodeData nd = new NodeData();
            this.nodeToData.put(node, nd);
        }
        return !found;
    }

    public Iterator iterator() {
        return this.nodeToData.keySet().iterator();
    }

    public int size() {
        return this.nodeToData.keySet().size();
    }

    public NodeData getNodeData(Node node) {
        return (NodeData)this.nodeToData.get(node);
    }

    private void clearNodeData() {
        for (Map.Entry entry : this.nodeToData.entrySet()) {
            NodeData nd = (NodeData)entry.getValue();
            nd.clear();
        }
    }

    void visitAll(NodeVisitor nv) {
        boolean done = false;
        do {
            done = true;
            Map.Entry[] entries = this.nodeToData.entrySet().toArray(new Map.Entry[0]);
            for (int ctr = 0; ctr < entries.length; ++ctr) {
                Map.Entry current = entries[ctr];
                Node node = (Node)current.getKey();
                NodeData nd = (NodeData)current.getValue();
                if (nd.isVisited()) continue;
                nd.visited();
                done = false;
                nv.visit(this, node, nd);
            }
        } while (!done);
    }

    private void markNonRoots() {
        this.visitAll(new NodeVisitor(){

            public void visit(Graph graph, Node node, NodeData nd) {
                for (Node child : node.getChildren()) {
                    graph.add(child);
                    NodeData cnd = graph.getNodeData(child);
                    cnd.notRoot();
                }
            }
        });
    }

    private Set collectRootSet() {
        HashSet<Node> result = new HashSet<Node>();
        for (Map.Entry entry : this.nodeToData.entrySet()) {
            Node node = (Node)entry.getKey();
            NodeData nd = (NodeData)entry.getValue();
            if (!nd.isRoot()) continue;
            result.add(node);
        }
        return result;
    }

    public Set getRoots() {
        this.clearNodeData();
        this.markNonRoots();
        return this.collectRootSet();
    }

    static interface NodeVisitor {
        public void visit(Graph var1, Node var2, NodeData var3);
    }
}

