/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.ChoicePeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventListener;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Choice
extends Component
implements ItemSelectable,
Accessible {
    Vector pItems;
    int selectedIndex = -1;
    transient ItemListener itemListener;
    private static final String base = "choice";
    private static int nameCounter = 0;
    private static final long serialVersionUID = -4075310674757313071L;
    private int choiceSerializedDataVersion = 1;

    public Choice() throws HeadlessException {
        GraphicsEnvironment.checkHeadless();
        this.pItems = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String constructComponentName() {
        Class<Choice> clazz = Choice.class;
        synchronized (Choice.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return base + nameCounter++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = this.getToolkit().createChoice(this);
            }
            super.addNotify();
        }
    }

    public int getItemCount() {
        return this.countItems();
    }

    @Deprecated
    public int countItems() {
        return this.pItems.size();
    }

    public String getItem(int index) {
        return this.getItemImpl(index);
    }

    final String getItemImpl(int index) {
        return (String)this.pItems.elementAt(index);
    }

    public void add(String item) {
        this.addItem(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(String item) {
        Choice choice = this;
        synchronized (choice) {
            this.insertNoInvalidate(item, this.pItems.size());
        }
        if (this.valid) {
            this.invalidate();
        }
    }

    private void insertNoInvalidate(String item, int index) {
        if (item == null) {
            throw new NullPointerException("cannot add null item to Choice");
        }
        this.pItems.insertElementAt(item, index);
        ChoicePeer peer = (ChoicePeer)this.peer;
        if (peer != null) {
            peer.addItem(item, index);
        }
        if (this.selectedIndex < 0 || this.selectedIndex >= index) {
            this.select(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(String item, int index) {
        Choice choice = this;
        synchronized (choice) {
            if (index < 0) {
                throw new IllegalArgumentException("index less than zero.");
            }
            index = Math.min(index, this.pItems.size());
            this.insertNoInvalidate(item, index);
        }
        if (this.valid) {
            this.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String item) {
        Choice choice = this;
        synchronized (choice) {
            int index = this.pItems.indexOf(item);
            if (index < 0) {
                throw new IllegalArgumentException("item " + item + " not found in choice");
            }
            this.removeNoInvalidate(index);
        }
        if (this.valid) {
            this.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int position) {
        Choice choice = this;
        synchronized (choice) {
            this.removeNoInvalidate(position);
        }
        if (this.valid) {
            this.invalidate();
        }
    }

    private void removeNoInvalidate(int position) {
        this.pItems.removeElementAt(position);
        ChoicePeer peer = (ChoicePeer)this.peer;
        if (peer != null) {
            peer.remove(position);
        }
        if (this.pItems.size() == 0) {
            this.selectedIndex = -1;
        } else if (this.selectedIndex == position) {
            this.select(0);
        } else if (this.selectedIndex > position) {
            this.select(this.selectedIndex - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Choice choice = this;
        synchronized (choice) {
            if (this.peer != null) {
                ((ChoicePeer)this.peer).removeAll();
            }
            this.pItems.removeAllElements();
            this.selectedIndex = -1;
        }
        if (this.valid) {
            this.invalidate();
        }
    }

    public synchronized String getSelectedItem() {
        return this.selectedIndex >= 0 ? this.getItem(this.selectedIndex) : null;
    }

    @Override
    public synchronized Object[] getSelectedObjects() {
        if (this.selectedIndex >= 0) {
            Object[] items = new Object[]{this.getItem(this.selectedIndex)};
            return items;
        }
        return null;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public synchronized void select(int pos) {
        if (pos >= this.pItems.size() || pos < 0) {
            throw new IllegalArgumentException("illegal Choice item position: " + pos);
        }
        if (this.pItems.size() > 0) {
            this.selectedIndex = pos;
            ChoicePeer peer = (ChoicePeer)this.peer;
            if (peer != null) {
                peer.select(pos);
            }
        }
    }

    public synchronized void select(String str) {
        int index = this.pItems.indexOf(str);
        if (index >= 0) {
            this.select(index);
        }
    }

    @Override
    public synchronized void addItemListener(ItemListener l) {
        if (l == null) {
            return;
        }
        this.itemListener = AWTEventMulticaster.add(this.itemListener, l);
        this.newEventsOnly = true;
    }

    @Override
    public synchronized void removeItemListener(ItemListener l) {
        if (l == null) {
            return;
        }
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, l);
    }

    public synchronized ItemListener[] getItemListeners() {
        return (ItemListener[])this.getListeners(ItemListener.class);
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        ItemListener l = null;
        if (listenerType != ItemListener.class) {
            return super.getListeners(listenerType);
        }
        l = this.itemListener;
        return AWTEventMulticaster.getListeners((EventListener)l, listenerType);
    }

    @Override
    boolean eventEnabled(AWTEvent e) {
        if (e.id == 701) {
            return (this.eventMask & 0x200L) != 0L || this.itemListener != null;
        }
        return super.eventEnabled(e);
    }

    @Override
    protected void processEvent(AWTEvent e) {
        if (e instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)e);
            return;
        }
        super.processEvent(e);
    }

    protected void processItemEvent(ItemEvent e) {
        ItemListener listener = this.itemListener;
        if (listener != null) {
            listener.itemStateChanged(e);
        }
    }

    @Override
    protected String paramString() {
        return super.paramString() + ",current=" + this.getSelectedItem();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        AWTEventMulticaster.save(s, "itemL", this.itemListener);
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException, HeadlessException {
        Object keyOrNull;
        GraphicsEnvironment.checkHeadless();
        s.defaultReadObject();
        while (null != (keyOrNull = s.readObject())) {
            String key = ((String)keyOrNull).intern();
            if ("itemL" == key) {
                this.addItemListener((ItemListener)s.readObject());
                continue;
            }
            s.readObject();
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTChoice();
        }
        return this.accessibleContext;
    }

    protected class AccessibleAWTChoice
    extends Component.AccessibleAWTComponent
    implements AccessibleAction {
        private static final long serialVersionUID = 7175603582428509322L;

        public AccessibleAWTChoice() {
            super(Choice.this);
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.COMBO_BOX;
        }

        public int getAccessibleActionCount() {
            return 0;
        }

        public String getAccessibleActionDescription(int i) {
            return null;
        }

        public boolean doAccessibleAction(int i) {
            return false;
        }
    }
}

