/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicIterator;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Arrays;
import sun.awt.geom.Curve;

public abstract class CubicCurve2D
implements Shape,
Cloneable {
    private static final int BELOW = -2;
    private static final int LOWEDGE = -1;
    private static final int INSIDE = 0;
    private static final int HIGHEDGE = 1;
    private static final int ABOVE = 2;

    protected CubicCurve2D() {
    }

    public abstract double getX1();

    public abstract double getY1();

    public abstract Point2D getP1();

    public abstract double getCtrlX1();

    public abstract double getCtrlY1();

    public abstract Point2D getCtrlP1();

    public abstract double getCtrlX2();

    public abstract double getCtrlY2();

    public abstract Point2D getCtrlP2();

    public abstract double getX2();

    public abstract double getY2();

    public abstract Point2D getP2();

    public abstract void setCurve(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15);

    public void setCurve(double[] coords, int offset) {
        this.setCurve(coords[offset + 0], coords[offset + 1], coords[offset + 2], coords[offset + 3], coords[offset + 4], coords[offset + 5], coords[offset + 6], coords[offset + 7]);
    }

    public void setCurve(Point2D p1, Point2D cp1, Point2D cp2, Point2D p2) {
        this.setCurve(p1.getX(), p1.getY(), cp1.getX(), cp1.getY(), cp2.getX(), cp2.getY(), p2.getX(), p2.getY());
    }

    public void setCurve(Point2D[] pts, int offset) {
        this.setCurve(pts[offset + 0].getX(), pts[offset + 0].getY(), pts[offset + 1].getX(), pts[offset + 1].getY(), pts[offset + 2].getX(), pts[offset + 2].getY(), pts[offset + 3].getX(), pts[offset + 3].getY());
    }

    public void setCurve(CubicCurve2D c) {
        this.setCurve(c.getX1(), c.getY1(), c.getCtrlX1(), c.getCtrlY1(), c.getCtrlX2(), c.getCtrlY2(), c.getX2(), c.getY2());
    }

    public static double getFlatnessSq(double x1, double y1, double ctrlx1, double ctrly1, double ctrlx2, double ctrly2, double x2, double y2) {
        return Math.max(Line2D.ptSegDistSq(x1, y1, x2, y2, ctrlx1, ctrly1), Line2D.ptSegDistSq(x1, y1, x2, y2, ctrlx2, ctrly2));
    }

    public static double getFlatness(double x1, double y1, double ctrlx1, double ctrly1, double ctrlx2, double ctrly2, double x2, double y2) {
        return Math.sqrt(CubicCurve2D.getFlatnessSq(x1, y1, ctrlx1, ctrly1, ctrlx2, ctrly2, x2, y2));
    }

    public static double getFlatnessSq(double[] coords, int offset) {
        return CubicCurve2D.getFlatnessSq(coords[offset + 0], coords[offset + 1], coords[offset + 2], coords[offset + 3], coords[offset + 4], coords[offset + 5], coords[offset + 6], coords[offset + 7]);
    }

    public static double getFlatness(double[] coords, int offset) {
        return CubicCurve2D.getFlatness(coords[offset + 0], coords[offset + 1], coords[offset + 2], coords[offset + 3], coords[offset + 4], coords[offset + 5], coords[offset + 6], coords[offset + 7]);
    }

    public double getFlatnessSq() {
        return CubicCurve2D.getFlatnessSq(this.getX1(), this.getY1(), this.getCtrlX1(), this.getCtrlY1(), this.getCtrlX2(), this.getCtrlY2(), this.getX2(), this.getY2());
    }

    public double getFlatness() {
        return CubicCurve2D.getFlatness(this.getX1(), this.getY1(), this.getCtrlX1(), this.getCtrlY1(), this.getCtrlX2(), this.getCtrlY2(), this.getX2(), this.getY2());
    }

    public void subdivide(CubicCurve2D left, CubicCurve2D right) {
        CubicCurve2D.subdivide(this, left, right);
    }

    public static void subdivide(CubicCurve2D src, CubicCurve2D left, CubicCurve2D right) {
        double x1 = src.getX1();
        double y1 = src.getY1();
        double ctrlx1 = src.getCtrlX1();
        double ctrly1 = src.getCtrlY1();
        double ctrlx2 = src.getCtrlX2();
        double ctrly2 = src.getCtrlY2();
        double x2 = src.getX2();
        double y2 = src.getY2();
        double centerx = (ctrlx1 + ctrlx2) / 2.0;
        double centery = (ctrly1 + ctrly2) / 2.0;
        ctrlx1 = (x1 + ctrlx1) / 2.0;
        ctrly1 = (y1 + ctrly1) / 2.0;
        ctrlx2 = (x2 + ctrlx2) / 2.0;
        ctrly2 = (y2 + ctrly2) / 2.0;
        double ctrlx12 = (ctrlx1 + centerx) / 2.0;
        double ctrly12 = (ctrly1 + centery) / 2.0;
        double ctrlx21 = (ctrlx2 + centerx) / 2.0;
        double ctrly21 = (ctrly2 + centery) / 2.0;
        centerx = (ctrlx12 + ctrlx21) / 2.0;
        centery = (ctrly12 + ctrly21) / 2.0;
        if (left != null) {
            left.setCurve(x1, y1, ctrlx1, ctrly1, ctrlx12, ctrly12, centerx, centery);
        }
        if (right != null) {
            right.setCurve(centerx, centery, ctrlx21, ctrly21, ctrlx2, ctrly2, x2, y2);
        }
    }

    public static void subdivide(double[] src, int srcoff, double[] left, int leftoff, double[] right, int rightoff) {
        double x1 = src[srcoff + 0];
        double y1 = src[srcoff + 1];
        double ctrlx1 = src[srcoff + 2];
        double ctrly1 = src[srcoff + 3];
        double ctrlx2 = src[srcoff + 4];
        double ctrly2 = src[srcoff + 5];
        double x2 = src[srcoff + 6];
        double y2 = src[srcoff + 7];
        if (left != null) {
            left[leftoff + 0] = x1;
            left[leftoff + 1] = y1;
        }
        if (right != null) {
            right[rightoff + 6] = x2;
            right[rightoff + 7] = y2;
        }
        x1 = (x1 + ctrlx1) / 2.0;
        y1 = (y1 + ctrly1) / 2.0;
        x2 = (x2 + ctrlx2) / 2.0;
        y2 = (y2 + ctrly2) / 2.0;
        double centerx = (ctrlx1 + ctrlx2) / 2.0;
        double centery = (ctrly1 + ctrly2) / 2.0;
        ctrlx1 = (x1 + centerx) / 2.0;
        ctrly1 = (y1 + centery) / 2.0;
        ctrlx2 = (x2 + centerx) / 2.0;
        ctrly2 = (y2 + centery) / 2.0;
        centerx = (ctrlx1 + ctrlx2) / 2.0;
        centery = (ctrly1 + ctrly2) / 2.0;
        if (left != null) {
            left[leftoff + 2] = x1;
            left[leftoff + 3] = y1;
            left[leftoff + 4] = ctrlx1;
            left[leftoff + 5] = ctrly1;
            left[leftoff + 6] = centerx;
            left[leftoff + 7] = centery;
        }
        if (right != null) {
            right[rightoff + 0] = centerx;
            right[rightoff + 1] = centery;
            right[rightoff + 2] = ctrlx2;
            right[rightoff + 3] = ctrly2;
            right[rightoff + 4] = x2;
            right[rightoff + 5] = y2;
        }
    }

    public static int solveCubic(double[] eqn) {
        return CubicCurve2D.solveCubic(eqn, eqn);
    }

    public static int solveCubic(double[] eqn, double[] res) {
        double d = eqn[3];
        if (d == 0.0) {
            return QuadCurve2D.solveQuadratic(eqn, res);
        }
        double a = eqn[2] / d;
        double b = eqn[1] / d;
        double c = eqn[0] / d;
        int roots = 0;
        double Q = (a * a - 3.0 * b) / 9.0;
        double R = (2.0 * a * a * a - 9.0 * a * b + 27.0 * c) / 54.0;
        double R2 = R * R;
        double Q3 = Q * Q * Q;
        a /= 3.0;
        if (R2 < Q3) {
            double theta = Math.acos(R / Math.sqrt(Q3));
            Q = -2.0 * Math.sqrt(Q);
            if (res == eqn) {
                eqn = new double[4];
                System.arraycopy(res, 0, eqn, 0, 4);
            }
            res[roots++] = Q * Math.cos(theta / 3.0) - a;
            res[roots++] = Q * Math.cos((theta + Math.PI * 2) / 3.0) - a;
            res[roots++] = Q * Math.cos((theta - Math.PI * 2) / 3.0) - a;
            CubicCurve2D.fixRoots(res, eqn);
        } else {
            boolean neg = R < 0.0;
            double S = Math.sqrt(R2 - Q3);
            if (neg) {
                R = -R;
            }
            double A = Math.pow(R + S, 0.3333333333333333);
            if (!neg) {
                A = -A;
            }
            double B = A == 0.0 ? 0.0 : Q / A;
            res[roots++] = A + B - a;
        }
        return roots;
    }

    private static void fixRoots(double[] res, double[] eqn) {
        double EPSILON = 1.0E-5;
        for (int i = 0; i < 3; ++i) {
            double t = res[i];
            if (Math.abs(t) < 1.0E-5) {
                res[i] = CubicCurve2D.findZero(t, 0.0, eqn);
                continue;
            }
            if (!(Math.abs(t - 1.0) < 1.0E-5)) continue;
            res[i] = CubicCurve2D.findZero(t, 1.0, eqn);
        }
    }

    private static double solveEqn(double[] eqn, int order, double t) {
        double v = eqn[order];
        while (--order >= 0) {
            v = v * t + eqn[order];
        }
        return v;
    }

    private static double findZero(double t, double target, double[] eqn) {
        double[] slopeqn = new double[]{eqn[1], 2.0 * eqn[2], 3.0 * eqn[3]};
        double origdelta = 0.0;
        double origt = t;
        double slope;
        while ((slope = CubicCurve2D.solveEqn(slopeqn, 2, t)) != 0.0) {
            double newt;
            double y = CubicCurve2D.solveEqn(eqn, 3, t);
            if (y == 0.0) {
                return t;
            }
            double delta = -(y / slope);
            if (origdelta == 0.0) {
                origdelta = delta;
            }
            if (t < target) {
                if (delta < 0.0) {
                    return t;
                }
            } else if (t > target) {
                if (delta > 0.0) {
                    return t;
                }
            } else {
                return delta > 0.0 ? target + java.lang.Double.MIN_VALUE : target - java.lang.Double.MIN_VALUE;
            }
            if (t == (newt = t + delta)) {
                return t;
            }
            if (delta * origdelta < 0.0) {
                int tag;
                int n = tag = origt < t ? CubicCurve2D.getTag(target, origt, t) : CubicCurve2D.getTag(target, t, origt);
                if (tag != 0) {
                    return (origt + t) / 2.0;
                }
                t = target;
                continue;
            }
            t = newt;
        }
        return t;
    }

    public boolean contains(double x, double y) {
        double y2;
        double x2;
        double y1;
        if (x * 0.0 + y * 0.0 != 0.0) {
            return false;
        }
        double x1 = this.getX1();
        int crossings = Curve.pointCrossingsForLine(x, y, x1, y1 = this.getY1(), x2 = this.getX2(), y2 = this.getY2()) + Curve.pointCrossingsForCubic(x, y, x1, y1, this.getCtrlX1(), this.getCtrlY1(), this.getCtrlX2(), this.getCtrlY2(), x2, y2, 0);
        return (crossings & 1) == 1;
    }

    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    private static void fillEqn(double[] eqn, double val, double c1, double cp1, double cp2, double c2) {
        eqn[0] = c1 - val;
        eqn[1] = (cp1 - c1) * 3.0;
        eqn[2] = (cp2 - cp1 - cp1 + c1) * 3.0;
        eqn[3] = c2 + (cp1 - cp2) * 3.0 - c1;
    }

    private static int evalCubic(double[] vals, int num, boolean include0, boolean include1, double[] inflect, double c1, double cp1, double cp2, double c2) {
        int j = 0;
        for (int i = 0; i < num; ++i) {
            double t = vals[i];
            if (!(include0 ? t >= 0.0 : t > 0.0) || !(include1 ? t <= 1.0 : t < 1.0) || inflect != null && inflect[1] + (2.0 * inflect[2] + 3.0 * inflect[3] * t) * t == 0.0) continue;
            double u = 1.0 - t;
            vals[j++] = c1 * u * u * u + 3.0 * cp1 * t * u * u + 3.0 * cp2 * t * t * u + c2 * t * t * t;
        }
        return j;
    }

    private static int getTag(double coord, double low, double high) {
        if (coord <= low) {
            return coord < low ? -2 : -1;
        }
        if (coord >= high) {
            return coord > high ? 2 : 1;
        }
        return 0;
    }

    private static boolean inwards(int pttag, int opt1tag, int opt2tag) {
        switch (pttag) {
            default: {
                return false;
            }
            case -1: {
                return opt1tag >= 0 || opt2tag >= 0;
            }
            case 0: {
                return true;
            }
            case 1: 
        }
        return opt1tag <= 0 || opt2tag <= 0;
    }

    public boolean intersects(double x, double y, double w, double h) {
        int c2tag;
        boolean yoverlap;
        if (w <= 0.0 || h <= 0.0) {
            return false;
        }
        double x1 = this.getX1();
        double y1 = this.getY1();
        int x1tag = CubicCurve2D.getTag(x1, x, x + w);
        int y1tag = CubicCurve2D.getTag(y1, y, y + h);
        if (x1tag == 0 && y1tag == 0) {
            return true;
        }
        double x2 = this.getX2();
        double y2 = this.getY2();
        int x2tag = CubicCurve2D.getTag(x2, x, x + w);
        int y2tag = CubicCurve2D.getTag(y2, y, y + h);
        if (x2tag == 0 && y2tag == 0) {
            return true;
        }
        double ctrlx1 = this.getCtrlX1();
        double ctrly1 = this.getCtrlY1();
        double ctrlx2 = this.getCtrlX2();
        double ctrly2 = this.getCtrlY2();
        int ctrlx1tag = CubicCurve2D.getTag(ctrlx1, x, x + w);
        int ctrly1tag = CubicCurve2D.getTag(ctrly1, y, y + h);
        int ctrlx2tag = CubicCurve2D.getTag(ctrlx2, x, x + w);
        int ctrly2tag = CubicCurve2D.getTag(ctrly2, y, y + h);
        if (x1tag < 0 && x2tag < 0 && ctrlx1tag < 0 && ctrlx2tag < 0) {
            return false;
        }
        if (y1tag < 0 && y2tag < 0 && ctrly1tag < 0 && ctrly2tag < 0) {
            return false;
        }
        if (x1tag > 0 && x2tag > 0 && ctrlx1tag > 0 && ctrlx2tag > 0) {
            return false;
        }
        if (y1tag > 0 && y2tag > 0 && ctrly1tag > 0 && ctrly2tag > 0) {
            return false;
        }
        if (CubicCurve2D.inwards(x1tag, x2tag, ctrlx1tag) && CubicCurve2D.inwards(y1tag, y2tag, ctrly1tag)) {
            return true;
        }
        if (CubicCurve2D.inwards(x2tag, x1tag, ctrlx2tag) && CubicCurve2D.inwards(y2tag, y1tag, ctrly2tag)) {
            return true;
        }
        boolean xoverlap = x1tag * x2tag <= 0;
        boolean bl = yoverlap = y1tag * y2tag <= 0;
        if (x1tag == 0 && x2tag == 0 && yoverlap) {
            return true;
        }
        if (y1tag == 0 && y2tag == 0 && xoverlap) {
            return true;
        }
        double[] eqn = new double[4];
        double[] res = new double[4];
        if (!yoverlap) {
            CubicCurve2D.fillEqn(eqn, y1tag < 0 ? y : y + h, y1, ctrly1, ctrly2, y2);
            int num = CubicCurve2D.solveCubic(eqn, res);
            num = CubicCurve2D.evalCubic(res, num, true, true, null, x1, ctrlx1, ctrlx2, x2);
            return num == 2 && CubicCurve2D.getTag(res[0], x, x + w) * CubicCurve2D.getTag(res[1], x, x + w) <= 0;
        }
        if (!xoverlap) {
            CubicCurve2D.fillEqn(eqn, x1tag < 0 ? x : x + w, x1, ctrlx1, ctrlx2, x2);
            int num = CubicCurve2D.solveCubic(eqn, res);
            num = CubicCurve2D.evalCubic(res, num, true, true, null, y1, ctrly1, ctrly2, y2);
            return num == 2 && CubicCurve2D.getTag(res[0], y, y + h) * CubicCurve2D.getTag(res[1], y, y + h) <= 0;
        }
        double dx = x2 - x1;
        double dy = y2 - y1;
        double k = y2 * x1 - x2 * y1;
        int c1tag = y1tag == 0 ? x1tag : CubicCurve2D.getTag((k + dx * (y1tag < 0 ? y : y + h)) / dy, x, x + w);
        if (c1tag * (c2tag = y2tag == 0 ? x2tag : CubicCurve2D.getTag((k + dx * (y2tag < 0 ? y : y + h)) / dy, x, x + w)) <= 0) {
            return true;
        }
        c1tag = c1tag * x1tag <= 0 ? y1tag : y2tag;
        CubicCurve2D.fillEqn(eqn, c2tag < 0 ? x : x + w, x1, ctrlx1, ctrlx2, x2);
        int num = CubicCurve2D.solveCubic(eqn, res);
        num = CubicCurve2D.evalCubic(res, num, true, true, null, y1, ctrly1, ctrly2, y2);
        int[] tags = new int[num + 1];
        for (int i = 0; i < num; ++i) {
            tags[i] = CubicCurve2D.getTag(res[i], y, y + h);
        }
        tags[num] = c1tag;
        Arrays.sort(tags);
        return num >= 1 && tags[0] * tags[1] <= 0 || num >= 3 && tags[2] * tags[3] <= 0;
    }

    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean contains(double x, double y, double w, double h) {
        if (w <= 0.0 || h <= 0.0) {
            return false;
        }
        if (!(this.contains(x, y) && this.contains(x + w, y) && this.contains(x + w, y + h) && this.contains(x, y + h))) {
            return false;
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(x, y, w, h);
        return !rect.intersectsLine(this.getX1(), this.getY1(), this.getX2(), this.getY2());
    }

    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return new CubicIterator(this, at);
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return new FlatteningPathIterator(this.getPathIterator(at), flatness);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public static class Double
    extends CubicCurve2D
    implements Serializable {
        public double x1;
        public double y1;
        public double ctrlx1;
        public double ctrly1;
        public double ctrlx2;
        public double ctrly2;
        public double x2;
        public double y2;
        private static final long serialVersionUID = -4202960122839707295L;

        public Double() {
        }

        public Double(double x1, double y1, double ctrlx1, double ctrly1, double ctrlx2, double ctrly2, double x2, double y2) {
            this.setCurve(x1, y1, ctrlx1, ctrly1, ctrlx2, ctrly2, x2, y2);
        }

        public double getX1() {
            return this.x1;
        }

        public double getY1() {
            return this.y1;
        }

        public Point2D getP1() {
            return new Point2D.Double(this.x1, this.y1);
        }

        public double getCtrlX1() {
            return this.ctrlx1;
        }

        public double getCtrlY1() {
            return this.ctrly1;
        }

        public Point2D getCtrlP1() {
            return new Point2D.Double(this.ctrlx1, this.ctrly1);
        }

        public double getCtrlX2() {
            return this.ctrlx2;
        }

        public double getCtrlY2() {
            return this.ctrly2;
        }

        public Point2D getCtrlP2() {
            return new Point2D.Double(this.ctrlx2, this.ctrly2);
        }

        public double getX2() {
            return this.x2;
        }

        public double getY2() {
            return this.y2;
        }

        public Point2D getP2() {
            return new Point2D.Double(this.x2, this.y2);
        }

        public void setCurve(double x1, double y1, double ctrlx1, double ctrly1, double ctrlx2, double ctrly2, double x2, double y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.ctrlx1 = ctrlx1;
            this.ctrly1 = ctrly1;
            this.ctrlx2 = ctrlx2;
            this.ctrly2 = ctrly2;
            this.x2 = x2;
            this.y2 = y2;
        }

        public Rectangle2D getBounds2D() {
            double left = Math.min(Math.min(this.x1, this.x2), Math.min(this.ctrlx1, this.ctrlx2));
            double top = Math.min(Math.min(this.y1, this.y2), Math.min(this.ctrly1, this.ctrly2));
            double right = Math.max(Math.max(this.x1, this.x2), Math.max(this.ctrlx1, this.ctrlx2));
            double bottom = Math.max(Math.max(this.y1, this.y2), Math.max(this.ctrly1, this.ctrly2));
            return new Rectangle2D.Double(left, top, right - left, bottom - top);
        }
    }

    public static class Float
    extends CubicCurve2D
    implements Serializable {
        public float x1;
        public float y1;
        public float ctrlx1;
        public float ctrly1;
        public float ctrlx2;
        public float ctrly2;
        public float x2;
        public float y2;
        private static final long serialVersionUID = -1272015596714244385L;

        public Float() {
        }

        public Float(float x1, float y1, float ctrlx1, float ctrly1, float ctrlx2, float ctrly2, float x2, float y2) {
            this.setCurve(x1, y1, ctrlx1, ctrly1, ctrlx2, ctrly2, x2, y2);
        }

        public double getX1() {
            return this.x1;
        }

        public double getY1() {
            return this.y1;
        }

        public Point2D getP1() {
            return new Point2D.Float(this.x1, this.y1);
        }

        public double getCtrlX1() {
            return this.ctrlx1;
        }

        public double getCtrlY1() {
            return this.ctrly1;
        }

        public Point2D getCtrlP1() {
            return new Point2D.Float(this.ctrlx1, this.ctrly1);
        }

        public double getCtrlX2() {
            return this.ctrlx2;
        }

        public double getCtrlY2() {
            return this.ctrly2;
        }

        public Point2D getCtrlP2() {
            return new Point2D.Float(this.ctrlx2, this.ctrly2);
        }

        public double getX2() {
            return this.x2;
        }

        public double getY2() {
            return this.y2;
        }

        public Point2D getP2() {
            return new Point2D.Float(this.x2, this.y2);
        }

        public void setCurve(double x1, double y1, double ctrlx1, double ctrly1, double ctrlx2, double ctrly2, double x2, double y2) {
            this.x1 = (float)x1;
            this.y1 = (float)y1;
            this.ctrlx1 = (float)ctrlx1;
            this.ctrly1 = (float)ctrly1;
            this.ctrlx2 = (float)ctrlx2;
            this.ctrly2 = (float)ctrly2;
            this.x2 = (float)x2;
            this.y2 = (float)y2;
        }

        public void setCurve(float x1, float y1, float ctrlx1, float ctrly1, float ctrlx2, float ctrly2, float x2, float y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.ctrlx1 = ctrlx1;
            this.ctrly1 = ctrly1;
            this.ctrlx2 = ctrlx2;
            this.ctrly2 = ctrly2;
            this.x2 = x2;
            this.y2 = y2;
        }

        public Rectangle2D getBounds2D() {
            float left = Math.min(Math.min(this.x1, this.x2), Math.min(this.ctrlx1, this.ctrlx2));
            float top = Math.min(Math.min(this.y1, this.y2), Math.min(this.ctrly1, this.ctrly2));
            float right = Math.max(Math.max(this.x1, this.x2), Math.max(this.ctrlx1, this.ctrlx2));
            float bottom = Math.max(Math.max(this.y1, this.y2), Math.max(this.ctrly1, this.ctrly2));
            return new Rectangle2D.Float(left, top, right - left, bottom - top);
        }
    }
}

