/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.ExceptionListener;
import java.beans.Expression;
import java.beans.MetaData;
import java.beans.PersistenceDelegate;
import java.beans.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Encoder {
    private final Map<Class<?>, PersistenceDelegate> delegates = Collections.synchronizedMap(new HashMap());
    private Map bindings = new IdentityHashMap();
    private ExceptionListener exceptionListener;
    boolean executeStatements = true;
    private Map attributes;

    protected void writeObject(Object o) {
        if (o == this) {
            return;
        }
        PersistenceDelegate info = this.getPersistenceDelegate(o == null ? null : o.getClass());
        info.writeObject(o, this);
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener != null ? this.exceptionListener : Statement.defaultExceptionListener;
    }

    Object getValue(Expression exp) {
        try {
            return exp == null ? null : exp.getValue();
        }
        catch (Exception e) {
            this.getExceptionListener().exceptionThrown(e);
            throw new RuntimeException("failed to evaluate: " + exp.toString());
        }
    }

    public PersistenceDelegate getPersistenceDelegate(Class<?> type) {
        PersistenceDelegate pd = this.delegates.get(type);
        return pd != null ? pd : MetaData.getPersistenceDelegate(type);
    }

    public void setPersistenceDelegate(Class<?> type, PersistenceDelegate persistenceDelegate) {
        if (persistenceDelegate != null) {
            this.delegates.put(type, persistenceDelegate);
        } else {
            this.delegates.remove(type);
        }
    }

    public Object remove(Object oldInstance) {
        Expression exp = (Expression)this.bindings.remove(oldInstance);
        return this.getValue(exp);
    }

    public Object get(Object oldInstance) {
        if (oldInstance == null || oldInstance == this || oldInstance.getClass() == String.class) {
            return oldInstance;
        }
        Expression exp = (Expression)this.bindings.get(oldInstance);
        return this.getValue(exp);
    }

    private Object writeObject1(Object oldInstance) {
        Object o = this.get(oldInstance);
        if (o == null) {
            this.writeObject(oldInstance);
            o = this.get(oldInstance);
        }
        return o;
    }

    private Statement cloneStatement(Statement oldExp) {
        Object oldTarget = oldExp.getTarget();
        Object newTarget = this.writeObject1(oldTarget);
        Object[] oldArgs = oldExp.getArguments();
        Object[] newArgs = new Object[oldArgs.length];
        for (int i = 0; i < oldArgs.length; ++i) {
            newArgs[i] = this.writeObject1(oldArgs[i]);
        }
        if (oldExp.getClass() == Statement.class) {
            return new Statement(newTarget, oldExp.getMethodName(), newArgs);
        }
        return new Expression(newTarget, oldExp.getMethodName(), newArgs);
    }

    public void writeStatement(Statement oldStm) {
        Statement newStm = this.cloneStatement(oldStm);
        if (oldStm.getTarget() != this && this.executeStatements) {
            try {
                newStm.execute();
            }
            catch (Exception e) {
                this.getExceptionListener().exceptionThrown(new Exception("Encoder: discarding statement " + newStm, e));
            }
        }
    }

    public void writeExpression(Expression oldExp) {
        Object oldValue = this.getValue(oldExp);
        if (this.get(oldValue) != null) {
            return;
        }
        this.bindings.put(oldValue, (Expression)this.cloneStatement(oldExp));
        this.writeObject(oldValue);
    }

    void clear() {
        this.bindings.clear();
    }

    void setAttribute(Object key, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(key, value);
    }

    Object getAttribute(Object key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(key);
    }
}

