/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteBufferAsCharBufferB;
import java.nio.ByteBufferAsCharBufferL;
import java.nio.ByteBufferAsDoubleBufferB;
import java.nio.ByteBufferAsDoubleBufferL;
import java.nio.ByteBufferAsFloatBufferB;
import java.nio.ByteBufferAsFloatBufferL;
import java.nio.ByteBufferAsIntBufferB;
import java.nio.ByteBufferAsIntBufferL;
import java.nio.ByteBufferAsLongBufferB;
import java.nio.ByteBufferAsLongBufferL;
import java.nio.ByteBufferAsShortBufferB;
import java.nio.ByteBufferAsShortBufferL;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DirectByteBufferR;
import java.nio.DirectCharBufferS;
import java.nio.DirectCharBufferU;
import java.nio.DirectDoubleBufferS;
import java.nio.DirectDoubleBufferU;
import java.nio.DirectFloatBufferS;
import java.nio.DirectFloatBufferU;
import java.nio.DirectIntBufferS;
import java.nio.DirectIntBufferU;
import java.nio.DirectLongBufferS;
import java.nio.DirectLongBufferU;
import java.nio.DirectShortBufferS;
import java.nio.DirectShortBufferU;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.MappedByteBuffer;
import java.nio.ShortBuffer;
import sun.misc.Cleaner;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

class DirectByteBuffer
extends MappedByteBuffer
implements DirectBuffer {
    protected static final Unsafe unsafe = Bits.unsafe();
    protected static final boolean unaligned = Bits.unaligned();
    protected Object viewedBuffer = null;
    private final Cleaner cleaner;

    public Object viewedBuffer() {
        return this.viewedBuffer;
    }

    public Cleaner cleaner() {
        return this.cleaner;
    }

    DirectByteBuffer(int cap) {
        super(-1, 0, cap, cap, false);
        Bits.reserveMemory(cap);
        int ps = Bits.pageSize();
        long base = 0L;
        try {
            base = unsafe.allocateMemory(cap + ps);
        }
        catch (OutOfMemoryError x) {
            Bits.unreserveMemory(cap);
            throw x;
        }
        unsafe.setMemory(base, cap + ps, (byte)0);
        this.address = base % (long)ps != 0L ? base + (long)ps - (base & (long)(ps - 1)) : base;
        this.cleaner = Cleaner.create(this, new Deallocator(base, cap));
    }

    private DirectByteBuffer(long addr, int cap) {
        super(-1, 0, cap, cap, false);
        this.address = addr;
        this.cleaner = null;
    }

    protected DirectByteBuffer(int cap, long addr, Runnable unmapper) {
        super(-1, 0, cap, cap, true);
        this.address = addr;
        this.viewedBuffer = null;
        this.cleaner = Cleaner.create(this, unmapper);
    }

    DirectByteBuffer(DirectBuffer db, int mark, int pos, int lim, int cap, int off) {
        super(mark, pos, lim, cap);
        this.address = db.address() + (long)off;
        this.viewedBuffer = db;
        this.cleaner = null;
    }

    public ByteBuffer slice() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        int off = pos << 0;
        assert (off >= 0);
        return new DirectByteBuffer(this, -1, 0, rem, rem, off);
    }

    public ByteBuffer duplicate() {
        return new DirectByteBuffer(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public ByteBuffer asReadOnlyBuffer() {
        return new DirectByteBufferR(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public long address() {
        return this.address;
    }

    private long ix(int i) {
        return this.address + (long)(i << 0);
    }

    public byte get() {
        return unsafe.getByte(this.ix(this.nextGetIndex()));
    }

    public byte get(int i) {
        return unsafe.getByte(this.ix(this.checkIndex(i)));
    }

    public ByteBuffer get(byte[] dst, int offset, int length) {
        if (length << 0 > 6) {
            int rem;
            DirectByteBuffer.checkBounds(offset, length, dst.length);
            int pos = this.position();
            int lim = this.limit();
            assert (pos <= lim);
            int n = rem = pos <= lim ? lim - pos : 0;
            if (length > rem) {
                throw new BufferUnderflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyToByteArray(this.ix(pos), dst, offset << 0, length << 0);
            } else {
                Bits.copyToByteArray(this.ix(pos), dst, offset << 0, length << 0);
            }
            this.position(pos + length);
        } else {
            super.get(dst, offset, length);
        }
        return this;
    }

    public ByteBuffer put(byte x) {
        unsafe.putByte(this.ix(this.nextPutIndex()), x);
        return this;
    }

    public ByteBuffer put(int i, byte x) {
        unsafe.putByte(this.ix(this.checkIndex(i)), x);
        return this;
    }

    public ByteBuffer put(ByteBuffer src) {
        if (src instanceof DirectByteBuffer) {
            int rem;
            if (src == this) {
                throw new IllegalArgumentException();
            }
            DirectByteBuffer sb = (DirectByteBuffer)src;
            int spos = sb.position();
            int slim = sb.limit();
            assert (spos <= slim);
            int srem = spos <= slim ? slim - spos : 0;
            int pos = this.position();
            int lim = this.limit();
            assert (pos <= lim);
            int n = rem = pos <= lim ? lim - pos : 0;
            if (srem > rem) {
                throw new BufferOverflowException();
            }
            unsafe.copyMemory(sb.ix(spos), this.ix(pos), srem << 0);
            sb.position(spos + srem);
            this.position(pos + srem);
        } else if (src.hb != null) {
            int spos = src.position();
            int slim = src.limit();
            assert (spos <= slim);
            int srem = spos <= slim ? slim - spos : 0;
            this.put(src.hb, src.offset + spos, srem);
            src.position(spos + srem);
        } else {
            super.put(src);
        }
        return this;
    }

    public ByteBuffer put(byte[] src, int offset, int length) {
        if (length << 0 > 6) {
            int rem;
            DirectByteBuffer.checkBounds(offset, length, src.length);
            int pos = this.position();
            int lim = this.limit();
            assert (pos <= lim);
            int n = rem = pos <= lim ? lim - pos : 0;
            if (length > rem) {
                throw new BufferOverflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyFromByteArray(src, offset << 0, this.ix(pos), length << 0);
            } else {
                Bits.copyFromByteArray(src, offset << 0, this.ix(pos), length << 0);
            }
            this.position(pos + length);
        } else {
            super.put(src, offset, length);
        }
        return this;
    }

    public ByteBuffer compact() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        unsafe.copyMemory(this.ix(pos), this.ix(0), rem << 0);
        this.position(rem);
        this.limit(this.capacity());
        this.clearMark();
        return this;
    }

    public boolean isDirect() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    byte _get(int i) {
        return unsafe.getByte(this.address + (long)i);
    }

    void _put(int i, byte b) {
        unsafe.putByte(this.address + (long)i, b);
    }

    private char getChar(long a) {
        if (unaligned) {
            char x = unsafe.getChar(a);
            return this.nativeByteOrder ? x : Bits.swap(x);
        }
        return Bits.getChar(a, this.bigEndian);
    }

    public char getChar() {
        return this.getChar(this.ix(this.nextGetIndex(2)));
    }

    public char getChar(int i) {
        return this.getChar(this.ix(this.checkIndex(i, 2)));
    }

    private ByteBuffer putChar(long a, char x) {
        if (unaligned) {
            char y = x;
            unsafe.putChar(a, this.nativeByteOrder ? y : Bits.swap(y));
        } else {
            Bits.putChar(a, x, this.bigEndian);
        }
        return this;
    }

    public ByteBuffer putChar(char x) {
        this.putChar(this.ix(this.nextPutIndex(2)), x);
        return this;
    }

    public ByteBuffer putChar(int i, char x) {
        this.putChar(this.ix(this.checkIndex(i, 2)), x);
        return this;
    }

    public CharBuffer asCharBuffer() {
        int off = this.position();
        int lim = this.limit();
        assert (off <= lim);
        int rem = off <= lim ? lim - off : 0;
        int size = rem >> 1;
        if (!unaligned && (this.address + (long)off) % 2L != 0L) {
            return this.bigEndian ? new ByteBufferAsCharBufferB(this, -1, 0, size, size, off) : new ByteBufferAsCharBufferL(this, -1, 0, size, size, off);
        }
        return this.nativeByteOrder ? new DirectCharBufferU(this, -1, 0, size, size, off) : new DirectCharBufferS(this, -1, 0, size, size, off);
    }

    private short getShort(long a) {
        if (unaligned) {
            short x = unsafe.getShort(a);
            return this.nativeByteOrder ? x : Bits.swap(x);
        }
        return Bits.getShort(a, this.bigEndian);
    }

    public short getShort() {
        return this.getShort(this.ix(this.nextGetIndex(2)));
    }

    public short getShort(int i) {
        return this.getShort(this.ix(this.checkIndex(i, 2)));
    }

    private ByteBuffer putShort(long a, short x) {
        if (unaligned) {
            short y = x;
            unsafe.putShort(a, this.nativeByteOrder ? y : Bits.swap(y));
        } else {
            Bits.putShort(a, x, this.bigEndian);
        }
        return this;
    }

    public ByteBuffer putShort(short x) {
        this.putShort(this.ix(this.nextPutIndex(2)), x);
        return this;
    }

    public ByteBuffer putShort(int i, short x) {
        this.putShort(this.ix(this.checkIndex(i, 2)), x);
        return this;
    }

    public ShortBuffer asShortBuffer() {
        int off = this.position();
        int lim = this.limit();
        assert (off <= lim);
        int rem = off <= lim ? lim - off : 0;
        int size = rem >> 1;
        if (!unaligned && (this.address + (long)off) % 2L != 0L) {
            return this.bigEndian ? new ByteBufferAsShortBufferB(this, -1, 0, size, size, off) : new ByteBufferAsShortBufferL(this, -1, 0, size, size, off);
        }
        return this.nativeByteOrder ? new DirectShortBufferU(this, -1, 0, size, size, off) : new DirectShortBufferS(this, -1, 0, size, size, off);
    }

    private int getInt(long a) {
        if (unaligned) {
            int x = unsafe.getInt(a);
            return this.nativeByteOrder ? x : Bits.swap(x);
        }
        return Bits.getInt(a, this.bigEndian);
    }

    public int getInt() {
        return this.getInt(this.ix(this.nextGetIndex(4)));
    }

    public int getInt(int i) {
        return this.getInt(this.ix(this.checkIndex(i, 4)));
    }

    private ByteBuffer putInt(long a, int x) {
        if (unaligned) {
            int y = x;
            unsafe.putInt(a, this.nativeByteOrder ? y : Bits.swap(y));
        } else {
            Bits.putInt(a, x, this.bigEndian);
        }
        return this;
    }

    public ByteBuffer putInt(int x) {
        this.putInt(this.ix(this.nextPutIndex(4)), x);
        return this;
    }

    public ByteBuffer putInt(int i, int x) {
        this.putInt(this.ix(this.checkIndex(i, 4)), x);
        return this;
    }

    public IntBuffer asIntBuffer() {
        int off = this.position();
        int lim = this.limit();
        assert (off <= lim);
        int rem = off <= lim ? lim - off : 0;
        int size = rem >> 2;
        if (!unaligned && (this.address + (long)off) % 4L != 0L) {
            return this.bigEndian ? new ByteBufferAsIntBufferB(this, -1, 0, size, size, off) : new ByteBufferAsIntBufferL(this, -1, 0, size, size, off);
        }
        return this.nativeByteOrder ? new DirectIntBufferU(this, -1, 0, size, size, off) : new DirectIntBufferS(this, -1, 0, size, size, off);
    }

    private long getLong(long a) {
        if (unaligned) {
            long x = unsafe.getLong(a);
            return this.nativeByteOrder ? x : Bits.swap(x);
        }
        return Bits.getLong(a, this.bigEndian);
    }

    public long getLong() {
        return this.getLong(this.ix(this.nextGetIndex(8)));
    }

    public long getLong(int i) {
        return this.getLong(this.ix(this.checkIndex(i, 8)));
    }

    private ByteBuffer putLong(long a, long x) {
        if (unaligned) {
            long y = x;
            unsafe.putLong(a, this.nativeByteOrder ? y : Bits.swap(y));
        } else {
            Bits.putLong(a, x, this.bigEndian);
        }
        return this;
    }

    public ByteBuffer putLong(long x) {
        this.putLong(this.ix(this.nextPutIndex(8)), x);
        return this;
    }

    public ByteBuffer putLong(int i, long x) {
        this.putLong(this.ix(this.checkIndex(i, 8)), x);
        return this;
    }

    public LongBuffer asLongBuffer() {
        int off = this.position();
        int lim = this.limit();
        assert (off <= lim);
        int rem = off <= lim ? lim - off : 0;
        int size = rem >> 3;
        if (!unaligned && (this.address + (long)off) % 8L != 0L) {
            return this.bigEndian ? new ByteBufferAsLongBufferB(this, -1, 0, size, size, off) : new ByteBufferAsLongBufferL(this, -1, 0, size, size, off);
        }
        return this.nativeByteOrder ? new DirectLongBufferU(this, -1, 0, size, size, off) : new DirectLongBufferS(this, -1, 0, size, size, off);
    }

    private float getFloat(long a) {
        if (unaligned) {
            int x = unsafe.getInt(a);
            return Float.intBitsToFloat(this.nativeByteOrder ? x : Bits.swap(x));
        }
        return Bits.getFloat(a, this.bigEndian);
    }

    public float getFloat() {
        return this.getFloat(this.ix(this.nextGetIndex(4)));
    }

    public float getFloat(int i) {
        return this.getFloat(this.ix(this.checkIndex(i, 4)));
    }

    private ByteBuffer putFloat(long a, float x) {
        if (unaligned) {
            int y = Float.floatToRawIntBits(x);
            unsafe.putInt(a, this.nativeByteOrder ? y : Bits.swap(y));
        } else {
            Bits.putFloat(a, x, this.bigEndian);
        }
        return this;
    }

    public ByteBuffer putFloat(float x) {
        this.putFloat(this.ix(this.nextPutIndex(4)), x);
        return this;
    }

    public ByteBuffer putFloat(int i, float x) {
        this.putFloat(this.ix(this.checkIndex(i, 4)), x);
        return this;
    }

    public FloatBuffer asFloatBuffer() {
        int off = this.position();
        int lim = this.limit();
        assert (off <= lim);
        int rem = off <= lim ? lim - off : 0;
        int size = rem >> 2;
        if (!unaligned && (this.address + (long)off) % 4L != 0L) {
            return this.bigEndian ? new ByteBufferAsFloatBufferB(this, -1, 0, size, size, off) : new ByteBufferAsFloatBufferL(this, -1, 0, size, size, off);
        }
        return this.nativeByteOrder ? new DirectFloatBufferU(this, -1, 0, size, size, off) : new DirectFloatBufferS(this, -1, 0, size, size, off);
    }

    private double getDouble(long a) {
        if (unaligned) {
            long x = unsafe.getLong(a);
            return Double.longBitsToDouble(this.nativeByteOrder ? x : Bits.swap(x));
        }
        return Bits.getDouble(a, this.bigEndian);
    }

    public double getDouble() {
        return this.getDouble(this.ix(this.nextGetIndex(8)));
    }

    public double getDouble(int i) {
        return this.getDouble(this.ix(this.checkIndex(i, 8)));
    }

    private ByteBuffer putDouble(long a, double x) {
        if (unaligned) {
            long y = Double.doubleToRawLongBits(x);
            unsafe.putLong(a, this.nativeByteOrder ? y : Bits.swap(y));
        } else {
            Bits.putDouble(a, x, this.bigEndian);
        }
        return this;
    }

    public ByteBuffer putDouble(double x) {
        this.putDouble(this.ix(this.nextPutIndex(8)), x);
        return this;
    }

    public ByteBuffer putDouble(int i, double x) {
        this.putDouble(this.ix(this.checkIndex(i, 8)), x);
        return this;
    }

    public DoubleBuffer asDoubleBuffer() {
        int off = this.position();
        int lim = this.limit();
        assert (off <= lim);
        int rem = off <= lim ? lim - off : 0;
        int size = rem >> 3;
        if (!unaligned && (this.address + (long)off) % 8L != 0L) {
            return this.bigEndian ? new ByteBufferAsDoubleBufferB(this, -1, 0, size, size, off) : new ByteBufferAsDoubleBufferL(this, -1, 0, size, size, off);
        }
        return this.nativeByteOrder ? new DirectDoubleBufferU(this, -1, 0, size, size, off) : new DirectDoubleBufferS(this, -1, 0, size, size, off);
    }

    private static class Deallocator
    implements Runnable {
        private static Unsafe unsafe = Unsafe.getUnsafe();
        private long address;
        private int capacity;

        private Deallocator(long address, int capacity) {
            assert (address != 0L);
            this.address = address;
            this.capacity = capacity;
        }

        public void run() {
            if (this.address == 0L) {
                return;
            }
            unsafe.freeMemory(this.address);
            this.address = 0L;
            Bits.unreserveMemory(this.capacity);
        }
    }
}

