/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.Serializable;
import sun.misc.Unsafe;

public class AtomicLong
extends Number
implements Serializable {
    private static final long serialVersionUID = 1927816293512124184L;
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final long valueOffset;
    static final boolean VM_SUPPORTS_LONG_CAS;
    private volatile long value;

    private static native boolean VMSupportsCS8();

    public AtomicLong(long initialValue) {
        this.value = initialValue;
    }

    public AtomicLong() {
    }

    public final long get() {
        return this.value;
    }

    public final void set(long newValue) {
        this.value = newValue;
    }

    public final void lazySet(long newValue) {
        unsafe.putOrderedLong(this, valueOffset, newValue);
    }

    public final long getAndSet(long newValue) {
        long current;
        while (!this.compareAndSet(current = this.get(), newValue)) {
        }
        return current;
    }

    public final boolean compareAndSet(long expect, long update) {
        return unsafe.compareAndSwapLong(this, valueOffset, expect, update);
    }

    public final boolean weakCompareAndSet(long expect, long update) {
        return unsafe.compareAndSwapLong(this, valueOffset, expect, update);
    }

    public final long getAndIncrement() {
        long next;
        long current;
        while (!this.compareAndSet(current = this.get(), next = current + 1L)) {
        }
        return current;
    }

    public final long getAndDecrement() {
        long next;
        long current;
        while (!this.compareAndSet(current = this.get(), next = current - 1L)) {
        }
        return current;
    }

    public final long getAndAdd(long delta) {
        long next;
        long current;
        while (!this.compareAndSet(current = this.get(), next = current + delta)) {
        }
        return current;
    }

    public final long incrementAndGet() {
        long next;
        long current;
        while (!this.compareAndSet(current = this.get(), next = current + 1L)) {
        }
        return next;
    }

    public final long decrementAndGet() {
        long next;
        long current;
        while (!this.compareAndSet(current = this.get(), next = current - 1L)) {
        }
        return next;
    }

    public final long addAndGet(long delta) {
        long next;
        long current;
        while (!this.compareAndSet(current = this.get(), next = current + delta)) {
        }
        return next;
    }

    public String toString() {
        return Long.toString(this.get());
    }

    public int intValue() {
        return (int)this.get();
    }

    public long longValue() {
        return this.get();
    }

    public float floatValue() {
        return this.get();
    }

    public double doubleValue() {
        return this.get();
    }

    static {
        VM_SUPPORTS_LONG_CAS = AtomicLong.VMSupportsCS8();
        try {
            valueOffset = unsafe.objectFieldOffset(AtomicLong.class.getDeclaredField("value"));
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }
}

