/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import javax.security.auth.kerberos.KerberosPrincipal;
import sun.misc.HexDumpEncoder;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.util.DerValue;

class KeyImpl
implements SecretKey,
Destroyable,
Serializable {
    private static final long serialVersionUID = -7889313790214321193L;
    private transient byte[] keyBytes;
    private transient int keyType;
    private volatile transient boolean destroyed = false;

    public KeyImpl(byte[] keyBytes, int keyType) {
        this.keyBytes = (byte[])keyBytes.clone();
        this.keyType = keyType;
    }

    public KeyImpl(KerberosPrincipal principal, char[] password, String algorithm) {
        try {
            PrincipalName princ = new PrincipalName(principal.getName());
            EncryptionKey key = new EncryptionKey(password, princ.getSalt(), algorithm);
            this.keyBytes = key.getBytes();
            this.keyType = key.getEType();
        }
        catch (KrbException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public final int getKeyType() {
        if (this.destroyed) {
            throw new IllegalStateException("This key is no longer valid");
        }
        return this.keyType;
    }

    public final String getAlgorithm() {
        return this.getAlgorithmName(this.keyType);
    }

    private String getAlgorithmName(int eType) {
        if (this.destroyed) {
            throw new IllegalStateException("This key is no longer valid");
        }
        switch (eType) {
            case 1: 
            case 3: {
                return "DES";
            }
            case 16: {
                return "DESede";
            }
            case 23: {
                return "ArcFourHmac";
            }
            case 17: {
                return "AES128";
            }
            case 18: {
                return "AES256";
            }
            case 0: {
                return "NULL";
            }
        }
        throw new IllegalArgumentException("Unsupported encryption type: " + eType);
    }

    public final String getFormat() {
        if (this.destroyed) {
            throw new IllegalStateException("This key is no longer valid");
        }
        return "RAW";
    }

    public final byte[] getEncoded() {
        if (this.destroyed) {
            throw new IllegalStateException("This key is no longer valid");
        }
        return (byte[])this.keyBytes.clone();
    }

    public void destroy() throws DestroyFailedException {
        if (!this.destroyed) {
            this.destroyed = true;
            Arrays.fill(this.keyBytes, (byte)0);
        }
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    private void writeObject(ObjectOutputStream ois) throws IOException {
        if (this.destroyed) {
            throw new IOException("This key is no longer valid");
        }
        try {
            ois.writeObject(new EncryptionKey(this.keyType, this.keyBytes).asn1Encode());
        }
        catch (Asn1Exception ae) {
            throw new IOException(ae.getMessage());
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        try {
            EncryptionKey encKey = new EncryptionKey(new DerValue((byte[])ois.readObject()));
            this.keyType = encKey.getEType();
            this.keyBytes = encKey.getBytes();
        }
        catch (Asn1Exception ae) {
            throw new IOException(ae.getMessage());
        }
    }

    public String toString() {
        HexDumpEncoder hd = new HexDumpEncoder();
        return "EncryptionKey: keyType=" + this.keyType + " keyBytes (hex dump)=" + (this.keyBytes == null || this.keyBytes.length == 0 ? " Empty Key" : '\n' + hd.encode(this.keyBytes) + '\n');
    }

    public int hashCode() {
        int result = 17;
        if (this.isDestroyed()) {
            return result;
        }
        result = 37 * result + Arrays.hashCode(this.keyBytes);
        return 37 * result + this.keyType;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof KeyImpl)) {
            return false;
        }
        KeyImpl otherKey = (KeyImpl)other;
        if (this.isDestroyed() || otherKey.isDestroyed()) {
            return false;
        }
        return this.keyType == otherKey.getKeyType() && Arrays.equals(this.keyBytes, otherKey.getEncoded());
    }
}

