/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.serial;

import java.io.Serializable;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Ref;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Map;
import java.util.Vector;
import javax.sql.rowset.serial.SQLOutputImpl;
import javax.sql.rowset.serial.SerialArray;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialException;
import javax.sql.rowset.serial.SerialRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerialStruct
implements Struct,
Serializable,
Cloneable {
    private String SQLTypeName;
    private Object[] attribs;
    static final long serialVersionUID = -8322445504027483372L;

    public SerialStruct(Struct in, Map<String, Class<?>> map) throws SerialException {
        try {
            this.SQLTypeName = new String(in.getSQLTypeName());
            System.out.println("SQLTypeName: " + this.SQLTypeName);
            this.attribs = in.getAttributes(map);
            this.mapToSerial(map);
        }
        catch (SQLException e) {
            throw new SerialException(e.getMessage());
        }
    }

    public SerialStruct(SQLData in, Map<String, Class<?>> map) throws SerialException {
        try {
            this.SQLTypeName = new String(in.getSQLTypeName());
            Vector tmp = new Vector();
            in.writeSQL(new SQLOutputImpl(tmp, map));
            this.attribs = tmp.toArray();
        }
        catch (SQLException e) {
            throw new SerialException(e.getMessage());
        }
    }

    @Override
    public String getSQLTypeName() throws SerialException {
        return this.SQLTypeName;
    }

    @Override
    public Object[] getAttributes() throws SerialException {
        return this.attribs;
    }

    @Override
    public Object[] getAttributes(Map<String, Class<?>> map) throws SerialException {
        return this.attribs;
    }

    private void mapToSerial(Map map) throws SerialException {
        try {
            for (int i = 0; i < this.attribs.length; ++i) {
                if (this.attribs[i] instanceof Struct) {
                    this.attribs[i] = new SerialStruct((Struct)this.attribs[i], map);
                    continue;
                }
                if (this.attribs[i] instanceof SQLData) {
                    this.attribs[i] = new SerialStruct((SQLData)this.attribs[i], map);
                    continue;
                }
                if (this.attribs[i] instanceof Blob) {
                    this.attribs[i] = new SerialBlob((Blob)this.attribs[i]);
                    continue;
                }
                if (this.attribs[i] instanceof Clob) {
                    this.attribs[i] = new SerialClob((Clob)this.attribs[i]);
                    continue;
                }
                if (this.attribs[i] instanceof Ref) {
                    this.attribs[i] = new SerialRef((Ref)this.attribs[i]);
                    continue;
                }
                if (!(this.attribs[i] instanceof Array)) continue;
                this.attribs[i] = new SerialArray((Array)this.attribs[i], map);
            }
        }
        catch (SQLException e) {
            throw new SerialException(e.getMessage());
        }
    }
}

