/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.sourceforge.jnlp.AppletDesc;
import net.sourceforge.jnlp.ApplicationDesc;
import net.sourceforge.jnlp.ComponentDesc;
import net.sourceforge.jnlp.InformationDesc;
import net.sourceforge.jnlp.InstallerDesc;
import net.sourceforge.jnlp.Node;
import net.sourceforge.jnlp.ParseException;
import net.sourceforge.jnlp.Parser;
import net.sourceforge.jnlp.ResourcesDesc;
import net.sourceforge.jnlp.SecurityDesc;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.cache.ResourceTracker;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.runtime.JNLPRuntime;

public class JNLPFile {
    protected URL sourceLocation = null;
    protected URL fileLocation;
    protected URL codeBase;
    protected String cookieStr;
    protected Version fileVersion;
    protected Version specVersion;
    protected List info;
    protected List resources;
    protected ResourcesDesc sharedResources = new ResourcesDesc(this, null, null, null);
    protected Object launchType;
    protected SecurityDesc security;
    protected Locale defaultLocale = null;
    protected String defaultOS = null;
    protected String defaultArch = null;

    private static String R(String key) {
        return JNLPRuntime.getMessage(key);
    }

    protected JNLPFile() {
        try {
            this.defaultLocale = Locale.getDefault();
            this.defaultOS = System.getProperty("os.name");
            this.defaultArch = System.getProperty("os.arch");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public JNLPFile(URL location, String cookieStr) throws IOException, ParseException {
        this(location, cookieStr, false);
    }

    public JNLPFile(URL location, String cookieStr, boolean strict) throws IOException, ParseException {
        this(location, cookieStr, strict, JNLPRuntime.getDefaultUpdatePolicy());
    }

    public JNLPFile(URL location, String cookieStr, boolean strict, UpdatePolicy policy) throws IOException, ParseException {
        try {
            this.defaultLocale = Locale.getDefault();
            this.defaultOS = System.getProperty("os.name");
            this.defaultArch = System.getProperty("os.arch");
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        Node root = Parser.getRootNode(JNLPFile.openURL(location, cookieStr, policy));
        this.parse(root, strict, location);
        this.fileLocation = location;
        this.cookieStr = cookieStr;
    }

    public JNLPFile(InputStream input, boolean strict) throws ParseException {
        try {
            this.defaultLocale = Locale.getDefault();
            this.defaultOS = System.getProperty("os.name");
            this.defaultArch = System.getProperty("os.arch");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.parse(Parser.getRootNode(input), strict, null);
    }

    private JNLPFile(Reader input, boolean strict) throws ParseException {
        try {
            this.defaultLocale = Locale.getDefault();
            this.defaultOS = System.getProperty("os.name");
            this.defaultArch = System.getProperty("os.arch");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static InputStream openURL(URL location, String cookieStr, UpdatePolicy policy) throws IOException {
        if (location == null || policy == null) {
            throw new IllegalArgumentException(JNLPFile.R("NullParameter"));
        }
        try {
            ResourceTracker tracker = new ResourceTracker(false);
            tracker.addResource(location, cookieStr, null, policy);
            return tracker.getInputStream(location);
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public static Version getSupportedVersions() {
        return Parser.getSupportedVersions();
    }

    public String getTitle() {
        return this.getInformation().getTitle();
    }

    public URL getSourceLocation() {
        return this.sourceLocation;
    }

    public URL getFileLocation() {
        return this.fileLocation;
    }

    public Version getFileVersion() {
        return this.fileVersion;
    }

    public Version getSpecVersion() {
        return this.specVersion;
    }

    public URL getCodeBase() {
        return this.codeBase;
    }

    public String getCookieStr() {
        return this.cookieStr;
    }

    public InformationDesc getInformation() {
        return this.getInformation(this.defaultLocale);
    }

    public InformationDesc getInformation(final Locale locale) {
        return new InformationDesc(this, new Locale[]{locale}){

            @Override
            protected List getItems(Object key) {
                ArrayList result = new ArrayList();
                for (int i = 0; i < JNLPFile.this.info.size(); ++i) {
                    InformationDesc infoDesc = (InformationDesc)JNLPFile.this.info.get(i);
                    if (!JNLPFile.this.localMatches(locale, infoDesc.getLocales()) || !JNLPFile.this.localMatches(locale, infoDesc.getLocales())) continue;
                    result.addAll(infoDesc.getItems(key));
                }
                return result;
            }
        };
    }

    public SecurityDesc getSecurity() {
        return this.security;
    }

    public ResourcesDesc getResources() {
        return this.getResources(this.defaultLocale, this.defaultOS, this.defaultArch);
    }

    public ResourcesDesc getResources(final Locale locale, final String os, final String arch) {
        return new ResourcesDesc(this, new Locale[]{locale}, new String[]{os}, new String[]{arch}){

            @Override
            public List getResources(Class launchType) {
                ArrayList result = new ArrayList();
                for (int i = 0; i < JNLPFile.this.resources.size(); ++i) {
                    ResourcesDesc rescDesc = (ResourcesDesc)JNLPFile.this.resources.get(i);
                    if (!JNLPFile.this.localMatches(locale, rescDesc.getLocales()) || !JNLPFile.this.stringMatches(os, rescDesc.getOS()) || !JNLPFile.this.stringMatches(arch, rescDesc.getArch())) continue;
                    result.addAll(rescDesc.getResources(launchType));
                }
                result.addAll(JNLPFile.this.sharedResources.getResources(launchType));
                return result;
            }

            @Override
            public void addResource(Object resource) {
                JNLPFile.this.sharedResources.addResource(resource);
            }
        };
    }

    public Object getLaunchInfo() {
        return this.launchType;
    }

    public AppletDesc getApplet() {
        if (!this.isApplet()) {
            throw new UnsupportedOperationException(JNLPFile.R("JNotApplet"));
        }
        return (AppletDesc)this.launchType;
    }

    public ApplicationDesc getApplication() {
        if (!this.isApplication()) {
            throw new UnsupportedOperationException(JNLPFile.R("JNotApplication"));
        }
        return (ApplicationDesc)this.launchType;
    }

    public ComponentDesc getComponent() {
        if (!this.isComponent()) {
            throw new UnsupportedOperationException(JNLPFile.R("JNotComponent"));
        }
        return (ComponentDesc)this.launchType;
    }

    public InstallerDesc getInstaller() {
        if (!this.isInstaller()) {
            throw new UnsupportedOperationException(JNLPFile.R("NotInstaller"));
        }
        return (InstallerDesc)this.launchType;
    }

    public boolean isApplet() {
        return this.launchType instanceof AppletDesc;
    }

    public boolean isApplication() {
        return this.launchType instanceof ApplicationDesc;
    }

    public boolean isComponent() {
        return this.launchType instanceof ComponentDesc;
    }

    public boolean isInstaller() {
        return this.launchType instanceof InstallerDesc;
    }

    public void setDefaults(String os, String arch, Locale locale) {
        this.defaultOS = os;
        this.defaultArch = arch;
        this.defaultLocale = locale;
    }

    private boolean localMatches(Locale requested, Locale[] available) {
        if (available == null || available.length == 0) {
            return true;
        }
        for (int i = 0; i < available.length; ++i) {
            String language = requested.getLanguage();
            String country = requested.getCountry();
            String variant = requested.getVariant();
            if (!"".equals(language) && !language.equalsIgnoreCase(available[i].getLanguage()) || !"".equals(country) && !country.equalsIgnoreCase(available[i].getCountry()) || !"".equals(variant) && !variant.equalsIgnoreCase(available[i].getVariant())) continue;
            return true;
        }
        return false;
    }

    private boolean stringMatches(String prefixStr, String[] available) {
        if (available == null || available.length == 0) {
            return true;
        }
        for (int i = 0; i < available.length; ++i) {
            if (available[i] == null || !available[i].startsWith(prefixStr)) continue;
            return true;
        }
        return false;
    }

    private void parse(Node root, boolean strict, URL location) throws ParseException {
        try {
            Parser parser = new Parser(this, location, root, strict, true);
            this.specVersion = parser.getSpecVersion();
            this.fileVersion = parser.getFileVersion();
            this.codeBase = parser.getCodeBase();
            this.sourceLocation = parser.getFileLocation();
            this.info = parser.getInfo(root);
            this.resources = parser.getResources(root, false);
            this.launchType = parser.getLauncher(root);
            this.security = parser.getSecurity(root);
        }
        catch (ParseException ex) {
            throw ex;
        }
        catch (Exception ex) {
            if (JNLPRuntime.isDebug()) {
                ex.printStackTrace();
            }
            throw new RuntimeException(ex.toString());
        }
    }
}

