/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.applet.Applet;
import java.awt.Container;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.jar.JarFile;
import net.sourceforge.jnlp.JARDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.LaunchException;
import net.sourceforge.jnlp.LaunchHandler;
import net.sourceforge.jnlp.ParseException;
import net.sourceforge.jnlp.PluginBridge;
import net.sourceforge.jnlp.cache.CacheUtil;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.runtime.AppThreadGroup;
import net.sourceforge.jnlp.runtime.AppletInstance;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.runtime.JNLPClassLoader;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.util.Reflect;

public class Launcher {
    private static final ThreadGroup mainGroup = new ThreadGroup(Launcher.R("LAllThreadGroup"));
    private LaunchHandler handler = null;
    private UpdatePolicy updatePolicy = JNLPRuntime.getDefaultUpdatePolicy();
    private boolean context = true;
    private boolean exitOnFailure = true;

    private static String R(String key) {
        return JNLPRuntime.getMessage(key);
    }

    public Launcher() {
        this(null, null);
        if (this.handler == null) {
            this.handler = JNLPRuntime.getDefaultLaunchHandler();
        }
    }

    public Launcher(boolean exitOnFailure) {
        this(null, null);
        if (this.handler == null) {
            this.handler = JNLPRuntime.getDefaultLaunchHandler();
        }
        this.exitOnFailure = exitOnFailure;
    }

    public Launcher(LaunchHandler handler) {
        this(handler, null);
    }

    public Launcher(LaunchHandler handler, UpdatePolicy policy) {
        if (policy == null) {
            policy = JNLPRuntime.getDefaultUpdatePolicy();
        }
        this.handler = handler;
        this.updatePolicy = policy;
    }

    public void setUpdatePolicy(UpdatePolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException(Launcher.R("LNullUpdatePolicy"));
        }
        this.updatePolicy = policy;
    }

    public UpdatePolicy getUpdatePolicy() {
        return this.updatePolicy;
    }

    public void setCreateAppContext(boolean context) {
        this.context = context;
    }

    public boolean isCreateAppContext() {
        return this.context;
    }

    public ApplicationInstance launch(JNLPFile file) throws LaunchException {
        return this.launch(file, null);
    }

    public ApplicationInstance launch(JNLPFile file, Container cont) throws LaunchException {
        TgThread tg = file instanceof PluginBridge && cont != null ? new TgThread(file, cont, true) : (cont == null ? new TgThread(file) : new TgThread(file, cont));
        tg.start();
        try {
            tg.join();
        }
        catch (InterruptedException ex) {
            throw this.launchWarning(new LaunchException(file, ex, Launcher.R("LSMinor"), Launcher.R("LCSystem"), Launcher.R("LThreadInterrupted"), Launcher.R("LThreadInterruptedInfo")));
        }
        if (tg.getException() != null) {
            throw tg.getException();
        }
        if (this.handler != null) {
            this.handler.launchCompleted(tg.getApplication());
        }
        return tg.getApplication();
    }

    public ApplicationInstance launch(URL location) throws LaunchException {
        return this.launch(this.toFile(location));
    }

    public void launchBackground(JNLPFile file) {
        BgRunner runner = new BgRunner(file, null);
        new Thread(runner).start();
    }

    public void launchBackground(URL location) {
        BgRunner runner = new BgRunner(null, location);
        new Thread(runner).start();
    }

    public void launchExternal(JNLPFile file) throws LaunchException {
        if (file.getSourceLocation() != null) {
            this.launchExternal(file.getSourceLocation());
        } else if (file.getFileLocation() != null) {
            this.launchExternal(file.getFileLocation());
        } else {
            this.launchError(new LaunchException(file, null, Launcher.R("LSFatal"), Launcher.R("LCExternalLaunch"), Launcher.R("LNullLocation"), Launcher.R("LNullLocationInfo")));
        }
    }

    public void launchExternal(URL location) throws LaunchException {
        try {
            File netxFile;
            URL cs = Launcher.class.getProtectionDomain().getCodeSource().getLocation();
            if (JNLPRuntime.isDebug()) {
                System.out.println("netx.jar path: " + cs.getPath());
            }
            if (!(netxFile = new File(cs.getPath())).exists()) {
                throw this.launchError(new LaunchException(null, null, Launcher.R("LSFatal"), Launcher.R("LCExternalLaunch"), Launcher.R("LNetxJarMissing"), Launcher.R("LNetxJarMissingInfo")));
            }
            String[] command = new String[]{"javaw", "-jar", netxFile.toString(), "-jnlp", location.toString(), "-verbose"};
            Process p = Runtime.getRuntime().exec(command);
            new StreamEater(p.getErrorStream()).start();
            new StreamEater(p.getInputStream()).start();
            p.getOutputStream().close();
        }
        catch (NullPointerException ex) {
            throw this.launchError(new LaunchException(null, null, Launcher.R("LSFatal"), Launcher.R("LCExternalLaunch"), Launcher.R("LNetxJarMissing"), Launcher.R("LNetxJarMissingInfo")));
        }
        catch (Exception ex) {
            throw this.launchError(new LaunchException(null, ex, Launcher.R("LSFatal"), Launcher.R("LCExternalLaunch"), Launcher.R("LCouldNotLaunch"), Launcher.R("LCouldNotLaunchInfo")));
        }
    }

    private JNLPFile toFile(URL location) throws LaunchException {
        try {
            JNLPFile file;
            block5: {
                file = null;
                try {
                    file = new JNLPFile(location, null, true, this.updatePolicy);
                }
                catch (ParseException ex) {
                    file = new JNLPFile(location, null, false, this.updatePolicy);
                    LaunchException lex = this.launchWarning(new LaunchException(file, ex, Launcher.R("LSMinor"), Launcher.R("LCFileFormat"), Launcher.R("LNotToSpec"), Launcher.R("LNotToSpecInfo")));
                    if (lex == null) break block5;
                    throw lex;
                }
            }
            return file;
        }
        catch (Exception ex) {
            if (ex instanceof LaunchException) {
                throw (LaunchException)ex;
            }
            throw this.launchError(new LaunchException(null, ex, Launcher.R("LSFatal"), Launcher.R("LCReadError"), Launcher.R("LCantRead"), Launcher.R("LCantReadInfo")));
        }
    }

    protected ApplicationInstance launchApplication(JNLPFile file) throws LaunchException {
        if (!file.isApplication()) {
            throw this.launchError(new LaunchException(file, null, Launcher.R("LSFatal"), Launcher.R("LCClient"), Launcher.R("LNotApplication"), Launcher.R("LNotApplicationInfo")));
        }
        try {
            JARDesc mainJarDesc;
            File f;
            ApplicationInstance app = this.createApplication(file);
            app.initialize();
            String mainName = file.getApplication().getMainClass();
            if (mainName == null && (f = CacheUtil.getCacheFile((mainJarDesc = file.getResources().getMainJAR()).getLocation(), null)) != null) {
                JarFile mainJar = new JarFile(f);
                mainName = mainJar.getManifest().getMainAttributes().getValue("Main-Class");
            }
            if (mainName == null) {
                throw this.launchError(new LaunchException(file, null, Launcher.R("LSFatal"), Launcher.R("LCClient"), Launcher.R("LCantDetermineMainClass"), Launcher.R("LCantDetermineMainClassInfo")));
            }
            Class<?> mainClass = app.getClassLoader().loadClass(mainName);
            Method main = mainClass.getDeclaredMethod("main", String[].class);
            String[] args = file.getApplication().getArguments();
            Thread.currentThread().setContextClassLoader(app.getClassLoader());
            main.invoke(null, new Object[]{args});
            return app;
        }
        catch (LaunchException lex) {
            throw this.launchError(lex);
        }
        catch (Exception ex) {
            throw this.launchError(new LaunchException(file, ex, Launcher.R("LSFatal"), Launcher.R("LCLaunching"), Launcher.R("LCouldNotLaunch"), Launcher.R("LCouldNotLaunchInfo")));
        }
    }

    protected ApplicationInstance launchApplet(JNLPFile file, boolean enableCodeBase, Container cont) throws LaunchException {
        if (!file.isApplet()) {
            throw this.launchError(new LaunchException(file, null, Launcher.R("LSFatal"), Launcher.R("LCClient"), Launcher.R("LNotApplet"), Launcher.R("LNotAppletInfo")));
        }
        try {
            AppletInstance applet = this.createApplet(file, enableCodeBase, cont);
            applet.initialize();
            applet.getAppletEnvironment().startApplet();
            return applet;
        }
        catch (LaunchException lex) {
            throw this.launchError(lex);
        }
        catch (Exception ex) {
            throw this.launchError(new LaunchException(file, ex, Launcher.R("LSFatal"), Launcher.R("LCLaunching"), Launcher.R("LCouldNotLaunch"), Launcher.R("LCouldNotLaunchInfo")));
        }
    }

    protected ApplicationInstance getApplet(JNLPFile file, boolean enableCodeBase, Container cont) throws LaunchException {
        if (!file.isApplet()) {
            throw this.launchError(new LaunchException(file, null, Launcher.R("LSFatal"), Launcher.R("LCClient"), Launcher.R("LNotApplet"), Launcher.R("LNotAppletInfo")));
        }
        try {
            AppletInstance applet = this.createApplet(file, enableCodeBase, cont);
            applet.initialize();
            return applet;
        }
        catch (LaunchException lex) {
            throw this.launchError(lex);
        }
        catch (Exception ex) {
            throw this.launchError(new LaunchException(file, ex, Launcher.R("LSFatal"), Launcher.R("LCLaunching"), Launcher.R("LCouldNotLaunch"), Launcher.R("LCouldNotLaunchInfo")));
        }
    }

    protected ApplicationInstance launchInstaller(JNLPFile file) throws LaunchException {
        throw this.launchError(new LaunchException(file, null, Launcher.R("LSFatal"), Launcher.R("LCNotSupported"), Launcher.R("LNoInstallers"), Launcher.R("LNoInstallersInfo")));
    }

    protected AppletInstance createApplet(JNLPFile file, boolean enableCodeBase, Container cont) throws LaunchException {
        try {
            JNLPClassLoader loader = JNLPClassLoader.getInstance(file, this.updatePolicy);
            if (enableCodeBase || file.getResources().getJARs().length == 0) {
                loader.enableCodeBase();
            }
            AppThreadGroup group = (AppThreadGroup)Thread.currentThread().getThreadGroup();
            String appletName = file.getApplet().getMainClass();
            appletName = appletName.replace('/', '.');
            Class appletClass = loader.loadClass(appletName);
            Applet applet = (Applet)appletClass.newInstance();
            AppletInstance appletInstance = cont == null ? new AppletInstance(file, group, loader, applet) : new AppletInstance(file, group, loader, applet, cont);
            group.setApplication(appletInstance);
            loader.setApplication(appletInstance);
            return appletInstance;
        }
        catch (Exception ex) {
            throw this.launchError(new LaunchException(file, ex, Launcher.R("LSFatal"), Launcher.R("LCInit"), Launcher.R("LInitApplet"), Launcher.R("LInitAppletInfo")));
        }
    }

    protected Applet createAppletObject(JNLPFile file, boolean enableCodeBase, Container cont) throws LaunchException {
        try {
            JNLPClassLoader loader = JNLPClassLoader.getInstance(file, this.updatePolicy);
            if (enableCodeBase || file.getResources().getJARs().length == 0) {
                loader.enableCodeBase();
            }
            String appletName = file.getApplet().getMainClass();
            appletName = appletName.replace('/', '.');
            Class appletClass = loader.loadClass(appletName);
            Applet applet = (Applet)appletClass.newInstance();
            return applet;
        }
        catch (Exception ex) {
            throw this.launchError(new LaunchException(file, ex, Launcher.R("LSFatal"), Launcher.R("LCInit"), Launcher.R("LInitApplet"), Launcher.R("LInitAppletInfo")));
        }
    }

    protected ApplicationInstance createApplication(JNLPFile file) throws LaunchException {
        try {
            JNLPClassLoader loader = JNLPClassLoader.getInstance(file, this.updatePolicy);
            AppThreadGroup group = (AppThreadGroup)Thread.currentThread().getThreadGroup();
            ApplicationInstance app = new ApplicationInstance(file, group, loader);
            group.setApplication(app);
            loader.setApplication(app);
            return app;
        }
        catch (Exception ex) {
            throw new LaunchException(file, ex, Launcher.R("LSFatal"), Launcher.R("LCInit"), Launcher.R("LInitApplet"), Launcher.R("LInitAppletInfo"));
        }
    }

    protected AppThreadGroup createThreadGroup(JNLPFile file) {
        return new AppThreadGroup(mainGroup, file.getTitle());
    }

    private LaunchException launchError(LaunchException ex) {
        if (this.handler != null) {
            this.handler.launchError(ex);
        }
        return ex;
    }

    private LaunchException launchWarning(LaunchException ex) {
        if (this.handler != null && !this.handler.launchWarning(ex)) {
            return ex;
        }
        return null;
    }

    private static class StreamEater
    extends Thread {
        private InputStream stream;

        StreamEater(InputStream stream) {
            this.stream = new BufferedInputStream(stream);
        }

        @Override
        public void run() {
            try {
                int c;
                while ((c = this.stream.read()) != -1) {
                    System.out.write(c);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class BgRunner
    implements Runnable {
        private JNLPFile file;
        private URL location;

        BgRunner(JNLPFile file, URL location) {
            this.file = file;
            this.location = location;
        }

        @Override
        public void run() {
            try {
                if (this.file != null) {
                    Launcher.this.launch(this.file);
                }
                if (this.location != null) {
                    Launcher.this.launch(this.location);
                }
            }
            catch (LaunchException launchException) {
                // empty catch block
            }
        }
    }

    private class TgThread
    extends Thread {
        private JNLPFile file;
        private ApplicationInstance application;
        private LaunchException exception;
        private Container cont;
        private boolean isPlugin;

        TgThread(JNLPFile file) {
            this(file, null);
        }

        TgThread(JNLPFile file, Container cont) {
            super((ThreadGroup)Launcher.this.createThreadGroup(file), file.getTitle());
            this.isPlugin = false;
            this.file = file;
            this.cont = cont;
        }

        TgThread(JNLPFile file, Container cont, boolean isPlugin) {
            super((ThreadGroup)Launcher.this.createThreadGroup(file), file.getTitle());
            this.isPlugin = false;
            this.file = file;
            this.cont = cont;
            this.isPlugin = isPlugin;
        }

        @Override
        public void run() {
            block7: {
                try {
                    if (Launcher.this.context && !this.isPlugin) {
                        new Reflect().invokeStatic("sun.awt.SunToolkit", "createNewAppContext");
                    }
                    if (this.isPlugin) {
                        JNLPRuntime.setDefaultDownloadIndicator(null);
                        this.application = Launcher.this.getApplet(this.file, true, this.cont);
                        break block7;
                    }
                    if (this.file.isApplication()) {
                        this.application = Launcher.this.launchApplication(this.file);
                        break block7;
                    }
                    if (this.file.isApplet()) {
                        this.application = Launcher.this.launchApplet(this.file, true, this.cont);
                        break block7;
                    }
                    if (this.file.isInstaller()) {
                        this.application = Launcher.this.launchInstaller(this.file);
                        break block7;
                    }
                    throw Launcher.this.launchError(new LaunchException(this.file, null, Launcher.R("LSFatal"), Launcher.R("LCClient"), Launcher.R("LNotLaunchable"), Launcher.R("LNotLaunchableInfo")));
                }
                catch (LaunchException ex) {
                    ex.printStackTrace();
                    this.exception = ex;
                    if (!Launcher.this.exitOnFailure) break block7;
                    System.exit(0);
                }
            }
        }

        public LaunchException getException() {
            return this.exception;
        }

        public ApplicationInstance getApplication() {
            return this.application;
        }
    }
}

