/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.cache;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.jnlp.DownloadServiceListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import net.sourceforge.jnlp.cache.DownloadIndicator;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.runtime.JNLPRuntime;

public class DefaultDownloadIndicator
implements DownloadIndicator {
    private static String downloading = JNLPRuntime.getMessage("CDownloading");
    private static String complete = JNLPRuntime.getMessage("CComplete");
    private static final int CLOSE_DELAY = 750;
    private static JFrame frame;
    static GridBagConstraints vertical;
    static GridBagConstraints verticalIndent;

    @Override
    public int getUpdateRate() {
        return 150;
    }

    @Override
    public int getInitialDelay() {
        return 300;
    }

    @Override
    public DownloadServiceListener getListener(ApplicationInstance app, String downloadName, URL[] resources) {
        DownloadPanel result = new DownloadPanel(downloadName);
        if (frame == null) {
            frame = new JFrame(downloading + "...");
            frame.getContentPane().setLayout(new GridBagLayout());
        }
        if (resources != null) {
            for (int i = 0; i < resources.length; ++i) {
                result.addProgressPanel(resources[i], null);
            }
        }
        frame.getContentPane().add((Component)result, vertical);
        frame.pack();
        if (!frame.isVisible()) {
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            frame.setLocation(screen.width / 2 - frame.getWidth() / 2, screen.height / 2 - frame.getHeight() / 2);
        }
        frame.show();
        return result;
    }

    @Override
    public void disposeListener(final DownloadServiceListener listener) {
        if (!(listener instanceof DownloadPanel)) {
            return;
        }
        ActionListener hider = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (frame.getContentPane().getComponentCount() == 1) {
                    frame.hide();
                }
                frame.getContentPane().remove((DownloadPanel)listener);
                frame.pack();
            }
        };
        Timer timer = new Timer(750, hider);
        timer.setRepeats(false);
        timer.start();
    }

    static {
        vertical = new GridBagConstraints();
        DefaultDownloadIndicator.vertical.gridwidth = 0;
        DefaultDownloadIndicator.vertical.weightx = 1.0;
        DefaultDownloadIndicator.vertical.fill = 2;
        DefaultDownloadIndicator.vertical.anchor = 17;
        verticalIndent = (GridBagConstraints)vertical.clone();
        DefaultDownloadIndicator.verticalIndent.insets = new Insets(0, 10, 3, 0);
    }

    static class ProgressPanel
    extends JPanel {
        private JPanel bar = new JPanel();
        private long total;
        private long readSoFar;

        ProgressPanel(URL url, String version) {
            JLabel location = new JLabel(" " + url.getHost() + "/" + url.getFile());
            this.bar.setMinimumSize(new Dimension(80, 15));
            this.bar.setPreferredSize(new Dimension(80, 15));
            this.bar.setOpaque(false);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.weightx = 0.0;
            gbc.fill = 0;
            gbc.gridwidth = -1;
            this.add((Component)this.bar, gbc);
            gbc.insets = new Insets(0, 3, 0, 0);
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.gridwidth = 0;
            gbc.anchor = 17;
            this.add((Component)location, gbc);
        }

        public void setProgress(long readSoFar, long total) {
            this.readSoFar = readSoFar;
            this.total = total;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            int x = this.bar.getX();
            int y = this.bar.getY();
            int h = this.bar.getHeight();
            int w = this.bar.getWidth();
            if (this.readSoFar > 0L && this.total > 0L) {
                double progress = (double)this.readSoFar / (double)this.total;
                int divide = (int)((double)w * progress);
                g.setColor(Color.white);
                g.fillRect(x, y, w, h);
                g.setColor(Color.blue);
                g.fillRect(x + 1, y + 1, divide - 1, h - 1);
            }
        }
    }

    static class DownloadPanel
    extends JPanel
    implements DownloadServiceListener {
        private String downloadName;
        private JLabel header = new JLabel();
        private List urls = new ArrayList();
        private List panels = new ArrayList();

        protected DownloadPanel(String downloadName) {
            this.setLayout(new GridBagLayout());
            this.downloadName = downloadName;
            this.add((Component)this.header, vertical);
            this.header.setFont(this.header.getFont().deriveFont(1));
            this.setOverallPercent(0);
        }

        protected void addProgressPanel(URL url, String version) {
            if (!this.urls.contains(url)) {
                ProgressPanel panel = new ProgressPanel(url, version);
                this.add((Component)panel, verticalIndent);
                frame.pack();
                this.urls.add(url);
                this.panels.add(panel);
            }
        }

        protected void update(final URL url, final String version, final long readSoFar, final long total, final int overallPercent) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    if (!DownloadPanel.this.urls.contains(url)) {
                        DownloadPanel.this.addProgressPanel(url, version);
                    }
                    DownloadPanel.this.setOverallPercent(overallPercent);
                    ProgressPanel panel = (ProgressPanel)DownloadPanel.this.panels.get(DownloadPanel.this.urls.indexOf(url));
                    panel.setProgress(readSoFar, total);
                    panel.repaint();
                }
            };
            SwingUtilities.invokeLater(r);
        }

        public void setOverallPercent(int percent) {
            this.header.setText(downloading + " " + this.downloadName + ": " + percent + "% " + complete + ".");
        }

        @Override
        public void downloadFailed(URL url, String version) {
            this.update(url, version, -1L, -1L, -1);
        }

        @Override
        public void progress(URL url, String version, long readSoFar, long total, int overallPercent) {
            this.update(url, version, readSoFar, total, overallPercent);
        }

        @Override
        public void upgradingArchive(URL url, String version, int patchPercent, int overallPercent) {
            this.update(url, version, patchPercent, 100L, overallPercent);
        }

        @Override
        public void validating(URL url, String version, long entry, long total, int overallPercent) {
            this.update(url, version, entry, total, overallPercent);
        }
    }
}

