/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.KeyStore;

public class SecurityUtil {
    private static String homeDir = null;
    private static final String certDir = "/.netx/security/";
    private static final String certFile = "trusted.certs";
    private static final char[] password = "changeit".toCharArray();

    public static String getTrustedCertsFilename() throws Exception {
        homeDir = System.getProperty("user.home");
        if (homeDir == null) {
            throw new Exception("Could not access home directory");
        }
        return homeDir + certDir + certFile;
    }

    public static char[] getTrustedCertsPassword() {
        return password;
    }

    public static String getCN(String principal) {
        int start = principal.indexOf("CN=");
        int end = principal.indexOf(",", start);
        if (end == -1) {
            end = principal.length();
        }
        if (start >= 0) {
            return principal.substring(start + 3, end);
        }
        return principal;
    }

    public static boolean checkTrustedCertsFile() throws Exception {
        File certFile = new File(SecurityUtil.getTrustedCertsFilename());
        if (!certFile.isFile()) {
            File dir = new File(homeDir + certDir);
            boolean madeDir = false;
            if (!dir.isDirectory()) {
                madeDir = dir.mkdirs();
            }
            if (madeDir || dir.isDirectory()) {
                KeyStore ks = KeyStore.getInstance("JKS");
                ks.load(null, password);
                FileOutputStream fos = new FileOutputStream(certFile);
                ks.store(fos, password);
                fos.close();
                return true;
            }
            return false;
        }
        return true;
    }

    public static KeyStore getUserKeyStore() throws Exception {
        KeyStore ks = null;
        FileInputStream fis = null;
        if (SecurityUtil.checkTrustedCertsFile()) {
            try {
                File file = new File(SecurityUtil.getTrustedCertsFilename());
                if (file.exists()) {
                    fis = new FileInputStream(file);
                    ks = KeyStore.getInstance("JKS");
                    ks.load(fis, password);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
        }
        return ks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore getCacertsKeyStore() throws Exception {
        KeyStore caks = null;
        FileInputStream fis = null;
        try {
            File file = new File(System.getProperty("java.home") + "/lib/security/cacerts");
            if (file.exists()) {
                fis = new FileInputStream(file);
                caks = KeyStore.getInstance("JKS");
                caks.load(fis, null);
            }
        }
        catch (Exception e) {
            caks = null;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        return caks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore getSystemCertStore() throws Exception {
        KeyStore caks = null;
        FileInputStream fis = null;
        try {
            File file = new File(System.getProperty("javax.net.ssl.trustStore"));
            String type = System.getProperty("javax.net.ssl.trustStoreType");
            char[] password = System.getProperty("javax.net.ssl.trustStorePassword").toCharArray();
            if (file.exists()) {
                fis = new FileInputStream(file);
                caks = KeyStore.getInstance(type);
                caks.load(fis, password);
            }
        }
        catch (Exception e) {
            caks = null;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        return caks;
    }
}

