/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Point;
import java.io.IOException;
import sun.awt.X11.MotifDnDConstants;
import sun.awt.X11.Native;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XAtom;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XDropTargetEventProcessor;
import sun.awt.X11.XDropTargetProtocol;
import sun.awt.X11.XDropTargetProtocolListener;
import sun.awt.X11.XDropTargetRegistry;
import sun.awt.X11.XException;
import sun.awt.X11.XSelection;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWM;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowAttributes;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

class MotifDnDDropTargetProtocol
extends XDropTargetProtocol {
    private static final Unsafe unsafe = XlibWrapper.unsafe;
    private long sourceWindow = 0L;
    private long sourceWindowMask = 0L;
    private int sourceProtocolVersion = 0;
    private int sourceActions = 0;
    private long[] sourceFormats = null;
    private long sourceAtom = 0L;
    private int userAction = 0;
    private int sourceX = 0;
    private int sourceY = 0;
    private XWindow targetXWindow = null;
    private boolean topLevelLeavePostponed = false;

    protected MotifDnDDropTargetProtocol(XDropTargetProtocolListener listener) {
        super(listener);
    }

    static XDropTargetProtocol createInstance(XDropTargetProtocolListener listener) {
        return new MotifDnDDropTargetProtocol(listener);
    }

    public String getProtocolName() {
        return "MotifDnD";
    }

    public void registerDropTarget(long window) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        MotifDnDConstants.writeDragReceiverInfoStruct(window);
    }

    public void unregisterDropTarget(long window) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        MotifDnDConstants.XA_MOTIF_ATOM_0.DeleteProperty(window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEmbedderDropSite(long embedder) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        boolean overriden = false;
        int version = 0;
        long proxy = 0L;
        long newProxy = XDropTargetRegistry.getDnDProxyWindow();
        int status = 0;
        long data = 0L;
        int dataSize = 16;
        WindowPropertyGetter wpg = new WindowPropertyGetter(embedder, MotifDnDConstants.XA_MOTIF_DRAG_RECEIVER_INFO, 0L, 65535L, false, 0L);
        try {
            status = wpg.execute(XToolkit.IgnoreBadWindowHandler);
            if (status == 0 && wpg.getData() != 0L && wpg.getActualType() != 0L && wpg.getActualFormat() == 8 && wpg.getNumberOfItems() >= 16) {
                overriden = true;
                data = wpg.getData();
                dataSize = wpg.getNumberOfItems();
                byte byteOrderByte = unsafe.getByte(data);
                int tproxy = unsafe.getInt(data + 4L);
                if (byteOrderByte != MotifDnDConstants.getByteOrderByte()) {
                    tproxy = MotifDnDConstants.Swapper.swap(tproxy);
                }
                if ((proxy = (long)tproxy) == newProxy) {
                    return;
                }
                tproxy = (int)newProxy;
                if (byteOrderByte != MotifDnDConstants.getByteOrderByte()) {
                    tproxy = MotifDnDConstants.Swapper.swap(tproxy);
                }
                unsafe.putInt(data + 4L, tproxy);
            } else {
                data = unsafe.allocateMemory(dataSize);
                unsafe.putByte(data, MotifDnDConstants.getByteOrderByte());
                unsafe.putByte(data + 1L, (byte)0);
                unsafe.putByte(data + 2L, (byte)5);
                unsafe.putByte(data + 3L, (byte)0);
                unsafe.putInt(data + 4L, (int)newProxy);
                unsafe.putShort(data + 8L, (short)0);
                unsafe.putShort(data + 10L, (short)0);
                unsafe.putInt(data + 12L, dataSize);
            }
            XToolkit.WITH_XERROR_HANDLER(XWM.VerifyChangePropertyHandler);
            XlibWrapper.XChangeProperty(XToolkit.getDisplay(), embedder, MotifDnDConstants.XA_MOTIF_DRAG_RECEIVER_INFO.getAtom(), MotifDnDConstants.XA_MOTIF_DRAG_RECEIVER_INFO.getAtom(), 8, 0, data, dataSize);
            XToolkit.RESTORE_XERROR_HANDLER();
            if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                throw new XException("Cannot write Motif receiver info property");
            }
        }
        finally {
            if (!overriden) {
                unsafe.freeMemory(data);
                data = 0L;
            }
            wpg.dispose();
        }
        this.putEmbedderRegistryEntry(embedder, overriden, version, proxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unregisterEmbedderDropSite(long embedder) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        XDropTargetProtocol.EmbedderRegistryEntry entry = this.getEmbedderRegistryEntry(embedder);
        if (entry == null) {
            return;
        }
        if (entry.isOverriden()) {
            int status = 0;
            WindowPropertyGetter wpg = new WindowPropertyGetter(embedder, MotifDnDConstants.XA_MOTIF_DRAG_RECEIVER_INFO, 0L, 65535L, false, 0L);
            try {
                status = wpg.execute(XToolkit.IgnoreBadWindowHandler);
                if (status != 0 || wpg.getData() == 0L || wpg.getActualType() == 0L || wpg.getActualFormat() != 8 || wpg.getNumberOfItems() < 16) return;
                int dataSize = 16;
                long data = wpg.getData();
                byte byteOrderByte = unsafe.getByte(data);
                int tproxy = (int)entry.getProxy();
                if (MotifDnDConstants.getByteOrderByte() != byteOrderByte) {
                    tproxy = MotifDnDConstants.Swapper.swap(tproxy);
                }
                unsafe.putInt(data + 4L, tproxy);
                XToolkit.WITH_XERROR_HANDLER(XWM.VerifyChangePropertyHandler);
                XlibWrapper.XChangeProperty(XToolkit.getDisplay(), embedder, MotifDnDConstants.XA_MOTIF_DRAG_RECEIVER_INFO.getAtom(), MotifDnDConstants.XA_MOTIF_DRAG_RECEIVER_INFO.getAtom(), 8, 0, data, dataSize);
                XToolkit.RESTORE_XERROR_HANDLER();
                if (XToolkit.saved_error == null || XToolkit.saved_error.get_error_code() == 0) return;
                throw new XException("Cannot write Motif receiver info property");
            }
            finally {
                wpg.dispose();
            }
        } else {
            MotifDnDConstants.XA_MOTIF_DRAG_RECEIVER_INFO.DeleteProperty(embedder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEmbeddedDropSite(long embedded) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        boolean overriden = false;
        int version = 0;
        long proxy = 0L;
        int status = 0;
        WindowPropertyGetter wpg = new WindowPropertyGetter(embedded, MotifDnDConstants.XA_MOTIF_DRAG_RECEIVER_INFO, 0L, 65535L, false, 0L);
        try {
            status = wpg.execute(XToolkit.IgnoreBadWindowHandler);
            if (status == 0 && wpg.getData() != 0L && wpg.getActualType() != 0L && wpg.getActualFormat() == 8 && wpg.getNumberOfItems() >= 16) {
                overriden = true;
                long data = wpg.getData();
                byte byteOrderByte = unsafe.getByte(data);
                int tproxy = unsafe.getInt(data + 4L);
                if (byteOrderByte != MotifDnDConstants.getByteOrderByte()) {
                    tproxy = MotifDnDConstants.Swapper.swap(tproxy);
                }
                proxy = tproxy;
            }
        }
        finally {
            wpg.dispose();
        }
        this.putEmbedderRegistryEntry(embedded, overriden, version, proxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProtocolSupported(long window) {
        WindowPropertyGetter wpg = new WindowPropertyGetter(window, MotifDnDConstants.XA_MOTIF_DRAG_RECEIVER_INFO, 0L, 65535L, false, 0L);
        try {
            int status = wpg.execute(XToolkit.IgnoreBadWindowHandler);
            if (status == 0 && wpg.getData() != 0L && wpg.getActualType() != 0L && wpg.getActualFormat() == 8 && wpg.getNumberOfItems() >= 16) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            wpg.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processTopLevelEnter(XClientMessageEvent xclient) {
        int status;
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        if (this.targetXWindow != null || this.sourceWindow != 0L) {
            return false;
        }
        if (!(XToolkit.windowToXWindow(xclient.get_window()) instanceof XWindow) && this.getEmbedderRegistryEntry(xclient.get_window()) == null) {
            return false;
        }
        long source_win = 0L;
        long source_win_mask = 0L;
        byte protocol_version = 0;
        long property_atom = 0L;
        long[] formats = null;
        long data = xclient.get_data();
        byte eventByteOrder = unsafe.getByte(data + 1L);
        source_win = MotifDnDConstants.Swapper.getInt(data + 8L, eventByteOrder);
        property_atom = MotifDnDConstants.Swapper.getInt(data + 12L, eventByteOrder);
        WindowPropertyGetter wpg = new WindowPropertyGetter(source_win, XAtom.get(property_atom), 0L, 65535L, false, MotifDnDConstants.XA_MOTIF_DRAG_INITIATOR_INFO.getAtom());
        try {
            status = wpg.execute(XToolkit.IgnoreBadWindowHandler);
            if (status == 0 && wpg.getData() != 0L && wpg.getActualType() == MotifDnDConstants.XA_MOTIF_DRAG_INITIATOR_INFO.getAtom() && wpg.getActualFormat() == 8 && wpg.getNumberOfItems() == 8) {
                long data2 = wpg.getData();
                byte propertyByteOrder = unsafe.getByte(data2);
                protocol_version = unsafe.getByte(data2 + 1L);
                if (protocol_version != 0) {
                    boolean bl = false;
                    return bl;
                }
                short index = MotifDnDConstants.Swapper.getShort(data2 + 2L, propertyByteOrder);
                formats = MotifDnDConstants.getTargetListForIndex(index);
            } else {
                formats = new long[]{};
            }
        }
        finally {
            wpg.dispose();
        }
        XWindowAttributes wattr = new XWindowAttributes();
        try {
            XToolkit.WITH_XERROR_HANDLER(XToolkit.IgnoreBadWindowHandler);
            status = XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), source_win, wattr.pData);
            XToolkit.RESTORE_XERROR_HANDLER();
            if (status == 0 || XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                throw new XException("XGetWindowAttributes failed");
            }
            source_win_mask = wattr.get_your_event_mask();
        }
        finally {
            wattr.dispose();
        }
        XToolkit.WITH_XERROR_HANDLER(XToolkit.IgnoreBadWindowHandler);
        XlibWrapper.XSelectInput(XToolkit.getDisplay(), source_win, source_win_mask | 0x20000L);
        XToolkit.RESTORE_XERROR_HANDLER();
        if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
            throw new XException("XSelectInput failed");
        }
        this.sourceWindow = source_win;
        this.sourceWindowMask = source_win_mask;
        this.sourceProtocolVersion = protocol_version;
        this.sourceActions = 0;
        this.sourceFormats = formats;
        this.sourceAtom = property_atom;
        return true;
    }

    private boolean processDragMotion(XClientMessageEvent xclient) {
        long data = xclient.get_data();
        byte eventByteOrder = unsafe.getByte(data + 1L);
        byte eventReason = (byte)(unsafe.getByte(data) & 0x7F);
        int x = 0;
        int y = 0;
        short flags = MotifDnDConstants.Swapper.getShort(data + 2L, eventByteOrder);
        int motif_action = (flags & 0xF) >> 0;
        int motif_actions = (flags & 0xF00) >> 8;
        int java_action = MotifDnDConstants.getJavaActionsForMotifActions(motif_action);
        int java_actions = MotifDnDConstants.getJavaActionsForMotifActions(motif_actions);
        int win = (int)this.sourceWindow;
        if (eventByteOrder != MotifDnDConstants.getByteOrderByte()) {
            win = MotifDnDConstants.Swapper.swap(win);
        }
        unsafe.putInt(data + 12L, win);
        XWindow xwindow = null;
        XBaseWindow xbasewindow = XToolkit.windowToXWindow(xclient.get_window());
        if (xbasewindow instanceof XWindow) {
            xwindow = (XWindow)xbasewindow;
        }
        if (eventReason == 8) {
            x = this.sourceX;
            y = this.sourceY;
            if (xwindow == null) {
                xwindow = this.targetXWindow;
            }
        } else {
            XBaseWindow xbasewindow2;
            long receiver;
            x = MotifDnDConstants.Swapper.getShort(data + 8L, eventByteOrder);
            y = MotifDnDConstants.Swapper.getShort(data + 10L, eventByteOrder);
            if (xwindow == null && (receiver = XDropTargetRegistry.getRegistry().getEmbeddedDropSite(xclient.get_window(), x, y)) != 0L && (xbasewindow2 = XToolkit.windowToXWindow(receiver)) instanceof XWindow) {
                xwindow = (XWindow)xbasewindow2;
            }
            if (xwindow != null) {
                Point p = xwindow.toLocal(x, y);
                x = p.x;
                y = p.y;
            }
        }
        if (xwindow == null) {
            if (this.targetXWindow != null) {
                this.notifyProtocolListener(this.targetXWindow, x, y, 0, java_actions, xclient, 505);
            }
        } else {
            int java_event_id = 0;
            java_event_id = this.targetXWindow == null ? 504 : 506;
            this.notifyProtocolListener(xwindow, x, y, java_action, java_actions, xclient, java_event_id);
        }
        this.sourceActions = java_actions;
        this.userAction = java_action;
        this.sourceX = x;
        this.sourceY = y;
        this.targetXWindow = xwindow;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processTopLevelLeave(XClientMessageEvent xclient) {
        byte eventByteOrder;
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        long data = xclient.get_data();
        long source_win = MotifDnDConstants.Swapper.getInt(data + 8L, eventByteOrder = unsafe.getByte(data + 1L));
        if (source_win != this.sourceWindow) {
            return false;
        }
        this.topLevelLeavePostponed = true;
        long proxy = this.getEmbedderRegistryEntry(xclient.get_window()) != null ? XDropTargetRegistry.getDnDProxyWindow() : xclient.get_window();
        XClientMessageEvent dummy = new XClientMessageEvent();
        try {
            dummy.set_type(33);
            dummy.set_window(xclient.get_window());
            dummy.set_format(32);
            dummy.set_message_type(0L);
            dummy.set_data(0, 0L);
            dummy.set_data(1, 0L);
            dummy.set_data(2, 0L);
            dummy.set_data(3, 0L);
            dummy.set_data(4, 0L);
            XlibWrapper.XSendEvent(XToolkit.getDisplay(), proxy, false, 0L, dummy.pData);
        }
        finally {
            dummy.dispose();
        }
        return true;
    }

    private boolean processDropStart(XClientMessageEvent xclient) {
        XBaseWindow xbasewindow;
        long receiver;
        byte eventByteOrder;
        long data = xclient.get_data();
        long source_win = MotifDnDConstants.Swapper.getInt(data + 16L, eventByteOrder = unsafe.getByte(data + 1L));
        if (source_win != this.sourceWindow) {
            return false;
        }
        long property_atom = MotifDnDConstants.Swapper.getInt(data + 12L, eventByteOrder);
        short flags = MotifDnDConstants.Swapper.getShort(data + 2L, eventByteOrder);
        int motif_action = (flags & 0xF) >> 0;
        int motif_actions = (flags & 0xF00) >> 8;
        int java_action = MotifDnDConstants.getJavaActionsForMotifActions(motif_action);
        int java_actions = MotifDnDConstants.getJavaActionsForMotifActions(motif_actions);
        int x = MotifDnDConstants.Swapper.getShort(data + 8L, eventByteOrder);
        int y = MotifDnDConstants.Swapper.getShort(data + 10L, eventByteOrder);
        XWindow xwindow = null;
        XBaseWindow xbasewindow2 = XToolkit.windowToXWindow(xclient.get_window());
        if (xbasewindow2 instanceof XWindow) {
            xwindow = (XWindow)xbasewindow2;
        }
        if (xwindow == null && (receiver = XDropTargetRegistry.getRegistry().getEmbeddedDropSite(xclient.get_window(), x, y)) != 0L && (xbasewindow = XToolkit.windowToXWindow(receiver)) instanceof XWindow) {
            xwindow = (XWindow)xbasewindow;
        }
        if (xwindow != null) {
            Point p = xwindow.toLocal(x, y);
            x = p.x;
            y = p.y;
        }
        if (xwindow != null) {
            this.notifyProtocolListener(xwindow, x, y, java_action, java_actions, xclient, 502);
        } else if (this.targetXWindow != null) {
            this.notifyProtocolListener(this.targetXWindow, x, y, 0, java_actions, xclient, 505);
        }
        return true;
    }

    public int getMessageType(XClientMessageEvent xclient) {
        if (xclient.get_message_type() != MotifDnDConstants.XA_MOTIF_DRAG_AND_DROP_MESSAGE.getAtom()) {
            return 0;
        }
        long data = xclient.get_data();
        byte reason = (byte)(unsafe.getByte(data) & 0x7F);
        switch (reason) {
            case 0: {
                return 1;
            }
            case 2: 
            case 8: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 5: {
                return 4;
            }
        }
        return 0;
    }

    protected boolean processClientMessageImpl(XClientMessageEvent xclient) {
        if (xclient.get_message_type() != MotifDnDConstants.XA_MOTIF_DRAG_AND_DROP_MESSAGE.getAtom()) {
            if (this.topLevelLeavePostponed) {
                this.topLevelLeavePostponed = false;
                this.cleanup();
            }
            return false;
        }
        long data = xclient.get_data();
        byte reason = (byte)(unsafe.getByte(data) & 0x7F);
        byte origin = (byte)(unsafe.getByte(data) & 0xFFFFFF80);
        if (this.topLevelLeavePostponed) {
            this.topLevelLeavePostponed = false;
            if (reason != 5) {
                this.cleanup();
            }
        }
        if (origin != 0) {
            return false;
        }
        switch (reason) {
            case 0: {
                return this.processTopLevelEnter(xclient);
            }
            case 2: 
            case 8: {
                return this.processDragMotion(xclient);
            }
            case 1: {
                return this.processTopLevelLeave(xclient);
            }
            case 5: {
                return this.processDropStart(xclient);
            }
        }
        return false;
    }

    protected void sendEnterMessageToToplevel(long win, XClientMessageEvent xclient) {
        throw new Error("UNIMPLEMENTED");
    }

    protected void sendLeaveMessageToToplevel(long win, XClientMessageEvent xclient) {
        throw new Error("UNIMPLEMENTED");
    }

    public boolean forwardEventToEmbedded(long embedded, long ctxt, int eventID) {
        return false;
    }

    public boolean isXEmbedSupported() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendResponse(long ctxt, int eventID, int action) {
        XClientMessageEvent xclient = new XClientMessageEvent(ctxt);
        if (xclient.get_message_type() != MotifDnDConstants.XA_MOTIF_DRAG_AND_DROP_MESSAGE.getAtom()) {
            return false;
        }
        long data = xclient.get_data();
        int reason = unsafe.getByte(data) & 0x7F;
        byte origin = (byte)(unsafe.getByte(data) & 0xFFFFFF80);
        byte eventByteOrder = unsafe.getByte(data + 1L);
        int response_reason = 0;
        if (origin != 0) {
            return false;
        }
        switch (reason) {
            case 0: 
            case 1: {
                return false;
            }
            case 2: {
                switch (eventID) {
                    case 504: {
                        response_reason = 3;
                        break;
                    }
                    case 506: {
                        response_reason = 2;
                        break;
                    }
                    case 505: {
                        response_reason = 4;
                    }
                }
                break;
            }
            case 5: 
            case 8: {
                response_reason = reason;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        XClientMessageEvent msg = new XClientMessageEvent();
        try {
            msg.set_type(33);
            msg.set_window(MotifDnDConstants.Swapper.getInt(data + 12L, eventByteOrder));
            msg.set_format(8);
            msg.set_message_type(MotifDnDConstants.XA_MOTIF_DRAG_AND_DROP_MESSAGE.getAtom());
            long responseData = msg.get_data();
            unsafe.putByte(responseData, (byte)(response_reason | 0xFFFFFF80));
            unsafe.putByte(responseData + 1L, MotifDnDConstants.getByteOrderByte());
            int response_flags = 0;
            if (response_reason != 4) {
                short flags = MotifDnDConstants.Swapper.getShort(data + 2L, eventByteOrder);
                int dropSiteStatus = action == 0 ? 2 : 3;
                response_flags = flags & 0xFFFFFFF0 & 0xFFFFFF0F;
                response_flags |= MotifDnDConstants.getMotifActionsForJavaActions(action) << 0;
                response_flags |= dropSiteStatus << 4;
            } else {
                response_flags = 0;
            }
            unsafe.putShort(responseData + 2L, (short)response_flags);
            int time = MotifDnDConstants.Swapper.getInt(data + 4L, eventByteOrder);
            unsafe.putInt(responseData + 4L, time);
            if (response_reason != 4) {
                short x = MotifDnDConstants.Swapper.getShort(data + 8L, eventByteOrder);
                short y = MotifDnDConstants.Swapper.getShort(data + 10L, eventByteOrder);
                unsafe.putShort(responseData + 8L, x);
                unsafe.putShort(responseData + 10L, y);
            } else {
                unsafe.putShort(responseData + 8L, (short)0);
                unsafe.putShort(responseData + 10L, (short)0);
            }
            XToolkit.awtLock();
            try {
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), msg.get_window(), false, 0L, msg.pData);
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        finally {
            msg.dispose();
        }
        return true;
    }

    public Object getData(long ctxt, long format) throws IllegalArgumentException, IOException {
        XClientMessageEvent xclient = new XClientMessageEvent(ctxt);
        if (xclient.get_message_type() != MotifDnDConstants.XA_MOTIF_DRAG_AND_DROP_MESSAGE.getAtom()) {
            throw new IllegalArgumentException();
        }
        long data = xclient.get_data();
        byte reason = (byte)(unsafe.getByte(data) & 0x7F);
        byte origin = (byte)(unsafe.getByte(data) & 0xFFFFFF80);
        byte eventByteOrder = unsafe.getByte(data + 1L);
        if (origin != 0) {
            throw new IOException("Cannot get data: corrupted context");
        }
        long selatom = 0L;
        switch (reason) {
            case 2: 
            case 8: {
                selatom = this.sourceAtom;
                break;
            }
            case 5: {
                selatom = MotifDnDConstants.Swapper.getInt(data + 12L, eventByteOrder);
                break;
            }
            default: {
                throw new IOException("Cannot get data: invalid message reason");
            }
        }
        if (selatom == 0L) {
            throw new IOException("Cannot get data: drag source property atom unavailable");
        }
        long time_stamp = MotifDnDConstants.Swapper.getInt(data + 4L, eventByteOrder);
        XAtom selectionAtom = XAtom.get(selatom);
        XSelection selection = XSelection.getSelection(selectionAtom);
        if (selection == null) {
            selection = new XSelection(selectionAtom, null);
        }
        return selection.getData(format, time_stamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendDropDone(long ctxt, boolean success, int dropAction) {
        XClientMessageEvent xclient = new XClientMessageEvent(ctxt);
        if (xclient.get_message_type() != MotifDnDConstants.XA_MOTIF_DRAG_AND_DROP_MESSAGE.getAtom()) {
            return false;
        }
        long data = xclient.get_data();
        byte reason = (byte)(unsafe.getByte(data) & 0x7F);
        byte origin = (byte)(unsafe.getByte(data) & 0xFFFFFF80);
        byte eventByteOrder = unsafe.getByte(data + 1L);
        if (origin != 0) {
            return false;
        }
        if (reason != 5) {
            return false;
        }
        long time_stamp = MotifDnDConstants.Swapper.getInt(data + 4L, eventByteOrder);
        long sel_atom = MotifDnDConstants.Swapper.getInt(data + 12L, eventByteOrder);
        long status_atom = 0L;
        status_atom = success ? MotifDnDConstants.XA_XmTRANSFER_SUCCESS.getAtom() : MotifDnDConstants.XA_XmTRANSFER_FAILURE.getAtom();
        XToolkit.awtLock();
        try {
            XlibWrapper.XConvertSelection(XToolkit.getDisplay(), sel_atom, status_atom, MotifDnDConstants.XA_MOTIF_ATOM_0.getAtom(), XWindow.getXAWTRootWindow().getWindow(), time_stamp);
            XlibWrapper.XFlush(XToolkit.getDisplay());
        }
        finally {
            XToolkit.awtUnlock();
        }
        this.targetXWindow = null;
        this.cleanup();
        return true;
    }

    public final long getSourceWindow() {
        return this.sourceWindow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        XDropTargetEventProcessor.reset();
        if (this.targetXWindow != null) {
            this.notifyProtocolListener(this.targetXWindow, 0, 0, 0, this.sourceActions, null, 505);
        }
        if (this.sourceWindow != 0L) {
            XToolkit.awtLock();
            try {
                XToolkit.WITH_XERROR_HANDLER(XToolkit.IgnoreBadWindowHandler);
                XlibWrapper.XSelectInput(XToolkit.getDisplay(), this.sourceWindow, this.sourceWindowMask);
                XToolkit.RESTORE_XERROR_HANDLER();
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        this.sourceWindow = 0L;
        this.sourceWindowMask = 0L;
        this.sourceProtocolVersion = 0;
        this.sourceActions = 0;
        this.sourceFormats = null;
        this.sourceAtom = 0L;
        this.userAction = 0;
        this.sourceX = 0;
        this.sourceY = 0;
        this.targetXWindow = null;
        this.topLevelLeavePostponed = false;
    }

    public boolean isDragOverComponent() {
        return this.targetXWindow != null;
    }

    private void notifyProtocolListener(XWindow xwindow, int x, int y, int dropAction, int actions2, XClientMessageEvent xclient, int eventID) {
        long nativeCtxt = 0L;
        if (xclient != null) {
            new XClientMessageEvent(nativeCtxt);
            int size = XClientMessageEvent.getSize();
            nativeCtxt = unsafe.allocateMemory(size + 4 * Native.getLongSize());
            unsafe.copyMemory(xclient.pData, nativeCtxt, size);
        }
        this.getProtocolListener().handleDropTargetNotification(xwindow, x, y, dropAction, actions2, this.sourceFormats, nativeCtxt, eventID);
    }
}

