/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.peer.FileDialogPeer;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.UIDefaults;
import sun.awt.X11.FileDialogFilter;
import sun.awt.X11.ListHelper;
import sun.awt.X11.Separator;
import sun.awt.X11.XChoicePeer;
import sun.awt.X11.XChoicePeerListener;
import sun.awt.X11.XDialogPeer;
import sun.awt.X11.XToolkit;

class XFileDialogPeer
extends XDialogPeer
implements FileDialogPeer,
ActionListener,
ItemListener,
KeyEventDispatcher,
XChoicePeerListener {
    private static final Logger log = Logger.getLogger("sun.awt.X11.XFileDialogPeer");
    FileDialog target;
    String file;
    String dir;
    String title;
    int mode;
    FilenameFilter filter;
    private static final int PATH_CHOICE_WIDTH = 20;
    String savedFile;
    String savedDir;
    String userDir;
    Dialog fileDialog;
    GridBagLayout gbl;
    GridBagLayout gblButtons;
    GridBagConstraints gbc;
    TextField filterField;
    TextField selectionField;
    List directoryList;
    List fileList;
    Panel buttons;
    Button openButton;
    Button filterButton;
    Button cancelButton;
    Choice pathChoice;
    TextField pathField;
    Panel pathPanel;
    String cancelButtonText = null;
    String enterFileNameLabelText = null;
    String filesLabelText = null;
    String foldersLabelText = null;
    String pathLabelText = null;
    String filterLabelText = null;
    String openButtonText = null;
    String saveButtonText = null;
    String actionButtonText = null;

    void installStrings() {
        Locale l = this.target.getLocale();
        UIDefaults uid = XToolkit.getUIDefaults();
        this.cancelButtonText = uid.getString("FileChooser.cancelButtonText", l);
        this.enterFileNameLabelText = uid.getString("FileChooser.enterFileNameLabelText", l);
        this.filesLabelText = uid.getString("FileChooser.filesLabelText", l);
        this.foldersLabelText = uid.getString("FileChooser.foldersLabelText", l);
        this.pathLabelText = uid.getString("FileChooser.pathLabelText", l);
        this.filterLabelText = uid.getString("FileChooser.filterLabelText", l);
        this.openButtonText = uid.getString("FileChooser.openButtonText", l);
        this.saveButtonText = uid.getString("FileChooser.saveButtonText", l);
    }

    XFileDialogPeer(FileDialog target) {
        super(target);
        this.target = target;
    }

    private void init(FileDialog target) {
        this.fileDialog = target;
        this.title = target.getTitle();
        this.mode = target.getMode();
        this.target = target;
        this.filter = target.getFilenameFilter();
        this.savedFile = target.getFile();
        this.savedDir = target.getDirectory();
        this.userDir = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("user.dir");
            }
        });
        this.installStrings();
        this.gbl = new GridBagLayout();
        this.gblButtons = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.fileDialog.setLayout(this.gbl);
        this.buttons = new Panel();
        this.buttons.setLayout(this.gblButtons);
        this.actionButtonText = target.getMode() == 1 ? this.saveButtonText : this.openButtonText;
        this.openButton = new Button(this.actionButtonText);
        this.filterButton = new Button(this.filterLabelText);
        this.cancelButton = new Button(this.cancelButtonText);
        this.directoryList = new List();
        this.fileList = new List();
        this.filterField = new TextField();
        this.selectionField = new TextField();
        Insets noInset = new Insets(0, 0, 0, 0);
        Insets textFieldInset = new Insets(0, 8, 0, 8);
        Insets leftListInset = new Insets(0, 8, 0, 4);
        Insets rightListInset = new Insets(0, 4, 0, 8);
        Insets separatorInset = new Insets(8, 0, 0, 0);
        Insets labelInset = new Insets(0, 8, 0, 0);
        Insets buttonsInset = new Insets(10, 8, 10, 8);
        Font f = new Font("Dialog", 0, 12);
        Label label = new Label(this.pathLabelText);
        label.setFont(f);
        this.addComponent(label, this.gbl, this.gbc, 0, 0, 1, 17, this.fileDialog, 1, 0, 0, labelInset);
        this.pathField = new TextField(this.savedDir != null ? this.savedDir : this.userDir);
        this.pathChoice = new Choice(){

            public Dimension getPreferredSize() {
                return new Dimension(20, XFileDialogPeer.this.pathField.getPreferredSize().height);
            }
        };
        this.pathPanel = new Panel();
        this.pathPanel.setLayout(new BorderLayout());
        this.pathPanel.add((Component)this.pathField, "Center");
        this.pathPanel.add((Component)this.pathChoice, "East");
        this.addComponent(this.pathPanel, this.gbl, this.gbc, 0, 1, 2, 17, this.fileDialog, 1, 0, 2, textFieldInset);
        label = new Label(this.filterLabelText);
        label.setFont(f);
        this.addComponent(label, this.gbl, this.gbc, 0, 2, 1, 17, this.fileDialog, 1, 0, 0, labelInset);
        this.addComponent(this.filterField, this.gbl, this.gbc, 0, 3, 2, 17, this.fileDialog, 1, 0, 2, textFieldInset);
        label = new Label(this.foldersLabelText);
        label.setFont(f);
        this.addComponent(label, this.gbl, this.gbc, 0, 4, 1, 17, this.fileDialog, 1, 0, 0, labelInset);
        label = new Label(this.filesLabelText);
        label.setFont(f);
        this.addComponent(label, this.gbl, this.gbc, 1, 4, 1, 17, this.fileDialog, 1, 0, 0, labelInset);
        this.addComponent(this.directoryList, this.gbl, this.gbc, 0, 5, 1, 17, this.fileDialog, 1, 1, 1, leftListInset);
        this.addComponent(this.fileList, this.gbl, this.gbc, 1, 5, 1, 17, this.fileDialog, 1, 1, 1, rightListInset);
        label = new Label(this.enterFileNameLabelText);
        label.setFont(f);
        this.addComponent(label, this.gbl, this.gbc, 0, 6, 1, 17, this.fileDialog, 1, 0, 0, labelInset);
        this.addComponent(this.selectionField, this.gbl, this.gbc, 0, 7, 2, 17, this.fileDialog, 1, 0, 2, textFieldInset);
        this.addComponent(new Separator(this.fileDialog.size().width, 2, 0), this.gbl, this.gbc, 0, 8, 15, 17, this.fileDialog, 1, 0, 2, separatorInset);
        this.addComponent(this.openButton, this.gblButtons, this.gbc, 0, 0, 1, 17, this.buttons, 1, 0, 0, noInset);
        this.addComponent(this.filterButton, this.gblButtons, this.gbc, 1, 0, 1, 10, this.buttons, 1, 0, 0, noInset);
        this.addComponent(this.cancelButton, this.gblButtons, this.gbc, 2, 0, 1, 13, this.buttons, 1, 0, 0, noInset);
        this.addComponent(this.buttons, this.gbl, this.gbc, 0, 9, 2, 17, this.fileDialog, 1, 0, 2, buttonsInset);
        this.fileDialog.setSize(400, 400);
        XChoicePeer choicePeer = (XChoicePeer)this.pathChoice.getPeer();
        choicePeer.setDrawSelectedItem(false);
        choicePeer.setAlignUnder(this.pathField);
        this.filterField.addActionListener(this);
        this.selectionField.addActionListener(this);
        this.directoryList.addActionListener(this);
        this.directoryList.addItemListener(this);
        this.fileList.addItemListener(this);
        this.fileList.addActionListener(this);
        this.openButton.addActionListener(this);
        this.filterButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.pathChoice.addItemListener(this);
        this.pathField.addActionListener(this);
        target.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                XFileDialogPeer.this.handleCancel();
            }
        });
        this.pathChoice.addItemListener(this);
    }

    public void updateMinimumSize() {
    }

    public void updateIconImages() {
        if (this.winAttr.icons == null) {
            this.winAttr.iconsInherited = false;
            this.winAttr.icons = XFileDialogPeer.getDefaultIconInfo();
            this.setIconHints(this.winAttr.icons);
        }
    }

    void addComponent(Component comp, GridBagLayout gb, GridBagConstraints c, int gridx, int gridy, int gridwidth, int anchor, Container cont, int weightx, int weighty, int fill, Insets in) {
        c.gridx = gridx;
        c.gridy = gridy;
        c.gridwidth = gridwidth;
        c.anchor = anchor;
        c.weightx = weightx;
        c.weighty = weighty;
        c.fill = fill;
        c.insets = in;
        gb.setConstraints(comp, c);
        cont.add(comp);
    }

    String getFileName(String str) {
        if (str == null) {
            return "";
        }
        int index = str.lastIndexOf(47);
        if (index == -1) {
            return str;
        }
        return str.substring(index + 1);
    }

    void handleFilter(String f) {
        if (f == null) {
            return;
        }
        this.setFilterEntry(this.dir, f);
        this.directoryList.select(0);
        if (this.fileList.getItemCount() != 0) {
            this.fileList.requestFocus();
        } else {
            this.directoryList.requestFocus();
        }
    }

    void handleSelection(String file) {
        int index = file.lastIndexOf(47);
        if (index == -1) {
            this.savedDir = this.dir;
            this.savedFile = file;
        } else {
            this.savedDir = file.substring(0, index + 1);
            this.savedFile = file.substring(index + 1);
        }
        this.target.setDirectory(this.savedDir);
        this.target.setFile(this.savedFile);
    }

    void handleCancel() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
        this.setSelectionField(null);
        this.setFilterField(null);
        this.directoryList.clear();
        this.fileList.clear();
        this.target.setFile(null);
        this.target.setDirectory(null);
        this.handleQuitButton();
    }

    void handleQuitButton() {
        this.dir = null;
        this.file = null;
        this.target.hide();
    }

    void setFilterEntry(String d, String f) {
        File fe = new File(d);
        if (fe.isDirectory() && fe.canRead()) {
            Object[] l;
            this.setSelectionField(this.target.getFile());
            if (f.equals("")) {
                f = "*";
                this.setFilterField(f);
            } else {
                this.setFilterField(f);
            }
            if (f.equals("*")) {
                l = fe.list();
            } else {
                FileDialogFilter ff = new FileDialogFilter(f);
                l = fe.list(ff);
            }
            if (l == null) {
                this.dir = this.getParentDirectory();
                return;
            }
            this.directoryList.clear();
            this.fileList.clear();
            this.directoryList.setVisible(false);
            this.fileList.setVisible(false);
            this.directoryList.addItem("..");
            Arrays.sort(l);
            for (int i = 0; i < l.length; ++i) {
                File file = new File(d + (String)l[i]);
                if (file.isDirectory()) {
                    this.directoryList.addItem((String)l[i] + "/");
                    continue;
                }
                if (this.filter != null) {
                    if (!this.filter.accept(new File((String)l[i]), (String)l[i])) continue;
                    this.fileList.addItem((String)l[i]);
                    continue;
                }
                this.fileList.addItem((String)l[i]);
            }
            this.dir = d;
            this.pathField.setText(this.dir);
            this.target.setDirectory(this.dir);
            this.directoryList.setVisible(true);
            this.fileList.setVisible(true);
        }
    }

    String[] getDirList(String dir) {
        if (!dir.endsWith("/")) {
            dir = dir + "/";
        }
        char[] charr = dir.toCharArray();
        int numSlashes = 0;
        for (int i = 0; i < charr.length; ++i) {
            if (charr[i] != '/') continue;
            ++numSlashes;
        }
        String[] starr = new String[numSlashes];
        int j = 0;
        for (int i = charr.length - 1; i >= 0; --i) {
            if (charr[i] != '/') continue;
            starr[j++] = new String(charr, 0, i + 1);
        }
        return starr;
    }

    void setSelectionField(String str) {
        this.selectionField.setText(str);
    }

    void setFilterField(String str) {
        this.filterField.setText(str);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getID() != 701 || itemEvent.getStateChange() == 2) {
            return;
        }
        Object source = itemEvent.getSource();
        if (source == this.pathChoice) {
            String dir = this.pathChoice.getSelectedItem();
            this.pathField.setText(dir);
        } else if (this.directoryList == source) {
            this.setFilterField(this.getFileName(this.filterField.getText()));
        } else if (this.fileList == source) {
            String file = this.fileList.getItem((Integer)itemEvent.getItem());
            this.setSelectionField(file);
        }
    }

    boolean updateDirectoryByUserAction(String str) {
        String dir = str.equals("..") ? this.getParentDirectory() : this.dir + str;
        File fe = new File(dir);
        if (fe.canRead()) {
            this.dir = dir;
            return true;
        }
        return false;
    }

    String getParentDirectory() {
        String parent = this.dir;
        if (!this.dir.equals("/")) {
            if (this.dir.endsWith("/")) {
                parent = parent.substring(0, parent.lastIndexOf("/"));
            }
            parent = parent.substring(0, parent.lastIndexOf("/") + 1);
        }
        return parent;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String actionCommand = actionEvent.getActionCommand();
        Object source = actionEvent.getSource();
        if (actionCommand.equals(this.actionButtonText)) {
            this.handleSelection(this.selectionField.getText());
            this.handleQuitButton();
        } else if (actionCommand.equals(this.filterLabelText)) {
            this.handleFilter(this.filterField.getText());
        } else if (actionCommand.equals(this.cancelButtonText)) {
            this.handleCancel();
        } else if (source instanceof TextField) {
            if (this.selectionField == (TextField)source) {
                this.handleSelection(this.selectionField.getText());
                this.handleQuitButton();
            } else if (this.filterField == (TextField)source) {
                this.handleFilter(this.filterField.getText());
            } else if (this.pathField == (TextField)source) {
                this.target.setDirectory(this.pathField.getText());
            }
        } else if (source instanceof List) {
            if (this.directoryList == (List)source) {
                if (this.updateDirectoryByUserAction(actionCommand)) {
                    this.handleFilter(this.getFileName(this.filterField.getText()));
                }
            } else if (this.fileList == (List)source) {
                this.handleSelection(actionCommand);
                this.handleQuitButton();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        int id = keyEvent.getID();
        int keyCode = keyEvent.getKeyCode();
        if (id == 401 && keyCode == 27) {
            Object object = this.target.getTreeLock();
            synchronized (object) {
                for (Component comp = (Component)keyEvent.getSource(); comp != null; comp = comp.getParent()) {
                    XChoicePeer choicePeer;
                    if (comp == this.pathChoice && (choicePeer = (XChoicePeer)this.pathChoice.getPeer()).isUnfurled()) {
                        return false;
                    }
                    if (comp.getPeer() != this) continue;
                    this.handleCancel();
                    return true;
                }
            }
        }
        return false;
    }

    public void setFile(String file) {
        if (file == null) {
            this.file = null;
            return;
        }
        if (this.dir == null) {
            String d = "./";
            File f = new File(d, file);
            if (f.isFile()) {
                this.file = file;
                this.setDirectory(d);
            }
        } else {
            File f = new File(this.dir, file);
            if (f.isFile()) {
                this.file = file;
            }
        }
        this.setSelectionField(file);
    }

    public void setDirectory(String dir) {
        if (dir == null) {
            this.dir = null;
            return;
        }
        if (dir.equals(this.dir)) {
            return;
        }
        int i = dir.indexOf("~");
        if (i != -1) {
            dir = dir.substring(0, i) + System.getProperty("user.home") + dir.substring(i + 1, dir.length());
        }
        File fe = new File(dir).getAbsoluteFile();
        log.fine("Current directory : " + fe);
        if (!fe.isDirectory() && !(fe = new File(dir = "./").getAbsoluteFile()).isDirectory()) {
            return;
        }
        try {
            dir = this.dir = fe.getCanonicalPath();
        }
        catch (IOException ie) {
            dir = this.dir = fe.getAbsolutePath();
        }
        this.pathField.setText(this.dir);
        if (dir.endsWith("/")) {
            this.dir = dir;
            this.handleFilter("");
        } else {
            this.dir = dir + "/";
            this.handleFilter("");
        }
    }

    public void setFilenameFilter(FilenameFilter filter) {
        this.filter = filter;
    }

    public void show() {
        if (this.fileDialog == null) {
            this.init(this.target);
        }
        if (this.savedDir != null || this.userDir != null) {
            this.setDirectory(this.savedDir != null ? this.savedDir : this.userDir);
        }
        if (this.savedFile != null) {
            this.setFile(this.savedFile);
        }
        super.show();
    }

    public void dispose() {
        FileDialog fd = (FileDialog)this.fileDialog;
        if (fd != null) {
            fd.removeAll();
        }
        super.dispose();
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            XChoicePeer choicePeer = (XChoicePeer)this.pathChoice.getPeer();
            choicePeer.addXChoicePeerListener(this);
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        } else {
            XChoicePeer choicePeer = (XChoicePeer)this.pathChoice.getPeer();
            choicePeer.removeXChoicePeerListener();
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
        }
    }

    public void addItemsToPathChoice(String text) {
        String[] dirList = this.getDirList(text);
        for (int i = 0; i < dirList.length; ++i) {
            this.pathChoice.addItem(dirList[i]);
        }
    }

    public void unfurledChoiceOpening(ListHelper choiceHelper) {
        if (choiceHelper.getItemCount() == 0) {
            this.addItemsToPathChoice(this.pathField.getText());
            return;
        }
        if (this.pathChoice.getItem(0).equals(this.pathField.getText())) {
            return;
        }
        this.pathChoice.removeAll();
        this.addItemsToPathChoice(this.pathField.getText());
    }

    public void unfurledChoiceClosing() {
        String dir = this.pathChoice.getSelectedItem();
        this.target.setDirectory(dir);
    }
}

