/*
 * Decompiled with CFR 0.152.
 */
package sun.beans.editors;

import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;

public class FontEditor
extends Panel
implements PropertyEditor {
    private Font font;
    private Toolkit toolkit;
    private String sampleText = "Abcde...";
    private Label sample;
    private Choice familyChoser;
    private Choice styleChoser;
    private Choice sizeChoser;
    private String[] fonts;
    private String[] styleNames = new String[]{"plain", "bold", "italic"};
    private int[] styles = new int[]{0, 1, 2};
    private int[] pointSizes = new int[]{3, 5, 8, 10, 12, 14, 18, 24, 36, 48};
    private PropertyChangeSupport support = new PropertyChangeSupport(this);

    public FontEditor() {
        int i;
        this.setLayout(null);
        this.toolkit = Toolkit.getDefaultToolkit();
        this.fonts = this.toolkit.getFontList();
        this.familyChoser = new Choice();
        for (i = 0; i < this.fonts.length; ++i) {
            this.familyChoser.addItem(this.fonts[i]);
        }
        this.add(this.familyChoser);
        this.familyChoser.reshape(20, 5, 100, 30);
        this.styleChoser = new Choice();
        for (i = 0; i < this.styleNames.length; ++i) {
            this.styleChoser.addItem(this.styleNames[i]);
        }
        this.add(this.styleChoser);
        this.styleChoser.reshape(145, 5, 70, 30);
        this.sizeChoser = new Choice();
        for (i = 0; i < this.pointSizes.length; ++i) {
            this.sizeChoser.addItem("" + this.pointSizes[i]);
        }
        this.add(this.sizeChoser);
        this.sizeChoser.reshape(220, 5, 70, 30);
        this.resize(300, 40);
    }

    public Dimension preferredSize() {
        return new Dimension(300, 40);
    }

    public void setValue(Object o) {
        int i;
        this.font = (Font)o;
        if (this.font == null) {
            return;
        }
        this.changeFont(this.font);
        for (i = 0; i < this.fonts.length; ++i) {
            if (!this.fonts[i].equals(this.font.getFamily())) continue;
            this.familyChoser.select(i);
            break;
        }
        for (i = 0; i < this.styleNames.length; ++i) {
            if (this.font.getStyle() != this.styles[i]) continue;
            this.styleChoser.select(i);
            break;
        }
        for (i = 0; i < this.pointSizes.length; ++i) {
            if (this.font.getSize() > this.pointSizes[i]) continue;
            this.sizeChoser.select(i);
            break;
        }
    }

    private void changeFont(Font f) {
        this.font = f;
        if (this.sample != null) {
            this.remove(this.sample);
        }
        this.sample = new Label(this.sampleText);
        this.sample.setFont(this.font);
        this.add(this.sample);
        Container p = this.getParent();
        if (p != null) {
            ((Component)p).invalidate();
            ((Component)p).layout();
        }
        this.invalidate();
        this.layout();
        this.repaint();
        this.support.firePropertyChange("", null, null);
    }

    public Object getValue() {
        return this.font;
    }

    public String getJavaInitializationString() {
        if (this.font == null) {
            return "null";
        }
        return "new java.awt.Font(\"" + this.font.getName() + "\", " + this.font.getStyle() + ", " + this.font.getSize() + ")";
    }

    public boolean action(Event e, Object arg) {
        String family = this.familyChoser.getSelectedItem();
        int style = this.styles[this.styleChoser.getSelectedIndex()];
        int size = this.pointSizes[this.sizeChoser.getSelectedIndex()];
        try {
            Font f = new Font(family, style, size);
            this.changeFont(f);
        }
        catch (Exception ex) {
            System.err.println("Couldn't create font " + family + "-" + this.styleNames[style] + "-" + size);
        }
        return false;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        Font oldFont = gfx.getFont();
        gfx.setFont(this.font);
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getAscent()) / 2;
        gfx.drawString(this.sampleText, 0, box.height - vpad);
        gfx.setFont(oldFont);
    }

    public String getAsText() {
        boolean i;
        if (this.font == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.font.getName());
        sb.append(' ');
        boolean b = this.font.isBold();
        if (b) {
            sb.append("BOLD");
        }
        if (i = this.font.isItalic()) {
            sb.append("ITALIC");
        }
        if (b || i) {
            sb.append(' ');
        }
        sb.append(this.font.getSize());
        return sb.toString();
    }

    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(text == null ? null : Font.decode(text));
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        return this;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.support.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.support.removePropertyChangeListener(l);
    }
}

