/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.plaf.FontUIResource;
import sun.applet.AppletSecurity;
import sun.awt.AppContext;
import sun.awt.FontConfiguration;
import sun.awt.SunHints;
import sun.awt.SunToolkit;
import sun.font.CompositeFont;
import sun.font.CreatedFontTracker;
import sun.font.FileFont;
import sun.font.Font2D;
import sun.font.Font2DHandle;
import sun.font.FontFamily;
import sun.font.FontManagerNativeLibrary;
import sun.font.FontScaler;
import sun.font.NativeFont;
import sun.font.NullFontScaler;
import sun.font.PhysicalFont;
import sun.font.StrikeCache;
import sun.font.TrueTypeFont;
import sun.font.Type1Font;
import sun.java2d.Disposer;
import sun.java2d.HeadlessGraphicsEnvironment;
import sun.java2d.SunGraphicsEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FontManager {
    public static final int FONTFORMAT_NONE = -1;
    public static final int FONTFORMAT_TRUETYPE = 0;
    public static final int FONTFORMAT_TYPE1 = 1;
    public static final int FONTFORMAT_T2K = 2;
    public static final int FONTFORMAT_TTC = 3;
    public static final int FONTFORMAT_COMPOSITE = 4;
    public static final int FONTFORMAT_NATIVE = 5;
    public static final int NO_FALLBACK = 0;
    public static final int PHYSICAL_FALLBACK = 1;
    public static final int LOGICAL_FALLBACK = 2;
    public static final int QUADPATHTYPE = 1;
    public static final int CUBICPATHTYPE = 2;
    private static final int CHANNELPOOLSIZE = 20;
    private static int lastPoolIndex = 0;
    private static int poolSize = 0;
    private static FileFont[] fontFileCache = new FileFont[20];
    private static int maxCompFont = 0;
    private static CompositeFont[] compFonts = new CompositeFont[20];
    private static ConcurrentHashMap<String, CompositeFont> compositeFonts = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, PhysicalFont> physicalFonts = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, PhysicalFont> registeredFontFiles = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Font2D> fullNameToFont = new ConcurrentHashMap();
    private static HashMap<String, TrueTypeFont> localeFullNamesToFont;
    private static PhysicalFont defaultPhysicalFont;
    private static boolean usePlatformFontMetrics;
    public static Logger logger;
    public static boolean logging;
    static boolean longAddresses;
    static String osName;
    static boolean useT2K;
    static boolean isWindows;
    static boolean isSolaris;
    public static boolean isSolaris8;
    public static boolean isSolaris9;
    private static boolean loaded1dot0Fonts;
    static SunGraphicsEnvironment sgEnv;
    static boolean loadedAllFonts;
    static boolean loadedAllFontFiles;
    static TrueTypeFont eudcFont;
    static HashMap<String, String> jreFontMap;
    static HashSet<String> jreLucidaFontFiles;
    static String[] jreOtherFontFiles;
    static boolean noOtherJREFontFiles;
    private static String[] STR_ARRAY;
    private static final ConcurrentHashMap<String, FontRegistrationInfo> deferredFontFiles;
    private static final ConcurrentHashMap<String, Font2DHandle> initialisedFonts;
    private static HashMap<String, String> fontToFileMap;
    private static HashMap<String, String> fontToFamilyNameMap;
    private static HashMap<String, ArrayList<String>> familyToFontListMap;
    private static String[] pathDirs;
    private static boolean haveCheckedUnreferencedFontFiles;
    private static ConcurrentHashMap<String, Font2D> fontNameCache;
    private static final short US_LCID = 1033;
    private static Map<String, Short> lcidMap;
    private static Thread fileCloser;
    static Vector<File> tmpFontFiles;
    private static final Object altJAFontKey;
    private static final Object localeFontKey;
    private static final Object proportionalFontKey;
    public static boolean usingPerAppContextComposites;
    private static boolean usingAlternateComposites;
    private static boolean gAltJAFont;
    private static boolean gLocalePref;
    private static boolean gPropPref;
    private static HashSet<String> installedNames;
    private static final Object regFamilyKey;
    private static final Object regFullNameKey;
    private static Hashtable<String, FontFamily> createdByFamilyName;
    private static Hashtable<String, Font2D> createdByFullName;
    private static boolean fontsAreRegistered;
    private static boolean fontsAreRegisteredPerAppContext;
    private static final String[][] nameMap;
    private static String[] fontConfigNames;
    private static FontConfigInfo[] fontConfigFonts;
    private static String[] defaultPlatformFont;
    public static final int MIN_LAYOUT_CHARCODE = 768;
    public static final int MAX_LAYOUT_CHARCODE = 8303;
    private static FontScaler nullScaler;
    private static Constructor<FontScaler> scalerConstructor;

    private static void initJREFontMap() {
        jreFontMap = new HashMap();
        jreLucidaFontFiles = new HashSet();
        if (SunGraphicsEnvironment.isOpenJDK()) {
            return;
        }
        jreFontMap.put("lucida sans0", "LucidaSansRegular.ttf");
        jreFontMap.put("lucida sans1", "LucidaSansDemiBold.ttf");
        jreFontMap.put("lucida sans regular0", "LucidaSansRegular.ttf");
        jreFontMap.put("lucida sans regular1", "LucidaSansDemiBold.ttf");
        jreFontMap.put("lucida sans bold1", "LucidaSansDemiBold.ttf");
        jreFontMap.put("lucida sans demibold1", "LucidaSansDemiBold.ttf");
        jreFontMap.put("lucida sans typewriter0", "LucidaTypewriterRegular.ttf");
        jreFontMap.put("lucida sans typewriter1", "LucidaTypewriterBold.ttf");
        jreFontMap.put("lucida sans typewriter regular0", "LucidaTypewriter.ttf");
        jreFontMap.put("lucida sans typewriter regular1", "LucidaTypewriterBold.ttf");
        jreFontMap.put("lucida sans typewriter bold1", "LucidaTypewriterBold.ttf");
        jreFontMap.put("lucida sans typewriter demibold1", "LucidaTypewriterBold.ttf");
        jreFontMap.put("lucida bright0", "LucidaBrightRegular.ttf");
        jreFontMap.put("lucida bright1", "LucidaBrightDemiBold.ttf");
        jreFontMap.put("lucida bright2", "LucidaBrightItalic.ttf");
        jreFontMap.put("lucida bright3", "LucidaBrightDemiItalic.ttf");
        jreFontMap.put("lucida bright regular0", "LucidaBrightRegular.ttf");
        jreFontMap.put("lucida bright regular1", "LucidaBrightDemiBold.ttf");
        jreFontMap.put("lucida bright regular2", "LucidaBrightItalic.ttf");
        jreFontMap.put("lucida bright regular3", "LucidaBrightDemiItalic.ttf");
        jreFontMap.put("lucida bright bold1", "LucidaBrightDemiBold.ttf");
        jreFontMap.put("lucida bright bold3", "LucidaBrightDemiItalic.ttf");
        jreFontMap.put("lucida bright demibold1", "LucidaBrightDemiBold.ttf");
        jreFontMap.put("lucida bright demibold3", "LucidaBrightDemiItalic.ttf");
        jreFontMap.put("lucida bright italic2", "LucidaBrightItalic.ttf");
        jreFontMap.put("lucida bright italic3", "LucidaBrightDemiItalic.ttf");
        jreFontMap.put("lucida bright bold italic3", "LucidaBrightDemiItalic.ttf");
        jreFontMap.put("lucida bright demibold italic3", "LucidaBrightDemiItalic.ttf");
        for (String ffile : jreFontMap.values()) {
            jreLucidaFontFiles.add(ffile);
        }
    }

    private static native void initIDs();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToPool(FileFont font) {
        boolean added = false;
        FileFont[] fileFontArray = fontFileCache;
        synchronized (fontFileCache) {
            if (poolSize < 20) {
                for (int i = 0; i < 20; ++i) {
                    if (fontFileCache[i] != null) continue;
                    FontManager.fontFileCache[i] = font;
                    ++poolSize;
                    added = true;
                    break;
                }
                assert (added);
            } else {
                assert (fontFileCache[lastPoolIndex] != font);
                fontFileCache[lastPoolIndex].close();
                FontManager.fontFileCache[FontManager.lastPoolIndex] = font;
                lastPoolIndex = (lastPoolIndex + 1) % 20;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFromPool(FileFont font) {
        FileFont[] fileFontArray = fontFileCache;
        synchronized (fontFileCache) {
            for (int i = 0; i < 20; ++i) {
                if (fontFileCache[i] != font) continue;
                FontManager.fontFileCache[i] = null;
                --poolSize;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static boolean fontSupportsDefaultEncoding(Font font) {
        return FontManager.getFont2D(font) instanceof CompositeFont;
    }

    public static FontUIResource getCompositeFontUIResource(Font font) {
        FontUIResource fuir = new FontUIResource(font.getName(), font.getStyle(), font.getSize());
        Font2D font2D = FontManager.getFont2D(font);
        if (!(font2D instanceof PhysicalFont)) {
            return fuir;
        }
        CompositeFont dialog2D = (CompositeFont)FontManager.findFont2D("dialog", font.getStyle(), 0);
        if (dialog2D == null) {
            return fuir;
        }
        PhysicalFont physicalFont = (PhysicalFont)font2D;
        CompositeFont compFont = new CompositeFont(physicalFont, dialog2D);
        FontManager.setFont2D(fuir, compFont.handle);
        FontManager.setCreatedFont(fuir);
        return fuir;
    }

    public static Font2DHandle getNewComposite(String family, int style, Font2DHandle handle) {
        Font2D newFont;
        if (!(handle.font2D instanceof CompositeFont)) {
            return handle;
        }
        CompositeFont oldComp = (CompositeFont)handle.font2D;
        PhysicalFont oldFont = oldComp.getSlotFont(0);
        if (family == null) {
            family = oldFont.getFamilyName(null);
        }
        if (style == -1) {
            style = oldComp.getStyle();
        }
        if (!((newFont = FontManager.findFont2D(family, style, 0)) instanceof PhysicalFont)) {
            newFont = oldFont;
        }
        PhysicalFont physicalFont = (PhysicalFont)newFont;
        CompositeFont dialog2D = (CompositeFont)FontManager.findFont2D("dialog", style, 0);
        if (dialog2D == null) {
            return handle;
        }
        CompositeFont compFont = new CompositeFont(physicalFont, dialog2D);
        Font2DHandle newHandle = new Font2DHandle(compFont);
        return newHandle;
    }

    public static native void setFont2D(Font var0, Font2DHandle var1);

    private static native boolean isCreatedFont(Font var0);

    private static native void setCreatedFont(Font var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerCompositeFont(String compositeName, String[] componentFileNames, String[] componentNames, int numMetricsSlots, int[] exclusionRanges, int[] exclusionMaxIndex, boolean defer) {
        CompositeFont cf = new CompositeFont(compositeName, componentFileNames, componentNames, numMetricsSlots, exclusionRanges, exclusionMaxIndex, defer);
        FontManager.addCompositeToFontList(cf, 2);
        CompositeFont[] compositeFontArray = compFonts;
        synchronized (compFonts) {
            FontManager.compFonts[FontManager.maxCompFont++] = cf;
            // ** MonitorExit[var8_8] (shouldn't be in output)
            return;
        }
    }

    public static void registerCompositeFont(String compositeName, String[] componentFileNames, String[] componentNames, int numMetricsSlots, int[] exclusionRanges, int[] exclusionMaxIndex, boolean defer, ConcurrentHashMap<String, Font2D> altNameCache) {
        CompositeFont cf = new CompositeFont(compositeName, componentFileNames, componentNames, numMetricsSlots, exclusionRanges, exclusionMaxIndex, defer);
        Font2D oldFont = altNameCache.get(compositeName.toLowerCase(Locale.ENGLISH));
        if (oldFont instanceof CompositeFont) {
            oldFont.handle.font2D = cf;
        }
        altNameCache.put(compositeName.toLowerCase(Locale.ENGLISH), cf);
    }

    private static void addCompositeToFontList(CompositeFont f, int rank) {
        if (logging) {
            logger.info("Add to Family " + f.familyName + ", Font " + f.fullName + " rank=" + rank);
        }
        f.setRank(rank);
        compositeFonts.put(f.fullName, f);
        fullNameToFont.put(f.fullName.toLowerCase(Locale.ENGLISH), f);
        FontFamily family = FontFamily.getFamily(f.familyName);
        if (family == null) {
            family = new FontFamily(f.familyName, true, rank);
        }
        family.setFont(f, f.style);
    }

    private static PhysicalFont addToFontList(PhysicalFont f, int rank) {
        String fontName = f.fullName;
        String familyName = f.familyName;
        if (fontName == null || "".equals(fontName)) {
            return null;
        }
        if (compositeFonts.containsKey(fontName)) {
            return null;
        }
        f.setRank(rank);
        if (!physicalFonts.containsKey(fontName)) {
            if (logging) {
                logger.info("Add to Family " + familyName + ", Font " + fontName + " rank=" + rank);
            }
            physicalFonts.put(fontName, f);
            FontFamily family = FontFamily.getFamily(familyName);
            if (family == null) {
                family = new FontFamily(familyName, false, rank);
                family.setFont(f, f.style);
            } else if (family.getRank() >= rank) {
                family.setFont(f, f.style);
            }
            fullNameToFont.put(fontName.toLowerCase(Locale.ENGLISH), f);
            return f;
        }
        PhysicalFont newFont = f;
        PhysicalFont oldFont = physicalFonts.get(fontName);
        if (oldFont == null) {
            return null;
        }
        if (oldFont.getRank() >= rank) {
            if (oldFont.mapper != null && rank > 2) {
                return oldFont;
            }
            if (oldFont.getRank() == rank) {
                if (oldFont instanceof TrueTypeFont && newFont instanceof TrueTypeFont) {
                    TrueTypeFont oldTTFont = (TrueTypeFont)oldFont;
                    TrueTypeFont newTTFont = (TrueTypeFont)newFont;
                    if (oldTTFont.fileSize >= newTTFont.fileSize) {
                        return oldFont;
                    }
                } else {
                    return oldFont;
                }
            }
            if (oldFont.platName.startsWith(SunGraphicsEnvironment.jreFontDirName)) {
                if (logging) {
                    logger.warning("Unexpected attempt to replace a JRE  font " + fontName + " from " + oldFont.platName + " with " + newFont.platName);
                }
                return oldFont;
            }
            if (logging) {
                logger.info("Replace in Family " + familyName + ",Font " + fontName + " new rank=" + rank + " from " + oldFont.platName + " with " + newFont.platName);
            }
            FontManager.replaceFont(oldFont, newFont);
            physicalFonts.put(fontName, newFont);
            fullNameToFont.put(fontName.toLowerCase(Locale.ENGLISH), newFont);
            FontFamily family = FontFamily.getFamily(familyName);
            if (family == null) {
                family = new FontFamily(familyName, false, rank);
                family.setFont(newFont, newFont.style);
            } else if (family.getRank() >= rank) {
                family.setFont(newFont, newFont.style);
            }
            return newFont;
        }
        return oldFont;
    }

    public static Font2D[] getRegisteredFonts() {
        PhysicalFont[] physFonts = FontManager.getPhysicalFonts();
        int mcf = maxCompFont;
        Font2D[] regFonts = new Font2D[physFonts.length + mcf];
        System.arraycopy(compFonts, 0, regFonts, 0, mcf);
        System.arraycopy(physFonts, 0, regFonts, mcf, physFonts.length);
        return regFonts;
    }

    public static PhysicalFont[] getPhysicalFonts() {
        return physicalFonts.values().toArray(new PhysicalFont[0]);
    }

    public static synchronized void initialiseDeferredFonts() {
        for (String fileName : deferredFontFiles.keySet()) {
            FontManager.initialiseDeferredFont(fileName);
        }
    }

    public static synchronized void registerDeferredJREFonts(String jreDir) {
        for (FontRegistrationInfo info : deferredFontFiles.values()) {
            if (info.fontFilePath == null || !info.fontFilePath.startsWith(jreDir)) continue;
            FontManager.initialiseDeferredFont(info.fontFilePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PhysicalFont findJREDeferredFont(String name, int style) {
        PhysicalFont physicalFont;
        String nameAndStyle = name.toLowerCase(Locale.ENGLISH) + style;
        String fileName = jreFontMap.get(nameAndStyle);
        if (fileName != null) {
            FontManager.initSGEnv();
            fileName = SunGraphicsEnvironment.jreFontDirName + File.separator + fileName;
            if (deferredFontFiles.get(fileName) != null && (physicalFont = FontManager.initialiseDeferredFont(fileName)) != null && (physicalFont.getFontName(null).equalsIgnoreCase(name) || physicalFont.getFamilyName(null).equalsIgnoreCase(name)) && physicalFont.style == style) {
                return physicalFont;
            }
        }
        if (noOtherJREFontFiles) {
            return null;
        }
        HashSet<String> hashSet = jreLucidaFontFiles;
        synchronized (hashSet) {
            if (jreOtherFontFiles == null) {
                HashSet<String> otherFontFiles = new HashSet<String>();
                for (String deferredFile : deferredFontFiles.keySet()) {
                    File file = new File(deferredFile);
                    String dir = file.getParent();
                    String fname = file.getName();
                    if (dir == null || !dir.equals(SunGraphicsEnvironment.jreFontDirName) || jreLucidaFontFiles.contains(fname)) continue;
                    otherFontFiles.add(deferredFile);
                }
                jreOtherFontFiles = otherFontFiles.toArray(STR_ARRAY);
                if (jreOtherFontFiles.length == 0) {
                    noOtherJREFontFiles = true;
                }
            }
            for (int i = 0; i < jreOtherFontFiles.length; ++i) {
                fileName = jreOtherFontFiles[i];
                if (fileName == null) continue;
                FontManager.jreOtherFontFiles[i] = null;
                physicalFont = FontManager.initialiseDeferredFont(fileName);
                if (physicalFont == null || !physicalFont.getFontName(null).equalsIgnoreCase(name) && !physicalFont.getFamilyName(null).equalsIgnoreCase(name) || physicalFont.style != style) continue;
                return physicalFont;
            }
        }
        return null;
    }

    private static PhysicalFont findOtherDeferredFont(String name, int style) {
        for (String fileName : deferredFontFiles.keySet()) {
            PhysicalFont physicalFont;
            File file = new File(fileName);
            String dir = file.getParent();
            String fname = file.getName();
            if (dir != null && dir.equals(SunGraphicsEnvironment.jreFontDirName) && jreLucidaFontFiles.contains(fname) || (physicalFont = FontManager.initialiseDeferredFont(fileName)) == null || !physicalFont.getFontName(null).equalsIgnoreCase(name) && !physicalFont.getFamilyName(null).equalsIgnoreCase(name) || physicalFont.style != style) continue;
            return physicalFont;
        }
        return null;
    }

    private static PhysicalFont findDeferredFont(String name, int style) {
        PhysicalFont physicalFont = FontManager.findJREDeferredFont(name, style);
        if (physicalFont != null) {
            return physicalFont;
        }
        return FontManager.findOtherDeferredFont(name, style);
    }

    public static void registerDeferredFont(String fileNameKey, String fullPathName, String[] nativeNames, int fontFormat, boolean useJavaRasterizer, int fontRank) {
        FontRegistrationInfo regInfo = new FontRegistrationInfo(fullPathName, nativeNames, fontFormat, useJavaRasterizer, fontRank);
        deferredFontFiles.put(fileNameKey, regInfo);
    }

    public static synchronized PhysicalFont initialiseDeferredFont(String fileNameKey) {
        PhysicalFont physicalFont;
        FontRegistrationInfo regInfo;
        if (fileNameKey == null) {
            return null;
        }
        if (logging) {
            logger.info("Opening deferred font file " + fileNameKey);
        }
        if ((regInfo = deferredFontFiles.get(fileNameKey)) != null) {
            deferredFontFiles.remove(fileNameKey);
            physicalFont = FontManager.registerFontFile(regInfo.fontFilePath, regInfo.nativeNames, regInfo.fontFormat, regInfo.javaRasterizer, regInfo.fontRank);
            if (physicalFont != null) {
                initialisedFonts.put(fileNameKey, physicalFont.handle);
            } else {
                initialisedFonts.put(fileNameKey, FontManager.getDefaultPhysicalFont().handle);
            }
        } else {
            Font2DHandle handle = initialisedFonts.get(fileNameKey);
            physicalFont = handle == null ? FontManager.getDefaultPhysicalFont() : (PhysicalFont)handle.font2D;
        }
        return physicalFont;
    }

    public static PhysicalFont registerFontFile(String fileName, String[] nativeNames, int fontFormat, boolean useJavaRasterizer, int fontRank) {
        PhysicalFont physicalFont;
        block11: {
            PhysicalFont regFont = registeredFontFiles.get(fileName);
            if (regFont != null) {
                return regFont;
            }
            physicalFont = null;
            try {
                switch (fontFormat) {
                    case 0: {
                        TrueTypeFont ttf;
                        int fn = 0;
                        do {
                            ttf = new TrueTypeFont(fileName, nativeNames, fn++, useJavaRasterizer);
                            PhysicalFont pf = FontManager.addToFontList(ttf, fontRank);
                            if (physicalFont != null) continue;
                            physicalFont = pf;
                        } while (fn < ttf.getFontCount());
                        break;
                    }
                    case 1: {
                        Type1Font t1f = new Type1Font(fileName, nativeNames);
                        physicalFont = FontManager.addToFontList(t1f, fontRank);
                        break;
                    }
                    case 5: {
                        NativeFont nf = new NativeFont(fileName, false);
                        physicalFont = FontManager.addToFontList(nf, fontRank);
                    }
                }
                if (logging) {
                    logger.info("Registered file " + fileName + " as font " + physicalFont + " rank=" + fontRank);
                }
            }
            catch (FontFormatException ffe) {
                if (!logging) break block11;
                logger.warning("Unusable font: " + fileName + " " + ffe.toString());
            }
        }
        if (physicalFont != null && fontFormat != 5) {
            registeredFontFiles.put(fileName, physicalFont);
        }
        return physicalFont;
    }

    public static void registerFonts(String[] fileNames, String[][] nativeNames, int fontCount, int fontFormat, boolean useJavaRasterizer, int fontRank, boolean defer) {
        for (int i = 0; i < fontCount; ++i) {
            if (defer) {
                FontManager.registerDeferredFont(fileNames[i], fileNames[i], nativeNames[i], fontFormat, useJavaRasterizer, fontRank);
                continue;
            }
            FontManager.registerFontFile(fileNames[i], nativeNames[i], fontFormat, useJavaRasterizer, fontRank);
        }
    }

    public static PhysicalFont getDefaultPhysicalFont() {
        if (defaultPhysicalFont == null) {
            defaultPhysicalFont = (PhysicalFont)FontManager.findFont2D("Lucida Sans Regular", 0, 0);
            if (defaultPhysicalFont == null) {
                defaultPhysicalFont = (PhysicalFont)FontManager.findFont2D("Arial", 0, 0);
            }
            if (defaultPhysicalFont == null) {
                Iterator<PhysicalFont> i = physicalFonts.values().iterator();
                if (i.hasNext()) {
                    defaultPhysicalFont = i.next();
                } else {
                    throw new Error("Probable fatal error:No fonts found.");
                }
            }
        }
        return defaultPhysicalFont;
    }

    public static CompositeFont getDefaultLogicalFont(int style) {
        return (CompositeFont)FontManager.findFont2D("dialog", style, 0);
    }

    private static String dotStyleStr(int num) {
        switch (num) {
            case 1: {
                return ".bold";
            }
            case 2: {
                return ".italic";
            }
            case 3: {
                return ".bolditalic";
            }
        }
        return ".plain";
    }

    static void initSGEnv() {
        if (sgEnv == null) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            if (ge instanceof HeadlessGraphicsEnvironment) {
                HeadlessGraphicsEnvironment hgEnv = (HeadlessGraphicsEnvironment)ge;
                sgEnv = (SunGraphicsEnvironment)hgEnv.getSunGraphicsEnvironment();
            } else {
                sgEnv = (SunGraphicsEnvironment)ge;
            }
        }
    }

    private static native void populateFontFileNameMap(HashMap<String, String> var0, HashMap<String, String> var1, HashMap<String, ArrayList<String>> var2, Locale var3);

    private static String[] getFontFilesFromPath(boolean noType1) {
        final FilenameFilter filter = noType1 ? SunGraphicsEnvironment.ttFilter : new SunGraphicsEnvironment.TTorT1Filter();
        return (String[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (pathDirs.length == 1) {
                    File dir = new File(pathDirs[0]);
                    String[] files = dir.list(filter);
                    if (files == null) {
                        return new String[0];
                    }
                    for (int f = 0; f < files.length; ++f) {
                        files[f] = files[f].toLowerCase();
                    }
                    return files;
                }
                ArrayList<String> fileList = new ArrayList<String>();
                for (int i = 0; i < pathDirs.length; ++i) {
                    File dir = new File(pathDirs[i]);
                    String[] files = dir.list(filter);
                    if (files == null) continue;
                    for (int f = 0; f < files.length; ++f) {
                        fileList.add(files[f].toLowerCase());
                    }
                }
                return fileList.toArray(STR_ARRAY);
            }
        });
    }

    private static void resolveWindowsFonts() {
        ArrayList<String> unmappedFontNames = null;
        for (String font : fontToFamilyNameMap.keySet()) {
            String file = fontToFileMap.get(font);
            if (file != null) continue;
            if (font.indexOf("  ") > 0) {
                String newName = font.replaceFirst("  ", " ");
                file = fontToFileMap.get(newName);
                if (file == null || fontToFamilyNameMap.containsKey(newName)) continue;
                fontToFileMap.remove(newName);
                fontToFileMap.put(font, file);
                continue;
            }
            if (font.equals("marlett")) {
                fontToFileMap.put(font, "marlett.ttf");
                continue;
            }
            if (font.equals("david")) {
                file = fontToFileMap.get("david regular");
                if (file == null) continue;
                fontToFileMap.remove("david regular");
                fontToFileMap.put("david", file);
                continue;
            }
            if (unmappedFontNames == null) {
                unmappedFontNames = new ArrayList<String>();
            }
            unmappedFontNames.add(font);
        }
        if (unmappedFontNames != null) {
            HashSet<String> unmappedFontFiles = new HashSet<String>();
            HashMap ffmapCopy = (HashMap)fontToFileMap.clone();
            for (String key : fontToFamilyNameMap.keySet()) {
                ffmapCopy.remove(key);
            }
            for (String key : ffmapCopy.keySet()) {
                unmappedFontFiles.add((String)ffmapCopy.get(key));
                fontToFileMap.remove(key);
            }
            FontManager.resolveFontFiles(unmappedFontFiles, unmappedFontNames);
            if (unmappedFontNames.size() > 0) {
                ArrayList<String> registryFiles = new ArrayList<String>();
                for (String regFile : fontToFileMap.values()) {
                    registryFiles.add(regFile.toLowerCase());
                }
                for (String pathFile : FontManager.getFontFilesFromPath(true)) {
                    if (registryFiles.contains(pathFile)) continue;
                    unmappedFontFiles.add(pathFile);
                }
                FontManager.resolveFontFiles(unmappedFontFiles, unmappedFontNames);
            }
            if (unmappedFontNames.size() > 0) {
                int sz = unmappedFontNames.size();
                for (int i = 0; i < sz; ++i) {
                    ArrayList<String> family;
                    String name = (String)unmappedFontNames.get(i);
                    String familyName = fontToFamilyNameMap.get(name);
                    if (familyName != null && (family = familyToFontListMap.get(familyName)) != null && family.size() <= 1) {
                        familyToFontListMap.remove(familyName);
                    }
                    fontToFamilyNameMap.remove(name);
                    if (!logging) continue;
                    logger.info("No file for font:" + name);
                }
            }
        }
    }

    private static synchronized void checkForUnreferencedFontFiles() {
        if (haveCheckedUnreferencedFontFiles) {
            return;
        }
        haveCheckedUnreferencedFontFiles = true;
        if (!isWindows) {
            return;
        }
        ArrayList<String> registryFiles = new ArrayList<String>();
        for (String regFile : fontToFileMap.values()) {
            registryFiles.add(regFile.toLowerCase());
        }
        HashMap<String, String> fontToFileMap2 = null;
        HashMap<String, String> fontToFamilyNameMap2 = null;
        HashMap<String, ArrayList<String>> familyToFontListMap2 = null;
        for (String pathFile : FontManager.getFontFilesFromPath(false)) {
            PhysicalFont f;
            if (registryFiles.contains(pathFile)) continue;
            if (logging) {
                logger.info("Found non-registry file : " + pathFile);
            }
            if ((f = FontManager.registerFontFile(FontManager.getPathName(pathFile))) == null) continue;
            if (fontToFileMap2 == null) {
                fontToFileMap2 = new HashMap<String, String>(fontToFileMap);
                fontToFamilyNameMap2 = new HashMap<String, String>(fontToFamilyNameMap);
                familyToFontListMap2 = new HashMap<String, ArrayList<String>>(familyToFontListMap);
            }
            String fontName = f.getFontName(null);
            String family = f.getFamilyName(null);
            String familyLC = family.toLowerCase();
            fontToFamilyNameMap2.put(fontName, family);
            fontToFileMap2.put(fontName, pathFile);
            ArrayList<String> fonts = familyToFontListMap2.get(familyLC);
            fonts = fonts == null ? new ArrayList() : new ArrayList<String>(fonts);
            fonts.add(fontName);
            familyToFontListMap2.put(familyLC, fonts);
        }
        if (fontToFileMap2 != null) {
            fontToFileMap = fontToFileMap2;
            familyToFontListMap = familyToFontListMap2;
            fontToFamilyNameMap = fontToFamilyNameMap2;
        }
    }

    private static void resolveFontFiles(HashSet<String> unmappedFiles, ArrayList<String> unmappedFonts) {
        Locale l = SunToolkit.getStartupLocale();
        for (String file : unmappedFiles) {
            try {
                TrueTypeFont ttf;
                int fn = 0;
                String fullPath = FontManager.getPathName(file);
                if (logging) {
                    logger.info("Trying to resolve file " + fullPath);
                }
                do {
                    String fontName;
                    if (!unmappedFonts.contains(fontName = (ttf = new TrueTypeFont(fullPath, null, fn++, true)).getFontName(l).toLowerCase())) continue;
                    fontToFileMap.put(fontName, file);
                    unmappedFonts.remove(fontName);
                    if (!logging) continue;
                    logger.info("Resolved absent registry entry for " + fontName + " located in " + fullPath);
                } while (fn < ttf.getFontCount());
            }
            catch (Exception e) {}
        }
    }

    private static synchronized HashMap<String, String> getFullNameToFileMap() {
        if (fontToFileMap == null) {
            FontManager.initSGEnv();
            pathDirs = sgEnv.getPlatformFontDirs();
            fontToFileMap = new HashMap(100);
            fontToFamilyNameMap = new HashMap(100);
            familyToFontListMap = new HashMap(50);
            FontManager.populateFontFileNameMap(fontToFileMap, fontToFamilyNameMap, familyToFontListMap, Locale.ENGLISH);
            if (isWindows) {
                FontManager.resolveWindowsFonts();
            }
            if (logging) {
                FontManager.logPlatformFontInfo();
            }
        }
        return fontToFileMap;
    }

    private static void logPlatformFontInfo() {
        for (int i = 0; i < pathDirs.length; ++i) {
            logger.info("fontdir=" + pathDirs[i]);
        }
        for (String keyName : fontToFileMap.keySet()) {
            logger.info("font=" + keyName + " file=" + fontToFileMap.get(keyName));
        }
        for (String keyName : fontToFamilyNameMap.keySet()) {
            logger.info("font=" + keyName + " family=" + fontToFamilyNameMap.get(keyName));
        }
        for (String keyName : familyToFontListMap.keySet()) {
            logger.info("family=" + keyName + " fonts=" + familyToFontListMap.get(keyName));
        }
    }

    public static String[] getFontNamesFromPlatform() {
        if (FontManager.getFullNameToFileMap().size() == 0) {
            return null;
        }
        FontManager.checkForUnreferencedFontFiles();
        ArrayList<String> fontNames = new ArrayList<String>();
        for (ArrayList<String> a : familyToFontListMap.values()) {
            for (String s : a) {
                fontNames.add(s);
            }
        }
        return fontNames.toArray(STR_ARRAY);
    }

    public static boolean gotFontsFromPlatform() {
        return FontManager.getFullNameToFileMap().size() != 0;
    }

    public static String getFileNameForFontName(String fontName) {
        String fontNameLC = fontName.toLowerCase(Locale.ENGLISH);
        return fontToFileMap.get(fontNameLC);
    }

    private static PhysicalFont registerFontFile(String file) {
        if (new File(file).isAbsolute() && !registeredFontFiles.contains(file)) {
            int fontFormat = -1;
            int fontRank = 6;
            if (SunGraphicsEnvironment.ttFilter.accept(null, file)) {
                fontFormat = 0;
                fontRank = 3;
            } else if (SunGraphicsEnvironment.t1Filter.accept(null, file)) {
                fontFormat = 1;
                fontRank = 4;
            }
            if (fontFormat == -1) {
                return null;
            }
            return FontManager.registerFontFile(file, null, fontFormat, false, fontRank);
        }
        return null;
    }

    public static void registerOtherFontFiles(HashSet registeredFontFiles) {
        if (FontManager.getFullNameToFileMap().size() == 0) {
            return;
        }
        for (String file : fontToFileMap.values()) {
            FontManager.registerFontFile(file);
        }
    }

    public static boolean getFamilyNamesFromPlatform(TreeMap<String, String> familyNames, Locale requestedLocale) {
        if (FontManager.getFullNameToFileMap().size() == 0) {
            return false;
        }
        FontManager.checkForUnreferencedFontFiles();
        for (String name : fontToFamilyNameMap.values()) {
            familyNames.put(name.toLowerCase(requestedLocale), name);
        }
        return true;
    }

    private static String getPathName(String s) {
        File f = new File(s);
        if (f.isAbsolute()) {
            return s;
        }
        if (pathDirs.length == 1) {
            return pathDirs[0] + File.separator + s;
        }
        for (int p = 0; p < pathDirs.length; ++p) {
            f = new File(pathDirs[p] + File.separator + s);
            if (!f.exists()) continue;
            return f.getAbsolutePath();
        }
        return s;
    }

    private static Font2D findFontFromPlatform(String lcName, int style) {
        if (FontManager.getFullNameToFileMap().size() == 0) {
            return null;
        }
        ArrayList<String> family = null;
        String fontFile = null;
        String familyName = fontToFamilyNameMap.get(lcName);
        if (familyName != null) {
            fontFile = fontToFileMap.get(lcName);
            family = familyToFontListMap.get(familyName.toLowerCase(Locale.ENGLISH));
        } else {
            String lcFontName;
            family = familyToFontListMap.get(lcName);
            if (family != null && family.size() > 0 && (lcFontName = family.get(0).toLowerCase(Locale.ENGLISH)) != null) {
                familyName = fontToFamilyNameMap.get(lcFontName);
            }
        }
        if (family == null || familyName == null) {
            return null;
        }
        String[] fontList = family.toArray(STR_ARRAY);
        if (fontList.length == 0) {
            return null;
        }
        for (int f = 0; f < fontList.length; ++f) {
            String fontNameLC = fontList[f].toLowerCase(Locale.ENGLISH);
            String fileName = fontToFileMap.get(fontNameLC);
            if (fileName != null) continue;
            if (logging) {
                logger.info("Platform lookup : No file for font " + fontList[f] + " in family " + familyName);
            }
            return null;
        }
        PhysicalFont physicalFont = null;
        if (fontFile != null) {
            physicalFont = FontManager.registerFontFile(FontManager.getPathName(fontFile), null, 0, false, 3);
        }
        for (int f = 0; f < fontList.length; ++f) {
            String fontNameLC = fontList[f].toLowerCase(Locale.ENGLISH);
            String fileName = fontToFileMap.get(fontNameLC);
            if (fontFile != null && fontFile.equals(fileName)) continue;
            FontManager.registerFontFile(FontManager.getPathName(fileName), null, 0, false, 3);
        }
        Font2D font = null;
        FontFamily fontFamily = FontFamily.getFamily(familyName);
        if (physicalFont != null) {
            style |= physicalFont.style;
        }
        if (fontFamily != null && (font = fontFamily.getFont(style)) == null) {
            font = fontFamily.getClosestStyle(style);
        }
        return font;
    }

    public static Font2D findFont2D(String name, int style, int fallback) {
        FontFamily family;
        ConcurrentHashMap altNameCache;
        String lowerCaseName = name.toLowerCase(Locale.ENGLISH);
        String mapName = lowerCaseName + FontManager.dotStyleStr(style);
        Font2D font = usingPerAppContextComposites ? ((altNameCache = (ConcurrentHashMap)AppContext.getAppContext().get(CompositeFont.class)) != null ? (Font2D)altNameCache.get(mapName) : null) : fontNameCache.get(mapName);
        if (font != null) {
            return font;
        }
        if (logging) {
            logger.info("Search for font: " + name);
        }
        if (isWindows) {
            if (lowerCaseName.equals("ms sans serif")) {
                name = "sansserif";
            } else if (lowerCaseName.equals("ms serif")) {
                name = "serif";
            }
        }
        if (lowerCaseName.equals("default")) {
            name = "dialog";
        }
        if ((family = FontFamily.getFamily(name)) != null) {
            font = family.getFontWithExactStyleMatch(style);
            if (font == null) {
                font = FontManager.findDeferredFont(name, style);
            }
            if (font == null) {
                font = family.getFont(style);
            }
            if (font == null) {
                font = family.getClosestStyle(style);
            }
            if (font != null) {
                fontNameCache.put(mapName, font);
                return font;
            }
        }
        if ((font = fullNameToFont.get(lowerCaseName)) != null) {
            if (font.style == style || style == 0) {
                fontNameCache.put(mapName, font);
                return font;
            }
            family = FontFamily.getFamily(font.getFamilyName(null));
            if (family != null) {
                Font2D familyFont = family.getFont(style | font.style);
                if (familyFont != null) {
                    fontNameCache.put(mapName, familyFont);
                    return familyFont;
                }
                familyFont = family.getClosestStyle(style | font.style);
                if (familyFont != null && familyFont.canDoStyle(style | font.style)) {
                    fontNameCache.put(mapName, familyFont);
                    return familyFont;
                }
            }
        }
        if (sgEnv == null) {
            FontManager.initSGEnv();
            return FontManager.findFont2D(name, style, fallback);
        }
        if (isWindows) {
            if (deferredFontFiles.size() > 0 && (font = FontManager.findJREDeferredFont(lowerCaseName, style)) != null) {
                fontNameCache.put(mapName, font);
                return font;
            }
            font = FontManager.findFontFromPlatform(lowerCaseName, style);
            if (font != null) {
                if (logging) {
                    logger.info("Found font via platform API for request:\"" + name + "\":, style=" + style + " found font: " + font);
                }
                fontNameCache.put(mapName, font);
                return font;
            }
        }
        if (deferredFontFiles.size() > 0 && (font = FontManager.findDeferredFont(name, style)) != null) {
            fontNameCache.put(mapName, font);
            return font;
        }
        if (isSolaris && !loaded1dot0Fonts) {
            if (lowerCaseName.equals("timesroman")) {
                font = FontManager.findFont2D("serif", style, fallback);
                fontNameCache.put(mapName, font);
            }
            sgEnv.register1dot0Fonts();
            loaded1dot0Fonts = true;
            Font2D ff = FontManager.findFont2D(name, style, fallback);
            return ff;
        }
        if (fontsAreRegistered || fontsAreRegisteredPerAppContext) {
            Hashtable nameTable;
            Hashtable familyTable = null;
            if (fontsAreRegistered) {
                familyTable = createdByFamilyName;
                nameTable = createdByFullName;
            } else {
                AppContext appContext = AppContext.getAppContext();
                familyTable = (Hashtable)appContext.get(regFamilyKey);
                nameTable = (Hashtable)appContext.get(regFullNameKey);
            }
            family = (FontFamily)familyTable.get(lowerCaseName);
            if (family != null) {
                font = family.getFontWithExactStyleMatch(style);
                if (font == null) {
                    font = family.getFont(style);
                }
                if (font == null) {
                    font = family.getClosestStyle(style);
                }
                if (font != null) {
                    if (fontsAreRegistered) {
                        fontNameCache.put(mapName, font);
                    }
                    return font;
                }
            }
            if ((font = (Font2D)nameTable.get(lowerCaseName)) != null) {
                if (fontsAreRegistered) {
                    fontNameCache.put(mapName, font);
                }
                return font;
            }
        }
        if (!loadedAllFonts) {
            if (logging) {
                logger.info("Load fonts looking for:" + name);
            }
            sgEnv.loadFonts();
            loadedAllFonts = true;
            return FontManager.findFont2D(name, style, fallback);
        }
        if (!loadedAllFontFiles) {
            if (logging) {
                logger.info("Load font files looking for:" + name);
            }
            sgEnv.loadFontFiles();
            loadedAllFontFiles = true;
            return FontManager.findFont2D(name, style, fallback);
        }
        font = FontManager.findFont2DAllLocales(name, style);
        if (font != null) {
            fontNameCache.put(mapName, font);
            return font;
        }
        if (isWindows) {
            String compatName = sgEnv.getFontConfiguration().getFallbackFamilyName(name, null);
            if (compatName != null) {
                font = FontManager.findFont2D(compatName, style, fallback);
                fontNameCache.put(mapName, font);
                return font;
            }
        } else {
            if (lowerCaseName.equals("timesroman")) {
                font = FontManager.findFont2D("serif", style, fallback);
                fontNameCache.put(mapName, font);
                return font;
            }
            if (lowerCaseName.equals("helvetica")) {
                font = FontManager.findFont2D("sansserif", style, fallback);
                fontNameCache.put(mapName, font);
                return font;
            }
            if (lowerCaseName.equals("courier")) {
                font = FontManager.findFont2D("monospaced", style, fallback);
                fontNameCache.put(mapName, font);
                return font;
            }
        }
        if (logging) {
            logger.info("No font found for:" + name);
        }
        switch (fallback) {
            case 1: {
                return FontManager.getDefaultPhysicalFont();
            }
            case 2: {
                return FontManager.getDefaultLogicalFont(style);
            }
        }
        return null;
    }

    public static native Font2D getFont2D(Font var0);

    public static boolean usePlatformFontMetrics() {
        return usePlatformFontMetrics;
    }

    static native boolean getPlatformFontVar();

    public static short getLCIDFromLocale(Locale locale) {
        if (locale.equals(Locale.US)) {
            return 1033;
        }
        if (lcidMap == null) {
            FontManager.createLCIDMap();
        }
        String key = locale.toString();
        while (!"".equals(key)) {
            Short lcidObject = lcidMap.get(key);
            if (lcidObject != null) {
                return lcidObject;
            }
            int pos = key.lastIndexOf(95);
            if (pos < 1) {
                return 1033;
            }
            key = key.substring(0, pos);
        }
        return 1033;
    }

    private static void addLCIDMapEntry(Map<String, Short> map, String key, short value) {
        map.put(key, new Short(value));
    }

    private static synchronized void createLCIDMap() {
        if (lcidMap != null) {
            return;
        }
        HashMap<String, Short> map = new HashMap<String, Short>(200);
        FontManager.addLCIDMapEntry(map, "ar", (short)1025);
        FontManager.addLCIDMapEntry(map, "bg", (short)1026);
        FontManager.addLCIDMapEntry(map, "ca", (short)1027);
        FontManager.addLCIDMapEntry(map, "zh", (short)1028);
        FontManager.addLCIDMapEntry(map, "cs", (short)1029);
        FontManager.addLCIDMapEntry(map, "da", (short)1030);
        FontManager.addLCIDMapEntry(map, "de", (short)1031);
        FontManager.addLCIDMapEntry(map, "el", (short)1032);
        FontManager.addLCIDMapEntry(map, "es", (short)1034);
        FontManager.addLCIDMapEntry(map, "fi", (short)1035);
        FontManager.addLCIDMapEntry(map, "fr", (short)1036);
        FontManager.addLCIDMapEntry(map, "iw", (short)1037);
        FontManager.addLCIDMapEntry(map, "hu", (short)1038);
        FontManager.addLCIDMapEntry(map, "is", (short)1039);
        FontManager.addLCIDMapEntry(map, "it", (short)1040);
        FontManager.addLCIDMapEntry(map, "ja", (short)1041);
        FontManager.addLCIDMapEntry(map, "ko", (short)1042);
        FontManager.addLCIDMapEntry(map, "nl", (short)1043);
        FontManager.addLCIDMapEntry(map, "no", (short)1044);
        FontManager.addLCIDMapEntry(map, "pl", (short)1045);
        FontManager.addLCIDMapEntry(map, "pt", (short)1046);
        FontManager.addLCIDMapEntry(map, "rm", (short)1047);
        FontManager.addLCIDMapEntry(map, "ro", (short)1048);
        FontManager.addLCIDMapEntry(map, "ru", (short)1049);
        FontManager.addLCIDMapEntry(map, "hr", (short)1050);
        FontManager.addLCIDMapEntry(map, "sk", (short)1051);
        FontManager.addLCIDMapEntry(map, "sq", (short)1052);
        FontManager.addLCIDMapEntry(map, "sv", (short)1053);
        FontManager.addLCIDMapEntry(map, "th", (short)1054);
        FontManager.addLCIDMapEntry(map, "tr", (short)1055);
        FontManager.addLCIDMapEntry(map, "ur", (short)1056);
        FontManager.addLCIDMapEntry(map, "in", (short)1057);
        FontManager.addLCIDMapEntry(map, "uk", (short)1058);
        FontManager.addLCIDMapEntry(map, "be", (short)1059);
        FontManager.addLCIDMapEntry(map, "sl", (short)1060);
        FontManager.addLCIDMapEntry(map, "et", (short)1061);
        FontManager.addLCIDMapEntry(map, "lv", (short)1062);
        FontManager.addLCIDMapEntry(map, "lt", (short)1063);
        FontManager.addLCIDMapEntry(map, "fa", (short)1065);
        FontManager.addLCIDMapEntry(map, "vi", (short)1066);
        FontManager.addLCIDMapEntry(map, "hy", (short)1067);
        FontManager.addLCIDMapEntry(map, "eu", (short)1069);
        FontManager.addLCIDMapEntry(map, "mk", (short)1071);
        FontManager.addLCIDMapEntry(map, "tn", (short)1074);
        FontManager.addLCIDMapEntry(map, "xh", (short)1076);
        FontManager.addLCIDMapEntry(map, "zu", (short)1077);
        FontManager.addLCIDMapEntry(map, "af", (short)1078);
        FontManager.addLCIDMapEntry(map, "ka", (short)1079);
        FontManager.addLCIDMapEntry(map, "fo", (short)1080);
        FontManager.addLCIDMapEntry(map, "hi", (short)1081);
        FontManager.addLCIDMapEntry(map, "mt", (short)1082);
        FontManager.addLCIDMapEntry(map, "se", (short)1083);
        FontManager.addLCIDMapEntry(map, "gd", (short)1084);
        FontManager.addLCIDMapEntry(map, "ms", (short)1086);
        FontManager.addLCIDMapEntry(map, "kk", (short)1087);
        FontManager.addLCIDMapEntry(map, "ky", (short)1088);
        FontManager.addLCIDMapEntry(map, "sw", (short)1089);
        FontManager.addLCIDMapEntry(map, "tt", (short)1092);
        FontManager.addLCIDMapEntry(map, "bn", (short)1093);
        FontManager.addLCIDMapEntry(map, "pa", (short)1094);
        FontManager.addLCIDMapEntry(map, "gu", (short)1095);
        FontManager.addLCIDMapEntry(map, "ta", (short)1097);
        FontManager.addLCIDMapEntry(map, "te", (short)1098);
        FontManager.addLCIDMapEntry(map, "kn", (short)1099);
        FontManager.addLCIDMapEntry(map, "ml", (short)1100);
        FontManager.addLCIDMapEntry(map, "mr", (short)1102);
        FontManager.addLCIDMapEntry(map, "sa", (short)1103);
        FontManager.addLCIDMapEntry(map, "mn", (short)1104);
        FontManager.addLCIDMapEntry(map, "cy", (short)1106);
        FontManager.addLCIDMapEntry(map, "gl", (short)1110);
        FontManager.addLCIDMapEntry(map, "dv", (short)1125);
        FontManager.addLCIDMapEntry(map, "qu", (short)1131);
        FontManager.addLCIDMapEntry(map, "mi", (short)1153);
        FontManager.addLCIDMapEntry(map, "ar_IQ", (short)2049);
        FontManager.addLCIDMapEntry(map, "zh_CN", (short)2052);
        FontManager.addLCIDMapEntry(map, "de_CH", (short)2055);
        FontManager.addLCIDMapEntry(map, "en_GB", (short)2057);
        FontManager.addLCIDMapEntry(map, "es_MX", (short)2058);
        FontManager.addLCIDMapEntry(map, "fr_BE", (short)2060);
        FontManager.addLCIDMapEntry(map, "it_CH", (short)2064);
        FontManager.addLCIDMapEntry(map, "nl_BE", (short)2067);
        FontManager.addLCIDMapEntry(map, "no_NO_NY", (short)2068);
        FontManager.addLCIDMapEntry(map, "pt_PT", (short)2070);
        FontManager.addLCIDMapEntry(map, "ro_MD", (short)2072);
        FontManager.addLCIDMapEntry(map, "ru_MD", (short)2073);
        FontManager.addLCIDMapEntry(map, "sr_CS", (short)2074);
        FontManager.addLCIDMapEntry(map, "sv_FI", (short)2077);
        FontManager.addLCIDMapEntry(map, "az_AZ", (short)2092);
        FontManager.addLCIDMapEntry(map, "se_SE", (short)2107);
        FontManager.addLCIDMapEntry(map, "ga_IE", (short)2108);
        FontManager.addLCIDMapEntry(map, "ms_BN", (short)2110);
        FontManager.addLCIDMapEntry(map, "uz_UZ", (short)2115);
        FontManager.addLCIDMapEntry(map, "qu_EC", (short)2155);
        FontManager.addLCIDMapEntry(map, "ar_EG", (short)3073);
        FontManager.addLCIDMapEntry(map, "zh_HK", (short)3076);
        FontManager.addLCIDMapEntry(map, "de_AT", (short)3079);
        FontManager.addLCIDMapEntry(map, "en_AU", (short)3081);
        FontManager.addLCIDMapEntry(map, "fr_CA", (short)3084);
        FontManager.addLCIDMapEntry(map, "sr_CS", (short)3098);
        FontManager.addLCIDMapEntry(map, "se_FI", (short)3131);
        FontManager.addLCIDMapEntry(map, "qu_PE", (short)3179);
        FontManager.addLCIDMapEntry(map, "ar_LY", (short)4097);
        FontManager.addLCIDMapEntry(map, "zh_SG", (short)4100);
        FontManager.addLCIDMapEntry(map, "de_LU", (short)4103);
        FontManager.addLCIDMapEntry(map, "en_CA", (short)4105);
        FontManager.addLCIDMapEntry(map, "es_GT", (short)4106);
        FontManager.addLCIDMapEntry(map, "fr_CH", (short)4108);
        FontManager.addLCIDMapEntry(map, "hr_BA", (short)4122);
        FontManager.addLCIDMapEntry(map, "ar_DZ", (short)5121);
        FontManager.addLCIDMapEntry(map, "zh_MO", (short)5124);
        FontManager.addLCIDMapEntry(map, "de_LI", (short)5127);
        FontManager.addLCIDMapEntry(map, "en_NZ", (short)5129);
        FontManager.addLCIDMapEntry(map, "es_CR", (short)5130);
        FontManager.addLCIDMapEntry(map, "fr_LU", (short)5132);
        FontManager.addLCIDMapEntry(map, "bs_BA", (short)5146);
        FontManager.addLCIDMapEntry(map, "ar_MA", (short)6145);
        FontManager.addLCIDMapEntry(map, "en_IE", (short)6153);
        FontManager.addLCIDMapEntry(map, "es_PA", (short)6154);
        FontManager.addLCIDMapEntry(map, "fr_MC", (short)6156);
        FontManager.addLCIDMapEntry(map, "sr_BA", (short)6170);
        FontManager.addLCIDMapEntry(map, "ar_TN", (short)7169);
        FontManager.addLCIDMapEntry(map, "en_ZA", (short)7177);
        FontManager.addLCIDMapEntry(map, "es_DO", (short)7178);
        FontManager.addLCIDMapEntry(map, "sr_BA", (short)7194);
        FontManager.addLCIDMapEntry(map, "ar_OM", (short)8193);
        FontManager.addLCIDMapEntry(map, "en_JM", (short)8201);
        FontManager.addLCIDMapEntry(map, "es_VE", (short)8202);
        FontManager.addLCIDMapEntry(map, "ar_YE", (short)9217);
        FontManager.addLCIDMapEntry(map, "es_CO", (short)9226);
        FontManager.addLCIDMapEntry(map, "ar_SY", (short)10241);
        FontManager.addLCIDMapEntry(map, "en_BZ", (short)10249);
        FontManager.addLCIDMapEntry(map, "es_PE", (short)10250);
        FontManager.addLCIDMapEntry(map, "ar_JO", (short)11265);
        FontManager.addLCIDMapEntry(map, "en_TT", (short)11273);
        FontManager.addLCIDMapEntry(map, "es_AR", (short)11274);
        FontManager.addLCIDMapEntry(map, "ar_LB", (short)12289);
        FontManager.addLCIDMapEntry(map, "en_ZW", (short)12297);
        FontManager.addLCIDMapEntry(map, "es_EC", (short)12298);
        FontManager.addLCIDMapEntry(map, "ar_KW", (short)13313);
        FontManager.addLCIDMapEntry(map, "en_PH", (short)13321);
        FontManager.addLCIDMapEntry(map, "es_CL", (short)13322);
        FontManager.addLCIDMapEntry(map, "ar_AE", (short)14337);
        FontManager.addLCIDMapEntry(map, "es_UY", (short)14346);
        FontManager.addLCIDMapEntry(map, "ar_BH", (short)15361);
        FontManager.addLCIDMapEntry(map, "es_PY", (short)15370);
        FontManager.addLCIDMapEntry(map, "ar_QA", (short)16385);
        FontManager.addLCIDMapEntry(map, "es_BO", (short)16394);
        FontManager.addLCIDMapEntry(map, "es_SV", (short)17418);
        FontManager.addLCIDMapEntry(map, "es_HN", (short)18442);
        FontManager.addLCIDMapEntry(map, "es_NI", (short)19466);
        FontManager.addLCIDMapEntry(map, "es_PR", (short)20490);
        lcidMap = map;
    }

    public static int getNumFonts() {
        return physicalFonts.size() + maxCompFont;
    }

    private static boolean fontSupportsEncoding(Font font, String encoding) {
        return FontManager.getFont2D(font).supportsEncoding(encoding);
    }

    public static synchronized native String getFontPath(boolean var0);

    public static synchronized native void setNativeFontPath(String var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Font2D createFont2D(File fontFile, int fontFormat, boolean isCopy, CreatedFontTracker tracker) throws FontFormatException {
        String fontFilePath = fontFile.getPath();
        FileFont font2D = null;
        final File fFile = fontFile;
        final CreatedFontTracker _tracker = tracker;
        try {
            switch (fontFormat) {
                case 0: {
                    font2D = new TrueTypeFont(fontFilePath, null, 0, true);
                    break;
                }
                case 1: {
                    font2D = new Type1Font(fontFilePath, null, isCopy);
                    break;
                }
                default: {
                    throw new FontFormatException("Unrecognised Font Format");
                }
            }
        }
        catch (FontFormatException e) {
            if (!isCopy) throw e;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (_tracker != null) {
                        _tracker.subBytes((int)fFile.length());
                    }
                    fFile.delete();
                    return null;
                }
            });
            throw e;
        }
        if (!isCopy) return font2D;
        font2D.setFileToRemove(fontFile, tracker);
        Class<FontManager> clazz = FontManager.class;
        synchronized (FontManager.class) {
            if (tmpFontFiles == null) {
                tmpFontFiles = new Vector();
            }
            tmpFontFiles.add(fontFile);
            if (fileCloser != null) return font2D;
            final Runnable fileCloserRunnable = new Runnable(){

                public void run() {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            for (int i = 0; i < 20; ++i) {
                                if (fontFileCache[i] == null) continue;
                                try {
                                    fontFileCache[i].close();
                                    continue;
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            if (tmpFontFiles != null) {
                                File[] files = new File[tmpFontFiles.size()];
                                files = tmpFontFiles.toArray(files);
                                for (int f = 0; f < files.length; ++f) {
                                    try {
                                        files[f].delete();
                                        continue;
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                            return null;
                        }
                    });
                }
            };
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ThreadGroup tg;
                    ThreadGroup tgn = tg = Thread.currentThread().getThreadGroup();
                    while (tgn != null) {
                        tg = tgn;
                        tgn = tg.getParent();
                    }
                    fileCloser = new Thread(tg, fileCloserRunnable);
                    Runtime.getRuntime().addShutdownHook(fileCloser);
                    return null;
                }
            });
            // ** MonitorExit[var8_9] (shouldn't be in output)
            return font2D;
        }
    }

    public static synchronized String getFullNameByFileName(String fileName) {
        PhysicalFont[] physFonts = FontManager.getPhysicalFonts();
        for (int i = 0; i < physFonts.length; ++i) {
            if (!physFonts[i].platName.equals(fileName)) continue;
            return physFonts[i].getFontName(null);
        }
        return null;
    }

    public static synchronized void deRegisterBadFont(Font2D font2D) {
        if (!(font2D instanceof PhysicalFont)) {
            return;
        }
        if (logging) {
            logger.severe("Deregister bad font: " + font2D);
        }
        FontManager.replaceFont((PhysicalFont)font2D, FontManager.getDefaultPhysicalFont());
    }

    public static synchronized void replaceFont(PhysicalFont oldFont, PhysicalFont newFont) {
        int i;
        if (oldFont.handle.font2D != oldFont) {
            return;
        }
        if (oldFont == newFont) {
            if (logging) {
                logger.severe("Can't replace bad font with itself " + oldFont);
            }
            PhysicalFont[] physFonts = FontManager.getPhysicalFonts();
            for (i = 0; i < physFonts.length; ++i) {
                if (physFonts[i] == newFont) continue;
                newFont = physFonts[i];
                break;
            }
            if (oldFont == newFont) {
                if (logging) {
                    logger.severe("This is bad. No good physicalFonts found.");
                }
                return;
            }
        }
        oldFont.handle.font2D = newFont;
        physicalFonts.remove(oldFont.fullName);
        fullNameToFont.remove(oldFont.fullName.toLowerCase(Locale.ENGLISH));
        FontFamily.remove(oldFont);
        if (localeFullNamesToFont != null) {
            Map.Entry[] mapEntries = localeFullNamesToFont.entrySet().toArray(new Map.Entry[0]);
            for (i = 0; i < mapEntries.length; ++i) {
                if (mapEntries[i].getValue() != oldFont) continue;
                try {
                    mapEntries[i].setValue(newFont);
                    continue;
                }
                catch (Exception e) {
                    localeFullNamesToFont.remove(mapEntries[i].getKey());
                }
            }
        }
        for (int i2 = 0; i2 < maxCompFont; ++i2) {
            if (newFont.getRank() <= 2) continue;
            compFonts[i2].replaceComponentFont(oldFont, newFont);
        }
    }

    private static synchronized void loadLocaleNames() {
        if (localeFullNamesToFont != null) {
            return;
        }
        localeFullNamesToFont = new HashMap();
        Font2D[] fonts = FontManager.getRegisteredFonts();
        for (int i = 0; i < fonts.length; ++i) {
            if (!(fonts[i] instanceof TrueTypeFont)) continue;
            TrueTypeFont ttf = (TrueTypeFont)fonts[i];
            String[] fullNames = ttf.getAllFullNames();
            for (int n = 0; n < fullNames.length; ++n) {
                localeFullNamesToFont.put(fullNames[n], ttf);
            }
            FontFamily family = FontFamily.getFamily(ttf.familyName);
            if (family == null) continue;
            FontFamily.addLocaleNames(family, ttf.getAllFamilyNames());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Font2D findFont2DAllLocales(String name, int style) {
        if (logging) {
            logger.info("Searching localised font names for:" + name);
        }
        if (localeFullNamesToFont == null) {
            FontManager.loadLocaleNames();
        }
        String lowerCaseName = name.toLowerCase();
        Font2D font = null;
        FontFamily family = FontFamily.getLocaleFamily(lowerCaseName);
        if (family != null) {
            font = family.getFont(style);
            if (font == null) {
                font = family.getClosestStyle(style);
            }
            if (font != null) {
                return font;
            }
        }
        Class<FontManager> clazz = FontManager.class;
        synchronized (FontManager.class) {
            font = localeFullNamesToFont.get(name);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (font != null) {
                if (font.style == style || style == 0) {
                    return font;
                }
                family = FontFamily.getFamily(font.getFamilyName(null));
                if (family != null) {
                    Font2D familyFont = family.getFont(style);
                    if (familyFont != null) {
                        return familyFont;
                    }
                    familyFont = family.getClosestStyle(style);
                    if (familyFont != null) {
                        if (!familyFont.canDoStyle(style)) {
                            familyFont = null;
                        }
                        return familyFont;
                    }
                }
            }
            return font;
        }
    }

    static boolean maybeUsingAlternateCompositeFonts() {
        return usingAlternateComposites || usingPerAppContextComposites;
    }

    public static boolean usingAlternateCompositeFonts() {
        return usingAlternateComposites || usingPerAppContextComposites && AppContext.getAppContext().get(CompositeFont.class) != null;
    }

    private static boolean maybeMultiAppContext() {
        Boolean appletSM = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SecurityManager sm = System.getSecurityManager();
                return new Boolean(sm instanceof AppletSecurity);
            }
        });
        return appletSM;
    }

    public static synchronized void useAlternateFontforJALocales() {
        if (!isWindows) {
            return;
        }
        FontManager.initSGEnv();
        if (!FontManager.maybeMultiAppContext()) {
            gAltJAFont = true;
        } else {
            AppContext appContext = AppContext.getAppContext();
            appContext.put(altJAFontKey, altJAFontKey);
        }
    }

    public static boolean usingAlternateFontforJALocales() {
        if (!FontManager.maybeMultiAppContext()) {
            return gAltJAFont;
        }
        AppContext appContext = AppContext.getAppContext();
        return appContext.get(altJAFontKey) == altJAFontKey;
    }

    public static synchronized void preferLocaleFonts() {
        FontManager.initSGEnv();
        if (!FontConfiguration.willReorderForStartupLocale()) {
            return;
        }
        if (!FontManager.maybeMultiAppContext()) {
            if (gLocalePref) {
                return;
            }
            gLocalePref = true;
            sgEnv.createCompositeFonts(fontNameCache, gLocalePref, gPropPref);
            usingAlternateComposites = true;
        } else {
            AppContext appContext = AppContext.getAppContext();
            if (appContext.get(localeFontKey) == localeFontKey) {
                return;
            }
            appContext.put(localeFontKey, localeFontKey);
            boolean acPropPref = appContext.get(proportionalFontKey) == proportionalFontKey;
            ConcurrentHashMap<String, Font2D> altNameCache = new ConcurrentHashMap<String, Font2D>();
            appContext.put(CompositeFont.class, altNameCache);
            usingPerAppContextComposites = true;
            sgEnv.createCompositeFonts(altNameCache, true, acPropPref);
        }
    }

    public static synchronized void preferProportionalFonts() {
        if (!FontConfiguration.hasMonoToPropMap()) {
            return;
        }
        FontManager.initSGEnv();
        if (!FontManager.maybeMultiAppContext()) {
            if (gPropPref) {
                return;
            }
            gPropPref = true;
            sgEnv.createCompositeFonts(fontNameCache, gLocalePref, gPropPref);
            usingAlternateComposites = true;
        } else {
            AppContext appContext = AppContext.getAppContext();
            if (appContext.get(proportionalFontKey) == proportionalFontKey) {
                return;
            }
            appContext.put(proportionalFontKey, proportionalFontKey);
            boolean acLocalePref = appContext.get(localeFontKey) == localeFontKey;
            ConcurrentHashMap<String, Font2D> altNameCache = new ConcurrentHashMap<String, Font2D>();
            appContext.put(CompositeFont.class, altNameCache);
            usingPerAppContextComposites = true;
            sgEnv.createCompositeFonts(altNameCache, acLocalePref, true);
        }
    }

    private static HashSet<String> getInstalledNames() {
        if (installedNames == null) {
            int i;
            Locale l = sgEnv.getSystemStartupLocale();
            String[] installedFamilies = sgEnv.getInstalledFontFamilyNames(l);
            Font[] installedFonts = sgEnv.getAllInstalledFonts();
            HashSet<String> names = new HashSet<String>();
            for (i = 0; i < installedFamilies.length; ++i) {
                names.add(installedFamilies[i].toLowerCase(l));
            }
            for (i = 0; i < installedFonts.length; ++i) {
                names.add(installedFonts[i].getFontName(l).toLowerCase(l));
            }
            installedNames = names;
        }
        return installedNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean registerFont(Font font) {
        Hashtable<String, Font2D> fullNameTable;
        Hashtable<String, FontFamily> familyTable;
        if (font == null) {
            return false;
        }
        Object object = regFamilyKey;
        synchronized (object) {
            if (createdByFamilyName == null) {
                createdByFamilyName = new Hashtable();
                createdByFullName = new Hashtable();
            }
        }
        if (!FontManager.isCreatedFont(font)) {
            return false;
        }
        if (sgEnv == null) {
            FontManager.initSGEnv();
        }
        HashSet<String> names = FontManager.getInstalledNames();
        Locale l = sgEnv.getSystemStartupLocale();
        String familyName = font.getFamily(l).toLowerCase();
        String fullName = font.getFontName(l).toLowerCase();
        if (names.contains(familyName) || names.contains(fullName)) {
            return false;
        }
        if (!FontManager.maybeMultiAppContext()) {
            familyTable = createdByFamilyName;
            fullNameTable = createdByFullName;
            fontsAreRegistered = true;
        } else {
            AppContext appContext = AppContext.getAppContext();
            familyTable = (Hashtable<String, FontFamily>)appContext.get(regFamilyKey);
            fullNameTable = (Hashtable<String, Font2D>)appContext.get(regFullNameKey);
            if (familyTable == null) {
                familyTable = new Hashtable<String, FontFamily>();
                fullNameTable = new Hashtable<String, Font2D>();
                appContext.put(regFamilyKey, familyTable);
                appContext.put(regFullNameKey, fullNameTable);
            }
            fontsAreRegisteredPerAppContext = true;
        }
        Font2D font2D = FontManager.getFont2D(font);
        int style = font2D.getStyle();
        FontFamily family = (FontFamily)familyTable.get(familyName);
        if (family == null) {
            family = new FontFamily(font.getFamily(l));
            familyTable.put(familyName, family);
        }
        if (fontsAreRegistered) {
            FontManager.removeFromCache(family.getFont(0));
            FontManager.removeFromCache(family.getFont(1));
            FontManager.removeFromCache(family.getFont(2));
            FontManager.removeFromCache(family.getFont(3));
            FontManager.removeFromCache((Font2D)fullNameTable.get(fullName));
        }
        family.setFont(font2D, style);
        fullNameTable.put(fullName, font2D);
        return true;
    }

    private static void removeFromCache(Font2D font) {
        if (font == null) {
            return;
        }
        String[] keys = fontNameCache.keySet().toArray(STR_ARRAY);
        for (int k = 0; k < keys.length; ++k) {
            if (fontNameCache.get(keys[k]) != font) continue;
            fontNameCache.remove(keys[k]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TreeMap<String, String> getCreatedFontFamilyNames() {
        Hashtable familyTable;
        if (fontsAreRegistered) {
            familyTable = createdByFamilyName;
        } else if (fontsAreRegisteredPerAppContext) {
            AppContext appContext = AppContext.getAppContext();
            familyTable = (Hashtable)appContext.get(regFamilyKey);
        } else {
            return null;
        }
        Locale l = sgEnv.getSystemStartupLocale();
        Hashtable hashtable = familyTable;
        synchronized (hashtable) {
            TreeMap<String, String> map = new TreeMap<String, String>();
            for (FontFamily f : familyTable.values()) {
                Font2D font2D = f.getFont(0);
                if (font2D == null) {
                    font2D = f.getClosestStyle(0);
                }
                String name = font2D.getFamilyName(l);
                map.put(name.toLowerCase(l), name);
            }
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Font[] getCreatedFonts() {
        Hashtable nameTable;
        if (fontsAreRegistered) {
            nameTable = createdByFullName;
        } else if (fontsAreRegisteredPerAppContext) {
            AppContext appContext = AppContext.getAppContext();
            nameTable = (Hashtable)appContext.get(regFullNameKey);
        } else {
            return null;
        }
        Locale l = sgEnv.getSystemStartupLocale();
        Hashtable hashtable = nameTable;
        synchronized (hashtable) {
            Font[] fonts = new Font[nameTable.size()];
            int i = 0;
            for (Font2D font2D : nameTable.values()) {
                fonts[i++] = new Font(font2D.getFontName(l), 0, 1);
            }
            return fonts;
        }
    }

    public static String mapFcName(String name) {
        for (int i = 0; i < nameMap.length; ++i) {
            if (!name.equals(nameMap[i][0])) continue;
            return nameMap[i][1];
        }
        return null;
    }

    private static String getFCLocaleStr() {
        Locale l = SunToolkit.getStartupLocale();
        String localeStr = l.getLanguage();
        String country = l.getCountry();
        if (!country.equals("")) {
            localeStr = localeStr + "-" + country;
        }
        return localeStr;
    }

    private static native int getFontConfigAASettings(String var0, String var1);

    public static Object getFontConfigAAHint(String fcFamily) {
        if (isWindows) {
            return null;
        }
        int hint = FontManager.getFontConfigAASettings(FontManager.getFCLocaleStr(), fcFamily);
        if (hint < 0) {
            return null;
        }
        return SunHints.Value.get(2, hint);
    }

    public static Object getFontConfigAAHint() {
        return FontManager.getFontConfigAAHint("sans");
    }

    private static native void getFontConfig(String var0, FontConfigInfo[] var1);

    private static void initFontConfigFonts() {
        if (fontConfigFonts != null) {
            return;
        }
        if (isWindows) {
            return;
        }
        long t0 = 0L;
        if (logging) {
            t0 = System.currentTimeMillis();
        }
        FontConfigInfo[] fontArr = new FontConfigInfo[fontConfigNames.length];
        for (int i = 0; i < fontArr.length; ++i) {
            fontArr[i] = new FontConfigInfo();
            fontArr[i].fcName = fontConfigNames[i];
            int colonPos = fontArr[i].fcName.indexOf(58);
            fontArr[i].fcFamily = fontArr[i].fcName.substring(0, colonPos);
            fontArr[i].jdkName = FontManager.mapFcName(fontArr[i].fcFamily);
            fontArr[i].style = i % 4;
        }
        FontManager.getFontConfig(FontManager.getFCLocaleStr(), fontArr);
        fontConfigFonts = fontArr;
        if (logging) {
            long t1 = System.currentTimeMillis();
            logger.info("Time spent accessing fontconfig=" + (t1 - t0) + "ms.");
            for (int i = 0; i < fontConfigFonts.length; ++i) {
                FontConfigInfo fci = fontConfigFonts[i];
                logger.info("FC font " + fci.fcName + " maps to family " + fci.familyName + " in file " + fci.fontFile);
            }
        }
    }

    private static PhysicalFont registerFromFcInfo(FontConfigInfo fcInfo) {
        int offset = fcInfo.fontFile.length() - 4;
        if (offset <= 0) {
            return null;
        }
        String ext = fcInfo.fontFile.substring(offset).toLowerCase();
        boolean isTTC = ext.equals(".ttc");
        PhysicalFont physFont = registeredFontFiles.get(fcInfo.fontFile);
        if (physFont != null) {
            if (isTTC) {
                Font2D f2d = FontManager.findFont2D(fcInfo.familyName, fcInfo.style, 0);
                if (f2d instanceof PhysicalFont) {
                    return (PhysicalFont)f2d;
                }
                return null;
            }
            return physFont;
        }
        physFont = FontManager.findJREDeferredFont(fcInfo.familyName, fcInfo.style);
        if (physFont == null && deferredFontFiles.get(fcInfo.fontFile) != null && (physFont = FontManager.initialiseDeferredFont(fcInfo.fontFile)) != null) {
            if (isTTC) {
                Font2D f2d = FontManager.findFont2D(fcInfo.familyName, fcInfo.style, 0);
                if (f2d instanceof PhysicalFont) {
                    return (PhysicalFont)f2d;
                }
                return null;
            }
            return physFont;
        }
        if (physFont == null) {
            int fontFormat = -1;
            int fontRank = 6;
            if (ext.equals(".ttf") || isTTC) {
                fontFormat = 0;
                fontRank = 3;
            } else if (ext.equals(".pfa") || ext.equals(".pfb")) {
                fontFormat = 1;
                fontRank = 4;
            }
            physFont = FontManager.registerFontFile(fcInfo.fontFile, null, fontFormat, true, fontRank);
        }
        return physFont;
    }

    private static String[] getPlatformFontDirs() {
        String path = FontManager.getFontPath(true);
        StringTokenizer parser = new StringTokenizer(path, File.pathSeparator);
        ArrayList<String> pathList = new ArrayList<String>();
        try {
            while (parser.hasMoreTokens()) {
                pathList.add(parser.nextToken());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return pathList.toArray(new String[0]);
    }

    public static String[] getDefaultPlatformFont() {
        if (defaultPlatformFont != null) {
            return defaultPlatformFont;
        }
        String[] info = new String[2];
        if (isWindows) {
            info[0] = "Arial";
            info[1] = "c:\\windows\\fonts";
            final String[] dirs = FontManager.getPlatformFontDirs();
            if (dirs.length > 1) {
                String dir = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        for (int i = 0; i < dirs.length; ++i) {
                            String path = dirs[i] + File.separator + "arial.ttf";
                            File file = new File(path);
                            if (!file.exists()) continue;
                            return dirs[i];
                        }
                        return null;
                    }
                });
                if (dir != null) {
                    info[1] = dir;
                }
            } else {
                info[1] = dirs[0];
            }
            info[1] = info[1] + File.separator + "arial.ttf";
        } else {
            FontManager.initFontConfigFonts();
            for (int i = 0; i < fontConfigFonts.length; ++i) {
                if (!"sans".equals(FontManager.fontConfigFonts[i].fcFamily) || 0 != FontManager.fontConfigFonts[i].style) continue;
                info[0] = FontManager.fontConfigFonts[i].familyName;
                info[1] = FontManager.fontConfigFonts[i].fontFile;
                break;
            }
            if (info[0] == null) {
                if (fontConfigFonts.length > 0 && FontManager.fontConfigFonts[0].fontFile != null) {
                    info[0] = FontManager.fontConfigFonts[0].familyName;
                    info[1] = FontManager.fontConfigFonts[0].fontFile;
                } else {
                    info[0] = "Dialog";
                    info[1] = "/dialog.ttf";
                }
            }
        }
        defaultPlatformFont = info;
        return defaultPlatformFont;
    }

    private FontConfigInfo getFontConfigInfo() {
        FontManager.initFontConfigFonts();
        for (int i = 0; i < fontConfigFonts.length; ++i) {
            if (!"sans".equals(FontManager.fontConfigFonts[i].fcFamily) || 0 != FontManager.fontConfigFonts[i].style) continue;
            return fontConfigFonts[i];
        }
        return null;
    }

    private static CompositeFont getFontConfigFont(String name, int style) {
        Font2D f2D;
        name = name.toLowerCase();
        FontManager.initFontConfigFonts();
        FontConfigInfo fcInfo = null;
        for (int i = 0; i < fontConfigFonts.length; ++i) {
            if (!name.equals(FontManager.fontConfigFonts[i].fcFamily) || style != FontManager.fontConfigFonts[i].style) continue;
            fcInfo = fontConfigFonts[i];
            break;
        }
        if (fcInfo == null) {
            fcInfo = fontConfigFonts[0];
        }
        if (logging) {
            logger.info("FC name=" + name + " style=" + style + " uses " + fcInfo.familyName + " in file: " + fcInfo.fontFile);
        }
        if (fcInfo.compFont != null) {
            return fcInfo.compFont;
        }
        CompositeFont jdkFont = (CompositeFont)FontManager.findFont2D(fcInfo.jdkName, style, 2);
        if (fcInfo.familyName == null || fcInfo.fontFile == null) {
            fcInfo.compFont = jdkFont;
            return fcInfo.compFont;
        }
        FontFamily family = FontFamily.getFamily(fcInfo.familyName);
        PhysicalFont physFont = null;
        if (family != null && (f2D = family.getFontWithExactStyleMatch(fcInfo.style)) instanceof PhysicalFont) {
            physFont = (PhysicalFont)f2D;
        }
        if (physFont == null || !fcInfo.fontFile.equals(physFont.platName)) {
            physFont = FontManager.registerFromFcInfo(fcInfo);
            if (physFont == null) {
                fcInfo.compFont = jdkFont;
                return fcInfo.compFont;
            }
            family = FontFamily.getFamily(physFont.getFamilyName(null));
        }
        for (int i = 0; i < fontConfigFonts.length; ++i) {
            FontConfigInfo fc = fontConfigFonts[i];
            if (fc == fcInfo || !physFont.getFamilyName(null).equals(fc.familyName) || fc.fontFile.equals(physFont.platName) || family.getFontWithExactStyleMatch(fc.style) != null) continue;
            FontManager.registerFromFcInfo(fontConfigFonts[i]);
        }
        fcInfo.compFont = new CompositeFont(physFont, jdkFont);
        return fcInfo.compFont;
    }

    public static FontUIResource getFontConfigFUIR(String fcFamily, int style, int size) {
        String mappedName = FontManager.mapFcName(fcFamily);
        if (mappedName == null) {
            mappedName = "sansserif";
        }
        if (isWindows) {
            return new FontUIResource(mappedName, style, size);
        }
        CompositeFont font2D = FontManager.getFontConfigFont(fcFamily, style);
        if (font2D == null) {
            return new FontUIResource(mappedName, style, size);
        }
        FontUIResource fuir = new FontUIResource(font2D.getFamilyName(null), style, size);
        FontManager.setFont2D(fuir, font2D.handle);
        FontManager.setCreatedFont(fuir);
        return fuir;
    }

    static boolean isComplexCharCode(int code) {
        if (code < 768 || code > 8303) {
            return false;
        }
        if (code <= 879) {
            return true;
        }
        if (code < 1424) {
            return false;
        }
        if (code <= 1791) {
            return true;
        }
        if (code < 2304) {
            return false;
        }
        if (code <= 3711) {
            return true;
        }
        if (code < 6016) {
            return false;
        }
        if (code <= 6143) {
            return true;
        }
        if (code < 8204) {
            return false;
        }
        if (code <= 8205) {
            return true;
        }
        if (code >= 8234 && code <= 8238) {
            return true;
        }
        return code >= 8298 && code <= 8303;
    }

    static boolean isNonSimpleChar(char ch) {
        return FontManager.isComplexCharCode(ch) || ch >= '\ud800' && ch <= '\udfff';
    }

    public static boolean isComplexText(char[] chs, int start, int limit) {
        for (int i = start; i < limit; ++i) {
            if (chs[i] < '\u0300' || !FontManager.isNonSimpleChar(chs[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean textLayoutIsCompatible(Font font) {
        Font2D font2D = FontManager.getFont2D(font);
        if (font2D instanceof TrueTypeFont) {
            TrueTypeFont ttf = (TrueTypeFont)font2D;
            return ttf.getDirectoryEntry(1196643650) == null || ttf.getDirectoryEntry(1196445523) != null;
        }
        return false;
    }

    public static synchronized FontScaler getNullScaler() {
        if (nullScaler == null) {
            nullScaler = new NullFontScaler();
        }
        return nullScaler;
    }

    public static FontScaler getScaler(Font2D font, int indexInCollection, boolean supportsCJK, int filesize) {
        FontScaler scaler = null;
        try {
            Object[] args = new Object[]{font, indexInCollection, supportsCJK, filesize};
            scaler = scalerConstructor.newInstance(args);
            Disposer.addObjectRecord(font, scaler);
        }
        catch (Throwable e) {
            scaler = nullScaler;
            FontManager.deRegisterBadFont(font);
        }
        return scaler;
    }

    static {
        usePlatformFontMetrics = false;
        logger = null;
        loaded1dot0Fonts = false;
        loadedAllFonts = false;
        loadedAllFontFiles = false;
        noOtherJREFontFiles = false;
        STR_ARRAY = new String[0];
        if (SunGraphicsEnvironment.debugFonts) {
            logger = Logger.getLogger("sun.java2d", null);
            logging = logger.getLevel() != Level.OFF;
        }
        FontManager.initJREFontMap();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                FontManagerNativeLibrary.load();
                FontManager.initIDs();
                switch (StrikeCache.nativeAddressSize) {
                    case 8: {
                        longAddresses = true;
                        break;
                    }
                    case 4: {
                        longAddresses = false;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unexpected address size");
                    }
                }
                osName = System.getProperty("os.name", "unknownOS");
                isSolaris = osName.startsWith("SunOS");
                if (isSolaris) {
                    String t2kStr = System.getProperty("sun.java2d.font.scaler");
                    useT2K = "t2k".equals(t2kStr);
                    String version = System.getProperty("os.version", "unk");
                    isSolaris8 = version.equals("5.8");
                    isSolaris9 = version.equals("5.9");
                } else {
                    isWindows = osName.startsWith("Windows");
                    if (isWindows) {
                        String prop;
                        String eudcFile = SunGraphicsEnvironment.eudcFontFileName;
                        if (eudcFile != null) {
                            try {
                                eudcFont = new TrueTypeFont(eudcFile, null, 0, true);
                            }
                            catch (FontFormatException e) {
                                // empty catch block
                            }
                        }
                        if ("true".equals(prop = System.getProperty("java2d.font.usePlatformFont")) || FontManager.getPlatformFontVar()) {
                            usePlatformFontMetrics = true;
                            System.out.println("Enabling platform font metrics for win32. This is an unsupported option.");
                            System.out.println("This yields incorrect composite font metrics as reported by 1.1.x releases.");
                            System.out.println("It is appropriate only for use by applications which do not use any Java 2");
                            System.out.println("functionality. This property will be removed in a later release.");
                        }
                    }
                }
                return null;
            }
        });
        deferredFontFiles = new ConcurrentHashMap();
        initialisedFonts = new ConcurrentHashMap();
        fontToFileMap = null;
        fontToFamilyNameMap = null;
        familyToFontListMap = null;
        pathDirs = null;
        fontNameCache = new ConcurrentHashMap();
        fileCloser = null;
        tmpFontFiles = null;
        altJAFontKey = new Object();
        localeFontKey = new Object();
        proportionalFontKey = new Object();
        usingPerAppContextComposites = false;
        usingAlternateComposites = false;
        gAltJAFont = false;
        gLocalePref = false;
        gPropPref = false;
        installedNames = null;
        regFamilyKey = new Object();
        regFullNameKey = new Object();
        fontsAreRegistered = false;
        fontsAreRegisteredPerAppContext = false;
        nameMap = new String[][]{{"sans", "sansserif"}, {"sans-serif", "sansserif"}, {"serif", "serif"}, {"monospace", "monospaced"}};
        fontConfigNames = new String[]{"sans:regular:roman", "sans:bold:roman", "sans:regular:italic", "sans:bold:italic", "serif:regular:roman", "serif:bold:roman", "serif:regular:italic", "serif:bold:italic", "monospace:regular:roman", "monospace:bold:roman", "monospace:regular:italic", "monospace:bold:italic"};
        defaultPlatformFont = null;
        nullScaler = null;
        scalerConstructor = null;
        Class scalerClass = null;
        Class[] arglst = new Class[]{Font2D.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE};
        try {
            scalerClass = SunGraphicsEnvironment.isOpenJDK() ? Class.forName("sun.font.FreetypeFontScaler") : Class.forName("sun.font.T2KFontScaler");
        }
        catch (ClassNotFoundException e) {
            scalerClass = NullFontScaler.class;
        }
        try {
            scalerConstructor = scalerClass.getConstructor(arglst);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    private static class FontConfigInfo {
        String fcName;
        String fcFamily;
        String jdkName;
        int style;
        String familyName;
        String fontFile;
        CompositeFont compFont;

        private FontConfigInfo() {
        }
    }

    private static final class FontRegistrationInfo {
        String fontFilePath;
        String[] nativeNames;
        int fontFormat;
        boolean javaRasterizer;
        int fontRank;

        FontRegistrationInfo(String fontPath, String[] names, int format, boolean useJavaRasterizer, int rank) {
            this.fontFilePath = fontPath;
            this.nativeNames = names;
            this.fontFormat = format;
            this.javaRasterizer = useJavaRasterizer;
            this.fontRank = rank;
        }
    }
}

