/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.image.ColorModel;
import sun.awt.X11ComponentPeer;
import sun.awt.image.SunVolatileImage;
import sun.awt.image.VolatileSurfaceManager;
import sun.java2d.SurfaceData;
import sun.java2d.opengl.GLXGraphicsConfig;
import sun.java2d.opengl.GLXSurfaceData;

public class GLXVolatileSurfaceManager
extends VolatileSurfaceManager {
    private boolean accelerationEnabled;

    public GLXVolatileSurfaceManager(SunVolatileImage vImg, Object context) {
        super(vImg, context);
        int transparency = vImg.getTransparency();
        GLXGraphicsConfig gc = (GLXGraphicsConfig)vImg.getGraphicsConfig();
        this.accelerationEnabled = transparency == 1 || transparency == 3 && (gc.isCapPresent(16) || gc.isCapPresent(2));
    }

    protected boolean isAccelerationEnabled() {
        return this.accelerationEnabled;
    }

    protected SurfaceData initAcceleratedSurface() {
        GLXSurfaceData.GLXOffScreenSurfaceData sData;
        Component comp = this.vImg.getComponent();
        X11ComponentPeer peer = comp != null ? (X11ComponentPeer)((Object)comp.getPeer()) : null;
        try {
            boolean forceback = false;
            if (this.context instanceof Boolean) {
                forceback = (Boolean)this.context;
            }
            if (forceback) {
                sData = GLXSurfaceData.createData(peer, this.vImg);
            } else {
                GLXGraphicsConfig gc = (GLXGraphicsConfig)this.vImg.getGraphicsConfig();
                ColorModel cm = gc.getColorModel(this.vImg.getTransparency());
                int type = gc.isCapPresent(16) ? 5 : 2;
                sData = GLXSurfaceData.createData(gc, this.vImg.getWidth(), this.vImg.getHeight(), cm, this.vImg, type);
            }
        }
        catch (NullPointerException ex) {
            sData = null;
        }
        catch (OutOfMemoryError er) {
            sData = null;
        }
        return sData;
    }

    protected boolean isConfigValid(GraphicsConfiguration gc) {
        return gc == null || gc == this.vImg.getGraphicsConfig();
    }
}

