/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.SortedSet;
import java.util.TreeSet;

public class GC {
    private static final long NO_TARGET = Long.MAX_VALUE;
    private static long latencyTarget = Long.MAX_VALUE;
    private static Thread daemon = null;
    private static Object lock = new LatencyLock();

    private GC() {
    }

    public static native long maxObjectInspectionAge();

    private static void setLatencyTarget(long ms) {
        latencyTarget = ms;
        if (daemon == null) {
            Daemon.create();
        } else {
            lock.notify();
        }
    }

    public static LatencyRequest requestLatency(long latency) {
        return new LatencyRequest(latency);
    }

    public static long currentLatencyTarget() {
        long t = latencyTarget;
        return t == Long.MAX_VALUE ? 0L : t;
    }

    public static class LatencyRequest
    implements Comparable {
        private static long counter = 0L;
        private static SortedSet requests = null;
        private long latency;
        private long id;

        private static void adjustLatencyIfNeeded() {
            if (requests == null || requests.isEmpty()) {
                if (latencyTarget != Long.MAX_VALUE) {
                    GC.setLatencyTarget(Long.MAX_VALUE);
                }
            } else {
                LatencyRequest r = (LatencyRequest)requests.first();
                if (r.latency != latencyTarget) {
                    GC.setLatencyTarget(r.latency);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LatencyRequest(long ms) {
            if (ms <= 0L) {
                throw new IllegalArgumentException("Non-positive latency: " + ms);
            }
            this.latency = ms;
            Object object = lock;
            synchronized (object) {
                this.id = ++counter;
                if (requests == null) {
                    requests = new TreeSet();
                }
                requests.add(this);
                LatencyRequest.adjustLatencyIfNeeded();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            Object object = lock;
            synchronized (object) {
                if (this.latency == Long.MAX_VALUE) {
                    throw new IllegalStateException("Request already cancelled");
                }
                if (!requests.remove(this)) {
                    throw new InternalError("Latency request " + this + " not found");
                }
                if (requests.isEmpty()) {
                    requests = null;
                }
                this.latency = Long.MAX_VALUE;
                LatencyRequest.adjustLatencyIfNeeded();
            }
        }

        public int compareTo(Object o) {
            LatencyRequest r = (LatencyRequest)o;
            long d = this.latency - r.latency;
            if (d == 0L) {
                d = this.id - r.id;
            }
            return d < 0L ? -1 : (d > 0L ? 1 : 0);
        }

        public String toString() {
            return LatencyRequest.class.getName() + "[" + this.latency + "," + this.id + "]";
        }
    }

    private static class Daemon
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Object object = lock;
                synchronized (object) {
                    long l = latencyTarget;
                    if (l == Long.MAX_VALUE) {
                        daemon = null;
                        return;
                    }
                    long d = GC.maxObjectInspectionAge();
                    if (d >= l) {
                        System.gc();
                        d = 0L;
                    }
                    try {
                        lock.wait(l - d);
                    }
                    catch (InterruptedException x) {
                    }
                }
            }
        }

        private Daemon(ThreadGroup tg) {
            super(tg, "GC Daemon");
        }

        public static void create() {
            PrivilegedAction pa = new PrivilegedAction(){

                public Object run() {
                    ThreadGroup tg;
                    ThreadGroup tgn = tg = Thread.currentThread().getThreadGroup();
                    while (tgn != null) {
                        tg = tgn;
                        tgn = tg.getParent();
                    }
                    Daemon d = new Daemon(tg);
                    d.setDaemon(true);
                    d.setPriority(2);
                    d.start();
                    daemon = d;
                    return null;
                }
            };
            AccessController.doPrivileged(pa);
        }
    }

    private static class LatencyLock {
        private LatencyLock() {
        }
    }
}

