/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.jar;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import sun.net.www.ParseUtil;
import sun.net.www.protocol.jar.URLJarFileCallBack;

public class URLJarFile
extends JarFile {
    private static URLJarFileCallBack callback = null;
    private URLJarFileCloseController closeController = null;
    private static int BUF_SIZE = 2048;
    private Manifest superMan;
    private Attributes superAttr;
    private Map superEntries;

    static JarFile getJarFile(URL url) throws IOException {
        return URLJarFile.getJarFile(url, null);
    }

    static JarFile getJarFile(URL url, URLJarFileCloseController closeController) throws IOException {
        if (URLJarFile.isFileURL(url)) {
            return new URLJarFile(url, closeController);
        }
        return URLJarFile.retrieve(url, closeController);
    }

    public URLJarFile(File file) throws IOException {
        this(file, null);
    }

    public URLJarFile(File file, URLJarFileCloseController closeController) throws IOException {
        super(file, true, 5);
        this.closeController = closeController;
    }

    private URLJarFile(URL url, URLJarFileCloseController closeController) throws IOException {
        super(ParseUtil.decode(url.getFile()));
        this.closeController = closeController;
    }

    private static boolean isFileURL(URL url) {
        String host;
        return url.getProtocol().equalsIgnoreCase("file") && ((host = url.getHost()) == null || host.equals("") || host.equals("~") || host.equalsIgnoreCase("localhost"));
    }

    protected void finalize() throws IOException {
        this.close();
    }

    public ZipEntry getEntry(String name) {
        ZipEntry ze = super.getEntry(name);
        if (ze != null) {
            if (ze instanceof JarEntry) {
                return new URLJarFileEntry((JarEntry)ze);
            }
            throw new InternalError(super.getClass() + " returned unexpected entry type " + ze.getClass());
        }
        return null;
    }

    public Manifest getManifest() throws IOException {
        if (!this.isSuperMan()) {
            return null;
        }
        Manifest man = new Manifest();
        Attributes attr = man.getMainAttributes();
        attr.putAll((Map<?, ?>)((Map)this.superAttr.clone()));
        if (this.superEntries != null) {
            Map<String, Attributes> entries = man.getEntries();
            for (Object key : this.superEntries.keySet()) {
                Attributes at = (Attributes)this.superEntries.get(key);
                entries.put((String)key, (Attributes)at.clone());
            }
        }
        return man;
    }

    public void close() throws IOException {
        if (this.closeController != null) {
            this.closeController.close(this);
        }
        super.close();
    }

    private synchronized boolean isSuperMan() throws IOException {
        if (this.superMan == null) {
            this.superMan = super.getManifest();
        }
        if (this.superMan != null) {
            this.superAttr = this.superMan.getMainAttributes();
            this.superEntries = this.superMan.getEntries();
            return true;
        }
        return false;
    }

    private static JarFile retrieve(URL url) throws IOException {
        return URLJarFile.retrieve(url, null);
    }

    private static JarFile retrieve(URL url, final URLJarFileCloseController closeController) throws IOException {
        if (callback != null) {
            return callback.retrieve(url);
        }
        JarFile result = null;
        final InputStream in = url.openConnection().getInputStream();
        try {
            result = (JarFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    URLJarFile uRLJarFile;
                    FileOutputStream out;
                    block8: {
                        out = null;
                        File tmpFile = null;
                        try {
                            tmpFile = File.createTempFile("jar_cache", null);
                            tmpFile.deleteOnExit();
                            out = new FileOutputStream(tmpFile);
                            int read = 0;
                            byte[] buf = new byte[BUF_SIZE];
                            while ((read = in.read(buf)) != -1) {
                                ((OutputStream)out).write(buf, 0, read);
                            }
                            ((OutputStream)out).close();
                            out = null;
                            uRLJarFile = new URLJarFile(tmpFile, closeController);
                            Object var7_7 = null;
                            if (in == null) break block8;
                        }
                        catch (IOException e) {
                            try {
                                if (tmpFile != null) {
                                    tmpFile.delete();
                                }
                                throw e;
                            }
                            catch (Throwable throwable) {
                                block9: {
                                    Object var7_8 = null;
                                    if (in != null) {
                                        in.close();
                                    }
                                    if (out == null) break block9;
                                    ((OutputStream)out).close();
                                }
                                throw throwable;
                            }
                        }
                        in.close();
                    }
                    if (out != null) {
                        ((OutputStream)out).close();
                    }
                    return uRLJarFile;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
        return result;
    }

    public static void setCallBack(URLJarFileCallBack cb) {
        callback = cb;
    }

    public static interface URLJarFileCloseController {
        public void close(JarFile var1);
    }

    private class URLJarFileEntry
    extends JarEntry {
        private JarEntry je;

        URLJarFileEntry(JarEntry je) {
            super(je);
            this.je = je;
        }

        public Attributes getAttributes() throws IOException {
            Attributes a;
            Map e;
            if (URLJarFile.this.isSuperMan() && (e = URLJarFile.this.superEntries) != null && (a = (Attributes)e.get(this.getName())) != null) {
                return (Attributes)a.clone();
            }
            return null;
        }

        public Certificate[] getCertificates() {
            Certificate[] certs = this.je.getCertificates();
            return certs == null ? null : (Certificate[])certs.clone();
        }

        public CodeSigner[] getCodeSigners() {
            CodeSigner[] csg = this.je.getCodeSigners();
            return csg == null ? null : (CodeSigner[])csg.clone();
        }
    }
}

