/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jca;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.ProviderException;
import sun.security.util.Debug;
import sun.security.util.PropertyExpander;

final class ProviderConfig {
    private static final Debug debug = Debug.getInstance("jca", "ProviderConfig");
    private static final String P11_SOL_NAME = "sun.security.pkcs11.SunPKCS11";
    private static final String P11_SOL_ARG = "${java.home}/lib/security/sunpkcs11-solaris.cfg";
    private static final int MAX_LOAD_TRIES = 30;
    private static final Class[] CL_STRING = new Class[]{String.class};
    private static volatile Object LOCK = new Object();
    private final String className;
    private final String argument;
    private int tries;
    private volatile Provider provider;
    private boolean isLoading;

    private static Object getLock() {
        Object o = LOCK;
        if (o instanceof ClassLoader) {
            return o;
        }
        Object cl = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return ClassLoader.getSystemClassLoader();
            }
        });
        if (cl != null) {
            LOCK = cl;
            o = cl;
        }
        return o;
    }

    ProviderConfig(String className, String argument) {
        if (className.equals(P11_SOL_NAME) && argument.equals(P11_SOL_ARG)) {
            this.checkSunPKCS11Solaris();
        }
        this.className = className;
        this.argument = ProviderConfig.expand(argument);
    }

    ProviderConfig(String className) {
        this(className, "");
    }

    ProviderConfig(Provider provider) {
        this.className = provider.getClass().getName();
        this.argument = "";
        this.provider = provider;
    }

    private void checkSunPKCS11Solaris() {
        Boolean o = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                File file = new File("/usr/lib/libpkcs11.so");
                if (!file.exists()) {
                    return Boolean.FALSE;
                }
                if ("false".equalsIgnoreCase(System.getProperty("sun.security.pkcs11.enable-solaris"))) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        if (o == Boolean.FALSE) {
            this.tries = 30;
        }
    }

    private boolean hasArgument() {
        return this.argument.length() != 0;
    }

    private boolean shouldLoad() {
        return this.tries < 30;
    }

    private void disableLoad() {
        this.tries = 30;
    }

    boolean isLoaded() {
        return this.provider != null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProviderConfig)) {
            return false;
        }
        ProviderConfig other = (ProviderConfig)obj;
        return this.className.equals(other.className) && this.argument.equals(other.argument);
    }

    public int hashCode() {
        return this.className.hashCode() + this.argument.hashCode();
    }

    public String toString() {
        if (this.hasArgument()) {
            return this.className + "('" + this.argument + "')";
        }
        return this.className;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Provider getProvider() {
        Provider p = this.provider;
        if (p != null) {
            return p;
        }
        if (!this.shouldLoad()) {
            return null;
        }
        Object object = ProviderConfig.getLock();
        synchronized (object) {
            p = this.provider;
            if (p != null) {
                return p;
            }
            if (this.isLoading) {
                if (debug != null) {
                    debug.println("Recursion loading provider: " + this);
                    new Exception("Call trace").printStackTrace();
                }
                return null;
            }
            try {
                this.isLoading = true;
                ++this.tries;
                p = this.doLoadProvider();
            }
            finally {
                this.isLoading = false;
            }
            this.provider = p;
        }
        return p;
    }

    private Provider doLoadProvider() {
        return AccessController.doPrivileged(new PrivilegedAction<Provider>(){

            @Override
            public Provider run() {
                if (debug != null) {
                    debug.println("Loading provider: " + ProviderConfig.this);
                }
                try {
                    Object obj;
                    ClassLoader cl = ClassLoader.getSystemClassLoader();
                    Class<?> provClass = cl != null ? cl.loadClass(ProviderConfig.this.className) : Class.forName(ProviderConfig.this.className);
                    if (!ProviderConfig.this.hasArgument()) {
                        obj = provClass.newInstance();
                    } else {
                        Constructor<?> cons = provClass.getConstructor(CL_STRING);
                        obj = cons.newInstance(ProviderConfig.this.argument);
                    }
                    if (obj instanceof Provider) {
                        if (debug != null) {
                            debug.println("Loaded provider " + obj);
                        }
                        return (Provider)obj;
                    }
                    if (debug != null) {
                        debug.println(ProviderConfig.this.className + " is not a provider");
                    }
                    ProviderConfig.this.disableLoad();
                    return null;
                }
                catch (Exception e) {
                    Throwable t = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getCause() : e;
                    if (debug != null) {
                        debug.println("Error loading provider " + ProviderConfig.this);
                        t.printStackTrace();
                    }
                    if (t instanceof ProviderException) {
                        throw (ProviderException)t;
                    }
                    if (t instanceof UnsupportedOperationException) {
                        ProviderConfig.this.disableLoad();
                    }
                    return null;
                }
            }
        });
    }

    private static String expand(final String value) {
        if (!value.contains("${")) {
            return value;
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                try {
                    return PropertyExpander.expand(value);
                }
                catch (GeneralSecurityException e) {
                    throw new ProviderException(e);
                }
            }
        });
    }
}

