/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.internal.LoginOptions;
import sun.security.krb5.internal.util.KerberosFlags;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;

public class TicketFlags
extends KerberosFlags {
    public TicketFlags() {
        super(32);
    }

    public TicketFlags(boolean[] flags) throws Asn1Exception {
        super(flags);
        if (flags.length > 32) {
            throw new Asn1Exception(502);
        }
    }

    public TicketFlags(int size, byte[] data) throws Asn1Exception {
        super(size, data);
        if (size > data.length * 8 || size > 32) {
            throw new Asn1Exception(502);
        }
    }

    public TicketFlags(DerValue encoding) throws IOException, Asn1Exception {
        this(encoding.getUnalignedBitString(true).toBooleanArray());
    }

    public static TicketFlags parse(DerInputStream data, byte explicitTag, boolean optional) throws Asn1Exception, IOException {
        if (optional && ((byte)data.peekByte() & 0x1F) != explicitTag) {
            return null;
        }
        DerValue der = data.getDerValue();
        if (explicitTag != (der.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue subDer = der.getData().getDerValue();
        return new TicketFlags(subDer);
    }

    public Object clone() {
        try {
            return new TicketFlags(this.toBooleanArray());
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean match(LoginOptions options) {
        boolean matched = false;
        if (this.get(1) == options.get(1) && this.get(3) == options.get(3) && this.get(8) == options.get(8)) {
            matched = true;
        }
        return matched;
    }

    public boolean match(TicketFlags flags) {
        boolean matched = true;
        for (int i = 0; i <= 31; ++i) {
            if (this.get(i) == flags.get(i)) continue;
            return false;
        }
        return matched;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        boolean[] flags = this.toBooleanArray();
        block14: for (int i = 0; i < flags.length; ++i) {
            if (!flags[i]) continue;
            switch (i) {
                case 0: {
                    sb.append("RESERVED;");
                    continue block14;
                }
                case 1: {
                    sb.append("FORWARDABLE;");
                    continue block14;
                }
                case 2: {
                    sb.append("FORWARDED;");
                    continue block14;
                }
                case 3: {
                    sb.append("PROXIABLE;");
                    continue block14;
                }
                case 4: {
                    sb.append("PROXY;");
                    continue block14;
                }
                case 5: {
                    sb.append("MAY-POSTDATE;");
                    continue block14;
                }
                case 6: {
                    sb.append("POSTDATED;");
                    continue block14;
                }
                case 7: {
                    sb.append("INVALID;");
                    continue block14;
                }
                case 8: {
                    sb.append("RENEWABLE;");
                    continue block14;
                }
                case 9: {
                    sb.append("INITIAL;");
                    continue block14;
                }
                case 10: {
                    sb.append("PRE-AUTHENT;");
                    continue block14;
                }
                case 11: {
                    sb.append("HW-AUTHENT;");
                }
            }
        }
        String result = sb.toString();
        if (result.length() > 0) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }
}

