/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URLClassLoader;
import java.security.Identity;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import sun.misc.BASE64Encoder;
import sun.security.pkcs.PKCS10;
import sun.security.provider.IdentityDatabase;
import sun.security.provider.SystemIdentity;
import sun.security.provider.SystemSigner;
import sun.security.tools.KeyStoreUtil;
import sun.security.tools.Pair;
import sun.security.util.DerOutputStream;
import sun.security.util.ObjectIdentifier;
import sun.security.util.Password;
import sun.security.util.PathList;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertAndKeyGen;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.Extension;
import sun.security.x509.X500Name;
import sun.security.x509.X500Signer;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KeyTool {
    private boolean debug = false;
    private int command = -1;
    private String sigAlgName = null;
    private String keyAlgName = null;
    private boolean verbose = false;
    private int keysize = -1;
    private boolean rfc = false;
    private long validity = 90L;
    private String alias = null;
    private String dname = null;
    private String dest = null;
    private String filename = null;
    private String srcksfname = null;
    private Set<Pair<String, String>> providers = null;
    private String storetype = null;
    private String srcProviderName = null;
    private String providerName = null;
    private String pathlist = null;
    private char[] storePass = null;
    private char[] storePassNew = null;
    private char[] keyPass = null;
    private char[] keyPassNew = null;
    private char[] oldPass = null;
    private char[] newPass = null;
    private char[] destKeyPass = null;
    private char[] srckeyPass = null;
    private String ksfname = null;
    private File ksfile = null;
    private InputStream ksStream = null;
    private KeyStore keyStore = null;
    private boolean token = false;
    private boolean nullStream = false;
    private boolean kssave = false;
    private boolean noprompt = false;
    private boolean trustcacerts = false;
    private boolean protectedPath = false;
    private boolean srcprotectedPath = false;
    private CertificateFactory cf = null;
    private KeyStore caks = null;
    private char[] srcstorePass = null;
    private String srcstoretype = null;
    private Set<char[]> passwords = new HashSet<char[]>();
    private String startDate = null;
    private static final int CERTREQ = 1;
    private static final int CHANGEALIAS = 2;
    private static final int DELETE = 3;
    private static final int EXPORTCERT = 4;
    private static final int GENKEYPAIR = 5;
    private static final int GENSECKEY = 6;
    private static final int IDENTITYDB = 7;
    private static final int IMPORTCERT = 8;
    private static final int IMPORTKEYSTORE = 9;
    private static final int KEYCLONE = 10;
    private static final int KEYPASSWD = 11;
    private static final int LIST = 12;
    private static final int PRINTCERT = 13;
    private static final int SELFCERT = 14;
    private static final int STOREPASSWD = 15;
    private static final Class[] PARAM_STRING = new Class[]{String.class};
    private static final String JKS = "jks";
    private static final String NONE = "NONE";
    private static final String P11KEYSTORE = "PKCS11";
    private static final String P12KEYSTORE = "PKCS12";
    private final String keyAlias = "mykey";
    private static final ResourceBundle rb = ResourceBundle.getBundle("sun.security.util.Resources");
    private static final Collator collator = Collator.getInstance();

    private KeyTool() {
    }

    public static void main(String[] args) throws Exception {
        KeyTool kt = new KeyTool();
        kt.run(args, System.out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(String[] args, PrintStream out) throws Exception {
        block9: {
            try {
                this.parseArgs(args);
                this.doCommands(out);
            }
            catch (Exception e) {
                System.out.println(rb.getString("keytool error: ") + e);
                if (this.verbose) {
                    e.printStackTrace(System.out);
                }
                if (!this.debug) {
                    System.exit(1);
                    break block9;
                }
                throw e;
            }
            finally {
                for (char[] pass : this.passwords) {
                    if (pass == null) continue;
                    Arrays.fill(pass, ' ');
                    pass = null;
                }
                if (this.ksStream != null) {
                    this.ksStream.close();
                }
            }
        }
    }

    void parseArgs(String[] args) {
        if (args.length == 0) {
            this.usage();
        }
        int i = 0;
        for (i = 0; i < args.length && args[i].startsWith("-"); ++i) {
            String flags = args[i];
            if (collator.compare(flags, "-certreq") == 0) {
                this.command = 1;
                continue;
            }
            if (collator.compare(flags, "-delete") == 0) {
                this.command = 3;
                continue;
            }
            if (collator.compare(flags, "-export") == 0 || collator.compare(flags, "-exportcert") == 0) {
                this.command = 4;
                continue;
            }
            if (collator.compare(flags, "-genkey") == 0 || collator.compare(flags, "-genkeypair") == 0) {
                this.command = 5;
                continue;
            }
            if (collator.compare(flags, "-help") == 0) {
                this.usage();
                return;
            }
            if (collator.compare(flags, "-identitydb") == 0) {
                this.command = 7;
                continue;
            }
            if (collator.compare(flags, "-import") == 0 || collator.compare(flags, "-importcert") == 0) {
                this.command = 8;
                continue;
            }
            if (collator.compare(flags, "-keyclone") == 0) {
                this.command = 10;
                continue;
            }
            if (collator.compare(flags, "-changealias") == 0) {
                this.command = 2;
                continue;
            }
            if (collator.compare(flags, "-keypasswd") == 0) {
                this.command = 11;
                continue;
            }
            if (collator.compare(flags, "-list") == 0) {
                this.command = 12;
                continue;
            }
            if (collator.compare(flags, "-printcert") == 0) {
                this.command = 13;
                continue;
            }
            if (collator.compare(flags, "-selfcert") == 0) {
                this.command = 14;
                continue;
            }
            if (collator.compare(flags, "-storepasswd") == 0) {
                this.command = 15;
                continue;
            }
            if (collator.compare(flags, "-importkeystore") == 0) {
                this.command = 9;
                continue;
            }
            if (collator.compare(flags, "-genseckey") == 0) {
                this.command = 6;
                continue;
            }
            if (collator.compare(flags, "-keystore") == 0 || collator.compare(flags, "-destkeystore") == 0) {
                if (++i == args.length) {
                    this.errorNeedArgument(flags);
                }
                this.ksfname = args[i];
                continue;
            }
            if (collator.compare(flags, "-storepass") == 0 || collator.compare(flags, "-deststorepass") == 0) {
                if (++i == args.length) {
                    this.errorNeedArgument(flags);
                }
                this.storePass = args[i].toCharArray();
                this.passwords.add(this.storePass);
                continue;
            }
            if (collator.compare(flags, "-storetype") == 0 || collator.compare(flags, "-deststoretype") == 0) {
                if (++i == args.length) {
                    this.errorNeedArgument(flags);
                }
                this.storetype = args[i];
                continue;
            }
            if (collator.compare(flags, "-srcstorepass") == 0) {
                if (++i == args.length) {
                    this.errorNeedArgument(flags);
                }
                this.srcstorePass = args[i].toCharArray();
                this.passwords.add(this.srcstorePass);
                continue;
            }
            if (collator.compare(flags, "-srcstoretype") == 0) {
                if (++i == args.length) {
                    this.errorNeedArgument(flags);
                }
                this.srcstoretype = args[i];
                continue;
            }
            if (collator.compare(flags, "-srckeypass") == 0) {
                if (++i == args.length) {
                    this.errorNeedArgument(flags);
                }
                this.srckeyPass = args[i].toCharArray();
                this.passwords.add(this.srckeyPass);
                continue;
            }
            if (collator.compare(flags, "-srcprovidername") == 0) {
                if (++i == args.length) {
                    this.errorNeedArgument(flags);
                }
                this.srcProviderName = args[i];
                continue;
            }
            if (collator.compare(flags, "-providername") == 0 || collator.compare(flags, "-destprovidername") == 0) {
                if (++i == args.length) {
                    this.errorNeedArgument(flags);
                }
                this.providerName = args[i];
                continue;
            }
            if (collator.compare(flags, "-providerpath") == 0) {
                if (++i == args.length) {
                    this.errorNeedArgument(flags);
                }
                this.pathlist = args[i];
                continue;
            }
            if (collator.compare(flags, "-keypass") == 0) {
                if (++i == args.length) {
                    this.errorNeedArgument(flags);
                }
                this.keyPass = args[i].toCharArray();
                this.passwords.add(this.keyPass);
                continue;
            }
            if (collator.compare(flags, "-new") == 0) {
                if (++i == args.length) {
                    this.errorNeedArgument(flags);
                }
                this.newPass = args[i].toCharArray();
                this.passwords.add(this.newPass);
                continue;
            }
            if (collator.compare(flags, "-destkeypass") == 0) {
                if (++i == args.length) {
                    this.errorNeedArgument(flags);
                }
                this.destKeyPass = args[i].toCharArray();
                this.passwords.add(this.destKeyPass);
                continue;
            }
            if (collator.compare(flags, "-alias") == 0 || collator.compare(flags, "-srcalias") == 0) {
                if (++i == args.length) {
                    this.errorNeedArgument(flags);
                }
                this.alias = args[i];
                continue;
            }
            if (collator.compare(flags, "-dest") == 0 || collator.compare(flags, "-destalias") == 0) {
                if (++i == args.length) {
                    this.errorNeedArgument(flags);
                }
                this.dest = args[i];
                continue;
            }
            if (collator.compare(flags, "-dname") == 0) {
                if (++i == args.length) {
                    this.errorNeedArgument(flags);
                }
                this.dname = args[i];
                continue;
            }
            if (collator.compare(flags, "-keysize") == 0) {
                if (++i == args.length) {
                    this.errorNeedArgument(flags);
                }
                this.keysize = Integer.parseInt(args[i]);
                continue;
            }
            if (collator.compare(flags, "-keyalg") == 0) {
                if (++i == args.length) {
                    this.errorNeedArgument(flags);
                }
                this.keyAlgName = args[i];
                continue;
            }
            if (collator.compare(flags, "-sigalg") == 0) {
                if (++i == args.length) {
                    this.errorNeedArgument(flags);
                }
                this.sigAlgName = args[i];
                continue;
            }
            if (collator.compare(flags, "-startdate") == 0) {
                if (++i == args.length) {
                    this.errorNeedArgument(flags);
                }
                this.startDate = args[i];
                continue;
            }
            if (collator.compare(flags, "-validity") == 0) {
                if (++i == args.length) {
                    this.errorNeedArgument(flags);
                }
                this.validity = Long.parseLong(args[i]);
                continue;
            }
            if (collator.compare(flags, "-file") == 0) {
                if (++i == args.length) {
                    this.errorNeedArgument(flags);
                }
                this.filename = args[i];
                continue;
            }
            if (collator.compare(flags, "-srckeystore") == 0) {
                if (++i == args.length) {
                    this.errorNeedArgument(flags);
                }
                this.srcksfname = args[i];
                continue;
            }
            if (collator.compare(flags, "-provider") == 0 || collator.compare(flags, "-providerclass") == 0) {
                if (++i == args.length) {
                    this.errorNeedArgument(flags);
                }
                if (this.providers == null) {
                    this.providers = new HashSet<Pair<String, String>>(3);
                }
                String providerClass = args[i];
                String providerArg = null;
                if (args.length > i + 1 && collator.compare(flags = args[i + 1], "-providerarg") == 0) {
                    if (args.length == i + 2) {
                        this.errorNeedArgument(flags);
                    }
                    providerArg = args[i + 2];
                    i += 2;
                }
                this.providers.add(new Pair<String, Object>(providerClass, providerArg));
                continue;
            }
            if (collator.compare(flags, "-v") == 0) {
                this.verbose = true;
                continue;
            }
            if (collator.compare(flags, "-debug") == 0) {
                this.debug = true;
                continue;
            }
            if (collator.compare(flags, "-rfc") == 0) {
                this.rfc = true;
                continue;
            }
            if (collator.compare(flags, "-noprompt") == 0) {
                this.noprompt = true;
                continue;
            }
            if (collator.compare(flags, "-trustcacerts") == 0) {
                this.trustcacerts = true;
                continue;
            }
            if (collator.compare(flags, "-protected") == 0 || collator.compare(flags, "-destprotected") == 0) {
                this.protectedPath = true;
                continue;
            }
            if (collator.compare(flags, "-srcprotected") == 0) {
                this.srcprotectedPath = true;
                continue;
            }
            System.err.println(rb.getString("Illegal option:  ") + flags);
            this.tinyHelp();
        }
        if (i < args.length) {
            MessageFormat form = new MessageFormat(rb.getString("Usage error, <arg> is not a legal command"));
            Object[] source = new Object[]{args[i]};
            throw new RuntimeException(form.format(source));
        }
        if (this.command == -1) {
            System.err.println(rb.getString("Usage error: no command provided"));
            this.tinyHelp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void doCommands(PrintStream out) throws Exception {
        block137: {
            if (this.storetype == null) {
                this.storetype = KeyStore.getDefaultType();
            }
            this.storetype = KeyStoreUtil.niceStoreTypeName(this.storetype);
            if (this.srcstoretype == null) {
                this.srcstoretype = KeyStore.getDefaultType();
            }
            this.srcstoretype = KeyStoreUtil.niceStoreTypeName(this.srcstoretype);
            if ("PKCS11".equalsIgnoreCase(this.storetype) || KeyStoreUtil.isWindowsKeyStore(this.storetype)) {
                this.token = true;
                if (this.ksfname == null) {
                    this.ksfname = "NONE";
                }
            }
            if ("NONE".equals(this.ksfname)) {
                this.nullStream = true;
            }
            if (this.token && !this.nullStream) {
                System.err.println(MessageFormat.format(KeyTool.rb.getString("-keystore must be NONE if -storetype is {0}"), new Object[]{this.storetype}));
                System.err.println();
                this.tinyHelp();
            }
            if (this.token && (this.command == 11 || this.command == 15)) {
                throw new UnsupportedOperationException(MessageFormat.format(KeyTool.rb.getString("-storepasswd and -keypasswd commands not supported if -storetype is {0}"), new Object[]{this.storetype}));
            }
            if ("PKCS12".equalsIgnoreCase(this.storetype) && this.command == 11) {
                throw new UnsupportedOperationException(KeyTool.rb.getString("-keypasswd commands not supported if -storetype is PKCS12"));
            }
            if (this.token && (this.keyPass != null || this.newPass != null || this.destKeyPass != null)) {
                throw new IllegalArgumentException(MessageFormat.format(KeyTool.rb.getString("-keypass and -new can not be specified if -storetype is {0}"), new Object[]{this.storetype}));
            }
            if (this.protectedPath && (this.storePass != null || this.keyPass != null || this.newPass != null || this.destKeyPass != null)) {
                throw new IllegalArgumentException(KeyTool.rb.getString("if -protected is specified, then -storepass, -keypass, and -new must not be specified"));
            }
            if (this.srcprotectedPath && (this.srcstorePass != null || this.srckeyPass != null)) {
                throw new IllegalArgumentException(KeyTool.rb.getString("if -srcprotected is specified, then -srcstorepass and -srckeypass must not be specified"));
            }
            if (KeyStoreUtil.isWindowsKeyStore(this.storetype) && (this.storePass != null || this.keyPass != null || this.newPass != null || this.destKeyPass != null)) {
                throw new IllegalArgumentException(KeyTool.rb.getString("if keystore is not password protected, then -storepass, -keypass, and -new must not be specified"));
            }
            if (KeyStoreUtil.isWindowsKeyStore(this.srcstoretype) && (this.srcstorePass != null || this.srckeyPass != null)) {
                throw new IllegalArgumentException(KeyTool.rb.getString("if source keystore is not password protected, then -srcstorepass and -srckeypass must not be specified"));
            }
            if (this.validity <= 0L) {
                throw new Exception(KeyTool.rb.getString("Validity must be greater than zero"));
            }
            if (this.providers != null) {
                cl = null;
                if (this.pathlist != null) {
                    path = null;
                    path = PathList.appendPath(path, System.getProperty("java.class.path"));
                    path = PathList.appendPath(path, System.getProperty("env.class.path"));
                    path = PathList.appendPath(path, this.pathlist);
                    urls = PathList.pathToURLs(path);
                    cl = new URLClassLoader(urls);
                } else {
                    cl = ClassLoader.getSystemClassLoader();
                }
                for (Pair<String, String> provider : this.providers) {
                    provName = (String)provider.fst;
                    provClass = cl != null ? cl.loadClass(provName) : Class.forName(provName);
                    provArg = (String)provider.snd;
                    if (provArg == null) {
                        obj = provClass.newInstance();
                    } else {
                        c = provClass.getConstructor(KeyTool.PARAM_STRING);
                        obj = c.newInstance(new Object[]{provArg});
                    }
                    if (!(obj instanceof Provider)) {
                        form = new MessageFormat(KeyTool.rb.getString("provName not a provider"));
                        source = new Object[]{provName};
                        throw new Exception(form.format(source));
                    }
                    Security.addProvider((Provider)obj);
                }
            }
            if (this.command == 12 && this.verbose && this.rfc) {
                System.err.println(KeyTool.rb.getString("Must not specify both -v and -rfc with 'list' command"));
                this.tinyHelp();
            }
            if (this.command == 5 && this.keyPass != null && this.keyPass.length < 6) {
                throw new Exception(KeyTool.rb.getString("Key password must be at least 6 characters"));
            }
            if (this.newPass != null && this.newPass.length < 6) {
                throw new Exception(KeyTool.rb.getString("New password must be at least 6 characters"));
            }
            if (this.destKeyPass != null && this.destKeyPass.length < 6) {
                throw new Exception(KeyTool.rb.getString("New password must be at least 6 characters"));
            }
            if (this.command != 13) {
                if (this.ksfname == null) {
                    this.ksfname = System.getProperty("user.home") + File.separator + ".keystore";
                }
                if (!this.nullStream) {
                    try {
                        this.ksfile = new File(this.ksfname);
                        if (this.ksfile.exists() && this.ksfile.length() == 0L) {
                            throw new Exception(KeyTool.rb.getString("Keystore file exists, but is empty: ") + this.ksfname);
                        }
                        this.ksStream = new FileInputStream(this.ksfile);
                    }
                    catch (FileNotFoundException e) {
                        if (this.command == 5 || this.command == 6 || this.command == 7 || this.command == 8 || this.command == 9) break block137;
                        throw new Exception(KeyTool.rb.getString("Keystore file does not exist: ") + this.ksfname);
                    }
                }
            }
        }
        if ((this.command == 10 || this.command == 2) && this.dest == null) {
            this.dest = this.getAlias("destination");
            if ("".equals(this.dest)) {
                throw new Exception(KeyTool.rb.getString("Must specify destination alias"));
            }
        }
        if (this.command == 3 && this.alias == null) {
            this.alias = this.getAlias(null);
            if ("".equals(this.alias)) {
                throw new Exception(KeyTool.rb.getString("Must specify alias"));
            }
        }
        this.keyStore = this.providerName == null ? KeyStore.getInstance(this.storetype) : KeyStore.getInstance(this.storetype, this.providerName);
        if (!this.nullStream) {
            this.keyStore.load(this.ksStream, this.storePass);
            if (this.ksStream != null) {
                this.ksStream.close();
            }
        }
        if (this.nullStream && this.storePass != null) {
            this.keyStore.load(null, this.storePass);
        } else if (!this.nullStream && this.storePass != null) {
            if (this.ksStream == null && this.storePass.length < 6) {
                throw new Exception(KeyTool.rb.getString("Keystore password must be at least 6 characters"));
            }
        } else if (this.storePass == null) {
            if (!(this.protectedPath || KeyStoreUtil.isWindowsKeyStore(this.storetype) || this.command != 1 && this.command != 3 && this.command != 5 && this.command != 6 && this.command != 8 && this.command != 9 && this.command != 10 && this.command != 2 && this.command != 14 && this.command != 15 && this.command != 11 && this.command != 7)) {
                count = 0;
                do {
                    if (this.command == 9) {
                        System.err.print(KeyTool.rb.getString("Enter destination keystore password:  "));
                    } else {
                        System.err.print(KeyTool.rb.getString("Enter keystore password:  "));
                    }
                    System.err.flush();
                    this.storePass = Password.readPassword(System.in);
                    this.passwords.add(this.storePass);
                    if (!(this.nullStream || this.storePass != null && this.storePass.length >= 6)) {
                        System.err.println(KeyTool.rb.getString("Keystore password is too short - must be at least 6 characters"));
                        this.storePass = null;
                    }
                    if (this.storePass == null || this.nullStream || this.ksStream != null) continue;
                    System.err.print(KeyTool.rb.getString("Re-enter new password: "));
                    storePassAgain = Password.readPassword(System.in);
                    this.passwords.add(storePassAgain);
                    if (Arrays.equals(this.storePass, storePassAgain)) continue;
                    System.err.println(KeyTool.rb.getString("They don't match. Try again"));
                    this.storePass = null;
                } while (this.storePass == null && ++count < 3);
                if (this.storePass == null) {
                    System.err.println(KeyTool.rb.getString("Too many failures - try later"));
                    return;
                }
            } else if (!this.protectedPath && !KeyStoreUtil.isWindowsKeyStore(this.storetype) && this.command != 13) {
                System.err.print(KeyTool.rb.getString("Enter keystore password:  "));
                System.err.flush();
                this.storePass = Password.readPassword(System.in);
                this.passwords.add(this.storePass);
            }
            if (this.nullStream) {
                this.keyStore.load(null, this.storePass);
            } else if (this.ksStream != null) {
                this.ksStream = new FileInputStream(this.ksfile);
                this.keyStore.load(this.ksStream, this.storePass);
                this.ksStream.close();
            }
        }
        if (this.storePass != null && "PKCS12".equalsIgnoreCase(this.storetype)) {
            form = new MessageFormat(KeyTool.rb.getString("Warning:  Different store and key passwords not supported for PKCS12 KeyStores. Ignoring user-specified <command> value."));
            if (this.keyPass != null && !Arrays.equals(this.storePass, this.keyPass)) {
                source = new Object[]{"-keypass"};
                System.err.println(form.format(source));
                this.keyPass = this.storePass;
            }
            if (this.newPass != null && !Arrays.equals(this.storePass, this.newPass)) {
                source = new Object[]{"-new"};
                System.err.println(form.format(source));
                this.newPass = this.storePass;
            }
            if (this.destKeyPass != null && !Arrays.equals(this.storePass, this.destKeyPass)) {
                source = new Object[]{"-destkeypass"};
                System.err.println(form.format(source));
                this.destKeyPass = this.storePass;
            }
        }
        if (this.command == 13 || this.command == 8 || this.command == 7) {
            this.cf = CertificateFactory.getInstance("X509");
        }
        if (this.trustcacerts) {
            this.caks = this.getCacertsKeyStore();
        }
        if (this.command == 1) {
            ps = null;
            if (this.filename != null) {
                out = ps = new PrintStream(new FileOutputStream(this.filename));
            }
            try {
                this.doCertReq(this.alias, this.sigAlgName, out);
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            if (this.verbose && this.filename != null) {
                form = new MessageFormat(KeyTool.rb.getString("Certification request stored in file <filename>"));
                source = new Object[]{this.filename};
                System.err.println(form.format(source));
                System.err.println(KeyTool.rb.getString("Submit this to your CA"));
            }
        } else if (this.command == 3) {
            this.doDeleteEntry(this.alias);
            this.kssave = true;
        } else if (this.command == 4) {
            ps = null;
            if (this.filename != null) {
                out = ps = new PrintStream(new FileOutputStream(this.filename));
            }
            try {
                this.doExportCert(this.alias, out);
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            if (this.filename != null) {
                form = new MessageFormat(KeyTool.rb.getString("Certificate stored in file <filename>"));
                source = new Object[]{this.filename};
                System.err.println(form.format(source));
            }
        } else if (this.command == 5) {
            if (this.keyAlgName == null) {
                this.keyAlgName = "DSA";
            }
            this.doGenKeyPair(this.alias, this.dname, this.keyAlgName, this.keysize, this.sigAlgName);
            this.kssave = true;
        } else if (this.command == 6) {
            if (this.keyAlgName == null) {
                this.keyAlgName = "DES";
            }
            this.doGenSecretKey(this.alias, this.keyAlgName, this.keysize);
            this.kssave = true;
        } else if (this.command == 7) {
            inStream = System.in;
            if (this.filename != null) {
                inStream = new FileInputStream(this.filename);
            }
            try {
                this.doImportIdentityDatabase(inStream);
            }
            finally {
                if (inStream != System.in) {
                    inStream.close();
                }
            }
        } else if (this.command == 8) {
            inStream = System.in;
            if (this.filename != null) {
                inStream = new FileInputStream(this.filename);
            }
            try {
                v0 = importAlias = this.alias != null ? this.alias : "mykey";
                if (this.keyStore.entryInstanceOf(importAlias, KeyStore.PrivateKeyEntry.class)) {
                    this.kssave = this.installReply(importAlias, inStream);
                    if (this.kssave) {
                        System.err.println(KeyTool.rb.getString("Certificate reply was installed in keystore"));
                    }
                    System.err.println(KeyTool.rb.getString("Certificate reply was not installed in keystore"));
                }
                if (this.keyStore.containsAlias(importAlias) && !this.keyStore.entryInstanceOf(importAlias, KeyStore.TrustedCertificateEntry.class)) ** GOTO lbl306
                this.kssave = this.addTrustedCert(importAlias, inStream);
                if (this.kssave) {
                    System.err.println(KeyTool.rb.getString("Certificate was added to keystore"));
                }
                System.err.println(KeyTool.rb.getString("Certificate was not added to keystore"));
            }
            finally {
                if (inStream != System.in) {
                    inStream.close();
                }
            }
        } else if (this.command == 9) {
            this.doImportKeyStore();
            this.kssave = true;
        } else if (this.command == 10) {
            this.keyPassNew = this.newPass;
            if (this.alias == null) {
                this.alias = "mykey";
            }
            if (!this.keyStore.containsAlias(this.alias)) {
                form = new MessageFormat(KeyTool.rb.getString("Alias <alias> does not exist"));
                source = new Object[]{this.alias};
                throw new Exception(form.format(source));
            }
            if (!this.keyStore.entryInstanceOf(this.alias, KeyStore.PrivateKeyEntry.class)) {
                form = new MessageFormat(KeyTool.rb.getString("Alias <alias> references an entry type that is not a private key entry.  The -keyclone command only supports cloning of private key entries"));
                source = new Object[]{this.alias};
                throw new Exception(form.format(source));
            }
            this.doCloneEntry(this.alias, this.dest, true);
            this.kssave = true;
        } else if (this.command == 2) {
            if (this.alias == null) {
                this.alias = "mykey";
            }
            this.doCloneEntry(this.alias, this.dest, false);
            if (this.keyStore.containsAlias(this.alias)) {
                this.doDeleteEntry(this.alias);
            }
            this.kssave = true;
        } else if (this.command == 11) {
            this.keyPassNew = this.newPass;
            this.doChangeKeyPasswd(this.alias);
            this.kssave = true;
        } else if (this.command == 12) {
            if (this.alias != null) {
                this.doPrintEntry(this.alias, out, true);
            } else {
                this.doPrintEntries(out);
            }
        } else if (this.command == 13) {
            inStream = System.in;
            if (this.filename != null) {
                inStream = new FileInputStream(this.filename);
            }
            try {
                this.doPrintCert(inStream, out);
            }
            finally {
                if (inStream != System.in) {
                    inStream.close();
                }
            }
        } else if (this.command == 14) {
            this.doSelfCert(this.alias, this.dname, this.sigAlgName);
            this.kssave = true;
        } else if (this.command == 15) {
            this.storePassNew = this.newPass;
            if (this.storePassNew == null) {
                this.storePassNew = this.getNewPasswd("keystore password", this.storePass);
            }
            this.kssave = true;
        }
lbl306:
        // 22 sources

        if (this.kssave) {
            if (this.verbose) {
                form = new MessageFormat(KeyTool.rb.getString("[Storing ksfname]"));
                source = new Object[]{this.nullStream != false ? "keystore" : this.ksfname};
                System.err.println(form.format(source));
            }
            if (this.token) {
                this.keyStore.store(null, null);
            } else {
                fout = null;
                try {
                    fout = this.nullStream != false ? (FileOutputStream)null : new FileOutputStream(this.ksfname);
                    this.keyStore.store(fout, this.storePassNew != null ? this.storePassNew : this.storePass);
                }
                finally {
                    if (fout != null) {
                        fout.close();
                    }
                }
            }
        }
    }

    private void doCertReq(String alias, String sigAlgName, PrintStream out) throws Exception {
        Certificate cert;
        if (alias == null) {
            alias = "mykey";
        }
        Object[] objs = this.recoverKey(alias, this.storePass, this.keyPass);
        PrivateKey privKey = (PrivateKey)objs[0];
        if (this.keyPass == null) {
            this.keyPass = (char[])objs[1];
        }
        if ((cert = this.keyStore.getCertificate(alias)) == null) {
            MessageFormat form = new MessageFormat(rb.getString("alias has no public key (certificate)"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        PKCS10 request = new PKCS10(cert.getPublicKey());
        if (sigAlgName == null) {
            String keyAlgName = privKey.getAlgorithm();
            if ("DSA".equalsIgnoreCase(keyAlgName) || "DSS".equalsIgnoreCase(keyAlgName)) {
                sigAlgName = "SHA1WithDSA";
            } else if ("RSA".equalsIgnoreCase(keyAlgName)) {
                sigAlgName = "SHA1WithRSA";
            } else {
                throw new Exception(rb.getString("Cannot derive signature algorithm"));
            }
        }
        Signature signature = Signature.getInstance(sigAlgName);
        signature.initSign(privKey);
        X500Name subject = new X500Name(((Object)((X509Certificate)cert).getSubjectDN()).toString());
        X500Signer signer = new X500Signer(signature, subject);
        request.encodeAndSign(signer);
        request.print(out);
    }

    private void doDeleteEntry(String alias) throws Exception {
        if (!this.keyStore.containsAlias(alias)) {
            MessageFormat form = new MessageFormat(rb.getString("Alias <alias> does not exist"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        this.keyStore.deleteEntry(alias);
    }

    private void doExportCert(String alias, PrintStream out) throws Exception {
        if (this.storePass == null && !KeyStoreUtil.isWindowsKeyStore(this.storetype)) {
            this.printWarning();
        }
        if (alias == null) {
            alias = "mykey";
        }
        if (!this.keyStore.containsAlias(alias)) {
            MessageFormat form = new MessageFormat(rb.getString("Alias <alias> does not exist"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        X509Certificate cert = (X509Certificate)this.keyStore.getCertificate(alias);
        if (cert == null) {
            MessageFormat form = new MessageFormat(rb.getString("Alias <alias> has no certificate"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        this.dumpCert(cert, out);
    }

    private char[] promptForKeyPass(String alias, String orig, char[] origPass) throws Exception {
        if (P12KEYSTORE.equalsIgnoreCase(this.storetype)) {
            return origPass;
        }
        if (!this.token) {
            int count;
            for (count = 0; count < 3; ++count) {
                MessageFormat form = new MessageFormat(rb.getString("Enter key password for <alias>"));
                Object[] source = new Object[]{alias};
                System.err.println(form.format(source));
                if (orig == null) {
                    System.err.print(rb.getString("\t(RETURN if same as keystore password):  "));
                } else {
                    form = new MessageFormat(rb.getString("\t(RETURN if same as for <otherAlias>)"));
                    Object[] src = new Object[]{orig};
                    System.err.print(form.format(src));
                }
                System.err.flush();
                char[] entered = Password.readPassword(System.in);
                this.passwords.add(entered);
                if (entered == null) {
                    return origPass;
                }
                if (entered.length >= 6) {
                    System.err.print(rb.getString("Re-enter new password: "));
                    char[] passAgain = Password.readPassword(System.in);
                    this.passwords.add(passAgain);
                    if (!Arrays.equals(entered, passAgain)) {
                        System.err.println(rb.getString("They don't match. Try again"));
                        continue;
                    }
                    return entered;
                }
                System.err.println(rb.getString("Key password is too short - must be at least 6 characters"));
            }
            if (count == 3) {
                if (this.command == 10) {
                    throw new Exception(rb.getString("Too many failures. Key entry not cloned"));
                }
                throw new Exception(rb.getString("Too many failures - key not added to keystore"));
            }
        }
        return null;
    }

    private void doGenSecretKey(String alias, String keyAlgName, int keysize) throws Exception {
        if (alias == null) {
            alias = "mykey";
        }
        if (this.keyStore.containsAlias(alias)) {
            MessageFormat form = new MessageFormat(rb.getString("Secret key not generated, alias <alias> already exists"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        SecretKey secKey = null;
        KeyGenerator keygen = KeyGenerator.getInstance(keyAlgName);
        if (keysize != -1) {
            keygen.init(keysize);
        } else if ("DES".equalsIgnoreCase(keyAlgName)) {
            keygen.init(56);
        } else if ("DESede".equalsIgnoreCase(keyAlgName)) {
            keygen.init(168);
        } else {
            throw new Exception(rb.getString("Please provide -keysize for secret key generation"));
        }
        secKey = keygen.generateKey();
        if (this.keyPass == null) {
            this.keyPass = this.promptForKeyPass(alias, null, this.storePass);
        }
        this.keyStore.setKeyEntry(alias, secKey, this.keyPass, null);
    }

    private void doGenKeyPair(String alias, String dname, String keyAlgName, int keysize, String sigAlgName) throws Exception {
        if (keysize == -1) {
            keysize = "EC".equalsIgnoreCase(keyAlgName) ? 256 : 1024;
        }
        if (alias == null) {
            alias = "mykey";
        }
        if (this.keyStore.containsAlias(alias)) {
            MessageFormat form = new MessageFormat(rb.getString("Key pair not generated, alias <alias> already exists"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        if (sigAlgName == null) {
            if ("DSA".equalsIgnoreCase(keyAlgName)) {
                sigAlgName = "SHA1WithDSA";
            } else if ("RSA".equalsIgnoreCase(keyAlgName)) {
                sigAlgName = "SHA1WithRSA";
            } else if ("EC".equalsIgnoreCase(keyAlgName)) {
                sigAlgName = "SHA1withECDSA";
            } else {
                throw new Exception(rb.getString("Cannot derive signature algorithm"));
            }
        }
        CertAndKeyGen keypair = new CertAndKeyGen(keyAlgName, sigAlgName, this.providerName);
        X500Name x500Name = dname == null ? this.getX500Name() : new X500Name(dname);
        keypair.generate(keysize);
        PrivateKey privKey = keypair.getPrivateKey();
        Certificate[] chain = new X509Certificate[]{keypair.getSelfCertificate(x500Name, KeyTool.getStartDate(this.startDate), this.validity * 24L * 60L * 60L)};
        if (this.verbose) {
            MessageFormat form = new MessageFormat(rb.getString("Generating keysize bit keyAlgName key pair and self-signed certificate (sigAlgName) with a validity of validality days\n\tfor: x500Name"));
            Object[] source = new Object[]{new Integer(keysize), privKey.getAlgorithm(), ((X509Certificate)chain[0]).getSigAlgName(), new Long(this.validity), x500Name};
            System.err.println(form.format(source));
        }
        if (this.keyPass == null) {
            this.keyPass = this.promptForKeyPass(alias, null, this.storePass);
        }
        this.keyStore.setKeyEntry(alias, privKey, this.keyPass, chain);
    }

    private void doCloneEntry(String orig, String dest, boolean changePassword) throws Exception {
        if (orig == null) {
            orig = "mykey";
        }
        if (this.keyStore.containsAlias(dest)) {
            MessageFormat form = new MessageFormat(rb.getString("Destination alias <dest> already exists"));
            Object[] source = new Object[]{dest};
            throw new Exception(form.format(source));
        }
        Object[] objs = this.recoverEntry(this.keyStore, orig, this.storePass, this.keyPass);
        KeyStore.Entry entry = (KeyStore.Entry)objs[0];
        this.keyPass = (char[])objs[1];
        KeyStore.PasswordProtection pp = null;
        if (this.keyPass != null) {
            if (!changePassword || P12KEYSTORE.equalsIgnoreCase(this.storetype)) {
                this.keyPassNew = this.keyPass;
            } else if (this.keyPassNew == null) {
                this.keyPassNew = this.promptForKeyPass(dest, orig, this.keyPass);
            }
            pp = new KeyStore.PasswordProtection(this.keyPassNew);
        }
        this.keyStore.setEntry(dest, entry, pp);
    }

    private void doChangeKeyPasswd(String alias) throws Exception {
        if (alias == null) {
            alias = "mykey";
        }
        Object[] objs = this.recoverKey(alias, this.storePass, this.keyPass);
        Key privKey = (Key)objs[0];
        if (this.keyPass == null) {
            this.keyPass = (char[])objs[1];
        }
        if (this.keyPassNew == null) {
            MessageFormat form = new MessageFormat(rb.getString("key password for <alias>"));
            Object[] source = new Object[]{alias};
            this.keyPassNew = this.getNewPasswd(form.format(source), this.keyPass);
        }
        this.keyStore.setKeyEntry(alias, privKey, this.keyPassNew, this.keyStore.getCertificateChain(alias));
    }

    private void doImportIdentityDatabase(InputStream in) throws Exception {
        Certificate[] chain = null;
        boolean modified = false;
        IdentityDatabase idb = IdentityDatabase.fromStream(in);
        Enumeration<Identity> enum_ = idb.identities();
        while (enum_.hasMoreElements()) {
            Identity id = enum_.nextElement();
            X509Certificate newCert = null;
            if ((!(id instanceof SystemSigner) || !((SystemSigner)id).isTrusted()) && (!(id instanceof SystemIdentity) || !((SystemIdentity)id).isTrusted())) continue;
            if (this.keyStore.containsAlias(id.getName())) {
                MessageFormat form = new MessageFormat(rb.getString("Keystore entry for <id.getName()> already exists"));
                Object[] source = new Object[]{id.getName()};
                System.err.println(form.format(source));
                continue;
            }
            java.security.Certificate[] certs = id.certificates();
            if (certs == null || certs.length <= 0) continue;
            DerOutputStream dos = new DerOutputStream();
            certs[0].encode(dos);
            byte[] encoded = dos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(encoded);
            newCert = (X509Certificate)this.cf.generateCertificate(bais);
            bais.close();
            if (this.isSelfSigned(newCert)) {
                PublicKey pubKey = newCert.getPublicKey();
                try {
                    newCert.verify(pubKey);
                }
                catch (Exception e) {
                    continue;
                }
            }
            if (id instanceof SystemSigner) {
                MessageFormat form = new MessageFormat(rb.getString("Creating keystore entry for <id.getName()> ..."));
                Object[] source = new Object[]{id.getName()};
                System.err.println(form.format(source));
                if (chain == null) {
                    chain = new Certificate[]{newCert};
                }
                PrivateKey privKey = ((SystemSigner)id).getPrivateKey();
                this.keyStore.setKeyEntry(id.getName(), privKey, this.storePass, chain);
            } else {
                this.keyStore.setCertificateEntry(id.getName(), newCert);
            }
            this.kssave = true;
        }
        if (!this.kssave) {
            System.err.println(rb.getString("No entries from identity database added"));
        }
    }

    private void doPrintEntry(String alias, PrintStream out, boolean printWarning) throws Exception {
        Object[] source;
        Object[] source2;
        MessageFormat form;
        if (this.storePass == null && printWarning && !KeyStoreUtil.isWindowsKeyStore(this.storetype)) {
            this.printWarning();
        }
        if (!this.keyStore.containsAlias(alias)) {
            MessageFormat form2 = new MessageFormat(rb.getString("Alias <alias> does not exist"));
            Object[] source3 = new Object[]{alias};
            throw new Exception(form2.format(source3));
        }
        if (this.verbose || this.rfc || this.debug) {
            form = new MessageFormat(rb.getString("Alias name: alias"));
            source2 = new Object[]{alias};
            out.println(form.format(source2));
            if (!this.token) {
                form = new MessageFormat(rb.getString("Creation date: keyStore.getCreationDate(alias)"));
                Object[] src = new Object[]{this.keyStore.getCreationDate(alias)};
                out.println(form.format(src));
            }
        } else if (!this.token) {
            form = new MessageFormat(rb.getString("alias, keyStore.getCreationDate(alias), "));
            source2 = new Object[]{alias, this.keyStore.getCreationDate(alias)};
            out.print(form.format(source2));
        } else {
            form = new MessageFormat(rb.getString("alias, "));
            source2 = new Object[]{alias};
            out.print(form.format(source2));
        }
        if (this.keyStore.entryInstanceOf(alias, KeyStore.SecretKeyEntry.class)) {
            if (this.verbose || this.rfc || this.debug) {
                source = new Object[]{"SecretKeyEntry"};
                out.println(new MessageFormat(rb.getString("Entry type: <type>")).format(source));
            } else {
                out.println("SecretKeyEntry, ");
            }
        } else if (this.keyStore.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class)) {
            if (this.verbose || this.rfc || this.debug) {
                source = new Object[]{"PrivateKeyEntry"};
                out.println(new MessageFormat(rb.getString("Entry type: <type>")).format(source));
            } else {
                out.println("PrivateKeyEntry, ");
            }
            Certificate[] chain = this.keyStore.getCertificateChain(alias);
            if (chain != null) {
                if (this.verbose || this.rfc || this.debug) {
                    out.println(rb.getString("Certificate chain length: ") + chain.length);
                    for (int i = 0; i < chain.length; ++i) {
                        MessageFormat form3 = new MessageFormat(rb.getString("Certificate[(i + 1)]:"));
                        Object[] source4 = new Object[]{new Integer(i + 1)};
                        out.println(form3.format(source4));
                        if (this.verbose && chain[i] instanceof X509Certificate) {
                            this.printX509Cert((X509Certificate)chain[i], out);
                            continue;
                        }
                        if (this.debug) {
                            out.println(chain[i].toString());
                            continue;
                        }
                        this.dumpCert(chain[i], out);
                    }
                } else {
                    out.println(rb.getString("Certificate fingerprint (MD5): ") + this.getCertFingerPrint("MD5", chain[0]));
                }
            }
        } else if (this.keyStore.entryInstanceOf(alias, KeyStore.TrustedCertificateEntry.class)) {
            Certificate cert = this.keyStore.getCertificate(alias);
            if (this.verbose && cert instanceof X509Certificate) {
                out.println(rb.getString("Entry type: trustedCertEntry\n"));
                this.printX509Cert((X509Certificate)cert, out);
            } else if (this.rfc) {
                out.println(rb.getString("Entry type: trustedCertEntry\n"));
                this.dumpCert(cert, out);
            } else if (this.debug) {
                out.println(cert.toString());
            } else {
                out.println(rb.getString("trustedCertEntry,"));
                out.println(rb.getString("Certificate fingerprint (MD5): ") + this.getCertFingerPrint("MD5", cert));
            }
        } else {
            out.println(rb.getString("Unknown Entry Type"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    KeyStore loadSourceKeyStore() throws Exception {
        KeyStore store;
        boolean isPkcs11 = false;
        InputStream is = null;
        if (P11KEYSTORE.equalsIgnoreCase(this.srcstoretype) || KeyStoreUtil.isWindowsKeyStore(this.srcstoretype)) {
            if (!NONE.equals(this.srcksfname)) {
                System.err.println(MessageFormat.format(rb.getString("-keystore must be NONE if -storetype is {0}"), this.srcstoretype));
                System.err.println();
                this.tinyHelp();
            }
            isPkcs11 = true;
        } else if (this.srcksfname != null) {
            File srcksfile = new File(this.srcksfname);
            if (srcksfile.exists() && srcksfile.length() == 0L) {
                throw new Exception(rb.getString("Source keystore file exists, but is empty: ") + this.srcksfname);
            }
            is = new FileInputStream(srcksfile);
        } else {
            throw new Exception(rb.getString("Please specify -srckeystore"));
        }
        try {
            store = this.srcProviderName == null ? KeyStore.getInstance(this.srcstoretype) : KeyStore.getInstance(this.srcstoretype, this.srcProviderName);
            if (this.srcstorePass == null && !this.srcprotectedPath && !KeyStoreUtil.isWindowsKeyStore(this.srcstoretype)) {
                System.err.print(rb.getString("Enter source keystore password:  "));
                System.err.flush();
                this.srcstorePass = Password.readPassword(System.in);
                this.passwords.add(this.srcstorePass);
            }
            if (P12KEYSTORE.equalsIgnoreCase(this.srcstoretype) && this.srckeyPass != null && this.srcstorePass != null && !Arrays.equals(this.srcstorePass, this.srckeyPass)) {
                MessageFormat form = new MessageFormat(rb.getString("Warning:  Different store and key passwords not supported for PKCS12 KeyStores. Ignoring user-specified <command> value."));
                Object[] source = new Object[]{"-srckeypass"};
                System.err.println(form.format(source));
                this.srckeyPass = this.srcstorePass;
            }
            store.load(is, this.srcstorePass);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        if (this.srcstorePass == null && !KeyStoreUtil.isWindowsKeyStore(this.srcstoretype)) {
            System.err.println();
            System.err.println(rb.getString("*****************  WARNING WARNING WARNING  *****************"));
            System.err.println(rb.getString("* The integrity of the information stored in the srckeystore*"));
            System.err.println(rb.getString("* has NOT been verified!  In order to verify its integrity, *"));
            System.err.println(rb.getString("* you must provide the srckeystore password.                *"));
            System.err.println(rb.getString("*****************  WARNING WARNING WARNING  *****************"));
            System.err.println();
        }
        return store;
    }

    private void doImportKeyStore() throws Exception {
        if (this.alias != null) {
            this.doImportKeyStoreSingle(this.loadSourceKeyStore(), this.alias);
        } else {
            if (this.dest != null || this.srckeyPass != null || this.destKeyPass != null) {
                throw new Exception(rb.getString("if alias not specified, destalias, srckeypass, and destkeypass must not be specified"));
            }
            this.doImportKeyStoreAll(this.loadSourceKeyStore());
        }
    }

    private int doImportKeyStoreSingle(KeyStore srckeystore, String alias) throws Exception {
        String newAlias;
        String string = newAlias = this.dest == null ? alias : this.dest;
        if (this.keyStore.containsAlias(newAlias)) {
            Object[] source = new Object[]{alias};
            if (this.noprompt) {
                System.err.println(new MessageFormat(rb.getString("Warning: Overwriting existing alias <alias> in destination keystore")).format(source));
            } else {
                String reply = this.getYesNoReply(new MessageFormat(rb.getString("Existing entry alias <alias> exists, overwrite? [no]:  ")).format(source));
                if ("NO".equals(reply) && "".equals(newAlias = this.inputStringFromStdin(rb.getString("Enter new alias name\t(RETURN to cancel import for this entry):  ")))) {
                    System.err.println(new MessageFormat(rb.getString("Entry for alias <alias> not imported.")).format(source));
                    return 0;
                }
            }
        }
        Object[] objs = this.recoverEntry(srckeystore, alias, this.srcstorePass, this.srckeyPass);
        KeyStore.Entry entry = (KeyStore.Entry)objs[0];
        KeyStore.PasswordProtection pp = null;
        if (this.destKeyPass != null) {
            pp = new KeyStore.PasswordProtection(this.destKeyPass);
        } else if (objs[1] != null) {
            pp = new KeyStore.PasswordProtection((char[])objs[1]);
        }
        try {
            this.keyStore.setEntry(newAlias, entry, pp);
            return 1;
        }
        catch (KeyStoreException kse) {
            Object[] source2 = new Object[]{alias, kse.toString()};
            MessageFormat form = new MessageFormat(rb.getString("Problem importing entry for alias <alias>: <exception>.\nEntry for alias <alias> not imported."));
            System.err.println(form.format(source2));
            return 2;
        }
    }

    private void doImportKeyStoreAll(KeyStore srckeystore) throws Exception {
        int ok = 0;
        int count = srckeystore.size();
        Enumeration<String> e = srckeystore.aliases();
        while (e.hasMoreElements()) {
            String reply;
            String alias = e.nextElement();
            int result = this.doImportKeyStoreSingle(srckeystore, alias);
            if (result == 1) {
                ++ok;
                Object[] source = new Object[]{alias};
                MessageFormat form = new MessageFormat(rb.getString("Entry for alias <alias> successfully imported."));
                System.err.println(form.format(source));
                continue;
            }
            if (result != 2 || this.noprompt || !"YES".equals(reply = this.getYesNoReply("Do you want to quit the import process? [no]:  "))) continue;
            break;
        }
        Object[] source = new Object[]{ok, count - ok};
        MessageFormat form = new MessageFormat(rb.getString("Import command completed:  <ok> entries successfully imported, <fail> entries failed or cancelled"));
        System.err.println(form.format(source));
    }

    private void doPrintEntries(PrintStream out) throws Exception {
        if (this.storePass == null && !KeyStoreUtil.isWindowsKeyStore(this.storetype)) {
            this.printWarning();
        } else {
            out.println();
        }
        out.println(rb.getString("Keystore type: ") + this.keyStore.getType());
        out.println(rb.getString("Keystore provider: ") + this.keyStore.getProvider().getName());
        out.println();
        MessageFormat form = this.keyStore.size() == 1 ? new MessageFormat(rb.getString("Your keystore contains keyStore.size() entry")) : new MessageFormat(rb.getString("Your keystore contains keyStore.size() entries"));
        Object[] source = new Object[]{new Integer(this.keyStore.size())};
        out.println(form.format(source));
        out.println();
        Enumeration<String> e = this.keyStore.aliases();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            this.doPrintEntry(alias, out, false);
            if (!this.verbose && !this.rfc) continue;
            out.println(rb.getString("\n"));
            out.println(rb.getString("*******************************************"));
            out.println(rb.getString("*******************************************\n\n"));
        }
    }

    private void doPrintCert(InputStream in, PrintStream out) throws Exception {
        Collection<? extends Certificate> c = null;
        try {
            c = this.cf.generateCertificates(in);
        }
        catch (CertificateException ce) {
            throw new Exception(rb.getString("Failed to parse input"), ce);
        }
        if (c.isEmpty()) {
            throw new Exception(rb.getString("Empty input"));
        }
        Certificate[] certs = c.toArray(new Certificate[c.size()]);
        for (int i = 0; i < certs.length; ++i) {
            X509Certificate x509Cert = null;
            try {
                x509Cert = (X509Certificate)certs[i];
            }
            catch (ClassCastException cce) {
                throw new Exception(rb.getString("Not X.509 certificate"));
            }
            if (certs.length > 1) {
                MessageFormat form = new MessageFormat(rb.getString("Certificate[(i + 1)]:"));
                Object[] source = new Object[]{new Integer(i + 1)};
                out.println(form.format(source));
            }
            this.printX509Cert(x509Cert, out);
            if (i >= certs.length - 1) continue;
            out.println();
        }
    }

    private void doSelfCert(String alias, String dname, String sigAlgName) throws Exception {
        X500Name owner;
        Certificate oldCert;
        if (alias == null) {
            alias = "mykey";
        }
        Object[] objs = this.recoverKey(alias, this.storePass, this.keyPass);
        PrivateKey privKey = (PrivateKey)objs[0];
        if (this.keyPass == null) {
            this.keyPass = (char[])objs[1];
        }
        if (sigAlgName == null) {
            String keyAlgName = privKey.getAlgorithm();
            if ("DSA".equalsIgnoreCase(keyAlgName) || "DSS".equalsIgnoreCase(keyAlgName)) {
                sigAlgName = "SHA1WithDSA";
            } else if ("RSA".equalsIgnoreCase(keyAlgName)) {
                sigAlgName = "SHA1WithRSA";
            } else if ("EC".equalsIgnoreCase(keyAlgName)) {
                sigAlgName = "SHA1withECDSA";
            } else {
                throw new Exception(rb.getString("Cannot derive signature algorithm"));
            }
        }
        if ((oldCert = this.keyStore.getCertificate(alias)) == null) {
            MessageFormat form = new MessageFormat(rb.getString("alias has no public key"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        if (!(oldCert instanceof X509Certificate)) {
            MessageFormat form = new MessageFormat(rb.getString("alias has no X.509 certificate"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        byte[] encoded = oldCert.getEncoded();
        X509CertImpl certImpl = new X509CertImpl(encoded);
        X509CertInfo certInfo = (X509CertInfo)certImpl.get("x509.info");
        Date firstDate = KeyTool.getStartDate(this.startDate);
        Date lastDate = new Date();
        lastDate.setTime(firstDate.getTime() + this.validity * 1000L * 24L * 60L * 60L);
        CertificateValidity interval = new CertificateValidity(firstDate, lastDate);
        certInfo.set("validity", interval);
        certInfo.set("serialNumber", new CertificateSerialNumber((int)(firstDate.getTime() / 1000L)));
        if (dname == null) {
            owner = (X500Name)certInfo.get("subject.dname");
        } else {
            owner = new X500Name(dname);
            certInfo.set("subject.dname", owner);
        }
        certInfo.set("issuer.dname", owner);
        X509CertImpl newCert = new X509CertImpl(certInfo);
        newCert.sign(privKey, sigAlgName);
        AlgorithmId sigAlgid = (AlgorithmId)newCert.get("x509.algorithm");
        certInfo.set("algorithmID.algorithm", sigAlgid);
        certInfo.set("version", new CertificateVersion(2));
        newCert = new X509CertImpl(certInfo);
        newCert.sign(privKey, sigAlgName);
        this.keyStore.setKeyEntry(alias, privKey, this.keyPass != null ? this.keyPass : this.storePass, new Certificate[]{newCert});
        if (this.verbose) {
            System.err.println(rb.getString("New certificate (self-signed):"));
            System.err.print(newCert.toString());
            System.err.println();
        }
    }

    private boolean installReply(String alias, InputStream in) throws Exception {
        Certificate userCert;
        if (alias == null) {
            alias = "mykey";
        }
        Object[] objs = this.recoverKey(alias, this.storePass, this.keyPass);
        PrivateKey privKey = (PrivateKey)objs[0];
        if (this.keyPass == null) {
            this.keyPass = (char[])objs[1];
        }
        if ((userCert = this.keyStore.getCertificate(alias)) == null) {
            MessageFormat form = new MessageFormat(rb.getString("alias has no public key (certificate)"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        Collection<? extends Certificate> c = this.cf.generateCertificates(in);
        if (c.isEmpty()) {
            throw new Exception(rb.getString("Reply has no certificates"));
        }
        Certificate[] replyCerts = c.toArray(new Certificate[c.size()]);
        Certificate[] newChain = replyCerts.length == 1 ? this.establishCertChain(userCert, replyCerts[0]) : this.validateReply(alias, userCert, replyCerts);
        if (newChain != null) {
            this.keyStore.setKeyEntry(alias, privKey, this.keyPass != null ? this.keyPass : this.storePass, newChain);
            return true;
        }
        return false;
    }

    private boolean addTrustedCert(String alias, InputStream in) throws Exception {
        MessageFormat form;
        if (alias == null) {
            throw new Exception(rb.getString("Must specify alias"));
        }
        if (this.keyStore.containsAlias(alias)) {
            MessageFormat form2 = new MessageFormat(rb.getString("Certificate not imported, alias <alias> already exists"));
            Object[] source = new Object[]{alias};
            throw new Exception(form2.format(source));
        }
        X509Certificate cert = null;
        try {
            cert = (X509Certificate)this.cf.generateCertificate(in);
        }
        catch (ClassCastException cce) {
            throw new Exception(rb.getString("Input not an X.509 certificate"));
        }
        catch (CertificateException ce) {
            throw new Exception(rb.getString("Input not an X.509 certificate"));
        }
        boolean selfSigned = false;
        if (this.isSelfSigned(cert)) {
            cert.verify(cert.getPublicKey());
            selfSigned = true;
        }
        if (this.noprompt) {
            this.keyStore.setCertificateEntry(alias, cert);
            return true;
        }
        String reply = null;
        String trustalias = this.keyStore.getCertificateAlias(cert);
        if (trustalias != null) {
            form = new MessageFormat(rb.getString("Certificate already exists in keystore under alias <trustalias>"));
            Object[] source = new Object[]{trustalias};
            System.err.println(form.format(source));
            reply = this.getYesNoReply(rb.getString("Do you still want to add it? [no]:  "));
        } else if (selfSigned) {
            if (this.trustcacerts && this.caks != null && (trustalias = this.caks.getCertificateAlias(cert)) != null) {
                form = new MessageFormat(rb.getString("Certificate already exists in system-wide CA keystore under alias <trustalias>"));
                Object[] source = new Object[]{trustalias};
                System.err.println(form.format(source));
                reply = this.getYesNoReply(rb.getString("Do you still want to add it to your own keystore? [no]:  "));
            }
            if (trustalias == null) {
                this.printX509Cert(cert, System.out);
                reply = this.getYesNoReply(rb.getString("Trust this certificate? [no]:  "));
            }
        }
        if (reply != null) {
            if ("YES".equals(reply)) {
                this.keyStore.setCertificateEntry(alias, cert);
                return true;
            }
            return false;
        }
        try {
            Certificate[] chain = this.establishCertChain(null, cert);
            if (chain != null) {
                this.keyStore.setCertificateEntry(alias, cert);
                return true;
            }
        }
        catch (Exception e) {
            this.printX509Cert(cert, System.out);
            reply = this.getYesNoReply(rb.getString("Trust this certificate? [no]:  "));
            if ("YES".equals(reply)) {
                this.keyStore.setCertificateEntry(alias, cert);
                return true;
            }
            return false;
        }
        return false;
    }

    private char[] getNewPasswd(String prompt, char[] oldPasswd) throws Exception {
        char[] entered = null;
        char[] reentered = null;
        for (int count = 0; count < 3; ++count) {
            MessageFormat form = new MessageFormat(rb.getString("New prompt: "));
            Object[] source = new Object[]{prompt};
            System.err.print(form.format(source));
            entered = Password.readPassword(System.in);
            this.passwords.add(entered);
            if (entered == null || entered.length < 6) {
                System.err.println(rb.getString("Password is too short - must be at least 6 characters"));
            } else if (Arrays.equals(entered, oldPasswd)) {
                System.err.println(rb.getString("Passwords must differ"));
            } else {
                form = new MessageFormat(rb.getString("Re-enter new prompt: "));
                Object[] src = new Object[]{prompt};
                System.err.print(form.format(src));
                reentered = Password.readPassword(System.in);
                this.passwords.add(reentered);
                if (!Arrays.equals(entered, reentered)) {
                    System.err.println(rb.getString("They don't match. Try again"));
                } else {
                    Arrays.fill(reentered, ' ');
                    return entered;
                }
            }
            if (entered != null) {
                Arrays.fill(entered, ' ');
                entered = null;
            }
            if (reentered == null) continue;
            Arrays.fill(reentered, ' ');
            reentered = null;
        }
        throw new Exception(rb.getString("Too many failures - try later"));
    }

    private String getAlias(String prompt) throws Exception {
        if (prompt != null) {
            MessageFormat form = new MessageFormat(rb.getString("Enter prompt alias name:  "));
            Object[] source = new Object[]{prompt};
            System.err.print(form.format(source));
        } else {
            System.err.print(rb.getString("Enter alias name:  "));
        }
        return new BufferedReader(new InputStreamReader(System.in)).readLine();
    }

    private String inputStringFromStdin(String prompt) throws Exception {
        System.err.print(prompt);
        return new BufferedReader(new InputStreamReader(System.in)).readLine();
    }

    private char[] getKeyPasswd(String alias, String otherAlias, char[] otherKeyPass) throws Exception {
        int count = 0;
        char[] keyPass = null;
        do {
            Object[] source;
            MessageFormat form;
            if (otherKeyPass != null) {
                form = new MessageFormat(rb.getString("Enter key password for <alias>"));
                source = new Object[]{alias};
                System.err.println(form.format(source));
                form = new MessageFormat(rb.getString("\t(RETURN if same as for <otherAlias>)"));
                Object[] src = new Object[]{otherAlias};
                System.err.print(form.format(src));
            } else {
                form = new MessageFormat(rb.getString("Enter key password for <alias>"));
                source = new Object[]{alias};
                System.err.print(form.format(source));
            }
            System.err.flush();
            keyPass = Password.readPassword(System.in);
            this.passwords.add(keyPass);
            if (keyPass != null) continue;
            keyPass = otherKeyPass;
        } while (keyPass == null && ++count < 3);
        if (keyPass == null) {
            throw new Exception(rb.getString("Too many failures - try later"));
        }
        return keyPass;
    }

    private void printX509Cert(X509Certificate cert, PrintStream out) throws Exception {
        MessageFormat form = new MessageFormat(rb.getString("*PATTERN* printX509Cert"));
        Object[] source = new Object[]{((Object)cert.getSubjectDN()).toString(), ((Object)cert.getIssuerDN()).toString(), cert.getSerialNumber().toString(16), cert.getNotBefore().toString(), cert.getNotAfter().toString(), this.getCertFingerPrint("MD5", cert), this.getCertFingerPrint("SHA1", cert), cert.getSigAlgName(), cert.getVersion()};
        out.println(form.format(source));
        int extnum = 0;
        if (cert instanceof X509CertImpl) {
            X509CertImpl impl = (X509CertImpl)cert;
            if (cert.getCriticalExtensionOIDs() != null) {
                for (String extOID : cert.getCriticalExtensionOIDs()) {
                    if (extnum == 0) {
                        out.println();
                        out.println(rb.getString("Extensions: "));
                        out.println();
                    }
                    out.println("#" + ++extnum + ": " + impl.getExtension(new ObjectIdentifier(extOID)));
                }
            }
            if (cert.getNonCriticalExtensionOIDs() != null) {
                for (String extOID : cert.getNonCriticalExtensionOIDs()) {
                    Extension ext;
                    if (extnum == 0) {
                        out.println();
                        out.println(rb.getString("Extensions: "));
                        out.println();
                    }
                    if ((ext = impl.getExtension(new ObjectIdentifier(extOID))) != null) {
                        out.println("#" + ++extnum + ": " + ext);
                        continue;
                    }
                    out.println("#" + ++extnum + ": " + impl.getUnparseableExtension(new ObjectIdentifier(extOID)));
                }
            }
        }
    }

    private boolean isSelfSigned(X509Certificate cert) {
        return ((Object)cert.getSubjectDN()).equals(cert.getIssuerDN());
    }

    private boolean isTrusted(Certificate cert) throws Exception {
        if (this.keyStore.getCertificateAlias(cert) != null) {
            return true;
        }
        return this.trustcacerts && this.caks != null && this.caks.getCertificateAlias(cert) != null;
    }

    private X500Name getX500Name() throws IOException {
        X500Name name;
        Object[] source;
        MessageFormat form;
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        String commonName = "Unknown";
        String organizationalUnit = "Unknown";
        String organization = "Unknown";
        String city = "Unknown";
        String state = "Unknown";
        String country = "Unknown";
        String userInput = null;
        int maxRetry = 20;
        do {
            if (maxRetry-- < 0) {
                throw new RuntimeException(rb.getString("Too may retries, program terminated"));
            }
            commonName = this.inputString(in, rb.getString("What is your first and last name?"), commonName);
            organizationalUnit = this.inputString(in, rb.getString("What is the name of your organizational unit?"), organizationalUnit);
            organization = this.inputString(in, rb.getString("What is the name of your organization?"), organization);
            city = this.inputString(in, rb.getString("What is the name of your City or Locality?"), city);
            state = this.inputString(in, rb.getString("What is the name of your State or Province?"), state);
            country = this.inputString(in, rb.getString("What is the two-letter country code for this unit?"), country);
            name = new X500Name(commonName, organizationalUnit, organization, city, state, country);
        } while (collator.compare(userInput = this.inputString(in, (form = new MessageFormat(rb.getString("Is <name> correct?"))).format(source = new Object[]{name}), rb.getString("no")), rb.getString("yes")) != 0 && collator.compare(userInput, rb.getString("y")) != 0);
        System.err.println();
        return name;
    }

    private String inputString(BufferedReader in, String prompt, String defaultValue) throws IOException {
        System.err.println(prompt);
        MessageFormat form = new MessageFormat(rb.getString("  [defaultValue]:  "));
        Object[] source = new Object[]{defaultValue};
        System.err.print(form.format(source));
        System.err.flush();
        String value = in.readLine();
        if (value == null || collator.compare(value, "") == 0) {
            value = defaultValue;
        }
        return value;
    }

    private void dumpCert(Certificate cert, PrintStream out) throws IOException, CertificateException {
        if (this.rfc) {
            BASE64Encoder encoder = new BASE64Encoder();
            out.println("-----BEGIN CERTIFICATE-----");
            encoder.encodeBuffer(cert.getEncoded(), (OutputStream)out);
            out.println("-----END CERTIFICATE-----");
        } else {
            out.write(cert.getEncoded());
        }
    }

    private void byte2hex(byte b, StringBuffer buf) {
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int high = (b & 0xF0) >> 4;
        int low = b & 0xF;
        buf.append(hexChars[high]);
        buf.append(hexChars[low]);
    }

    private String toHexString(byte[] block) {
        StringBuffer buf = new StringBuffer();
        int len = block.length;
        for (int i = 0; i < len; ++i) {
            this.byte2hex(block[i], buf);
            if (i >= len - 1) continue;
            buf.append(":");
        }
        return buf.toString();
    }

    private Object[] recoverKey(String alias, char[] storePass, char[] keyPass) throws Exception {
        Key key = null;
        if (!this.keyStore.containsAlias(alias)) {
            MessageFormat form = new MessageFormat(rb.getString("Alias <alias> does not exist"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        if (!this.keyStore.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class) && !this.keyStore.entryInstanceOf(alias, KeyStore.SecretKeyEntry.class)) {
            MessageFormat form = new MessageFormat(rb.getString("Alias <alias> has no key"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        if (keyPass == null) {
            try {
                key = this.keyStore.getKey(alias, storePass);
                keyPass = storePass;
                this.passwords.add(keyPass);
            }
            catch (UnrecoverableKeyException e) {
                if (!this.token) {
                    keyPass = this.getKeyPasswd(alias, null, null);
                    key = this.keyStore.getKey(alias, keyPass);
                }
                throw e;
            }
        } else {
            key = this.keyStore.getKey(alias, keyPass);
        }
        return new Object[]{key, keyPass};
    }

    private Object[] recoverEntry(KeyStore ks, String alias, char[] pstore, char[] pkey) throws Exception {
        KeyStore.Entry entry;
        if (!ks.containsAlias(alias)) {
            MessageFormat form = new MessageFormat(rb.getString("Alias <alias> does not exist"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        KeyStore.PasswordProtection pp = null;
        try {
            entry = ks.getEntry(alias, pp);
            pkey = null;
        }
        catch (UnrecoverableEntryException une) {
            if (P11KEYSTORE.equalsIgnoreCase(ks.getType()) || KeyStoreUtil.isWindowsKeyStore(ks.getType())) {
                throw une;
            }
            if (pkey != null) {
                pp = new KeyStore.PasswordProtection(pkey);
                entry = ks.getEntry(alias, pp);
            }
            try {
                pp = new KeyStore.PasswordProtection(pstore);
                entry = ks.getEntry(alias, pp);
                pkey = pstore;
            }
            catch (UnrecoverableEntryException une2) {
                if (P12KEYSTORE.equalsIgnoreCase(ks.getType())) {
                    throw une2;
                }
                pkey = this.getKeyPasswd(alias, null, null);
                pp = new KeyStore.PasswordProtection(pkey);
                entry = ks.getEntry(alias, pp);
            }
        }
        return new Object[]{entry, pkey};
    }

    private String getCertFingerPrint(String mdAlg, Certificate cert) throws Exception {
        byte[] encCertInfo = cert.getEncoded();
        MessageDigest md = MessageDigest.getInstance(mdAlg);
        byte[] digest = md.digest(encCertInfo);
        return this.toHexString(digest);
    }

    private void printWarning() {
        System.err.println();
        System.err.println(rb.getString("*****************  WARNING WARNING WARNING  *****************"));
        System.err.println(rb.getString("* The integrity of the information stored in your keystore  *"));
        System.err.println(rb.getString("* has NOT been verified!  In order to verify its integrity, *"));
        System.err.println(rb.getString("* you must provide your keystore password.                  *"));
        System.err.println(rb.getString("*****************  WARNING WARNING WARNING  *****************"));
        System.err.println();
    }

    private Certificate[] validateReply(String alias, Certificate userCert, Certificate[] replyCerts) throws Exception {
        int i;
        PublicKey userPubKey = userCert.getPublicKey();
        for (i = 0; i < replyCerts.length && !userPubKey.equals(replyCerts[i].getPublicKey()); ++i) {
        }
        if (i == replyCerts.length) {
            MessageFormat form = new MessageFormat(rb.getString("Certificate reply does not contain public key for <alias>"));
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        Certificate tmpCert = replyCerts[0];
        replyCerts[0] = replyCerts[i];
        replyCerts[i] = tmpCert;
        Principal issuer = ((X509Certificate)replyCerts[0]).getIssuerDN();
        for (i = 1; i < replyCerts.length - 1; ++i) {
            int j;
            for (j = i; j < replyCerts.length; ++j) {
                Principal subject = ((X509Certificate)replyCerts[j]).getSubjectDN();
                if (!((Object)subject).equals(issuer)) continue;
                tmpCert = replyCerts[i];
                replyCerts[i] = replyCerts[j];
                replyCerts[j] = tmpCert;
                issuer = ((X509Certificate)replyCerts[i]).getIssuerDN();
                break;
            }
            if (j != replyCerts.length) continue;
            throw new Exception(rb.getString("Incomplete certificate chain in reply"));
        }
        for (i = 0; i < replyCerts.length - 1; ++i) {
            PublicKey pubKey = replyCerts[i + 1].getPublicKey();
            try {
                replyCerts[i].verify(pubKey);
                continue;
            }
            catch (Exception e) {
                throw new Exception(rb.getString("Certificate chain in reply does not verify: ") + e.getMessage());
            }
        }
        if (this.noprompt) {
            return replyCerts;
        }
        Certificate topCert = replyCerts[replyCerts.length - 1];
        if (!this.isTrusted(topCert)) {
            boolean verified = false;
            Certificate rootCert = null;
            if (this.trustcacerts && this.caks != null) {
                Enumeration<String> aliases = this.caks.aliases();
                while (aliases.hasMoreElements()) {
                    String name = aliases.nextElement();
                    rootCert = this.caks.getCertificate(name);
                    if (rootCert == null) continue;
                    try {
                        topCert.verify(rootCert.getPublicKey());
                        verified = true;
                        break;
                    }
                    catch (Exception e) {
                    }
                }
            }
            if (!verified) {
                System.err.println();
                System.err.println(rb.getString("Top-level certificate in reply:\n"));
                this.printX509Cert((X509Certificate)topCert, System.out);
                System.err.println();
                System.err.print(rb.getString("... is not trusted. "));
                String reply = this.getYesNoReply(rb.getString("Install reply anyway? [no]:  "));
                if ("NO".equals(reply)) {
                    return null;
                }
            } else if (!this.isSelfSigned((X509Certificate)topCert)) {
                Certificate[] tmpCerts = new Certificate[replyCerts.length + 1];
                System.arraycopy(replyCerts, 0, tmpCerts, 0, replyCerts.length);
                tmpCerts[tmpCerts.length - 1] = rootCert;
                replyCerts = tmpCerts;
            }
        }
        return replyCerts;
    }

    private Certificate[] establishCertChain(Certificate userCert, Certificate certToVerify) throws Exception {
        Vector<Certificate> chain;
        if (userCert != null) {
            PublicKey replyPubKey;
            PublicKey origPubKey = userCert.getPublicKey();
            if (!origPubKey.equals(replyPubKey = certToVerify.getPublicKey())) {
                throw new Exception(rb.getString("Public keys in reply and keystore don't match"));
            }
            if (certToVerify.equals(userCert)) {
                throw new Exception(rb.getString("Certificate reply and certificate in keystore are identical"));
            }
        }
        Hashtable<Principal, Vector<Certificate>> certs = null;
        if (this.keyStore.size() > 0) {
            certs = new Hashtable<Principal, Vector<Certificate>>(11);
            this.keystorecerts2Hashtable(this.keyStore, certs);
        }
        if (this.trustcacerts && this.caks != null && this.caks.size() > 0) {
            if (certs == null) {
                certs = new Hashtable(11);
            }
            this.keystorecerts2Hashtable(this.caks, certs);
        }
        if (this.buildChain((X509Certificate)certToVerify, chain = new Vector<Certificate>(2), certs)) {
            Certificate[] newChain = new Certificate[chain.size()];
            int j = 0;
            for (int i = chain.size() - 1; i >= 0; --i) {
                newChain[j] = chain.elementAt(i);
                ++j;
            }
            return newChain;
        }
        throw new Exception(rb.getString("Failed to establish chain from reply"));
    }

    private boolean buildChain(X509Certificate certToVerify, Vector<Certificate> chain, Hashtable<Principal, Vector<Certificate>> certs) {
        Principal issuer;
        Principal subject = certToVerify.getSubjectDN();
        if (((Object)subject).equals(issuer = certToVerify.getIssuerDN())) {
            chain.addElement(certToVerify);
            return true;
        }
        Vector<Certificate> vec = certs.get(issuer);
        if (vec == null) {
            return false;
        }
        Enumeration<Certificate> issuerCerts = vec.elements();
        while (issuerCerts.hasMoreElements()) {
            X509Certificate issuerCert = (X509Certificate)issuerCerts.nextElement();
            PublicKey issuerPubKey = issuerCert.getPublicKey();
            try {
                certToVerify.verify(issuerPubKey);
            }
            catch (Exception e) {
                continue;
            }
            if (!this.buildChain(issuerCert, chain, certs)) continue;
            chain.addElement(certToVerify);
            return true;
        }
        return false;
    }

    private String getYesNoReply(String prompt) throws IOException {
        String reply = null;
        int maxRetry = 20;
        do {
            if (maxRetry-- < 0) {
                throw new RuntimeException(rb.getString("Too may retries, program terminated"));
            }
            System.err.print(prompt);
            System.err.flush();
            reply = new BufferedReader(new InputStreamReader(System.in)).readLine();
            if (collator.compare(reply, "") == 0 || collator.compare(reply, rb.getString("n")) == 0 || collator.compare(reply, rb.getString("no")) == 0) {
                reply = "NO";
                continue;
            }
            if (collator.compare(reply, rb.getString("y")) == 0 || collator.compare(reply, rb.getString("yes")) == 0) {
                reply = "YES";
                continue;
            }
            System.err.println(rb.getString("Wrong answer, try again"));
            reply = null;
        } while (reply == null);
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore getCacertsKeyStore() throws Exception {
        String sep = File.separator;
        File file = new File(System.getProperty("java.home") + sep + "lib" + sep + "security" + sep + "cacerts");
        if (!file.exists()) {
            return null;
        }
        FileInputStream fis = null;
        KeyStore caks = null;
        try {
            fis = new FileInputStream(file);
            caks = KeyStore.getInstance(JKS);
            caks.load(fis, null);
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        return caks;
    }

    private void keystorecerts2Hashtable(KeyStore ks, Hashtable<Principal, Vector<Certificate>> hash) throws Exception {
        Enumeration<String> aliases = ks.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Certificate cert = ks.getCertificate(alias);
            if (cert == null) continue;
            Principal subjectDN = ((X509Certificate)cert).getSubjectDN();
            Vector<Certificate> vec = hash.get(subjectDN);
            if (vec == null) {
                vec = new Vector();
                vec.addElement(cert);
            } else if (!vec.contains(cert)) {
                vec.addElement(cert);
            }
            hash.put(subjectDN, vec);
        }
    }

    private static Date getStartDate(String s) throws IOException {
        GregorianCalendar c = new GregorianCalendar();
        if (s != null) {
            IOException ioe = new IOException("Illegal startdate value");
            int len = s.length();
            if (len == 0) {
                throw ioe;
            }
            if (s.charAt(0) == '-' || s.charAt(0) == '+') {
                int start = 0;
                while (start < len) {
                    char ch;
                    int i;
                    int sign = 0;
                    switch (s.charAt(start)) {
                        case '+': {
                            sign = 1;
                            break;
                        }
                        case '-': {
                            sign = -1;
                            break;
                        }
                        default: {
                            throw ioe;
                        }
                    }
                    for (i = start + 1; i < len && (ch = s.charAt(i)) >= '0' && ch <= '9'; ++i) {
                    }
                    if (i == start + 1) {
                        throw ioe;
                    }
                    int number = Integer.parseInt(s.substring(start + 1, i));
                    if (i >= len) {
                        throw ioe;
                    }
                    int unit = 0;
                    switch (s.charAt(i)) {
                        case 'y': {
                            unit = 1;
                            break;
                        }
                        case 'm': {
                            unit = 2;
                            break;
                        }
                        case 'd': {
                            unit = 5;
                            break;
                        }
                        case 'H': {
                            unit = 10;
                            break;
                        }
                        case 'M': {
                            unit = 12;
                            break;
                        }
                        case 'S': {
                            unit = 13;
                            break;
                        }
                        default: {
                            throw ioe;
                        }
                    }
                    ((Calendar)c).add(unit, sign * number);
                    start = i + 1;
                }
            } else {
                String date = null;
                String time = null;
                if (len == 19) {
                    date = s.substring(0, 10);
                    time = s.substring(11);
                    if (s.charAt(10) != ' ') {
                        throw ioe;
                    }
                } else if (len == 10) {
                    date = s;
                } else if (len == 8) {
                    time = s;
                } else {
                    throw ioe;
                }
                if (date != null) {
                    if (date.matches("\\d\\d\\d\\d\\/\\d\\d\\/\\d\\d")) {
                        c.set(Integer.valueOf(date.substring(0, 4)), Integer.valueOf(date.substring(5, 7)) - 1, Integer.valueOf(date.substring(8, 10)));
                    } else {
                        throw ioe;
                    }
                }
                if (time != null) {
                    if (time.matches("\\d\\d:\\d\\d:\\d\\d")) {
                        c.set(11, Integer.valueOf(time.substring(0, 2)));
                        c.set(12, Integer.valueOf(time.substring(0, 2)));
                        c.set(13, Integer.valueOf(time.substring(0, 2)));
                        c.set(14, 0);
                    } else {
                        throw ioe;
                    }
                }
            }
        }
        return c.getTime();
    }

    private void usage() {
        System.err.println(rb.getString("keytool usage:\n"));
        System.err.println(rb.getString("-certreq     [-v] [-protected]"));
        System.err.println(rb.getString("\t     [-alias <alias>] [-sigalg <sigalg>]"));
        System.err.println(rb.getString("\t     [-file <csr_file>] [-keypass <keypass>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-providername <name>]"));
        System.err.println(rb.getString("\t     [-providerclass <provider_class_name> [-providerarg <arg>]] ..."));
        System.err.println(rb.getString("\t     [-providerpath <pathlist>]"));
        System.err.println();
        System.err.println(rb.getString("-changealias [-v] [-protected] -alias <alias> -destalias <destalias>"));
        System.err.println(rb.getString("\t     [-keypass <keypass>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-providername <name>]"));
        System.err.println(rb.getString("\t     [-providerclass <provider_class_name> [-providerarg <arg>]] ..."));
        System.err.println(rb.getString("\t     [-providerpath <pathlist>]"));
        System.err.println();
        System.err.println(rb.getString("-delete      [-v] [-protected] -alias <alias>"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-providername <name>]"));
        System.err.println(rb.getString("\t     [-providerclass <provider_class_name> [-providerarg <arg>]] ..."));
        System.err.println(rb.getString("\t     [-providerpath <pathlist>]"));
        System.err.println();
        System.err.println(rb.getString("-exportcert  [-v] [-rfc] [-protected]"));
        System.err.println(rb.getString("\t     [-alias <alias>] [-file <cert_file>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-providername <name>]"));
        System.err.println(rb.getString("\t     [-providerclass <provider_class_name> [-providerarg <arg>]] ..."));
        System.err.println(rb.getString("\t     [-providerpath <pathlist>]"));
        System.err.println();
        System.err.println(rb.getString("-genkeypair  [-v] [-protected]"));
        System.err.println(rb.getString("\t     [-alias <alias>]"));
        System.err.println(rb.getString("\t     [-keyalg <keyalg>] [-keysize <keysize>]"));
        System.err.println(rb.getString("\t     [-sigalg <sigalg>] [-dname <dname>]"));
        System.err.println(rb.getString("\t     [-validity <valDays>] [-keypass <keypass>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-providername <name>]"));
        System.err.println(rb.getString("\t     [-providerclass <provider_class_name> [-providerarg <arg>]] ..."));
        System.err.println(rb.getString("\t     [-providerpath <pathlist>]"));
        System.err.println();
        System.err.println(rb.getString("-genseckey   [-v] [-protected]"));
        System.err.println(rb.getString("\t     [-alias <alias>] [-keypass <keypass>]"));
        System.err.println(rb.getString("\t     [-keyalg <keyalg>] [-keysize <keysize>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-providername <name>]"));
        System.err.println(rb.getString("\t     [-providerclass <provider_class_name> [-providerarg <arg>]] ..."));
        System.err.println(rb.getString("\t     [-providerpath <pathlist>]"));
        System.err.println();
        System.err.println(rb.getString("-help"));
        System.err.println();
        System.err.println(rb.getString("-importcert  [-v] [-noprompt] [-trustcacerts] [-protected]"));
        System.err.println(rb.getString("\t     [-alias <alias>]"));
        System.err.println(rb.getString("\t     [-file <cert_file>] [-keypass <keypass>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-providername <name>]"));
        System.err.println(rb.getString("\t     [-providerclass <provider_class_name> [-providerarg <arg>]] ..."));
        System.err.println(rb.getString("\t     [-providerpath <pathlist>]"));
        System.err.println();
        System.err.println(rb.getString("-importkeystore [-v] "));
        System.err.println(rb.getString("\t     [-srckeystore <srckeystore>] [-destkeystore <destkeystore>]"));
        System.err.println(rb.getString("\t     [-srcstoretype <srcstoretype>] [-deststoretype <deststoretype>]"));
        System.err.println(rb.getString("\t     [-srcstorepass <srcstorepass>] [-deststorepass <deststorepass>]"));
        System.err.println(rb.getString("\t     [-srcprotected] [-destprotected]"));
        System.err.println(rb.getString("\t     [-srcprovidername <srcprovidername>]\n\t     [-destprovidername <destprovidername>]"));
        System.err.println(rb.getString("\t     [-srcalias <srcalias> [-destalias <destalias>]"));
        System.err.println(rb.getString("\t       [-srckeypass <srckeypass>] [-destkeypass <destkeypass>]]"));
        System.err.println(rb.getString("\t     [-noprompt]"));
        System.err.println(rb.getString("\t     [-providerclass <provider_class_name> [-providerarg <arg>]] ..."));
        System.err.println(rb.getString("\t     [-providerpath <pathlist>]"));
        System.err.println();
        System.err.println(rb.getString("-keypasswd   [-v] [-alias <alias>]"));
        System.err.println(rb.getString("\t     [-keypass <old_keypass>] [-new <new_keypass>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-providername <name>]"));
        System.err.println(rb.getString("\t     [-providerclass <provider_class_name> [-providerarg <arg>]] ..."));
        System.err.println(rb.getString("\t     [-providerpath <pathlist>]"));
        System.err.println();
        System.err.println(rb.getString("-list        [-v | -rfc] [-protected]"));
        System.err.println(rb.getString("\t     [-alias <alias>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-providername <name>]"));
        System.err.println(rb.getString("\t     [-providerclass <provider_class_name> [-providerarg <arg>]] ..."));
        System.err.println(rb.getString("\t     [-providerpath <pathlist>]"));
        System.err.println();
        System.err.println(rb.getString("-printcert   [-v] [-file <cert_file>]"));
        System.err.println();
        System.err.println(rb.getString("-storepasswd [-v] [-new <new_storepass>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-providername <name>]"));
        System.err.println(rb.getString("\t     [-providerclass <provider_class_name> [-providerarg <arg>]] ..."));
        System.err.println(rb.getString("\t     [-providerpath <pathlist>]"));
        if (this.debug) {
            throw new RuntimeException("NO ERROR, SORRY");
        }
        System.exit(1);
    }

    private void tinyHelp() {
        System.err.println(rb.getString("Try keytool -help"));
        if (this.debug) {
            throw new RuntimeException("NO BIG ERROR, SORRY");
        }
        System.exit(1);
    }

    private void errorNeedArgument(String flag) {
        Object[] source = new Object[]{flag};
        System.err.println(new MessageFormat(rb.getString("Command option <flag> needs an argument.")).format(source));
        this.tinyHelp();
    }

    static {
        collator.setStrength(0);
    }
}

