#!/usr/bin/perl
# MIT License
# Author: timeless
# Modified by qwerty12 to show "Changing theme notification" and run rcrefresh
use strict;

my @themepaths = </usr/share/themes/*/index.theme>;
my %thememap = ();
for my $themepath (@themepaths) {
 open THEME, "<", $themepath || next;
 my $line;
 do {
  $line = <THEME>;
 } while ($line !~ /^Name=\s*(.*)\s*$/);
 if ($1 ne "") {
  $thememap{$1} = $themepath;
 };
 close THEME;
}

my $activethemedir;
if (open THEME, "<", $ENV{HOME}."/.osso/current-gtk-theme") {
  my $themedir = <THEME>;
 close THEME;
 $themedir =~ s/[\n\r]+//g;
 $themedir =~ s{.* "}{};
 $themedir =~ s{/gtk-2\.0/gtkrc"}{};
# this doesn't handle multiple levels of indirection
 $activethemedir = (-l $themedir && readlink($themedir)) || $themedir;
}

my @zenityargs = qw(--list --radiolist --title);
push @zenityargs,"Select theme", "--text", "Change theme", qw(--column= --column=Theme);
for my $theme (keys %thememap) {
 my $themedir = $thememap{$theme};
 $themedir =~ s{/index\.theme}{};
 push @zenityargs, ($themedir eq $activethemedir ? "TRUE" : "FALSE"), "$theme";
};

open (ZENITY, "-|", "/usr/bin/zenity", @zenityargs);
 my $newtheme = <ZENITY>;
close ZENITY;
exit 1 if ($?>>8);

$newtheme =~ s/[\n\r]+//g;
my $themedir = $thememap{$newtheme};
$themedir =~ s{/index\.theme}{};
open THEME, ">", $ENV{HOME}."/.osso/current-gtk-theme";
 print THEME qq!include "$themedir/gtk-2.0/gtkrc"\n!;
close THEME;
open THEME, ">", $ENV{HOME}."/.osso/current-gtk-theme.maemo_af_desktop";
 print THEME qq!include "$themedir/gtk-2.0/gtkrc.maemo_af_desktop"\n!;
close THEME; 
$themedir =~ m{([^/]+?)\s*$};
my $themefolder = $1;
system('dbus-send', '--print-reply', '--type=method_call', '--dest=org.freedesktop.Notifications', '/org/freedesktop/Notifications', 'org.freedesktop.Notifications.SystemNoteInfoprint', 'string:Applying new theme');
system('matchbox-remote', '-t', $themefolder);
system('rcrefresh');
exit 0
