# Heavily inspired by powered from powerlaunch by Austin Che
# By Stskeeps <stskeeps@tspre.org>
# Not done yet: 
#   Device lock code support
#   Process watchdog messages
#   Thermal shutdown
#   Autolock expired
import socket, struct

DSME_GET_DEVICELOCK_CODE= 0x1200
DSME_IN_GET_DEVICELOCK_CODE= 0x1201
DSME_SET_DEVICELOCK_CODE= 0x1202
DSME_IN_SET_DEVICELOCK_CODE= 0x1203

DSME_DISPLAY_BLANKING_PAUSE= 0x0201
DSME_DISPLAY_BLANKING_ALLOW= 0x0202
DSME_SET_DISPLAY_BLANK_TIMEOUT= 0x0203
DSME_SET_DISPLAY_DIM_TIMEOUT= 0x0204
DSME_SET_DISPLAY_STATE= 0x0280
DSME_IN_DISPLAY_STATE= 0x0285
DSME_SET_DISPLAY_BRIGHTNESS= 0x0289
DSME_GET_DISPLAY_BRIGHTNESS= 0x0287 

DSME_IN_SYSTEM_STATE= 0x0301
DSME_GET_SYSTEM_STATE= 0x0302
DSME_IN_SYSTEM_INACTIVITY= 0x0303
DSME_IN_SAVE_UNSAVED_DATA= 0x0304
DSME_REQUEST_POWERUP= 0x0305
DSME_REQUEST_SHUTDOWN= 0x0306
DSME_SET_ALARM_MODE= 0x0307
DSME_REQUEST_REBOOT= 0x0308
DSME_IN_SYSTEM_ACTIVITY= 0x0311
DSME_SET_SOFTPOWERON= 0x0800
DSME_SET_SOFTPOWEROFF= 0x0801

class DSME:
  def __init__(self):
    self.dsme = socket.socket(socket.AF_UNIX, socket.SOCK_STREAM, 0)
    self.dsme.connect("/tmp/dsmesock")
  def __del__(self):
    self.dsme.close()
    
  def msg(self, type):
    msg = struct.pack("II", struct.calcsize("II"), type)
    self.dsme.send(msg)
    
  def msg_with_arg(self, type, arg):
    msg = struct.pack("III", struct.calcsize("III"), type, arg)
    self.dsme.send(msg)
    
  def read(self):
    header = self.dsme.recv(struct.calcsize("II"))
    len, type = struct.unpack("II", header)
    if len - struct.calcsize("II") > 0:
      data = self.dsme.recv(len - struct.calcsize("II"))
    else:
      data = None
    return type, data
    
  def parse_system_state(self, data):
    state = struct.unpack("I", data)[0]
    if state == 0x0:
      return "shutdown"
    elif state == 0x02:
      return "normal"
    elif state == 0x05:
      return "shutdown-and-charging"
    elif state == 0x06:
      return "reboot"
    else:
      return "unknown"

  def parse_display_state(self, data):
    state = struct.unpack("I", data)[0]
    if state == 0:
      return "on"
    elif state == 1:
      return "dimmed"
    elif state == 2:
      return "off"
    else:
      return "unknown" 
    
  # Override these
  def in_system_state(self, state): pass
  def in_display_state(self, state): pass
  def in_system_activity(self, state): pass
  def in_save_unsaved_data(self): pass
  def in_unknown_type(self, type, data): pass  
  
  def read_and_parse(self):
    type, data = self.read()
    if type == DSME_IN_DISPLAY_STATE:
      self.in_display_state(self.parse_display_state(data))
    elif type == DSME_IN_SYSTEM_STATE:
      self.in_system_state(self.parse_system_state)
    elif type == DSME_IN_SYSTEM_INACTIVITY:
      self.in_system_activity(False)
    elif type == DSME_IN_SYSTEM_ACTIVITY:
      self.in_system_activity(True)
    elif type == DSME_IN_SAVE_UNSAVED_DATA:
      self.in_save_unsaved_data()
    else:
      self.in_unknown_type(type, data)
      
if __name__ == "__main__":
  dsmeconn = DSME()
  dsmeconn.msg(DSME_GET_SYSTEM_STATE)
  type, data = dsmeconn.read()
  print type, data