#!/usr/bin/python
import dbus
import dbus.glib
import gobject
import subprocess

wlan0_path = None
network_connected = False
system_active = True
hal_manager = None

def powersave():
    global system_active, network_connected
    print "Powersave check " + str(network_connected) + "  :: " + str(system_active)
    if network_connected and not system_active:
      print "Passive mode, setting 200u"
      subprocess.call(["iwconfig", "wlan0", "power", "200u", "multicast"])
    if network_connected and system_active:
      print "Active mode, setting 100u"
      subprocess.call(["iwconfig", "wlan0", "power", "100u", "multicast"])

def system_activity(state):
    global system_active
    
    print "Got system activity " + str(state)
    if state == 1:
      system_active = True
    else:
      system_active = False

    powersave()

def device_active(path, wlan):
    global network_connected
    
    print "Device active: " + str(path)
    subprocess.call(["iwconfig", "wlan0", "power", "on"])
    if path.find("/wlan0") != -1:
      network_connected = True
      powersave()

def device_deactivated(path):
    global network_connected
    
    print "Device inactive" + str(path)
    subprocess.call(["iwconfig", "wlan0", "power", "off"])
    if path.find("/wlan0") != -1:
      network_connected = False
      powersave()

def device_state(new_state, old_state, reason):
  
  global network_connected

  print "device state " + str(new_state)

  if new_state == 3:
      network_connected = False
      subprocess.call(["iwconfig", "wlan0", "power", "off"])
      powersave()
  elif new_state == 8:
      network_connected = True
      subprocess.call(["iwconfig", "wlan0", "power", "on"])
      powersave()
      

system_bus = dbus.SystemBus()


obj = system_bus.get_object('org.freedesktop.Hal', '/org/freedesktop/Hal/Manager')
hal_manager = dbus.Interface(obj, 'org.freedesktop.Hal.Manager')

for x in hal_manager.FindDeviceByCapability('net.80211'):
  hal_device_obj = system_bus.get_object('org.freedesktop.Hal', x)
  hal_device = dbus.Interface(hal_device_obj, "org.freedesktop.Hal.Device")
  if hal_device.GetProperty('net.interface') == 'wlan0':
    wlan0_path = x

if wlan0_path is None:
  sys.exit(1)

system_bus.add_signal_receiver(system_activity, 'SystemActivity', 'org.tspre.dsme')
system_bus.add_signal_receiver(device_state, 'StateChanged', 'org.freedesktop.NetworkManager.Device', path=wlan0_path)

gobject.MainLoop().run()
