/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.HKSCS;
import sun.nio.cs.ext.MS950;

public class MS950_HKSCS
extends Charset
implements HistoricallyNamedCharset {
    public MS950_HKSCS() {
        super("x-MS950-HKSCS", ExtendedCharsets.aliasesFor("x-MS950-HKSCS"));
    }

    public String historicalName() {
        return "MS950_HKSCS";
    }

    public boolean contains(Charset cs) {
        return cs.name().equals("US-ASCII") || cs instanceof MS950 || cs instanceof MS950_HKSCS;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Encoder
    extends HKSCS.Encoder {
        private MS950.Encoder ms950Enc;

        protected int encodeDouble(char ch) {
            int r = super.encodeDouble(ch);
            return r != 0 ? r : this.ms950Enc.encodeDouble(ch);
        }

        private Encoder(Charset cs) {
            super(cs);
            this.ms950Enc = new MS950.Encoder(cs);
        }
    }

    private static class Decoder
    extends HKSCS.Decoder {
        private MS950.Decoder ms950Dec;

        protected char decodeDouble(int byte1, int byte2) {
            char c = super.decodeDouble(byte1, byte2);
            return c != '\ufffd' ? c : this.ms950Dec.decodeDouble(byte1, byte2);
        }

        private Decoder(Charset cs) {
            super(cs);
            this.ms950Dec = new MS950.Decoder(cs);
        }
    }
}

