/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.security;

import com.sun.jmx.mbeanserver.GetPropertyAction;
import java.io.ObjectInputStream;
import java.security.AccessController;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;
import javax.management.remote.MBeanServerForwarder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MBeanServerAccessController
implements MBeanServerForwarder {
    private MBeanServer mbs;

    @Override
    public MBeanServer getMBeanServer() {
        return this.mbs;
    }

    @Override
    public void setMBeanServer(MBeanServer mbs) {
        if (mbs == null) {
            throw new IllegalArgumentException("Null MBeanServer");
        }
        if (this.mbs != null) {
            throw new IllegalArgumentException("MBeanServer object already initialized");
        }
        this.mbs = mbs;
    }

    protected abstract void checkRead();

    protected abstract void checkWrite();

    @Override
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.checkRead();
        this.getMBeanServer().addNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.checkRead();
        this.getMBeanServer().addNotificationListener(name, listener, filter, handback);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        this.checkWrite();
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            Object object = this.getMBeanServer().instantiate(className);
            this.checkClassLoader(object);
            return this.getMBeanServer().registerMBean(object, name);
        }
        return this.getMBeanServer().createMBean(className, name);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        this.checkWrite();
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            Object object = this.getMBeanServer().instantiate(className, params, signature);
            this.checkClassLoader(object);
            return this.getMBeanServer().registerMBean(object, name);
        }
        return this.getMBeanServer().createMBean(className, name, params, signature);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        this.checkWrite();
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            Object object = this.getMBeanServer().instantiate(className, loaderName);
            this.checkClassLoader(object);
            return this.getMBeanServer().registerMBean(object, name);
        }
        return this.getMBeanServer().createMBean(className, name, loaderName);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        this.checkWrite();
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            Object object = this.getMBeanServer().instantiate(className, loaderName, params, signature);
            this.checkClassLoader(object);
            return this.getMBeanServer().registerMBean(object, name);
        }
        return this.getMBeanServer().createMBean(className, name, loaderName, params, signature);
    }

    @Override
    @Deprecated
    public ObjectInputStream deserialize(ObjectName name, byte[] data) throws InstanceNotFoundException, OperationsException {
        this.checkRead();
        return this.getMBeanServer().deserialize(name, data);
    }

    @Override
    @Deprecated
    public ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
        this.checkRead();
        return this.getMBeanServer().deserialize(className, data);
    }

    @Override
    @Deprecated
    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws InstanceNotFoundException, OperationsException, ReflectionException {
        this.checkRead();
        return this.getMBeanServer().deserialize(className, loaderName, data);
    }

    @Override
    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        this.checkRead();
        return this.getMBeanServer().getAttribute(name, attribute);
    }

    @Override
    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        this.checkRead();
        return this.getMBeanServer().getAttributes(name, attributes);
    }

    @Override
    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        this.checkRead();
        return this.getMBeanServer().getClassLoader(loaderName);
    }

    @Override
    public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
        this.checkRead();
        return this.getMBeanServer().getClassLoaderFor(mbeanName);
    }

    @Override
    public ClassLoaderRepository getClassLoaderRepository() {
        this.checkRead();
        return this.getMBeanServer().getClassLoaderRepository();
    }

    @Override
    public String getDefaultDomain() {
        this.checkRead();
        return this.getMBeanServer().getDefaultDomain();
    }

    @Override
    public String[] getDomains() {
        this.checkRead();
        return this.getMBeanServer().getDomains();
    }

    @Override
    public Integer getMBeanCount() {
        this.checkRead();
        return this.getMBeanServer().getMBeanCount();
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        this.checkRead();
        return this.getMBeanServer().getMBeanInfo(name);
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        this.checkRead();
        return this.getMBeanServer().getObjectInstance(name);
    }

    @Override
    public Object instantiate(String className) throws ReflectionException, MBeanException {
        this.checkWrite();
        return this.getMBeanServer().instantiate(className);
    }

    @Override
    public Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        this.checkWrite();
        return this.getMBeanServer().instantiate(className, params, signature);
    }

    @Override
    public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        this.checkWrite();
        return this.getMBeanServer().instantiate(className, loaderName);
    }

    @Override
    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
        this.checkWrite();
        return this.getMBeanServer().instantiate(className, loaderName, params, signature);
    }

    @Override
    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        this.checkWrite();
        this.checkMLetMethods(name, operationName);
        return this.getMBeanServer().invoke(name, operationName, params, signature);
    }

    @Override
    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        this.checkRead();
        return this.getMBeanServer().isInstanceOf(name, className);
    }

    @Override
    public boolean isRegistered(ObjectName name) {
        this.checkRead();
        return this.getMBeanServer().isRegistered(name);
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) {
        this.checkRead();
        return this.getMBeanServer().queryMBeans(name, query);
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) {
        this.checkRead();
        return this.getMBeanServer().queryNames(name, query);
    }

    @Override
    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        this.checkWrite();
        return this.getMBeanServer().registerMBean(object, name);
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.checkRead();
        this.getMBeanServer().removeNotificationListener(name, listener);
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.checkRead();
        this.getMBeanServer().removeNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.checkRead();
        this.getMBeanServer().removeNotificationListener(name, listener);
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.checkRead();
        this.getMBeanServer().removeNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.checkWrite();
        this.getMBeanServer().setAttribute(name, attribute);
    }

    @Override
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        this.checkWrite();
        return this.getMBeanServer().setAttributes(name, attributes);
    }

    @Override
    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        this.checkWrite();
        this.getMBeanServer().unregisterMBean(name);
    }

    private void checkClassLoader(Object object) {
        if (object instanceof ClassLoader) {
            throw new SecurityException("Access denied! Creating an MBean that is a ClassLoader is forbidden unless a security manager is installed.");
        }
    }

    private void checkMLetMethods(ObjectName name, String operation) throws InstanceNotFoundException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return;
        }
        if (!operation.equals("addURL") && !operation.equals("getMBeansFromURL")) {
            return;
        }
        if (!this.getMBeanServer().isInstanceOf(name, "javax.management.loading.MLet")) {
            return;
        }
        if (operation.equals("addURL")) {
            throw new SecurityException("Access denied! MLet method addURL cannot be invoked unless a security manager is installed.");
        }
        String propName = "jmx.remote.x.mlet.allow.getMBeansFromURL";
        GetPropertyAction propAction = new GetPropertyAction("jmx.remote.x.mlet.allow.getMBeansFromURL");
        String propValue = AccessController.doPrivileged(propAction);
        boolean allowGetMBeansFromURL = "true".equalsIgnoreCase(propValue);
        if (!allowGetMBeansFromURL) {
            throw new SecurityException("Access denied! MLet method getMBeansFromURL cannot be invoked unless a security manager is installed or the system property -Djmx.remote.x.mlet.allow.getMBeansFromURL=true is specified.");
        }
    }
}

