/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.daemon;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.SnmpEngine;
import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpPdu;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpValue;
import com.sun.jmx.snmp.SnmpVarBind;
import com.sun.jmx.snmp.ThreadContext;
import com.sun.jmx.snmp.agent.SnmpMibAgent;
import com.sun.jmx.snmp.daemon.SnmpAdaptorServer;
import com.sun.jmx.snmp.daemon.SnmpSubRequestHandler;
import com.sun.jmx.snmp.internal.SnmpIncomingRequest;
import java.util.logging.Level;

class SnmpSubNextRequestHandler
extends SnmpSubRequestHandler {
    private SnmpAdaptorServer server = null;

    protected SnmpSubNextRequestHandler(SnmpAdaptorServer server, SnmpMibAgent agent2, SnmpPdu req) {
        super(agent2, req);
        this.init(req, server);
    }

    protected SnmpSubNextRequestHandler(SnmpEngine engine, SnmpAdaptorServer server, SnmpIncomingRequest incRequest, SnmpMibAgent agent2, SnmpPdu req) {
        super(engine, incRequest, agent2, req);
        this.init(req, server);
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSubNextRequestHandler.class.getName(), "SnmpSubNextRequestHandler", "Constructor : " + this);
        }
    }

    private void init(SnmpPdu req, SnmpAdaptorServer server) {
        this.server = server;
        int max = this.translation.length;
        SnmpVarBind[] list = req.varBindList;
        SnmpSubRequestHandler.NonSyncVector nonSyncVarBind = (SnmpSubRequestHandler.NonSyncVector)this.varBind;
        for (int i = 0; i < max; ++i) {
            this.translation[i] = i;
            SnmpVarBind newVarBind = new SnmpVarBind(list[i].oid, list[i].value);
            nonSyncVarBind.addNonSyncElement(newVarBind);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block8: {
            try {
                ThreadContext oldContext = ThreadContext.push("SnmpUserData", this.data);
                try {
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:getNext operation on " + this.agent.getMibName());
                    }
                    this.agent.getNext(this.createMibRequest(this.varBind, 220, this.data));
                    Object var3_4 = null;
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    ThreadContext.restore(oldContext);
                    throw throwable;
                }
                ThreadContext.restore(oldContext);
                {
                }
            }
            catch (SnmpStatusException x) {
                this.errorStatus = x.getStatus();
                this.errorIndex = x.getErrorIndex();
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:an Snmp error occured during the operation", x);
                }
            }
            catch (Exception x) {
                this.errorStatus = 0;
                if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) break block8;
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:a generic error occured during the operation", x);
            }
        }
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:operation completed");
        }
    }

    protected void updateRequest(SnmpVarBind var, int pos) {
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSubRequestHandler.class.getName(), "updateRequest", "Copy :" + var);
        }
        int size = this.varBind.size();
        this.translation[size] = pos;
        SnmpVarBind newVarBind = new SnmpVarBind(var.oid, var.value);
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSubRequestHandler.class.getName(), "updateRequest", "Copied :" + newVarBind);
        }
        this.varBind.addElement(newVarBind);
    }

    protected void updateResult(SnmpVarBind[] result) {
        int max = this.varBind.size();
        for (int i = 0; i < max; ++i) {
            int index = this.translation[i];
            SnmpVarBind elmt = (SnmpVarBind)((SnmpSubRequestHandler.NonSyncVector)this.varBind).elementAtNonSync(i);
            SnmpVarBind vb = result[index];
            if (vb == null) {
                result[index] = elmt;
                continue;
            }
            SnmpValue val = vb.value;
            if (val == null || val == SnmpVarBind.endOfMibView) {
                if (elmt == null || elmt.value == SnmpVarBind.endOfMibView) continue;
                result[index] = elmt;
                continue;
            }
            if (elmt == null || elmt.value == SnmpVarBind.endOfMibView) continue;
            int comp = elmt.oid.compareTo(vb.oid);
            if (comp < 0) {
                result[index] = elmt;
                continue;
            }
            if (comp != 0) continue;
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "updateResult", " oid overlapping. Oid : " + elmt.oid + "value :" + elmt.value);
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "updateResult", "Already present varBind : " + vb);
            }
            SnmpOid oid = vb.oid;
            SnmpMibAgent deeperAgent = this.server.getAgentMib(oid);
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "updateResult", "Deeper agent : " + deeperAgent);
            }
            if (deeperAgent != this.agent) continue;
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "updateResult", "The current agent is the deeper one. Update the value with the current one");
            }
            result[index].value = elmt.value;
        }
    }
}

