/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.ASCII;
import java.util.regex.Matcher;
import java.util.regex.PatternSyntaxException;

public final class Pattern
implements Serializable {
    public static final int UNIX_LINES = 1;
    public static final int CASE_INSENSITIVE = 2;
    public static final int COMMENTS = 4;
    public static final int MULTILINE = 8;
    public static final int LITERAL = 16;
    public static final int DOTALL = 32;
    public static final int UNICODE_CASE = 64;
    public static final int CANON_EQ = 128;
    private static final long serialVersionUID = 5073258162644648461L;
    private String pattern;
    private int flags;
    private volatile transient boolean compiled = false;
    private transient String normalizedPattern;
    transient Node root;
    transient Node matchRoot;
    transient int[] buffer;
    transient GroupHead[] groupNodes;
    private transient int[] temp;
    transient int capturingGroupCount;
    transient int localCount;
    private transient int cursor;
    private transient int patternLength;
    static final int MAX_REPS = Integer.MAX_VALUE;
    static final int GREEDY = 0;
    static final int LAZY = 1;
    static final int POSSESSIVE = 2;
    static final int INDEPENDENT = 3;
    static Node lookbehindEnd = new Node(){

        boolean match(Matcher matcher, int i, CharSequence seq) {
            return i == matcher.lookbehindTo;
        }
    };
    static Node accept = new Node();
    static Node lastAccept = new LastNode();

    public static Pattern compile(String regex) {
        return new Pattern(regex, 0);
    }

    public static Pattern compile(String regex, int flags) {
        return new Pattern(regex, flags);
    }

    public String pattern() {
        return this.pattern;
    }

    public String toString() {
        return this.pattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Matcher matcher(CharSequence input) {
        if (!this.compiled) {
            Pattern pattern = this;
            synchronized (pattern) {
                if (!this.compiled) {
                    this.compile();
                }
            }
        }
        Matcher m = new Matcher(this, input);
        return m;
    }

    public int flags() {
        return this.flags;
    }

    public static boolean matches(String regex, CharSequence input) {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(input);
        return m.matches();
    }

    public String[] split(CharSequence input, int limit) {
        int resultSize;
        int index = 0;
        boolean matchLimited = limit > 0;
        ArrayList<String> matchList = new ArrayList<String>();
        Matcher m = this.matcher(input);
        while (m.find()) {
            String match;
            if (!matchLimited || matchList.size() < limit - 1) {
                match = ((Object)input.subSequence(index, m.start())).toString();
                matchList.add(match);
                index = m.end();
                continue;
            }
            if (matchList.size() != limit - 1) continue;
            match = ((Object)input.subSequence(index, input.length())).toString();
            matchList.add(match);
            index = m.end();
        }
        if (index == 0) {
            return new String[]{((Object)input).toString()};
        }
        if (!matchLimited || matchList.size() < limit) {
            matchList.add(((Object)input.subSequence(index, input.length())).toString());
        }
        if (limit == 0) {
            for (resultSize = matchList.size(); resultSize > 0 && ((String)matchList.get(resultSize - 1)).equals(""); --resultSize) {
            }
        }
        String[] result = new String[resultSize];
        return matchList.subList(0, resultSize).toArray(result);
    }

    public String[] split(CharSequence input) {
        return this.split(input, 0);
    }

    public static String quote(String s) {
        int slashEIndex = s.indexOf("\\E");
        if (slashEIndex == -1) {
            return "\\Q" + s + "\\E";
        }
        StringBuilder sb = new StringBuilder(s.length() * 2);
        sb.append("\\Q");
        slashEIndex = 0;
        int current = 0;
        while ((slashEIndex = s.indexOf("\\E", current)) != -1) {
            sb.append(s.substring(current, slashEIndex));
            current = slashEIndex + 2;
            sb.append("\\E\\\\E\\Q");
        }
        sb.append(s.substring(current, s.length()));
        sb.append("\\E");
        return sb.toString();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.capturingGroupCount = 1;
        this.localCount = 0;
        this.compiled = false;
        if (this.pattern.length() == 0) {
            this.root = new Start(lastAccept);
            this.matchRoot = lastAccept;
            this.compiled = true;
        }
    }

    private Pattern(String p, int f) {
        this.pattern = p;
        this.flags = f;
        this.capturingGroupCount = 1;
        this.localCount = 0;
        if (this.pattern.length() > 0) {
            this.compile();
        } else {
            this.root = new Start(lastAccept);
            this.matchRoot = lastAccept;
        }
    }

    private void normalize() {
        int c;
        boolean inCharClass = false;
        int lastCodePoint = -1;
        this.normalizedPattern = Normalizer.normalize(this.pattern, Normalizer.Form.NFD);
        this.patternLength = this.normalizedPattern.length();
        StringBuilder newPattern = new StringBuilder(this.patternLength);
        for (int i = 0; i < this.patternLength; i += Character.charCount(c)) {
            c = this.normalizedPattern.codePointAt(i);
            if (Character.getType(c) == 6 && lastCodePoint != -1) {
                StringBuilder sequenceBuffer = new StringBuilder();
                sequenceBuffer.appendCodePoint(lastCodePoint);
                sequenceBuffer.appendCodePoint(c);
                while (Character.getType(c) == 6 && (i += Character.charCount(c)) < this.patternLength) {
                    c = this.normalizedPattern.codePointAt(i);
                    sequenceBuffer.appendCodePoint(c);
                }
                String ea = this.produceEquivalentAlternation(sequenceBuffer.toString());
                newPattern.setLength(newPattern.length() - Character.charCount(lastCodePoint));
                newPattern.append("(?:").append(ea).append(")");
            } else if (c == 91 && lastCodePoint != 92) {
                i = this.normalizeCharClass(newPattern, i);
            } else {
                newPattern.appendCodePoint(c);
            }
            lastCodePoint = c;
        }
        this.normalizedPattern = newPattern.toString();
    }

    private int normalizeCharClass(StringBuilder newPattern, int i) {
        int c;
        StringBuilder charClass = new StringBuilder();
        StringBuilder eq = null;
        int lastCodePoint = -1;
        ++i;
        charClass.append("[");
        while (true) {
            if ((c = this.normalizedPattern.codePointAt(i)) == 93 && lastCodePoint != 92) break;
            if (Character.getType(c) == 6) {
                StringBuilder sequenceBuffer = new StringBuilder();
                sequenceBuffer.appendCodePoint(lastCodePoint);
                while (Character.getType(c) == 6) {
                    sequenceBuffer.appendCodePoint(c);
                    if ((i += Character.charCount(c)) >= this.normalizedPattern.length()) break;
                    c = this.normalizedPattern.codePointAt(i);
                }
                String ea = this.produceEquivalentAlternation(sequenceBuffer.toString());
                charClass.setLength(charClass.length() - Character.charCount(lastCodePoint));
                if (eq == null) {
                    eq = new StringBuilder();
                }
                eq.append('|');
                eq.append(ea);
            } else {
                charClass.appendCodePoint(c);
                ++i;
            }
            if (i == this.normalizedPattern.length()) {
                throw this.error("Unclosed character class");
            }
            lastCodePoint = c;
        }
        charClass.append((char)c);
        String result = eq != null ? "(?:" + charClass.toString() + eq.toString() + ")" : charClass.toString();
        newPattern.append(result);
        return i;
    }

    private String produceEquivalentAlternation(String source) {
        int len = Pattern.countChars(source, 0, 1);
        if (source.length() == len) {
            return source;
        }
        String base = source.substring(0, len);
        String combiningMarks = source.substring(len);
        String[] perms = this.producePermutations(combiningMarks);
        StringBuilder result = new StringBuilder(source);
        for (int x = 0; x < perms.length; ++x) {
            String next = base + perms[x];
            if (x > 0) {
                result.append("|" + next);
            }
            if ((next = this.composeOneStep(next)) == null) continue;
            result.append("|" + this.produceEquivalentAlternation(next));
        }
        return result.toString();
    }

    private String[] producePermutations(String input) {
        if (input.length() == Pattern.countChars(input, 0, 1)) {
            return new String[]{input};
        }
        if (input.length() == Pattern.countChars(input, 0, 2)) {
            int c0 = Character.codePointAt(input, 0);
            int c1 = Character.codePointAt(input, Character.charCount(c0));
            if (this.getClass(c1) == this.getClass(c0)) {
                return new String[]{input};
            }
            String[] result = new String[2];
            result[0] = input;
            StringBuilder sb = new StringBuilder(2);
            sb.appendCodePoint(c1);
            sb.appendCodePoint(c0);
            result[1] = sb.toString();
            return result;
        }
        int length = 1;
        int nCodePoints = Pattern.countCodePoints(input);
        for (int x = 1; x < nCodePoints; ++x) {
            length *= x + 1;
        }
        String[] temp = new String[length];
        int[] combClass = new int[nCodePoints];
        int i = 0;
        for (int x = 0; x < nCodePoints; ++x) {
            int c = Character.codePointAt(input, i);
            combClass[x] = this.getClass(c);
            i += Character.charCount(c);
        }
        int index = 0;
        int x = 0;
        int offset = 0;
        while (x < nCodePoints) {
            int len;
            block10: {
                len = Pattern.countChars(input, offset, 1);
                boolean skip = false;
                for (int y = x - 1; y >= 0; --y) {
                    if (combClass[y] != combClass[x]) {
                        continue;
                    }
                    break block10;
                }
                StringBuilder sb = new StringBuilder(input);
                String otherChars = sb.delete(offset, offset + len).toString();
                String[] subResult = this.producePermutations(otherChars);
                String prefix = input.substring(offset, offset + len);
                for (int y = 0; y < subResult.length; ++y) {
                    temp[index++] = prefix + subResult[y];
                }
            }
            ++x;
            offset += len;
        }
        String[] result = new String[index];
        for (int x2 = 0; x2 < index; ++x2) {
            result[x2] = temp[x2];
        }
        return result;
    }

    private int getClass(int c) {
        return sun.text.Normalizer.getCombiningClass(c);
    }

    private String composeOneStep(String input) {
        int len = Pattern.countChars(input, 0, 2);
        String firstTwoCharacters = input.substring(0, len);
        String result = Normalizer.normalize(firstTwoCharacters, Normalizer.Form.NFC);
        if (result.equals(firstTwoCharacters)) {
            return null;
        }
        String remainder = input.substring(len);
        return result + remainder;
    }

    private void RemoveQEQuoting() {
        int pLen = this.patternLength;
        int i = 0;
        while (i < pLen - 1) {
            if (this.temp[i] != 92) {
                ++i;
                continue;
            }
            if (this.temp[i + 1] == 81) break;
            i += 2;
        }
        if (i >= pLen - 1) {
            return;
        }
        int j = i;
        int[] newtemp = new int[j + 2 * (pLen - (i += 2)) + 2];
        System.arraycopy(this.temp, 0, newtemp, 0, j);
        boolean inQuote = true;
        while (i < pLen) {
            int c;
            if (!ASCII.isAscii(c = this.temp[i++]) || ASCII.isAlnum(c)) {
                newtemp[j++] = c;
                continue;
            }
            if (c != 92) {
                if (inQuote) {
                    newtemp[j++] = 92;
                }
                newtemp[j++] = c;
                continue;
            }
            if (inQuote) {
                if (this.temp[i] == 69) {
                    ++i;
                    inQuote = false;
                    continue;
                }
                newtemp[j++] = 92;
                newtemp[j++] = 92;
                continue;
            }
            if (this.temp[i] == 81) {
                ++i;
                inQuote = true;
                continue;
            }
            newtemp[j++] = c;
            if (i == pLen) continue;
            newtemp[j++] = this.temp[i++];
        }
        this.patternLength = j;
        this.temp = Arrays.copyOf(newtemp, j + 2);
    }

    private void compile() {
        int c;
        if (this.has(128) && !this.has(16)) {
            this.normalize();
        } else {
            this.normalizedPattern = this.pattern;
        }
        this.patternLength = this.normalizedPattern.length();
        this.temp = new int[this.patternLength + 2];
        boolean hasSupplementary = false;
        int count = 0;
        for (int x = 0; x < this.patternLength; x += Character.charCount(c)) {
            c = this.normalizedPattern.codePointAt(x);
            if (Pattern.isSupplementary(c)) {
                hasSupplementary = true;
            }
            this.temp[count++] = c;
        }
        this.patternLength = count;
        if (!this.has(16)) {
            this.RemoveQEQuoting();
        }
        this.buffer = new int[32];
        this.groupNodes = new GroupHead[10];
        if (this.has(16)) {
            this.matchRoot = this.newSlice(this.temp, this.patternLength, hasSupplementary);
            this.matchRoot.next = lastAccept;
        } else {
            this.matchRoot = this.expr(lastAccept);
            if (this.patternLength != this.cursor) {
                if (this.peek() == 41) {
                    throw this.error("Unmatched closing ')'");
                }
                throw this.error("Unexpected internal error");
            }
        }
        if (this.matchRoot instanceof Slice) {
            this.root = BnM.optimize(this.matchRoot);
            if (this.root == this.matchRoot) {
                this.root = hasSupplementary ? new StartS(this.matchRoot) : new Start(this.matchRoot);
            }
        } else {
            this.root = this.matchRoot instanceof Begin || this.matchRoot instanceof First ? this.matchRoot : (hasSupplementary ? new StartS(this.matchRoot) : new Start(this.matchRoot));
        }
        this.temp = null;
        this.buffer = null;
        this.groupNodes = null;
        this.patternLength = 0;
        this.compiled = true;
    }

    private static void printObjectTree(Node node) {
        while (node != null) {
            if (node instanceof Prolog) {
                System.out.println(node);
                Pattern.printObjectTree(((Prolog)node).loop);
                System.out.println("**** end contents prolog loop");
            } else if (node instanceof Loop) {
                System.out.println(node);
                Pattern.printObjectTree(((Loop)node).body);
                System.out.println("**** end contents Loop body");
            } else if (node instanceof Curly) {
                System.out.println(node);
                Pattern.printObjectTree(((Curly)node).atom);
                System.out.println("**** end contents Curly body");
            } else if (node instanceof GroupCurly) {
                System.out.println(node);
                Pattern.printObjectTree(((GroupCurly)node).atom);
                System.out.println("**** end contents GroupCurly body");
            } else {
                if (node instanceof GroupTail) {
                    System.out.println(node);
                    System.out.println("Tail next is " + node.next);
                    return;
                }
                System.out.println(node);
            }
            node = node.next;
            if (node != null) {
                System.out.println("->next:");
            }
            if (node != accept) continue;
            System.out.println("Accept Node");
            node = null;
        }
    }

    private boolean has(int f) {
        return (this.flags & f) != 0;
    }

    private void accept(int ch, String s) {
        int testChar = this.temp[this.cursor++];
        if (this.has(4)) {
            testChar = this.parsePastWhitespace(testChar);
        }
        if (ch != testChar) {
            throw this.error(s);
        }
    }

    private void mark(int c) {
        this.temp[this.patternLength] = c;
    }

    private int peek() {
        int ch = this.temp[this.cursor];
        if (this.has(4)) {
            ch = this.peekPastWhitespace(ch);
        }
        return ch;
    }

    private int read() {
        int ch = this.temp[this.cursor++];
        if (this.has(4)) {
            ch = this.parsePastWhitespace(ch);
        }
        return ch;
    }

    private int readEscaped() {
        int ch = this.temp[this.cursor++];
        return ch;
    }

    private int next() {
        int ch = this.temp[++this.cursor];
        if (this.has(4)) {
            ch = this.peekPastWhitespace(ch);
        }
        return ch;
    }

    private int nextEscaped() {
        int ch = this.temp[++this.cursor];
        return ch;
    }

    private int peekPastWhitespace(int ch) {
        while (ASCII.isSpace(ch) || ch == 35) {
            while (ASCII.isSpace(ch)) {
                ch = this.temp[++this.cursor];
            }
            if (ch != 35) continue;
            ch = this.peekPastLine();
        }
        return ch;
    }

    private int parsePastWhitespace(int ch) {
        while (ASCII.isSpace(ch) || ch == 35) {
            while (ASCII.isSpace(ch)) {
                ch = this.temp[this.cursor++];
            }
            if (ch != 35) continue;
            ch = this.parsePastLine();
        }
        return ch;
    }

    private int parsePastLine() {
        int ch = this.temp[this.cursor++];
        while (ch != 0 && !this.isLineSeparator(ch)) {
            ch = this.temp[this.cursor++];
        }
        return ch;
    }

    private int peekPastLine() {
        int ch = this.temp[++this.cursor];
        while (ch != 0 && !this.isLineSeparator(ch)) {
            ch = this.temp[++this.cursor];
        }
        return ch;
    }

    private boolean isLineSeparator(int ch) {
        if (this.has(1)) {
            return ch == 10;
        }
        return ch == 10 || ch == 13 || (ch | 1) == 8233 || ch == 133;
    }

    private int skip() {
        int i = this.cursor;
        int ch = this.temp[i + 1];
        this.cursor = i + 2;
        return ch;
    }

    private void unread() {
        --this.cursor;
    }

    private PatternSyntaxException error(String s) {
        return new PatternSyntaxException(s, this.normalizedPattern, this.cursor - 1);
    }

    private boolean findSupplementary(int start, int end) {
        for (int i = start; i < end; ++i) {
            if (!Pattern.isSupplementary(this.temp[i])) continue;
            return true;
        }
        return false;
    }

    private static final boolean isSupplementary(int ch) {
        return ch >= 65536 || Pattern.isSurrogate(ch);
    }

    private Node expr(Node end) {
        Node prev = null;
        Node firstTail = null;
        BranchConn branchConn = null;
        while (true) {
            Node node = this.sequence(end);
            Node nodeTail = this.root;
            if (prev == null) {
                prev = node;
                firstTail = nodeTail;
            } else {
                if (branchConn == null) {
                    branchConn = new BranchConn();
                    branchConn.next = end;
                }
                if (node == end) {
                    node = null;
                } else {
                    nodeTail.next = branchConn;
                }
                if (prev instanceof Branch) {
                    ((Branch)prev).add(node);
                } else {
                    if (prev == end) {
                        prev = null;
                    } else {
                        firstTail.next = branchConn;
                    }
                    prev = new Branch(prev, node, branchConn);
                }
            }
            if (this.peek() != 124) {
                return prev;
            }
            this.next();
        }
    }

    private Node sequence(Node end) {
        Node head = null;
        Node tail = null;
        Node node = null;
        block12: while (true) {
            int ch = this.peek();
            switch (ch) {
                case 40: {
                    node = this.group0();
                    if (node == null) continue block12;
                    if (head == null) {
                        head = node;
                    } else {
                        tail.next = node;
                    }
                    tail = this.root;
                    continue block12;
                }
                case 91: {
                    node = this.clazz(true);
                    break;
                }
                case 92: {
                    ch = this.nextEscaped();
                    if (ch == 112 || ch == 80) {
                        boolean oneLetter = true;
                        boolean comp = ch == 80;
                        ch = this.next();
                        if (ch != 123) {
                            this.unread();
                        } else {
                            oneLetter = false;
                        }
                        node = this.family(oneLetter).maybeComplement(comp);
                        break;
                    }
                    this.unread();
                    node = this.atom();
                    break;
                }
                case 94: {
                    this.next();
                    if (this.has(8)) {
                        if (this.has(1)) {
                            node = new UnixCaret();
                            break;
                        }
                        node = new Caret();
                        break;
                    }
                    node = new Begin();
                    break;
                }
                case 36: {
                    this.next();
                    if (this.has(1)) {
                        node = new UnixDollar(this.has(8));
                        break;
                    }
                    node = new Dollar(this.has(8));
                    break;
                }
                case 46: {
                    this.next();
                    if (this.has(32)) {
                        node = new All();
                        break;
                    }
                    if (this.has(1)) {
                        node = new UnixDot();
                        break;
                    }
                    node = new Dot();
                    break;
                }
                case 41: 
                case 124: {
                    break block12;
                }
                case 93: 
                case 125: {
                    node = this.atom();
                    break;
                }
                case 42: 
                case 43: 
                case 63: {
                    this.next();
                    throw this.error("Dangling meta character '" + (char)ch + "'");
                }
                case 0: {
                    if (this.cursor >= this.patternLength) break block12;
                }
                default: {
                    node = this.atom();
                }
            }
            node = this.closure(node);
            if (head == null) {
                head = tail = node;
                continue;
            }
            tail.next = node;
            tail = node;
        }
        if (head == null) {
            return end;
        }
        tail.next = end;
        this.root = tail;
        return head;
    }

    private Node atom() {
        int first = 0;
        int prev = -1;
        boolean hasSupplementary = false;
        int ch = this.peek();
        block6: while (true) {
            switch (ch) {
                case 42: 
                case 43: 
                case 63: 
                case 123: {
                    if (first <= true) break block6;
                    this.cursor = prev;
                    --first;
                    break block6;
                }
                case 36: 
                case 40: 
                case 41: 
                case 46: 
                case 91: 
                case 94: 
                case 124: {
                    break block6;
                }
                case 92: {
                    ch = this.nextEscaped();
                    if (ch == 112 || ch == 80) {
                        if (first > 0) {
                            this.unread();
                            break block6;
                        }
                        boolean comp = ch == 80;
                        boolean oneLetter = true;
                        ch = this.next();
                        if (ch != 123) {
                            this.unread();
                        } else {
                            oneLetter = false;
                        }
                        return this.family(oneLetter).maybeComplement(comp);
                    }
                    this.unread();
                    prev = this.cursor;
                    ch = this.escape(false, first == 0);
                    if (ch >= 0) {
                        this.append(ch, first);
                        ++first;
                        if (Pattern.isSupplementary(ch)) {
                            hasSupplementary = true;
                        }
                        ch = this.peek();
                        continue block6;
                    }
                    if (first == 0) {
                        return this.root;
                    }
                    this.cursor = prev;
                    break block6;
                }
                case 0: {
                    if (this.cursor >= this.patternLength) break block6;
                }
                default: {
                    prev = this.cursor;
                    this.append(ch, first);
                    ++first;
                    if (Pattern.isSupplementary(ch)) {
                        hasSupplementary = true;
                    }
                    ch = this.next();
                    continue block6;
                }
            }
            break;
        }
        if (first == 1) {
            return this.newSingle(this.buffer[0]);
        }
        return this.newSlice(this.buffer, first, hasSupplementary);
    }

    private void append(int ch, int len) {
        if (len >= this.buffer.length) {
            int[] tmp = new int[len + len];
            System.arraycopy(this.buffer, 0, tmp, 0, len);
            this.buffer = tmp;
        }
        this.buffer[len] = ch;
    }

    private Node ref(int refNum) {
        boolean done = false;
        block3: while (!done) {
            int ch = this.peek();
            switch (ch) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    int newRefNum = refNum * 10 + (ch - 48);
                    if (this.capturingGroupCount - 1 < newRefNum) {
                        done = true;
                        continue block3;
                    }
                    refNum = newRefNum;
                    this.read();
                    continue block3;
                }
            }
            done = true;
        }
        if (this.has(2)) {
            return new CIBackRef(refNum, this.has(64));
        }
        return new BackRef(refNum);
    }

    private int escape(boolean inclass, boolean create) {
        int ch = this.skip();
        switch (ch) {
            case 48: {
                return this.o();
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                if (inclass) break;
                if (create) {
                    this.root = this.ref(ch - 48);
                }
                return -1;
            }
            case 65: {
                if (inclass) break;
                if (create) {
                    this.root = new Begin();
                }
                return -1;
            }
            case 66: {
                if (inclass) break;
                if (create) {
                    this.root = new Bound(Bound.NONE);
                }
                return -1;
            }
            case 67: {
                break;
            }
            case 68: {
                if (create) {
                    this.root = new Ctype(1024).complement();
                }
                return -1;
            }
            case 69: 
            case 70: {
                break;
            }
            case 71: {
                if (inclass) break;
                if (create) {
                    this.root = new LastMatch();
                }
                return -1;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                break;
            }
            case 83: {
                if (create) {
                    this.root = new Ctype(2048).complement();
                }
                return -1;
            }
            case 84: 
            case 85: 
            case 86: {
                break;
            }
            case 87: {
                if (create) {
                    this.root = new Ctype(67328).complement();
                }
                return -1;
            }
            case 88: 
            case 89: {
                break;
            }
            case 90: {
                if (inclass) break;
                if (create) {
                    this.root = this.has(1) ? new UnixDollar(false) : new Dollar(false);
                }
                return -1;
            }
            case 97: {
                return 7;
            }
            case 98: {
                if (inclass) break;
                if (create) {
                    this.root = new Bound(Bound.BOTH);
                }
                return -1;
            }
            case 99: {
                return this.c();
            }
            case 100: {
                if (create) {
                    this.root = new Ctype(1024);
                }
                return -1;
            }
            case 101: {
                return 27;
            }
            case 102: {
                return 12;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                break;
            }
            case 110: {
                return 10;
            }
            case 111: 
            case 112: 
            case 113: {
                break;
            }
            case 114: {
                return 13;
            }
            case 115: {
                if (create) {
                    this.root = new Ctype(2048);
                }
                return -1;
            }
            case 116: {
                return 9;
            }
            case 117: {
                return this.u();
            }
            case 118: {
                return 11;
            }
            case 119: {
                if (create) {
                    this.root = new Ctype(67328);
                }
                return -1;
            }
            case 120: {
                return this.x();
            }
            case 121: {
                break;
            }
            case 122: {
                if (inclass) break;
                if (create) {
                    this.root = new End();
                }
                return -1;
            }
            default: {
                return ch;
            }
        }
        throw this.error("Illegal/unsupported escape sequence");
    }

    private CharProperty clazz(boolean consume) {
        CharProperty prev = null;
        CharProperty node = null;
        BitClass bits = new BitClass();
        boolean include = true;
        boolean firstInClass = true;
        int ch = this.next();
        block7: while (true) {
            switch (ch) {
                case 94: {
                    if (!firstInClass || this.temp[this.cursor - 1] != 91) break;
                    ch = this.next();
                    include = !include;
                    continue block7;
                }
                case 91: {
                    firstInClass = false;
                    node = this.clazz(true);
                    prev = prev == null ? node : Pattern.union(prev, node);
                    ch = this.peek();
                    continue block7;
                }
                case 38: {
                    firstInClass = false;
                    ch = this.next();
                    if (ch == 38) {
                        ch = this.next();
                        CharProperty rightNode = null;
                        while (ch != 93 && ch != 38) {
                            if (ch == 91) {
                                rightNode = rightNode == null ? this.clazz(true) : Pattern.union(rightNode, this.clazz(true));
                            } else {
                                this.unread();
                                rightNode = this.clazz(false);
                            }
                            ch = this.peek();
                        }
                        if (rightNode != null) {
                            node = rightNode;
                        }
                        if (prev == null) {
                            if (rightNode == null) {
                                throw this.error("Bad class syntax");
                            }
                            prev = rightNode;
                            continue block7;
                        }
                        prev = Pattern.intersection(prev, node);
                        continue block7;
                    }
                    this.unread();
                    break;
                }
                case 0: {
                    firstInClass = false;
                    if (this.cursor < this.patternLength) break;
                    throw this.error("Unclosed character class");
                }
                case 93: {
                    firstInClass = false;
                    if (prev == null) break;
                    if (consume) {
                        this.next();
                    }
                    return prev;
                }
                default: {
                    firstInClass = false;
                }
            }
            node = this.range(bits);
            if (include) {
                if (prev == null) {
                    prev = node;
                } else if (prev != node) {
                    prev = Pattern.union(prev, node);
                }
            } else if (prev == null) {
                prev = node.complement();
            } else if (prev != node) {
                prev = Pattern.setDifference(prev, node);
            }
            ch = this.peek();
        }
    }

    private CharProperty bitsOrSingle(BitClass bits, int ch) {
        if (ch < 256 && (!this.has(2) || !this.has(64) || ch != 255 && ch != 181 && ch != 73 && ch != 105 && ch != 83 && ch != 115 && ch != 75 && ch != 107 && ch != 197 && ch != 229)) {
            return bits.add(ch, this.flags());
        }
        return this.newSingle(ch);
    }

    private CharProperty range(BitClass bits) {
        int ch = this.peek();
        if (ch == 92) {
            ch = this.nextEscaped();
            if (ch == 112 || ch == 80) {
                boolean comp = ch == 80;
                boolean oneLetter = true;
                ch = this.next();
                if (ch != 123) {
                    this.unread();
                } else {
                    oneLetter = false;
                }
                return this.family(oneLetter).maybeComplement(comp);
            }
            this.unread();
            ch = this.escape(true, true);
            if (ch == -1) {
                return (CharProperty)this.root;
            }
        } else {
            ch = this.single();
        }
        if (ch >= 0) {
            if (this.peek() == 45) {
                int endRange = this.temp[this.cursor + 1];
                if (endRange == 91) {
                    return this.bitsOrSingle(bits, ch);
                }
                if (endRange != 93) {
                    this.next();
                    int m = this.single();
                    if (m < ch) {
                        throw this.error("Illegal character range");
                    }
                    if (this.has(2)) {
                        return this.caseInsensitiveRangeFor(ch, m);
                    }
                    return Pattern.rangeFor(ch, m);
                }
            }
            return this.bitsOrSingle(bits, ch);
        }
        throw this.error("Unexpected character '" + (char)ch + "'");
    }

    private int single() {
        int ch = this.peek();
        switch (ch) {
            case 92: {
                return this.escape(true, false);
            }
        }
        this.next();
        return ch;
    }

    private CharProperty family(boolean singleLetter) {
        String name;
        this.next();
        if (singleLetter) {
            int c = this.temp[this.cursor];
            name = !Character.isSupplementaryCodePoint(c) ? String.valueOf((char)c) : new String(this.temp, this.cursor, 1);
            this.read();
        } else {
            int i = this.cursor;
            this.mark(125);
            while (this.read() != 125) {
            }
            this.mark(0);
            int j = this.cursor;
            if (j > this.patternLength) {
                throw this.error("Unclosed character family");
            }
            if (i + 1 >= j) {
                throw this.error("Empty character family");
            }
            name = new String(this.temp, i, j - i - 1);
        }
        if (name.startsWith("In")) {
            return this.unicodeBlockPropertyFor(name.substring(2));
        }
        if (name.startsWith("Is")) {
            name = name.substring(2);
        }
        return this.charPropertyNodeFor(name);
    }

    private CharProperty unicodeBlockPropertyFor(String name) {
        Character.UnicodeBlock block;
        try {
            block = Character.UnicodeBlock.forName(name);
        }
        catch (IllegalArgumentException iae) {
            throw this.error("Unknown character block name {" + name + "}");
        }
        return new CharProperty(){

            boolean isSatisfiedBy(int ch) {
                return block == Character.UnicodeBlock.of(ch);
            }
        };
    }

    private CharProperty charPropertyNodeFor(String name) {
        CharProperty p = CharPropertyNames.charPropertyFor(name);
        if (p == null) {
            throw this.error("Unknown character property name {" + name + "}");
        }
        return p;
    }

    private Node group0() {
        boolean capturingGroup = false;
        Node head = null;
        Node tail = null;
        int save = this.flags;
        this.root = null;
        int ch = this.next();
        if (ch == 63) {
            ch = this.skip();
            switch (ch) {
                case 58: {
                    head = this.createGroup(true);
                    tail = this.root;
                    head.next = this.expr(tail);
                    break;
                }
                case 33: 
                case 61: {
                    head = this.createGroup(true);
                    tail = this.root;
                    head.next = this.expr(tail);
                    if (ch == 61) {
                        head = tail = new Pos(head);
                        break;
                    }
                    head = tail = new Neg(head);
                    break;
                }
                case 62: {
                    head = this.createGroup(true);
                    tail = this.root;
                    head.next = this.expr(tail);
                    head = tail = new Ques(head, 3);
                    break;
                }
                case 60: {
                    ch = this.read();
                    int start = this.cursor;
                    head = this.createGroup(true);
                    tail = this.root;
                    head.next = this.expr(tail);
                    tail.next = lookbehindEnd;
                    TreeInfo info = new TreeInfo();
                    head.study(info);
                    if (!info.maxValid) {
                        throw this.error("Look-behind group does not have an obvious maximum length");
                    }
                    boolean hasSupplementary = this.findSupplementary(start, this.patternLength);
                    if (ch == 61) {
                        tail = hasSupplementary ? new BehindS(head, info.maxLength, info.minLength) : new Behind(head, info.maxLength, info.minLength);
                        head = tail;
                        break;
                    }
                    if (ch == 33) {
                        tail = hasSupplementary ? new NotBehindS(head, info.maxLength, info.minLength) : new NotBehind(head, info.maxLength, info.minLength);
                        head = tail;
                        break;
                    }
                    throw this.error("Unknown look-behind group");
                }
                case 36: 
                case 64: {
                    throw this.error("Unknown group type");
                }
                default: {
                    this.unread();
                    this.addFlag();
                    ch = this.read();
                    if (ch == 41) {
                        return null;
                    }
                    if (ch != 58) {
                        throw this.error("Unknown inline modifier");
                    }
                    head = this.createGroup(true);
                    tail = this.root;
                    head.next = this.expr(tail);
                    break;
                }
            }
        } else {
            capturingGroup = true;
            head = this.createGroup(false);
            tail = this.root;
            head.next = this.expr(tail);
        }
        this.accept(41, "Unclosed group");
        this.flags = save;
        Node node = this.closure(head);
        if (node == head) {
            this.root = tail;
            return node;
        }
        if (head == tail) {
            this.root = node;
            return node;
        }
        if (node instanceof Ques) {
            Ques ques = (Ques)node;
            if (ques.type == 2) {
                this.root = node;
                return node;
            }
            tail = tail.next = new BranchConn();
            head = ques.type == 0 ? new Branch(head, null, tail) : new Branch(null, head, tail);
            this.root = tail;
            return head;
        }
        if (node instanceof Curly) {
            Curly curly = (Curly)node;
            if (curly.type == 2) {
                this.root = node;
                return node;
            }
            TreeInfo info = new TreeInfo();
            if (head.study(info)) {
                GroupTail temp = (GroupTail)tail;
                head = this.root = new GroupCurly(head.next, curly.cmin, curly.cmax, curly.type, ((GroupTail)tail).localIndex, ((GroupTail)tail).groupIndex, capturingGroup);
                return head;
            }
            int temp = ((GroupHead)head).localIndex;
            Loop loop = curly.type == 0 ? new Loop(this.localCount, temp) : new LazyLoop(this.localCount, temp);
            Prolog prolog = new Prolog(loop);
            ++this.localCount;
            loop.cmin = curly.cmin;
            loop.cmax = curly.cmax;
            loop.body = head;
            tail.next = loop;
            this.root = loop;
            return prolog;
        }
        throw this.error("Internal logic error");
    }

    private Node createGroup(boolean anonymous) {
        int localIndex = this.localCount++;
        int groupIndex = 0;
        if (!anonymous) {
            groupIndex = this.capturingGroupCount++;
        }
        GroupHead head = new GroupHead(localIndex);
        this.root = new GroupTail(localIndex, groupIndex);
        if (!anonymous && groupIndex < 10) {
            this.groupNodes[groupIndex] = head;
        }
        return head;
    }

    private void addFlag() {
        int ch = this.peek();
        while (true) {
            switch (ch) {
                case 105: {
                    this.flags |= 2;
                    break;
                }
                case 109: {
                    this.flags |= 8;
                    break;
                }
                case 115: {
                    this.flags |= 0x20;
                    break;
                }
                case 100: {
                    this.flags |= 1;
                    break;
                }
                case 117: {
                    this.flags |= 0x40;
                    break;
                }
                case 99: {
                    this.flags |= 0x80;
                    break;
                }
                case 120: {
                    this.flags |= 4;
                    break;
                }
                case 45: {
                    ch = this.next();
                    this.subFlag();
                }
                default: {
                    return;
                }
            }
            ch = this.next();
        }
    }

    private void subFlag() {
        int ch = this.peek();
        while (true) {
            switch (ch) {
                case 105: {
                    this.flags &= 0xFFFFFFFD;
                    break;
                }
                case 109: {
                    this.flags &= 0xFFFFFFF7;
                    break;
                }
                case 115: {
                    this.flags &= 0xFFFFFFDF;
                    break;
                }
                case 100: {
                    this.flags &= 0xFFFFFFFE;
                    break;
                }
                case 117: {
                    this.flags &= 0xFFFFFFBF;
                    break;
                }
                case 99: {
                    this.flags &= 0xFFFFFF7F;
                    break;
                }
                case 120: {
                    this.flags &= 0xFFFFFFFB;
                    break;
                }
                default: {
                    return;
                }
            }
            ch = this.next();
        }
    }

    private Node closure(Node prev) {
        int ch = this.peek();
        switch (ch) {
            case 63: {
                ch = this.next();
                if (ch == 63) {
                    this.next();
                    return new Ques(prev, 1);
                }
                if (ch == 43) {
                    this.next();
                    return new Ques(prev, 2);
                }
                return new Ques(prev, 0);
            }
            case 42: {
                ch = this.next();
                if (ch == 63) {
                    this.next();
                    return new Curly(prev, 0, Integer.MAX_VALUE, 1);
                }
                if (ch == 43) {
                    this.next();
                    return new Curly(prev, 0, Integer.MAX_VALUE, 2);
                }
                return new Curly(prev, 0, Integer.MAX_VALUE, 0);
            }
            case 43: {
                ch = this.next();
                if (ch == 63) {
                    this.next();
                    return new Curly(prev, 1, Integer.MAX_VALUE, 1);
                }
                if (ch == 43) {
                    this.next();
                    return new Curly(prev, 1, Integer.MAX_VALUE, 2);
                }
                return new Curly(prev, 1, Integer.MAX_VALUE, 0);
            }
            case 123: {
                ch = this.temp[this.cursor + 1];
                if (ASCII.isDigit(ch)) {
                    Curly curly;
                    this.skip();
                    int cmin = 0;
                    do {
                        cmin = cmin * 10 + (ch - 48);
                    } while (ASCII.isDigit(ch = this.read()));
                    int cmax = cmin;
                    if (ch == 44) {
                        ch = this.read();
                        cmax = Integer.MAX_VALUE;
                        if (ch != 125) {
                            cmax = 0;
                            while (ASCII.isDigit(ch)) {
                                cmax = cmax * 10 + (ch - 48);
                                ch = this.read();
                            }
                        }
                    }
                    if (ch != 125) {
                        throw this.error("Unclosed counted closure");
                    }
                    if ((cmin | cmax | cmax - cmin) < 0) {
                        throw this.error("Illegal repetition range");
                    }
                    ch = this.peek();
                    if (ch == 63) {
                        this.next();
                        curly = new Curly(prev, cmin, cmax, 1);
                    } else if (ch == 43) {
                        this.next();
                        curly = new Curly(prev, cmin, cmax, 2);
                    } else {
                        curly = new Curly(prev, cmin, cmax, 0);
                    }
                    return curly;
                }
                throw this.error("Illegal repetition");
            }
        }
        return prev;
    }

    private int c() {
        if (this.cursor < this.patternLength) {
            return this.read() ^ 0x40;
        }
        throw this.error("Illegal control escape sequence");
    }

    private int o() {
        int n = this.read();
        if ((n - 48 | 55 - n) >= 0) {
            int m = this.read();
            if ((m - 48 | 55 - m) >= 0) {
                int o = this.read();
                if ((o - 48 | 55 - o) >= 0 && (n - 48 | 51 - n) >= 0) {
                    return (n - 48) * 64 + (m - 48) * 8 + (o - 48);
                }
                this.unread();
                return (n - 48) * 8 + (m - 48);
            }
            this.unread();
            return n - 48;
        }
        throw this.error("Illegal octal escape sequence");
    }

    private int x() {
        int m;
        int n = this.read();
        if (ASCII.isHexDigit(n) && ASCII.isHexDigit(m = this.read())) {
            return ASCII.toDigit(n) * 16 + ASCII.toDigit(m);
        }
        throw this.error("Illegal hexadecimal escape sequence");
    }

    private int u() {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            int ch = this.read();
            if (!ASCII.isHexDigit(ch)) {
                throw this.error("Illegal Unicode escape sequence");
            }
            n = n * 16 + ASCII.toDigit(ch);
        }
        return n;
    }

    private static final boolean isSurrogate(int c) {
        return c >= 55296 && c <= 57343;
    }

    private static final int countChars(CharSequence seq, int index, int lengthInCodePoints) {
        if (lengthInCodePoints == 1 && !Character.isHighSurrogate(seq.charAt(index))) {
            assert (index >= 0 && index < seq.length());
            return 1;
        }
        int length = seq.length();
        int x = index;
        if (lengthInCodePoints >= 0) {
            assert (index >= 0 && index < length);
            for (int i = 0; x < length && i < lengthInCodePoints; ++i) {
                if (!Character.isHighSurrogate(seq.charAt(x++)) || x >= length || !Character.isLowSurrogate(seq.charAt(x))) continue;
                ++x;
            }
            return x - index;
        }
        assert (index >= 0 && index <= length);
        if (index == 0) {
            return 0;
        }
        int len = -lengthInCodePoints;
        for (int i = 0; x > 0 && i < len; ++i) {
            if (!Character.isLowSurrogate(seq.charAt(--x)) || x <= 0 || !Character.isHighSurrogate(seq.charAt(x - 1))) continue;
            --x;
        }
        return index - x;
    }

    private static final int countCodePoints(CharSequence seq) {
        int length = seq.length();
        int n = 0;
        int i = 0;
        while (i < length) {
            ++n;
            if (!Character.isHighSurrogate(seq.charAt(i++)) || i >= length || !Character.isLowSurrogate(seq.charAt(i))) continue;
            ++i;
        }
        return n;
    }

    private CharProperty newSingle(int ch) {
        if (this.has(2)) {
            int upper;
            int lower;
            if (this.has(64)) {
                int lower2;
                int upper2 = Character.toUpperCase(ch);
                if (upper2 != (lower2 = Character.toLowerCase(upper2))) {
                    return new SingleU(lower2);
                }
            } else if (ASCII.isAscii(ch) && (lower = ASCII.toLower(ch)) != (upper = ASCII.toUpper(ch))) {
                return new SingleI(lower, upper);
            }
        }
        if (Pattern.isSupplementary(ch)) {
            return new SingleS(ch);
        }
        return new Single(ch);
    }

    private Node newSlice(int[] buf, int count, boolean hasSupplementary) {
        int[] tmp = new int[count];
        if (this.has(2)) {
            if (this.has(64)) {
                for (int i = 0; i < count; ++i) {
                    tmp[i] = Character.toLowerCase(Character.toUpperCase(buf[i]));
                }
                return hasSupplementary ? new SliceUS(tmp) : new SliceU(tmp);
            }
            for (int i = 0; i < count; ++i) {
                tmp[i] = ASCII.toLower(buf[i]);
            }
            return hasSupplementary ? new SliceIS(tmp) : new SliceI(tmp);
        }
        for (int i = 0; i < count; ++i) {
            tmp[i] = buf[i];
        }
        return hasSupplementary ? new SliceS(tmp) : new Slice(tmp);
    }

    private static boolean inRange(int lower, int ch, int upper) {
        return lower <= ch && ch <= upper;
    }

    private static CharProperty rangeFor(final int lower, final int upper) {
        return new CharProperty(){

            boolean isSatisfiedBy(int ch) {
                return Pattern.inRange(lower, ch, upper);
            }
        };
    }

    private CharProperty caseInsensitiveRangeFor(final int lower, final int upper) {
        if (this.has(64)) {
            return new CharProperty(){

                boolean isSatisfiedBy(int ch) {
                    if (Pattern.inRange(lower, ch, upper)) {
                        return true;
                    }
                    int up = Character.toUpperCase(ch);
                    return Pattern.inRange(lower, up, upper) || Pattern.inRange(lower, Character.toLowerCase(up), upper);
                }
            };
        }
        return new CharProperty(){

            boolean isSatisfiedBy(int ch) {
                return Pattern.inRange(lower, ch, upper) || ASCII.isAscii(ch) && (Pattern.inRange(lower, ASCII.toUpper(ch), upper) || Pattern.inRange(lower, ASCII.toLower(ch), upper));
            }
        };
    }

    private static CharProperty union(final CharProperty lhs, final CharProperty rhs) {
        return new CharProperty(){

            boolean isSatisfiedBy(int ch) {
                return lhs.isSatisfiedBy(ch) || rhs.isSatisfiedBy(ch);
            }
        };
    }

    private static CharProperty intersection(final CharProperty lhs, final CharProperty rhs) {
        return new CharProperty(){

            boolean isSatisfiedBy(int ch) {
                return lhs.isSatisfiedBy(ch) && rhs.isSatisfiedBy(ch);
            }
        };
    }

    private static CharProperty setDifference(final CharProperty lhs, final CharProperty rhs) {
        return new CharProperty(){

            boolean isSatisfiedBy(int ch) {
                return !rhs.isSatisfiedBy(ch) && lhs.isSatisfiedBy(ch);
            }
        };
    }

    private static boolean hasBaseCharacter(Matcher matcher, int i, CharSequence seq) {
        int start = !matcher.transparentBounds ? matcher.from : 0;
        for (int x = i; x >= start; --x) {
            int ch = Character.codePointAt(seq, x);
            if (Character.isLetterOrDigit(ch)) {
                return true;
            }
            if (Character.getType(ch) == 6) continue;
            return false;
        }
        return false;
    }

    private static class CharPropertyNames {
        private static final HashMap<String, CharPropertyFactory> map = new HashMap();

        private CharPropertyNames() {
        }

        static CharProperty charPropertyFor(String name) {
            CharPropertyFactory m = map.get(name);
            return m == null ? null : m.make();
        }

        private static void defCategory(String name, final int typeMask) {
            map.put(name, new CharPropertyFactory(){

                CharProperty make() {
                    return new Category(typeMask);
                }
            });
        }

        private static void defRange(String name, final int lower, final int upper) {
            map.put(name, new CharPropertyFactory(){

                CharProperty make() {
                    return Pattern.rangeFor(lower, upper);
                }
            });
        }

        private static void defCtype(String name, final int ctype) {
            map.put(name, new CharPropertyFactory(){

                CharProperty make() {
                    return new Ctype(ctype);
                }
            });
        }

        private static void defClone(String name, final CloneableProperty p) {
            map.put(name, new CharPropertyFactory(){

                CharProperty make() {
                    return p.clone();
                }
            });
        }

        static {
            CharPropertyNames.defCategory("Cn", 1);
            CharPropertyNames.defCategory("Lu", 2);
            CharPropertyNames.defCategory("Ll", 4);
            CharPropertyNames.defCategory("Lt", 8);
            CharPropertyNames.defCategory("Lm", 16);
            CharPropertyNames.defCategory("Lo", 32);
            CharPropertyNames.defCategory("Mn", 64);
            CharPropertyNames.defCategory("Me", 128);
            CharPropertyNames.defCategory("Mc", 256);
            CharPropertyNames.defCategory("Nd", 512);
            CharPropertyNames.defCategory("Nl", 1024);
            CharPropertyNames.defCategory("No", 2048);
            CharPropertyNames.defCategory("Zs", 4096);
            CharPropertyNames.defCategory("Zl", 8192);
            CharPropertyNames.defCategory("Zp", 16384);
            CharPropertyNames.defCategory("Cc", 32768);
            CharPropertyNames.defCategory("Cf", 65536);
            CharPropertyNames.defCategory("Co", 262144);
            CharPropertyNames.defCategory("Cs", 524288);
            CharPropertyNames.defCategory("Pd", 0x100000);
            CharPropertyNames.defCategory("Ps", 0x200000);
            CharPropertyNames.defCategory("Pe", 0x400000);
            CharPropertyNames.defCategory("Pc", 0x800000);
            CharPropertyNames.defCategory("Po", 0x1000000);
            CharPropertyNames.defCategory("Sm", 0x2000000);
            CharPropertyNames.defCategory("Sc", 0x4000000);
            CharPropertyNames.defCategory("Sk", 0x8000000);
            CharPropertyNames.defCategory("So", 0x10000000);
            CharPropertyNames.defCategory("Pi", 0x20000000);
            CharPropertyNames.defCategory("Pf", 0x40000000);
            CharPropertyNames.defCategory("L", 62);
            CharPropertyNames.defCategory("M", 448);
            CharPropertyNames.defCategory("N", 3584);
            CharPropertyNames.defCategory("Z", 28672);
            CharPropertyNames.defCategory("C", 884736);
            CharPropertyNames.defCategory("P", 1643118592);
            CharPropertyNames.defCategory("S", 0x1E000000);
            CharPropertyNames.defCategory("LC", 14);
            CharPropertyNames.defCategory("LD", 574);
            CharPropertyNames.defRange("L1", 0, 255);
            map.put("all", new CharPropertyFactory(){

                CharProperty make() {
                    return new All();
                }
            });
            CharPropertyNames.defRange("ASCII", 0, 127);
            CharPropertyNames.defCtype("Alnum", 1792);
            CharPropertyNames.defCtype("Alpha", 768);
            CharPropertyNames.defCtype("Blank", 16384);
            CharPropertyNames.defCtype("Cntrl", 8192);
            CharPropertyNames.defRange("Digit", 48, 57);
            CharPropertyNames.defCtype("Graph", 5888);
            CharPropertyNames.defRange("Lower", 97, 122);
            CharPropertyNames.defRange("Print", 32, 126);
            CharPropertyNames.defCtype("Punct", 4096);
            CharPropertyNames.defCtype("Space", 2048);
            CharPropertyNames.defRange("Upper", 65, 90);
            CharPropertyNames.defCtype("XDigit", 32768);
            CharPropertyNames.defClone("javaLowerCase", new CloneableProperty(){

                boolean isSatisfiedBy(int ch) {
                    return Character.isLowerCase(ch);
                }
            });
            CharPropertyNames.defClone("javaUpperCase", new CloneableProperty(){

                boolean isSatisfiedBy(int ch) {
                    return Character.isUpperCase(ch);
                }
            });
            CharPropertyNames.defClone("javaTitleCase", new CloneableProperty(){

                boolean isSatisfiedBy(int ch) {
                    return Character.isTitleCase(ch);
                }
            });
            CharPropertyNames.defClone("javaDigit", new CloneableProperty(){

                boolean isSatisfiedBy(int ch) {
                    return Character.isDigit(ch);
                }
            });
            CharPropertyNames.defClone("javaDefined", new CloneableProperty(){

                boolean isSatisfiedBy(int ch) {
                    return Character.isDefined(ch);
                }
            });
            CharPropertyNames.defClone("javaLetter", new CloneableProperty(){

                boolean isSatisfiedBy(int ch) {
                    return Character.isLetter(ch);
                }
            });
            CharPropertyNames.defClone("javaLetterOrDigit", new CloneableProperty(){

                boolean isSatisfiedBy(int ch) {
                    return Character.isLetterOrDigit(ch);
                }
            });
            CharPropertyNames.defClone("javaJavaIdentifierStart", new CloneableProperty(){

                boolean isSatisfiedBy(int ch) {
                    return Character.isJavaIdentifierStart(ch);
                }
            });
            CharPropertyNames.defClone("javaJavaIdentifierPart", new CloneableProperty(){

                boolean isSatisfiedBy(int ch) {
                    return Character.isJavaIdentifierPart(ch);
                }
            });
            CharPropertyNames.defClone("javaUnicodeIdentifierStart", new CloneableProperty(){

                boolean isSatisfiedBy(int ch) {
                    return Character.isUnicodeIdentifierStart(ch);
                }
            });
            CharPropertyNames.defClone("javaUnicodeIdentifierPart", new CloneableProperty(){

                boolean isSatisfiedBy(int ch) {
                    return Character.isUnicodeIdentifierPart(ch);
                }
            });
            CharPropertyNames.defClone("javaIdentifierIgnorable", new CloneableProperty(){

                boolean isSatisfiedBy(int ch) {
                    return Character.isIdentifierIgnorable(ch);
                }
            });
            CharPropertyNames.defClone("javaSpaceChar", new CloneableProperty(){

                boolean isSatisfiedBy(int ch) {
                    return Character.isSpaceChar(ch);
                }
            });
            CharPropertyNames.defClone("javaWhitespace", new CloneableProperty(){

                boolean isSatisfiedBy(int ch) {
                    return Character.isWhitespace(ch);
                }
            });
            CharPropertyNames.defClone("javaISOControl", new CloneableProperty(){

                boolean isSatisfiedBy(int ch) {
                    return Character.isISOControl(ch);
                }
            });
            CharPropertyNames.defClone("javaMirrored", new CloneableProperty(){

                boolean isSatisfiedBy(int ch) {
                    return Character.isMirrored(ch);
                }
            });
        }

        private static abstract class CloneableProperty
        extends CharProperty
        implements Cloneable {
            private CloneableProperty() {
            }

            public CloneableProperty clone() {
                try {
                    return (CloneableProperty)super.clone();
                }
                catch (CloneNotSupportedException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }

        private static abstract class CharPropertyFactory {
            private CharPropertyFactory() {
            }

            abstract CharProperty make();
        }
    }

    static final class BnMS
    extends BnM {
        int lengthInChars;

        BnMS(int[] src, int[] lastOcc, int[] optoSft, Node next) {
            super(src, lastOcc, optoSft, next);
            for (int x = 0; x < this.buffer.length; ++x) {
                this.lengthInChars += Character.charCount(this.buffer[x]);
            }
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            int[] src = this.buffer;
            int patternLength = src.length;
            int last = matcher.to - this.lengthInChars;
            block0: while (i <= last) {
                int j = Pattern.countChars(seq, i, patternLength);
                int x = patternLength - 1;
                while (j > 0) {
                    int ch = Character.codePointBefore(seq, i + j);
                    if (ch != src[x]) {
                        int n = Math.max(x + 1 - this.lastOcc[ch & 0x7F], this.optoSft[x]);
                        i += Pattern.countChars(seq, i, n);
                        continue block0;
                    }
                    j -= Character.charCount(ch);
                    --x;
                }
                matcher.first = i;
                boolean ret = this.next.match(matcher, i + this.lengthInChars, seq);
                if (ret) {
                    matcher.groups[0] = matcher.first = i;
                    matcher.groups[1] = matcher.last;
                    return true;
                }
                i += Pattern.countChars(seq, i, 1);
            }
            matcher.hitEnd = true;
            return false;
        }
    }

    static class BnM
    extends Node {
        int[] buffer;
        int[] lastOcc;
        int[] optoSft;

        static Node optimize(Node node) {
            int i;
            if (!(node instanceof Slice)) {
                return node;
            }
            int[] src = ((Slice)node).buffer;
            int patternLength = src.length;
            if (patternLength < 4) {
                return node;
            }
            int[] lastOcc = new int[128];
            int[] optoSft = new int[patternLength];
            for (i = 0; i < patternLength; ++i) {
                lastOcc[src[i] & 0x7F] = i + 1;
            }
            block1: for (i = patternLength; i > 0; --i) {
                int j;
                for (j = patternLength - 1; j >= i; --j) {
                    if (src[j] != src[j - i]) continue block1;
                    optoSft[j - 1] = i;
                }
                while (j > 0) {
                    optoSft[--j] = i;
                }
            }
            optoSft[patternLength - 1] = 1;
            if (node instanceof SliceS) {
                return new BnMS(src, lastOcc, optoSft, node.next);
            }
            return new BnM(src, lastOcc, optoSft, node.next);
        }

        BnM(int[] src, int[] lastOcc, int[] optoSft, Node next) {
            this.buffer = src;
            this.lastOcc = lastOcc;
            this.optoSft = optoSft;
            this.next = next;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            int[] src = this.buffer;
            int patternLength = src.length;
            int last = matcher.to - patternLength;
            block0: while (i <= last) {
                for (int j = patternLength - 1; j >= 0; --j) {
                    char ch = seq.charAt(i + j);
                    if (ch == src[j]) continue;
                    i += Math.max(j + 1 - this.lastOcc[ch & 0x7F], this.optoSft[j]);
                    continue block0;
                }
                matcher.first = i;
                boolean ret = this.next.match(matcher, i + patternLength, seq);
                if (ret) {
                    matcher.groups[0] = matcher.first = i;
                    matcher.groups[1] = matcher.last;
                    return true;
                }
                ++i;
            }
            matcher.hitEnd = true;
            return false;
        }

        boolean study(TreeInfo info) {
            info.minLength += this.buffer.length;
            info.maxValid = false;
            return this.next.study(info);
        }
    }

    static final class Bound
    extends Node {
        static int LEFT = 1;
        static int RIGHT = 2;
        static int BOTH = 3;
        static int NONE = 4;
        int type;

        Bound(int n) {
            this.type = n;
        }

        int check(Matcher matcher, int i, CharSequence seq) {
            int ch;
            boolean left = false;
            int startIndex = matcher.from;
            int endIndex = matcher.to;
            if (matcher.transparentBounds) {
                startIndex = 0;
                endIndex = matcher.getTextLength();
            }
            if (i > startIndex) {
                ch = Character.codePointBefore(seq, i);
                left = ch == 95 || Character.isLetterOrDigit(ch) || Character.getType(ch) == 6 && Pattern.hasBaseCharacter(matcher, i - 1, seq);
            }
            boolean right = false;
            if (i < endIndex) {
                ch = Character.codePointAt(seq, i);
                right = ch == 95 || Character.isLetterOrDigit(ch) || Character.getType(ch) == 6 && Pattern.hasBaseCharacter(matcher, i, seq);
            } else {
                matcher.hitEnd = true;
                matcher.requireEnd = true;
            }
            return left ^ right ? (right ? LEFT : RIGHT) : NONE;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            return (this.check(matcher, i, seq) & this.type) > 0 && this.next.match(matcher, i, seq);
        }
    }

    static final class NotBehindS
    extends NotBehind {
        NotBehindS(Node cond, int rmax, int rmin) {
            super(cond, rmax, rmin);
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            int rmaxChars = Pattern.countChars(seq, i, -this.rmax);
            int rminChars = Pattern.countChars(seq, i, -this.rmin);
            int savedFrom = matcher.from;
            int savedLBT = matcher.lookbehindTo;
            boolean conditionMatched = false;
            int startIndex = !matcher.transparentBounds ? matcher.from : 0;
            int from = Math.max(i - rmaxChars, startIndex);
            matcher.lookbehindTo = i;
            if (matcher.transparentBounds) {
                matcher.from = 0;
            }
            for (int j = i - rminChars; !conditionMatched && j >= from; j -= j > from ? Pattern.countChars(seq, j, -1) : 1) {
                conditionMatched = this.cond.match(matcher, j, seq);
            }
            matcher.from = savedFrom;
            matcher.lookbehindTo = savedLBT;
            return !conditionMatched && this.next.match(matcher, i, seq);
        }
    }

    static class NotBehind
    extends Node {
        Node cond;
        int rmax;
        int rmin;

        NotBehind(Node cond, int rmax, int rmin) {
            this.cond = cond;
            this.rmax = rmax;
            this.rmin = rmin;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            int savedLBT = matcher.lookbehindTo;
            int savedFrom = matcher.from;
            boolean conditionMatched = false;
            int startIndex = !matcher.transparentBounds ? matcher.from : 0;
            int from = Math.max(i - this.rmax, startIndex);
            matcher.lookbehindTo = i;
            if (matcher.transparentBounds) {
                matcher.from = 0;
            }
            for (int j = i - this.rmin; !conditionMatched && j >= from; --j) {
                conditionMatched = this.cond.match(matcher, j, seq);
            }
            matcher.from = savedFrom;
            matcher.lookbehindTo = savedLBT;
            return !conditionMatched && this.next.match(matcher, i, seq);
        }
    }

    static final class BehindS
    extends Behind {
        BehindS(Node cond, int rmax, int rmin) {
            super(cond, rmax, rmin);
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            int rmaxChars = Pattern.countChars(seq, i, -this.rmax);
            int rminChars = Pattern.countChars(seq, i, -this.rmin);
            int savedFrom = matcher.from;
            int startIndex = !matcher.transparentBounds ? matcher.from : 0;
            boolean conditionMatched = false;
            int from = Math.max(i - rmaxChars, startIndex);
            int savedLBT = matcher.lookbehindTo;
            matcher.lookbehindTo = i;
            if (matcher.transparentBounds) {
                matcher.from = 0;
            }
            for (int j = i - rminChars; !conditionMatched && j >= from; j -= j > from ? Pattern.countChars(seq, j, -1) : 1) {
                conditionMatched = this.cond.match(matcher, j, seq);
            }
            matcher.from = savedFrom;
            matcher.lookbehindTo = savedLBT;
            return conditionMatched && this.next.match(matcher, i, seq);
        }
    }

    static class Behind
    extends Node {
        Node cond;
        int rmax;
        int rmin;

        Behind(Node cond, int rmax, int rmin) {
            this.cond = cond;
            this.rmax = rmax;
            this.rmin = rmin;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            int savedFrom = matcher.from;
            boolean conditionMatched = false;
            int startIndex = !matcher.transparentBounds ? matcher.from : 0;
            int from = Math.max(i - this.rmax, startIndex);
            int savedLBT = matcher.lookbehindTo;
            matcher.lookbehindTo = i;
            if (matcher.transparentBounds) {
                matcher.from = 0;
            }
            for (int j = i - this.rmin; !conditionMatched && j >= from; --j) {
                conditionMatched = this.cond.match(matcher, j, seq);
            }
            matcher.from = savedFrom;
            matcher.lookbehindTo = savedLBT;
            return conditionMatched && this.next.match(matcher, i, seq);
        }
    }

    static final class Neg
    extends Node {
        Node cond;

        Neg(Node cond) {
            this.cond = cond;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int savedTo = matcher.to;
            boolean conditionMatched = false;
            if (matcher.transparentBounds) {
                matcher.to = matcher.getTextLength();
            }
            try {
                if (i < matcher.to) {
                    conditionMatched = !this.cond.match(matcher, i, seq);
                } else {
                    matcher.requireEnd = true;
                    conditionMatched = !this.cond.match(matcher, i, seq);
                }
            }
            finally {
                matcher.to = savedTo;
            }
            return conditionMatched && this.next.match(matcher, i, seq);
        }
    }

    static final class Pos
    extends Node {
        Node cond;

        Pos(Node cond) {
            this.cond = cond;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int savedTo = matcher.to;
            boolean conditionMatched = false;
            if (matcher.transparentBounds) {
                matcher.to = matcher.getTextLength();
            }
            try {
                conditionMatched = this.cond.match(matcher, i, seq);
            }
            finally {
                matcher.to = savedTo;
            }
            return conditionMatched && this.next.match(matcher, i, seq);
        }
    }

    static final class Conditional
    extends Node {
        Node cond;
        Node yes;
        Node not;

        Conditional(Node cond, Node yes, Node not) {
            this.cond = cond;
            this.yes = yes;
            this.not = not;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (this.cond.match(matcher, i, seq)) {
                return this.yes.match(matcher, i, seq);
            }
            return this.not.match(matcher, i, seq);
        }

        boolean study(TreeInfo info) {
            int minL = info.minLength;
            int maxL = info.maxLength;
            boolean maxV = info.maxValid;
            info.reset();
            this.yes.study(info);
            int minL2 = info.minLength;
            int maxL2 = info.maxLength;
            boolean maxV2 = info.maxValid;
            info.reset();
            this.not.study(info);
            info.minLength = minL + Math.min(minL2, info.minLength);
            info.maxLength = maxL + Math.max(maxL2, info.maxLength);
            info.maxValid = maxV & maxV2 & info.maxValid;
            info.deterministic = false;
            return this.next.study(info);
        }
    }

    static final class First
    extends Node {
        Node atom;

        First(Node node) {
            this.atom = BnM.optimize(node);
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (this.atom instanceof BnM) {
                return this.atom.match(matcher, i, seq) && this.next.match(matcher, matcher.last, seq);
            }
            while (true) {
                if (i > matcher.to) {
                    matcher.hitEnd = true;
                    return false;
                }
                if (this.atom.match(matcher, i, seq)) {
                    return this.next.match(matcher, matcher.last, seq);
                }
                i += Pattern.countChars(seq, i, 1);
                ++matcher.first;
            }
        }

        boolean study(TreeInfo info) {
            this.atom.study(info);
            info.maxValid = false;
            info.deterministic = false;
            return this.next.study(info);
        }
    }

    static class CIBackRef
    extends Node {
        int groupIndex;
        boolean doUnicodeCase;

        CIBackRef(int groupCount, boolean doUnicodeCase) {
            this.groupIndex = groupCount + groupCount;
            this.doUnicodeCase = doUnicodeCase;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            int j = matcher.groups[this.groupIndex];
            int k = matcher.groups[this.groupIndex + 1];
            int groupSize = k - j;
            if (j < 0) {
                return false;
            }
            if (i + groupSize > matcher.to) {
                matcher.hitEnd = true;
                return false;
            }
            int x = i;
            for (int index = 0; index < groupSize; ++index) {
                int cc2;
                int cc1;
                int c2;
                int c1 = Character.codePointAt(seq, x);
                if (c1 != (c2 = Character.codePointAt(seq, j)) && (this.doUnicodeCase ? (cc1 = Character.toUpperCase(c1)) != (cc2 = Character.toUpperCase(c2)) && Character.toLowerCase(cc1) != Character.toLowerCase(cc2) : ASCII.toLower(c1) != ASCII.toLower(c2))) {
                    return false;
                }
                x += Character.charCount(c1);
                j += Character.charCount(c2);
            }
            return this.next.match(matcher, i + groupSize, seq);
        }

        boolean study(TreeInfo info) {
            info.maxValid = false;
            return this.next.study(info);
        }
    }

    static class BackRef
    extends Node {
        int groupIndex;

        BackRef(int groupCount) {
            this.groupIndex = groupCount + groupCount;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            int j = matcher.groups[this.groupIndex];
            int k = matcher.groups[this.groupIndex + 1];
            int groupSize = k - j;
            if (j < 0) {
                return false;
            }
            if (i + groupSize > matcher.to) {
                matcher.hitEnd = true;
                return false;
            }
            for (int index = 0; index < groupSize; ++index) {
                if (seq.charAt(i + index) == seq.charAt(j + index)) continue;
                return false;
            }
            return this.next.match(matcher, i + groupSize, seq);
        }

        boolean study(TreeInfo info) {
            info.maxValid = false;
            return this.next.study(info);
        }
    }

    static final class LazyLoop
    extends Loop {
        LazyLoop(int countIndex, int beginIndex) {
            super(countIndex, beginIndex);
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (i > matcher.locals[this.beginIndex]) {
                int count = matcher.locals[this.countIndex];
                if (count < this.cmin) {
                    matcher.locals[this.countIndex] = count + 1;
                    boolean result = this.body.match(matcher, i, seq);
                    if (!result) {
                        matcher.locals[this.countIndex] = count;
                    }
                    return result;
                }
                if (this.next.match(matcher, i, seq)) {
                    return true;
                }
                if (count < this.cmax) {
                    matcher.locals[this.countIndex] = count + 1;
                    boolean result = this.body.match(matcher, i, seq);
                    if (!result) {
                        matcher.locals[this.countIndex] = count;
                    }
                    return result;
                }
                return false;
            }
            return this.next.match(matcher, i, seq);
        }

        boolean matchInit(Matcher matcher, int i, CharSequence seq) {
            int save = matcher.locals[this.countIndex];
            boolean ret = false;
            if (0 < this.cmin) {
                matcher.locals[this.countIndex] = 1;
                ret = this.body.match(matcher, i, seq);
            } else if (this.next.match(matcher, i, seq)) {
                ret = true;
            } else if (0 < this.cmax) {
                matcher.locals[this.countIndex] = 1;
                ret = this.body.match(matcher, i, seq);
            }
            matcher.locals[this.countIndex] = save;
            return ret;
        }

        boolean study(TreeInfo info) {
            info.maxValid = false;
            info.deterministic = false;
            return false;
        }
    }

    static class Loop
    extends Node {
        Node body;
        int countIndex;
        int beginIndex;
        int cmin;
        int cmax;

        Loop(int countIndex, int beginIndex) {
            this.countIndex = countIndex;
            this.beginIndex = beginIndex;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (i > matcher.locals[this.beginIndex]) {
                int count = matcher.locals[this.countIndex];
                if (count < this.cmin) {
                    matcher.locals[this.countIndex] = count + 1;
                    boolean b = this.body.match(matcher, i, seq);
                    if (!b) {
                        matcher.locals[this.countIndex] = count;
                    }
                    return b;
                }
                if (count < this.cmax) {
                    matcher.locals[this.countIndex] = count + 1;
                    boolean b = this.body.match(matcher, i, seq);
                    if (!b) {
                        matcher.locals[this.countIndex] = count;
                    } else {
                        return true;
                    }
                }
            }
            return this.next.match(matcher, i, seq);
        }

        boolean matchInit(Matcher matcher, int i, CharSequence seq) {
            int save = matcher.locals[this.countIndex];
            boolean ret = false;
            if (0 < this.cmin) {
                matcher.locals[this.countIndex] = 1;
                ret = this.body.match(matcher, i, seq);
            } else if (0 < this.cmax) {
                matcher.locals[this.countIndex] = 1;
                ret = this.body.match(matcher, i, seq);
                if (!ret) {
                    ret = this.next.match(matcher, i, seq);
                }
            } else {
                ret = this.next.match(matcher, i, seq);
            }
            matcher.locals[this.countIndex] = save;
            return ret;
        }

        boolean study(TreeInfo info) {
            info.maxValid = false;
            info.deterministic = false;
            return false;
        }
    }

    static final class Prolog
    extends Node {
        Loop loop;

        Prolog(Loop loop) {
            this.loop = loop;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            return this.loop.matchInit(matcher, i, seq);
        }

        boolean study(TreeInfo info) {
            return this.loop.study(info);
        }
    }

    static final class GroupTail
    extends Node {
        int localIndex;
        int groupIndex;

        GroupTail(int localCount, int groupCount) {
            this.localIndex = localCount;
            this.groupIndex = groupCount + groupCount;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            int tmp = matcher.locals[this.localIndex];
            if (tmp >= 0) {
                int groupStart = matcher.groups[this.groupIndex];
                int groupEnd = matcher.groups[this.groupIndex + 1];
                matcher.groups[this.groupIndex] = tmp;
                matcher.groups[this.groupIndex + 1] = i;
                if (this.next.match(matcher, i, seq)) {
                    return true;
                }
                matcher.groups[this.groupIndex] = groupStart;
                matcher.groups[this.groupIndex + 1] = groupEnd;
                return false;
            }
            matcher.last = i;
            return true;
        }
    }

    static final class GroupRef
    extends Node {
        GroupHead head;

        GroupRef(GroupHead head) {
            this.head = head;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            return this.head.matchRef(matcher, i, seq) && this.next.match(matcher, matcher.last, seq);
        }

        boolean study(TreeInfo info) {
            info.maxValid = false;
            info.deterministic = false;
            return this.next.study(info);
        }
    }

    static final class GroupHead
    extends Node {
        int localIndex;

        GroupHead(int localCount) {
            this.localIndex = localCount;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            int save = matcher.locals[this.localIndex];
            matcher.locals[this.localIndex] = i;
            boolean ret = this.next.match(matcher, i, seq);
            matcher.locals[this.localIndex] = save;
            return ret;
        }

        boolean matchRef(Matcher matcher, int i, CharSequence seq) {
            int save = matcher.locals[this.localIndex];
            matcher.locals[this.localIndex] = ~i;
            boolean ret = this.next.match(matcher, i, seq);
            matcher.locals[this.localIndex] = save;
            return ret;
        }
    }

    static final class Branch
    extends Node {
        Node[] atoms = new Node[2];
        int size = 2;
        Node conn;

        Branch(Node first, Node second, Node branchConn) {
            this.conn = branchConn;
            this.atoms[0] = first;
            this.atoms[1] = second;
        }

        void add(Node node) {
            if (this.size >= this.atoms.length) {
                Node[] tmp = new Node[this.atoms.length * 2];
                System.arraycopy(this.atoms, 0, tmp, 0, this.atoms.length);
                this.atoms = tmp;
            }
            this.atoms[this.size++] = node;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            for (int n = 0; n < this.size; ++n) {
                if (!(this.atoms[n] == null ? this.conn.next.match(matcher, i, seq) : this.atoms[n].match(matcher, i, seq))) continue;
                return true;
            }
            return false;
        }

        boolean study(TreeInfo info) {
            int minL = info.minLength;
            int maxL = info.maxLength;
            boolean maxV = info.maxValid;
            int minL2 = Integer.MAX_VALUE;
            int maxL2 = -1;
            for (int n = 0; n < this.size; ++n) {
                info.reset();
                if (this.atoms[n] != null) {
                    this.atoms[n].study(info);
                }
                minL2 = Math.min(minL2, info.minLength);
                maxL2 = Math.max(maxL2, info.maxLength);
                maxV &= info.maxValid;
            }
            info.reset();
            this.conn.next.study(info);
            info.minLength += (minL += minL2);
            info.maxLength += (maxL += maxL2);
            info.maxValid &= maxV;
            info.deterministic = false;
            return false;
        }
    }

    static final class BranchConn
    extends Node {
        BranchConn() {
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            return this.next.match(matcher, i, seq);
        }

        boolean study(TreeInfo info) {
            return info.deterministic;
        }
    }

    static final class GroupCurly
    extends Node {
        Node atom;
        int type;
        int cmin;
        int cmax;
        int localIndex;
        int groupIndex;
        boolean capture;

        GroupCurly(Node node, int cmin, int cmax, int type, int local, int group, boolean capture) {
            this.atom = node;
            this.type = type;
            this.cmin = cmin;
            this.cmax = cmax;
            this.localIndex = local;
            this.groupIndex = group;
            this.capture = capture;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            int[] groups = matcher.groups;
            int[] locals = matcher.locals;
            int save0 = locals[this.localIndex];
            int save1 = 0;
            int save2 = 0;
            if (this.capture) {
                save1 = groups[this.groupIndex];
                save2 = groups[this.groupIndex + 1];
            }
            locals[this.localIndex] = -1;
            boolean ret = true;
            for (int j = 0; j < this.cmin; ++j) {
                if (this.atom.match(matcher, i, seq)) {
                    if (this.capture) {
                        groups[this.groupIndex] = i;
                        groups[this.groupIndex + 1] = matcher.last;
                    }
                } else {
                    ret = false;
                    break;
                }
                i = matcher.last;
            }
            if (ret) {
                ret = this.type == 0 ? this.match0(matcher, i, this.cmin, seq) : (this.type == 1 ? this.match1(matcher, i, this.cmin, seq) : this.match2(matcher, i, this.cmin, seq));
            }
            if (!ret) {
                locals[this.localIndex] = save0;
                if (this.capture) {
                    groups[this.groupIndex] = save1;
                    groups[this.groupIndex + 1] = save2;
                }
            }
            return ret;
        }

        boolean match0(Matcher matcher, int i, int j, CharSequence seq) {
            int[] groups = matcher.groups;
            int save0 = 0;
            int save1 = 0;
            if (this.capture) {
                save0 = groups[this.groupIndex];
                save1 = groups[this.groupIndex + 1];
            }
            if (j < this.cmax && this.atom.match(matcher, i, seq)) {
                int k = matcher.last - i;
                if (k <= 0) {
                    if (this.capture) {
                        groups[this.groupIndex] = i;
                        groups[this.groupIndex + 1] = i + k;
                    }
                    i += k;
                } else {
                    block13: {
                        do {
                            if (this.capture) {
                                groups[this.groupIndex] = i;
                                groups[this.groupIndex + 1] = i + k;
                            }
                            if (++j >= this.cmax || !this.atom.match(matcher, i += k, seq)) break block13;
                        } while (i + k == matcher.last);
                        if (this.match0(matcher, i, j, seq)) {
                            return true;
                        }
                    }
                    while (j > this.cmin) {
                        if (this.next.match(matcher, i, seq)) {
                            if (this.capture) {
                                groups[this.groupIndex + 1] = i;
                                groups[this.groupIndex] = i - k;
                            }
                            i -= k;
                            return true;
                        }
                        if (this.capture) {
                            groups[this.groupIndex + 1] = i;
                            groups[this.groupIndex] = i - k;
                        }
                        i -= k;
                        --j;
                    }
                }
            }
            if (this.capture) {
                groups[this.groupIndex] = save0;
                groups[this.groupIndex + 1] = save1;
            }
            return this.next.match(matcher, i, seq);
        }

        boolean match1(Matcher matcher, int i, int j, CharSequence seq) {
            while (!this.next.match(matcher, i, seq)) {
                if (j >= this.cmax) {
                    return false;
                }
                if (!this.atom.match(matcher, i, seq)) {
                    return false;
                }
                if (i == matcher.last) {
                    return false;
                }
                if (this.capture) {
                    matcher.groups[this.groupIndex] = i;
                    matcher.groups[this.groupIndex + 1] = matcher.last;
                }
                i = matcher.last;
                ++j;
            }
            return true;
        }

        boolean match2(Matcher matcher, int i, int j, CharSequence seq) {
            while (j < this.cmax && this.atom.match(matcher, i, seq)) {
                if (this.capture) {
                    matcher.groups[this.groupIndex] = i;
                    matcher.groups[this.groupIndex + 1] = matcher.last;
                }
                if (i == matcher.last) break;
                i = matcher.last;
                ++j;
            }
            return this.next.match(matcher, i, seq);
        }

        boolean study(TreeInfo info) {
            int minL = info.minLength;
            int maxL = info.maxLength;
            boolean maxV = info.maxValid;
            boolean detm = info.deterministic;
            info.reset();
            this.atom.study(info);
            int temp = info.minLength * this.cmin + minL;
            if (temp < minL) {
                temp = 0xFFFFFFF;
            }
            info.minLength = temp;
            if (maxV & info.maxValid) {
                info.maxLength = temp = info.maxLength * this.cmax + maxL;
                if (temp < maxL) {
                    info.maxValid = false;
                }
            } else {
                info.maxValid = false;
            }
            info.deterministic = info.deterministic && this.cmin == this.cmax ? detm : false;
            return this.next.study(info);
        }
    }

    static final class Curly
    extends Node {
        Node atom;
        int type;
        int cmin;
        int cmax;

        Curly(Node node, int cmin, int cmax, int type) {
            this.atom = node;
            this.type = type;
            this.cmin = cmin;
            this.cmax = cmax;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            int j;
            for (j = 0; j < this.cmin; ++j) {
                if (!this.atom.match(matcher, i, seq)) {
                    return false;
                }
                i = matcher.last;
            }
            if (this.type == 0) {
                return this.match0(matcher, i, j, seq);
            }
            if (this.type == 1) {
                return this.match1(matcher, i, j, seq);
            }
            return this.match2(matcher, i, j, seq);
        }

        boolean match0(Matcher matcher, int i, int j, CharSequence seq) {
            int k;
            if (j >= this.cmax) {
                return this.next.match(matcher, i, seq);
            }
            int backLimit = j++;
            if (this.atom.match(matcher, i, seq) && (k = matcher.last - i) != 0) {
                i = matcher.last;
                while (j < this.cmax && this.atom.match(matcher, i, seq)) {
                    if (i + k != matcher.last) {
                        if (!this.match0(matcher, matcher.last, j + 1, seq)) break;
                        return true;
                    }
                    i += k;
                    ++j;
                }
                while (j >= backLimit) {
                    if (this.next.match(matcher, i, seq)) {
                        return true;
                    }
                    i -= k;
                    --j;
                }
                return false;
            }
            return this.next.match(matcher, i, seq);
        }

        boolean match1(Matcher matcher, int i, int j, CharSequence seq) {
            while (!this.next.match(matcher, i, seq)) {
                if (j >= this.cmax) {
                    return false;
                }
                if (!this.atom.match(matcher, i, seq)) {
                    return false;
                }
                if (i == matcher.last) {
                    return false;
                }
                i = matcher.last;
                ++j;
            }
            return true;
        }

        boolean match2(Matcher matcher, int i, int j, CharSequence seq) {
            while (j < this.cmax && this.atom.match(matcher, i, seq) && i != matcher.last) {
                i = matcher.last;
                ++j;
            }
            return this.next.match(matcher, i, seq);
        }

        boolean study(TreeInfo info) {
            int minL = info.minLength;
            int maxL = info.maxLength;
            boolean maxV = info.maxValid;
            boolean detm = info.deterministic;
            info.reset();
            this.atom.study(info);
            int temp = info.minLength * this.cmin + minL;
            if (temp < minL) {
                temp = 0xFFFFFFF;
            }
            info.minLength = temp;
            if (maxV & info.maxValid) {
                info.maxLength = temp = info.maxLength * this.cmax + maxL;
                if (temp < maxL) {
                    info.maxValid = false;
                }
            } else {
                info.maxValid = false;
            }
            info.deterministic = info.deterministic && this.cmin == this.cmax ? detm : false;
            return this.next.study(info);
        }
    }

    static final class Ques
    extends Node {
        Node atom;
        int type;

        Ques(Node node, int type) {
            this.atom = node;
            this.type = type;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            switch (this.type) {
                case 0: {
                    return this.atom.match(matcher, i, seq) && this.next.match(matcher, matcher.last, seq) || this.next.match(matcher, i, seq);
                }
                case 1: {
                    return this.next.match(matcher, i, seq) || this.atom.match(matcher, i, seq) && this.next.match(matcher, matcher.last, seq);
                }
                case 2: {
                    if (this.atom.match(matcher, i, seq)) {
                        i = matcher.last;
                    }
                    return this.next.match(matcher, i, seq);
                }
            }
            return this.atom.match(matcher, i, seq) && this.next.match(matcher, matcher.last, seq);
        }

        boolean study(TreeInfo info) {
            if (this.type != 3) {
                int minL = info.minLength;
                this.atom.study(info);
                info.minLength = minL;
                info.deterministic = false;
                return this.next.study(info);
            }
            this.atom.study(info);
            return this.next.study(info);
        }
    }

    static final class UnixDot
    extends CharProperty {
        UnixDot() {
        }

        boolean isSatisfiedBy(int ch) {
            return ch != 10;
        }
    }

    static final class Dot
    extends CharProperty {
        Dot() {
        }

        boolean isSatisfiedBy(int ch) {
            return ch != 10 && ch != 13 && (ch | 1) != 8233 && ch != 133;
        }
    }

    static final class All
    extends CharProperty {
        All() {
        }

        boolean isSatisfiedBy(int ch) {
            return true;
        }
    }

    static final class SliceUS
    extends SliceIS {
        SliceUS(int[] buf) {
            super(buf);
        }

        int toLower(int c) {
            return Character.toLowerCase(Character.toUpperCase(c));
        }
    }

    static class SliceIS
    extends SliceNode {
        SliceIS(int[] buf) {
            super(buf);
        }

        int toLower(int c) {
            return ASCII.toLower(c);
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            int[] buf = this.buffer;
            int x = i;
            for (int j = 0; j < buf.length; ++j) {
                if (x >= matcher.to) {
                    matcher.hitEnd = true;
                    return false;
                }
                int c = Character.codePointAt(seq, x);
                if (buf[j] != c && buf[j] != this.toLower(c)) {
                    return false;
                }
                if ((x += Character.charCount(c)) <= matcher.to) continue;
                matcher.hitEnd = true;
                return false;
            }
            return this.next.match(matcher, x, seq);
        }
    }

    static final class SliceS
    extends SliceNode {
        SliceS(int[] buf) {
            super(buf);
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            int[] buf = this.buffer;
            int x = i;
            for (int j = 0; j < buf.length; ++j) {
                if (x >= matcher.to) {
                    matcher.hitEnd = true;
                    return false;
                }
                int c = Character.codePointAt(seq, x);
                if (buf[j] != c) {
                    return false;
                }
                if ((x += Character.charCount(c)) <= matcher.to) continue;
                matcher.hitEnd = true;
                return false;
            }
            return this.next.match(matcher, x, seq);
        }
    }

    static final class SliceU
    extends SliceNode {
        SliceU(int[] buf) {
            super(buf);
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            int[] buf = this.buffer;
            int len = buf.length;
            for (int j = 0; j < len; ++j) {
                if (i + j >= matcher.to) {
                    matcher.hitEnd = true;
                    return false;
                }
                char c = seq.charAt(i + j);
                if (buf[j] == c || buf[j] == Character.toLowerCase(Character.toUpperCase((int)c))) continue;
                return false;
            }
            return this.next.match(matcher, i + len, seq);
        }
    }

    static class SliceI
    extends SliceNode {
        SliceI(int[] buf) {
            super(buf);
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            int[] buf = this.buffer;
            int len = buf.length;
            for (int j = 0; j < len; ++j) {
                if (i + j >= matcher.to) {
                    matcher.hitEnd = true;
                    return false;
                }
                char c = seq.charAt(i + j);
                if (buf[j] == c || buf[j] == ASCII.toLower(c)) continue;
                return false;
            }
            return this.next.match(matcher, i + len, seq);
        }
    }

    static final class Slice
    extends SliceNode {
        Slice(int[] buf) {
            super(buf);
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            int[] buf = this.buffer;
            int len = buf.length;
            for (int j = 0; j < len; ++j) {
                if (i + j >= matcher.to) {
                    matcher.hitEnd = true;
                    return false;
                }
                if (buf[j] == seq.charAt(i + j)) continue;
                return false;
            }
            return this.next.match(matcher, i + len, seq);
        }
    }

    static class SliceNode
    extends Node {
        int[] buffer;

        SliceNode(int[] buf) {
            this.buffer = buf;
        }

        boolean study(TreeInfo info) {
            info.minLength += this.buffer.length;
            info.maxLength += this.buffer.length;
            return this.next.study(info);
        }
    }

    static final class Ctype
    extends BmpCharProperty {
        final int ctype;

        Ctype(int ctype) {
            this.ctype = ctype;
        }

        boolean isSatisfiedBy(int ch) {
            return ch < 128 && ASCII.isType(ch, this.ctype);
        }
    }

    static final class Category
    extends CharProperty {
        final int typeMask;

        Category(int typeMask) {
            this.typeMask = typeMask;
        }

        boolean isSatisfiedBy(int ch) {
            return (this.typeMask & 1 << Character.getType(ch)) != 0;
        }
    }

    static final class SingleU
    extends CharProperty {
        final int lower;

        SingleU(int lower) {
            this.lower = lower;
        }

        boolean isSatisfiedBy(int ch) {
            return this.lower == ch || this.lower == Character.toLowerCase(Character.toUpperCase(ch));
        }
    }

    static final class SingleI
    extends BmpCharProperty {
        final int lower;
        final int upper;

        SingleI(int lower, int upper) {
            this.lower = lower;
            this.upper = upper;
        }

        boolean isSatisfiedBy(int ch) {
            return ch == this.lower || ch == this.upper;
        }
    }

    static final class Single
    extends BmpCharProperty {
        final int c;

        Single(int c) {
            this.c = c;
        }

        boolean isSatisfiedBy(int ch) {
            return ch == this.c;
        }
    }

    static final class SingleS
    extends CharProperty {
        final int c;

        SingleS(int c) {
            this.c = c;
        }

        boolean isSatisfiedBy(int ch) {
            return ch == this.c;
        }
    }

    private static abstract class BmpCharProperty
    extends CharProperty {
        private BmpCharProperty() {
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (i < matcher.to) {
                return this.isSatisfiedBy(seq.charAt(i)) && this.next.match(matcher, i + 1, seq);
            }
            matcher.hitEnd = true;
            return false;
        }
    }

    private static abstract class CharProperty
    extends Node {
        private CharProperty() {
        }

        abstract boolean isSatisfiedBy(int var1);

        CharProperty complement() {
            return new CharProperty(){

                boolean isSatisfiedBy(int ch) {
                    return !CharProperty.this.isSatisfiedBy(ch);
                }
            };
        }

        CharProperty maybeComplement(boolean complement) {
            return complement ? this.complement() : this;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (i < matcher.to) {
                int ch = Character.codePointAt(seq, i);
                return this.isSatisfiedBy(ch) && this.next.match(matcher, i + Character.charCount(ch), seq);
            }
            matcher.hitEnd = true;
            return false;
        }

        boolean study(TreeInfo info) {
            ++info.minLength;
            ++info.maxLength;
            return this.next.study(info);
        }
    }

    static final class UnixDollar
    extends Node {
        boolean multiline;

        UnixDollar(boolean mul) {
            this.multiline = mul;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            int endIndex;
            int n = endIndex = matcher.anchoringBounds ? matcher.to : matcher.getTextLength();
            if (i < endIndex) {
                char ch = seq.charAt(i);
                if (ch == '\n') {
                    if (!this.multiline && i != endIndex - 1) {
                        return false;
                    }
                    if (this.multiline) {
                        return this.next.match(matcher, i, seq);
                    }
                } else {
                    return false;
                }
            }
            matcher.hitEnd = true;
            matcher.requireEnd = true;
            return this.next.match(matcher, i, seq);
        }

        boolean study(TreeInfo info) {
            this.next.study(info);
            return info.deterministic;
        }
    }

    static final class Dollar
    extends Node {
        boolean multiline;

        Dollar(boolean mul) {
            this.multiline = mul;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            char ch;
            int endIndex;
            int n = endIndex = matcher.anchoringBounds ? matcher.to : matcher.getTextLength();
            if (!this.multiline) {
                if (i < endIndex - 2) {
                    return false;
                }
                if (i == endIndex - 2) {
                    ch = seq.charAt(i);
                    if (ch != '\r') {
                        return false;
                    }
                    ch = seq.charAt(i + 1);
                    if (ch != '\n') {
                        return false;
                    }
                }
            }
            if (i < endIndex) {
                ch = seq.charAt(i);
                if (ch == '\n') {
                    if (i > 0 && seq.charAt(i - 1) == '\r') {
                        return false;
                    }
                    if (this.multiline) {
                        return this.next.match(matcher, i, seq);
                    }
                } else if (ch == '\r' || ch == '\u0085' || (ch | '\u0001') == 8233) {
                    if (this.multiline) {
                        return this.next.match(matcher, i, seq);
                    }
                } else {
                    return false;
                }
            }
            matcher.hitEnd = true;
            matcher.requireEnd = true;
            return this.next.match(matcher, i, seq);
        }

        boolean study(TreeInfo info) {
            this.next.study(info);
            return info.deterministic;
        }
    }

    static final class LastMatch
    extends Node {
        LastMatch() {
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (i != matcher.oldLast) {
                return false;
            }
            return this.next.match(matcher, i, seq);
        }
    }

    static final class UnixCaret
    extends Node {
        UnixCaret() {
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            char ch;
            int startIndex = matcher.from;
            int endIndex = matcher.to;
            if (!matcher.anchoringBounds) {
                startIndex = 0;
                endIndex = matcher.getTextLength();
            }
            if (i == endIndex) {
                matcher.hitEnd = true;
                return false;
            }
            if (i > startIndex && (ch = seq.charAt(i - 1)) != '\n') {
                return false;
            }
            return this.next.match(matcher, i, seq);
        }
    }

    static final class Caret
    extends Node {
        Caret() {
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            int startIndex = matcher.from;
            int endIndex = matcher.to;
            if (!matcher.anchoringBounds) {
                startIndex = 0;
                endIndex = matcher.getTextLength();
            }
            if (i == endIndex) {
                matcher.hitEnd = true;
                return false;
            }
            if (i > startIndex) {
                char ch = seq.charAt(i - 1);
                if (ch != '\n' && ch != '\r' && (ch | '\u0001') != 8233 && ch != '\u0085') {
                    return false;
                }
                if (ch == '\r' && seq.charAt(i) == '\n') {
                    return false;
                }
            }
            return this.next.match(matcher, i, seq);
        }
    }

    static final class End
    extends Node {
        End() {
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            int endIndex;
            int n = endIndex = matcher.anchoringBounds ? matcher.to : matcher.getTextLength();
            if (i == endIndex) {
                matcher.hitEnd = true;
                return this.next.match(matcher, i, seq);
            }
            return false;
        }
    }

    static final class Begin
    extends Node {
        Begin() {
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            int fromIndex;
            int n = fromIndex = matcher.anchoringBounds ? matcher.from : 0;
            if (i == fromIndex && this.next.match(matcher, i, seq)) {
                matcher.first = i;
                matcher.groups[0] = i;
                matcher.groups[1] = matcher.last;
                return true;
            }
            return false;
        }
    }

    static final class StartS
    extends Start {
        StartS(Node node) {
            super(node);
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (i > matcher.to - this.minLength) {
                matcher.hitEnd = true;
                return false;
            }
            boolean ret = false;
            int guard = matcher.to - this.minLength;
            while (i <= guard && !(ret = this.next.match(matcher, i, seq)) && i != guard) {
                if (Character.isHighSurrogate(seq.charAt(i++)) && i < seq.length() && Character.isLowSurrogate(seq.charAt(i))) {
                    ++i;
                }
                if (i != guard) continue;
                matcher.hitEnd = true;
            }
            if (ret) {
                matcher.groups[0] = matcher.first = i;
                matcher.groups[1] = matcher.last;
            }
            return ret;
        }
    }

    static class Start
    extends Node {
        int minLength;

        Start(Node node) {
            this.next = node;
            TreeInfo info = new TreeInfo();
            this.next.study(info);
            this.minLength = info.minLength;
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (i > matcher.to - this.minLength) {
                matcher.hitEnd = true;
                return false;
            }
            boolean ret = false;
            int guard = matcher.to - this.minLength;
            while (i <= guard && !(ret = this.next.match(matcher, i, seq))) {
                if (i == guard) {
                    matcher.hitEnd = true;
                }
                ++i;
            }
            if (ret) {
                matcher.groups[0] = matcher.first = i;
                matcher.groups[1] = matcher.last;
            }
            return ret;
        }

        boolean study(TreeInfo info) {
            this.next.study(info);
            info.maxValid = false;
            info.deterministic = false;
            return false;
        }
    }

    static class LastNode
    extends Node {
        LastNode() {
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (matcher.acceptMode == 1 && i != matcher.to) {
                return false;
            }
            matcher.last = i;
            matcher.groups[0] = matcher.first;
            matcher.groups[1] = matcher.last;
            return true;
        }
    }

    static class Node {
        Node next = accept;

        Node() {
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            matcher.last = i;
            matcher.groups[0] = matcher.first;
            matcher.groups[1] = matcher.last;
            return true;
        }

        boolean study(TreeInfo info) {
            if (this.next != null) {
                return this.next.study(info);
            }
            return info.deterministic;
        }
    }

    private static final class BitClass
    extends BmpCharProperty {
        final boolean[] bits;

        BitClass() {
            this.bits = new boolean[256];
        }

        private BitClass(boolean[] bits) {
            this.bits = bits;
        }

        BitClass add(int c, int flags) {
            assert (c >= 0 && c <= 255);
            if ((flags & 2) != 0) {
                if (ASCII.isAscii(c)) {
                    this.bits[ASCII.toUpper((int)c)] = true;
                    this.bits[ASCII.toLower((int)c)] = true;
                } else if ((flags & 0x40) != 0) {
                    this.bits[Character.toLowerCase((int)c)] = true;
                    this.bits[Character.toUpperCase((int)c)] = true;
                }
            }
            this.bits[c] = true;
            return this;
        }

        boolean isSatisfiedBy(int ch) {
            return ch < 256 && this.bits[ch];
        }
    }

    static final class TreeInfo {
        int minLength;
        int maxLength;
        boolean maxValid;
        boolean deterministic;

        TreeInfo() {
            this.reset();
        }

        void reset() {
            this.minLength = 0;
            this.maxLength = 0;
            this.maxValid = true;
            this.deterministic = true;
        }
    }
}

