/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import java.util.EventObject;
import javax.sound.sampled.Line;

public class LineEvent
extends EventObject {
    private final Type type;
    private final long position;

    public LineEvent(Line line, Type type, long position) {
        super(line);
        this.type = type;
        this.position = position;
    }

    public final Line getLine() {
        return (Line)this.getSource();
    }

    public final Type getType() {
        return this.type;
    }

    public final long getFramePosition() {
        return this.position;
    }

    public String toString() {
        String sType = "";
        if (this.type != null) {
            sType = this.type.toString() + " ";
        }
        String sLine = this.getLine() == null ? "null" : this.getLine().toString();
        return new String(sType + "event from line " + sLine);
    }

    public static class Type {
        private String name;
        public static final Type OPEN = new Type("Open");
        public static final Type CLOSE = new Type("Close");
        public static final Type START = new Type("Start");
        public static final Type STOP = new Type("Stop");

        protected Type(String name) {
            this.name = name;
        }

        public final boolean equals(Object obj) {
            return super.equals(obj);
        }

        public final int hashCode() {
            return super.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }
}

