/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.LookAndFeel;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorChooserComponentFactory;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ColorChooserUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.CenterLayout;
import sun.swing.DefaultLookup;

public class BasicColorChooserUI
extends ColorChooserUI {
    protected JColorChooser chooser;
    JTabbedPane tabbedPane;
    JPanel singlePanel;
    JPanel previewPanelHolder;
    JComponent previewPanel;
    boolean isMultiPanel = false;
    private static TransferHandler defaultTransferHandler = new ColorTransferHandler();
    protected AbstractColorChooserPanel[] defaultChoosers;
    protected ChangeListener previewListener;
    protected PropertyChangeListener propertyChangeListener;
    private Handler handler;

    public static ComponentUI createUI(JComponent c) {
        return new BasicColorChooserUI();
    }

    protected AbstractColorChooserPanel[] createDefaultChoosers() {
        AbstractColorChooserPanel[] panels = ColorChooserComponentFactory.getDefaultChooserPanels();
        return panels;
    }

    protected void uninstallDefaultChoosers() {
        AbstractColorChooserPanel[] choosers = this.chooser.getChooserPanels();
        for (int i = 0; i < choosers.length; ++i) {
            this.chooser.removeChooserPanel(choosers[i]);
        }
    }

    public void installUI(JComponent c) {
        this.chooser = (JColorChooser)c;
        super.installUI(c);
        this.installDefaults();
        this.installListeners();
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setName("ColorChooser.tabPane");
        this.tabbedPane.setInheritsPopupMenu(true);
        this.singlePanel = new JPanel(new CenterLayout());
        this.singlePanel.setName("ColorChooser.panel");
        this.singlePanel.setInheritsPopupMenu(true);
        this.chooser.setLayout(new BorderLayout());
        this.defaultChoosers = this.createDefaultChoosers();
        this.chooser.setChooserPanels(this.defaultChoosers);
        this.previewPanelHolder = new JPanel(new CenterLayout());
        this.previewPanelHolder.setName("ColorChooser.previewPanelHolder");
        if (DefaultLookup.getBoolean(this.chooser, this, "ColorChooser.showPreviewPanelText", true)) {
            String previewString = UIManager.getString((Object)"ColorChooser.previewText", this.chooser.getLocale());
            this.previewPanelHolder.setBorder(new TitledBorder(previewString));
        }
        this.previewPanelHolder.setInheritsPopupMenu(true);
        this.chooser.add((Component)this.previewPanelHolder, "South");
        this.installPreviewPanel();
        this.chooser.applyComponentOrientation(c.getComponentOrientation());
    }

    public void uninstallUI(JComponent c) {
        this.chooser.remove(this.tabbedPane);
        this.chooser.remove(this.singlePanel);
        this.chooser.remove(this.previewPanelHolder);
        this.uninstallDefaultChoosers();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.previewPanelHolder.remove(this.previewPanel);
        if (this.previewPanel instanceof UIResource) {
            this.chooser.setPreviewPanel(null);
        }
        this.previewPanelHolder = null;
        this.previewPanel = null;
        this.defaultChoosers = null;
        this.chooser = null;
        this.tabbedPane = null;
        this.handler = null;
    }

    protected void installPreviewPanel() {
        if (this.previewPanel != null) {
            this.previewPanelHolder.remove(this.previewPanel);
            this.previewPanel.removeMouseListener(this.getHandler());
        }
        this.previewPanel = this.chooser.getPreviewPanel();
        Dimension layoutSize = new Dimension();
        if (this.previewPanel != null) {
            layoutSize = new BorderLayout().minimumLayoutSize(this.previewPanel);
            if (this.previewPanelHolder != null && this.chooser != null && layoutSize.getWidth() + layoutSize.getHeight() == 0.0) {
                this.chooser.remove(this.previewPanelHolder);
                return;
            }
        }
        if (this.previewPanel == null || this.previewPanel instanceof UIResource) {
            this.previewPanel = ColorChooserComponentFactory.getPreviewPanel();
            this.chooser.setPreviewPanel(this.previewPanel);
        }
        this.previewPanel.setForeground(this.chooser.getColor());
        this.previewPanelHolder.add(this.previewPanel);
        this.previewPanel.addMouseListener(this.getHandler());
        this.previewPanel.setInheritsPopupMenu(true);
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.chooser, "ColorChooser.background", "ColorChooser.foreground", "ColorChooser.font");
        LookAndFeel.installProperty(this.chooser, "opaque", Boolean.TRUE);
        TransferHandler th = this.chooser.getTransferHandler();
        if (th == null || th instanceof UIResource) {
            this.chooser.setTransferHandler(defaultTransferHandler);
        }
    }

    protected void uninstallDefaults() {
        if (this.chooser.getTransferHandler() instanceof UIResource) {
            this.chooser.setTransferHandler(null);
        }
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.chooser.addPropertyChangeListener(this.propertyChangeListener);
        this.previewListener = this.getHandler();
        this.chooser.getSelectionModel().addChangeListener(this.previewListener);
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    protected void uninstallListeners() {
        this.chooser.removePropertyChangeListener(this.propertyChangeListener);
        this.chooser.getSelectionModel().removeChangeListener(this.previewListener);
        this.previewPanel.removeMouseListener(this.getHandler());
    }

    static class ColorTransferHandler
    extends TransferHandler
    implements UIResource {
        ColorTransferHandler() {
            super("color");
        }
    }

    public class PropertyHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            BasicColorChooserUI.this.getHandler().propertyChange(e);
        }
    }

    private class Handler
    implements ChangeListener,
    MouseListener,
    PropertyChangeListener {
        private Handler() {
        }

        public void stateChanged(ChangeEvent evt) {
            ColorSelectionModel model = (ColorSelectionModel)evt.getSource();
            if (BasicColorChooserUI.this.previewPanel != null) {
                BasicColorChooserUI.this.previewPanel.setForeground(model.getSelectedColor());
                BasicColorChooserUI.this.previewPanel.repaint();
            }
        }

        public void mousePressed(MouseEvent evt) {
            if (BasicColorChooserUI.this.chooser.getDragEnabled()) {
                TransferHandler th = BasicColorChooserUI.this.chooser.getTransferHandler();
                th.exportAsDrag(BasicColorChooserUI.this.chooser, evt, 1);
            }
        }

        public void mouseReleased(MouseEvent evt) {
        }

        public void mouseClicked(MouseEvent evt) {
        }

        public void mouseEntered(MouseEvent evt) {
        }

        public void mouseExited(MouseEvent evt) {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String prop = evt.getPropertyName();
            if (prop == "chooserPanels") {
                AbstractColorChooserPanel[] oldPanels = (AbstractColorChooserPanel[])evt.getOldValue();
                AbstractColorChooserPanel[] newPanels = (AbstractColorChooserPanel[])evt.getNewValue();
                for (int i = 0; i < oldPanels.length; ++i) {
                    Container wrapper = oldPanels[i].getParent();
                    if (wrapper == null) continue;
                    Container parent = wrapper.getParent();
                    if (parent != null) {
                        parent.remove(wrapper);
                    }
                    oldPanels[i].uninstallChooserPanel(BasicColorChooserUI.this.chooser);
                }
                int numNewPanels = newPanels.length;
                if (numNewPanels == 0) {
                    BasicColorChooserUI.this.chooser.remove(BasicColorChooserUI.this.tabbedPane);
                    return;
                }
                if (numNewPanels == 1) {
                    BasicColorChooserUI.this.chooser.remove(BasicColorChooserUI.this.tabbedPane);
                    JPanel centerWrapper = new JPanel(new CenterLayout());
                    centerWrapper.setInheritsPopupMenu(true);
                    centerWrapper.add(newPanels[0]);
                    BasicColorChooserUI.this.singlePanel.add((Component)centerWrapper, "Center");
                    BasicColorChooserUI.this.chooser.add(BasicColorChooserUI.this.singlePanel);
                } else {
                    if (oldPanels.length < 2) {
                        BasicColorChooserUI.this.chooser.remove(BasicColorChooserUI.this.singlePanel);
                        BasicColorChooserUI.this.chooser.add((Component)BasicColorChooserUI.this.tabbedPane, "Center");
                    }
                    for (int i = 0; i < newPanels.length; ++i) {
                        JPanel centerWrapper = new JPanel(new CenterLayout());
                        centerWrapper.setInheritsPopupMenu(true);
                        String name = newPanels[i].getDisplayName();
                        int mnemonic = newPanels[i].getMnemonic();
                        centerWrapper.add(newPanels[i]);
                        BasicColorChooserUI.this.tabbedPane.addTab(name, centerWrapper);
                        if (mnemonic <= 0) continue;
                        BasicColorChooserUI.this.tabbedPane.setMnemonicAt(i, mnemonic);
                        BasicColorChooserUI.this.tabbedPane.setDisplayedMnemonicIndexAt(i, newPanels[i].getDisplayedMnemonicIndex());
                    }
                }
                BasicColorChooserUI.this.chooser.applyComponentOrientation(BasicColorChooserUI.this.chooser.getComponentOrientation());
                for (int i = 0; i < newPanels.length; ++i) {
                    newPanels[i].installChooserPanel(BasicColorChooserUI.this.chooser);
                }
            }
            if (prop == "previewPanel" && evt.getNewValue() != BasicColorChooserUI.this.previewPanel) {
                BasicColorChooserUI.this.installPreviewPanel();
            }
            if (prop == "componentOrientation") {
                ComponentOrientation o = (ComponentOrientation)evt.getNewValue();
                JColorChooser cc = (JColorChooser)evt.getSource();
                if (o != (ComponentOrientation)evt.getOldValue()) {
                    cc.applyComponentOrientation(o);
                    cc.updateUI();
                }
            }
        }
    }
}

