/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import net.sourceforge.jnlp.AppletDesc;
import net.sourceforge.jnlp.InformationDesc;
import net.sourceforge.jnlp.JARDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.ResourcesDesc;
import net.sourceforge.jnlp.SecurityDesc;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.runtime.JNLPRuntime;

public class PluginBridge
extends JNLPFile {
    Version specVersion = new Version("1.0");
    Version fileVersion = new Version("1.1");
    String name;
    String[] jars = new String[0];
    String[] cache_jars = new String[0];
    String[] cache_ex_jars = new String[0];
    Hashtable atts;

    public PluginBridge(URL codebase, URL documentBase, String jar2, String main, int width, int height, Hashtable atts) throws Exception {
        this.codeBase = codebase;
        this.sourceLocation = documentBase;
        if (atts.get("cache_archive") != null && ((String)atts.get("cache_archive")).length() > 0) {
            String[] versions = new String[]{};
            if (atts.get("cache_version") != null) {
                versions = ((String)atts.get("cache_version")).split(",");
            }
            String[] jars = ((String)atts.get("cache_archive")).split(",");
            this.cache_jars = new String[jars.length];
            for (int i = 0; i < jars.length; ++i) {
                this.cache_jars[i] = jars[i].trim();
                if (versions.length <= 0) continue;
                int n = i;
                this.cache_jars[n] = this.cache_jars[n] + ";" + versions[i].trim();
            }
        }
        if (atts.get("cache_archive_ex") != null && ((String)atts.get("cache_archive_ex")).length() > 0) {
            this.cache_ex_jars = ((String)atts.get("cache_archive_ex")).split(",");
        }
        if (jar2 != null && jar2.length() > 0) {
            this.jars = jar2.split(",");
            if (JNLPRuntime.isDebug()) {
                System.err.println("Jar string: " + jar2);
                System.err.println("jars length: " + this.jars.length);
            }
        }
        this.atts = atts;
        this.name = (String)atts.get("name");
        this.name = this.name == null ? "Applet" : this.name + " applet";
        if (main.endsWith(".class")) {
            main = main.substring(0, main.length() - 6);
        }
        this.launchType = new AppletDesc(this.name, main, documentBase, width, height, atts);
        this.security = main.endsWith(".class") ? new SecurityDesc(this, SecurityDesc.SANDBOX_PERMISSIONS, codebase.getHost()) : null;
    }

    @Override
    public String getTitle() {
        return this.name;
    }

    @Override
    public InformationDesc getInformation(Locale locale) {
        return new InformationDesc(this, new Locale[]{locale}){

            @Override
            protected List getItems(Object key) {
                ArrayList result = new ArrayList();
                return result;
            }
        };
    }

    @Override
    public ResourcesDesc getResources(Locale locale, String os, String arch) {
        return new ResourcesDesc(this, new Locale[]{locale}, new String[]{os}, new String[]{arch}){

            @Override
            public List getResources(Class launchType) {
                ArrayList<JARDesc> result = new ArrayList<JARDesc>();
                result.addAll(PluginBridge.this.sharedResources.getResources(launchType));
                try {
                    if (launchType.equals(JARDesc.class)) {
                        Version version;
                        String jar2;
                        int i;
                        for (int i2 = 0; i2 < PluginBridge.this.jars.length; ++i2) {
                            result.add(new JARDesc(new URL(PluginBridge.this.codeBase, PluginBridge.this.jars[i2]), null, null, false, true, false, true));
                        }
                        boolean cacheable = true;
                        if (PluginBridge.this.atts.get("cache_option") != null && ((String)PluginBridge.this.atts.get("cache_option")).equalsIgnoreCase("no")) {
                            cacheable = false;
                        }
                        for (i = 0; i < PluginBridge.this.cache_jars.length; ++i) {
                            String[] jar_and_ver = PluginBridge.this.cache_jars[i].split(";");
                            jar2 = jar_and_ver[0];
                            version = null;
                            if (jar_and_ver.length > 1) {
                                version = new Version(jar_and_ver[1]);
                            }
                            result.add(new JARDesc(new URL(PluginBridge.this.codeBase, jar2), version, null, false, true, false, cacheable));
                        }
                        for (i = 0; i < PluginBridge.this.cache_ex_jars.length; ++i) {
                            String[] jar_info = PluginBridge.this.cache_ex_jars[i].split(";");
                            jar2 = jar_info[0].trim();
                            version = null;
                            boolean lazy = true;
                            if (jar_info.length > 1) {
                                if (jar_info[1].equals("preload")) {
                                    lazy = false;
                                } else {
                                    version = new Version(jar_info[1].trim());
                                }
                                if (jar_info.length > 2) {
                                    lazy = false;
                                    version = new Version(jar_info[2].trim());
                                }
                            }
                            result.add(new JARDesc(new URL(PluginBridge.this.codeBase, jar2), version, null, lazy, true, false, false));
                        }
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                return result;
            }

            @Override
            public JARDesc[] getJARs() {
                List resources = this.getResources(JARDesc.class);
                ArrayList<JARDesc> jars = new ArrayList<JARDesc>();
                for (int i = 0; i < resources.size(); ++i) {
                    Object resource = resources.get(i);
                    if (!(resource instanceof JARDesc)) continue;
                    jars.add((JARDesc)resource);
                }
                Object[] objectArray = jars.toArray();
                JARDesc[] jarArray = new JARDesc[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    jarArray[i] = (JARDesc)objectArray[i];
                }
                return jarArray;
            }

            @Override
            public void addResource(Object resource) {
                PluginBridge.this.sharedResources.addResource(resource);
            }
        };
    }

    @Override
    public boolean isApplet() {
        return true;
    }

    @Override
    public boolean isApplication() {
        return false;
    }

    @Override
    public boolean isComponent() {
        return false;
    }

    @Override
    public boolean isInstaller() {
        return false;
    }
}

